﻿// ****************************************************** 
// 文件名称(File Name)：       Employees.cs
// 项目名称(Project Name)：    YourProjectName
// 功能描述(Description)：     雇员 （数据模型）
// 数据表(Tables)：            Employees（所用到的数据表，视图，存储过程的说明，如关系比较复杂，则应说明哪些是可擦写的，哪些表为只读的）
// 作者(Author)：              zhaoshunlu@163.com
// 日期(Create Date)：         2014-10-21 22:17:27
// 参考文档(Reference)(可选)： （该档所对应的分析文档，设计文檔）
// 引用(Using) (可选)﹕        （开发的系统中引用其它系统的Dll、对象时，要列出其对应的出处，是否与系统有关﹙不清楚的可以不写﹚，以方便制作安装档）
// 编码约定：                   命名规则(类名和属性名首字母必须大写)
// 修改记录(Revision History)：（若档案的所有者改变，则需要有修改人员的名字、修改日期及修改理由）
//****************************************************** 
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using Newtonsoft.Json; //[JsonIgnore]//使用JsonConvert序列化时不序列化此字段

namespace Northwind.Model {

    //保持与架构无关性的POCO类

    //命名规则：类名和属性名首字母必须大写    

    /// <summary>
    /// 雇员（Employees）
    /// </summary>               
    /// <remarks> 
    /// 创建人及日期：zhaoshunlu@163.com 2014-10-21 22:17:27
    /// <para>修改人、日期及内容:</para>
    /// </remarks>
    public class Employees : Northwind.Model._common {
        /// <summary>
        /// 雇员
        /// </summary>
        public Employees() {
            //不允许null的属性及设置有默认值的属性
			this.EmployeeID = 0 ;			// 雇员ID Not NULL 
			this.LastName = "" ;			// 姓氏 Not NULL 
			this.FirstName = "" ;			// 名称 Not NULL 
			//this.BirthDate = System.DateTime.Now ;
			//this.HireDate = System.DateTime.Now ;
			//this.ReportsTo = 0 ;

			//Orderss = new List<Orders>();  

        }

		/// <summary>
		/// 雇员ID (Not NULL)
		/// </summary>
		/// <value>int</value>
	    [Display(Name = "雇员ID")]
        public int EmployeeID {get;set;}
		/// <summary>
		/// 姓氏 (Not NULL)
		/// </summary>
		/// <value>string</value>
	    [Display(Name = "姓氏")]
        public string LastName {get;set;}
		/// <summary>
		/// 名称 (Not NULL)
		/// </summary>
		/// <value>string</value>
	    [Display(Name = "名称")]
        public string FirstName {get;set;}
		/// <summary>
		/// 职位 
		/// </summary>
		/// <value>string</value>
	    [Display(Name = "职位")]
        public string Title {get;set;}
		/// <summary>
		/// 尊称 
		/// </summary>
		/// <value>string</value>
	    [Display(Name = "尊称")]
        public string TitleOfCourtesy {get;set;}
		/// <summary>
		/// 出生日期 
		/// </summary>
		/// <value>System.DateTime</value>
	    [Display(Name = "出生日期")]
        public System.DateTime? BirthDate {get;set;}
		/// <summary>
		/// 雇用日期 
		/// </summary>
		/// <value>System.DateTime</value>
	    [Display(Name = "雇用日期")]
        public System.DateTime? HireDate {get;set;}
		/// <summary>
		/// 地址 
		/// </summary>
		/// <value>string</value>
	    [Display(Name = "地址")]
        public string Address {get;set;}
		/// <summary>
		/// 城市 
		/// </summary>
		/// <value>string</value>
	    [Display(Name = "城市")]
        public string City {get;set;}
		/// <summary>
		/// 地区 
		/// </summary>
		/// <value>string</value>
	    [Display(Name = "地区")]
        public string Region {get;set;}
		/// <summary>
		/// 邮政编码 
		/// </summary>
		/// <value>string</value>
	    [Display(Name = "邮政编码")]
        public string PostalCode {get;set;}
		/// <summary>
		/// 国家 
		/// </summary>
		/// <value>string</value>
	    [Display(Name = "国家")]
        public string Country {get;set;}
		/// <summary>
		/// 家庭电话 
		/// </summary>
		/// <value>string</value>
	    [Display(Name = "家庭电话")]
        public string HomePhone {get;set;}
		/// <summary>
		/// 电话分机 
		/// </summary>
		/// <value>string</value>
	    [Display(Name = "电话分机")]
        public string Extension {get;set;}
		/// <summary>
		/// 照片 
		/// </summary>
		/// <value>string</value>
	    [Display(Name = "照片")]
        public string Photo {get;set;}
		/// <summary>
		/// 备注 
		/// </summary>
		/// <value>string</value>
	    [Display(Name = "备注")]
        public string Notes {get;set;}
		/// <summary>
		/// 上级雇员 
		/// </summary>
		/// <value>int</value>
	    [Display(Name = "上级雇员")]
        public int? ReportsTo {get;set;}
		/// <summary>
		/// 图片路径 
		/// </summary>
		/// <value>string</value>
	    [Display(Name = "图片路径")]
        public string PhotoPath {get;set;}


	    ///// <summary> 
	    ///// 订单(子表) 
	    ///// </summary> 
	    //public virtual IList<Orders> Orderss {get;set;} 


        
    }
}