﻿using System.Data.Entity.ModelConfiguration;
using System.ComponentModel.DataAnnotations;

namespace Northwind.Model.Mapping
{
    /// <summary>
    /// 领域（Territories）  
    /// </summary>
    /// <remarks> 
    /// 创建人及日期：zhaoshunlu@163.com 2014-10-21 22:17:28
    /// <para>修改人、日期及内容:</para>
    /// </remarks>
    public class TerritoriesMap : EntityTypeConfiguration<Northwind.Model.Territories>
    {
        /// <summary>
        /// 领域
        /// </summary>
        public TerritoriesMap()
        {
            // Primary Key           
            this.HasKey(t => t.TerritoryID);
 
            // NotMapped
            this.Ignore(t => t._uid);
            this.Ignore(t => t._index);
            this.Ignore(t => t._state);
            this.Ignore(t => t._tag);
            this.Ignore(t => t._tag2);
            
            //属性赋值检查，如果失败就会抛出如下异常信息：
            //Validation failed for one or more entities. See 'EntityValidationErrors' property for more details.
            //用DbEntityValidationException异常类获取具体的是哪个属性赋值错误
          
            // Properties
            //YourProperties

            // Table & Column Mappings
            this.ToTable("Territories");
            this.Property(t => t.TerritoryID).HasColumnName("TerritoryID").HasMaxLength(20);
            this.Property(t => t.TerritoryDescription).HasColumnName("TerritoryDescription");
            this.Property(t => t.RegionID).HasColumnName("RegionID");


            // Relationships HasOptional,HasRequired
            //this.HasRequired(t => t.Region)         // 主表 
            //	.WithMany(m => m.Territoriess)             // 一对多 一个Region可以有多个Territories
            // 	.HasForeignKey(t => t.RegionID);        // 外键 

        }
    }
}
