﻿using System.Data.Entity.ModelConfiguration;
using System.ComponentModel.DataAnnotations;

namespace Northwind.Model.Mapping
{
    /// <summary>
    /// 地区（Region）  
    /// </summary>
    /// <remarks> 
    /// 创建人及日期：zhaoshunlu@163.com 2014-10-21 22:17:28
    /// <para>修改人、日期及内容:</para>
    /// </remarks>
    public class RegionMap : EntityTypeConfiguration<Northwind.Model.Region>
    {
        /// <summary>
        /// 地区
        /// </summary>
        public RegionMap()
        {
            // Primary Key           
            this.HasKey(t => t.RegionID);
 
            // NotMapped
            this.Ignore(t => t._uid);
            this.Ignore(t => t._index);
            this.Ignore(t => t._state);
            this.Ignore(t => t._tag);
            this.Ignore(t => t._tag2);
            
            //属性赋值检查，如果失败就会抛出如下异常信息：
            //Validation failed for one or more entities. See 'EntityValidationErrors' property for more details.
            //用DbEntityValidationException异常类获取具体的是哪个属性赋值错误
          
            // Properties
            //YourProperties

            // Table & Column Mappings
            this.ToTable("Region");
            this.Property(t => t.RegionID).HasColumnName("RegionID");
            this.Property(t => t.RegionDescription).HasColumnName("RegionDescription");


            // Relationships HasOptional,HasRequired

        }
    }
}
