﻿using System.Data.Entity.ModelConfiguration;
using System.ComponentModel.DataAnnotations;

namespace Northwind.Model.Mapping
{
    /// <summary>
    /// 产品（Products）  
    /// </summary>
    /// <remarks> 
    /// 创建人及日期：zhaoshunlu@163.com 2014-10-21 22:17:28
    /// <para>修改人、日期及内容:</para>
    /// </remarks>
    public class ProductsMap : EntityTypeConfiguration<Northwind.Model.Products>
    {
        /// <summary>
        /// 产品
        /// </summary>
        public ProductsMap()
        {
            // Primary Key           
            this.HasKey(t => t.ProductID);
 
            // NotMapped
            this.Ignore(t => t._uid);
            this.Ignore(t => t._index);
            this.Ignore(t => t._state);
            this.Ignore(t => t._tag);
            this.Ignore(t => t._tag2);
            
            //属性赋值检查，如果失败就会抛出如下异常信息：
            //Validation failed for one or more entities. See 'EntityValidationErrors' property for more details.
            //用DbEntityValidationException异常类获取具体的是哪个属性赋值错误
          
            // Properties
            //YourProperties

            // Table & Column Mappings
            this.ToTable("Products");
            this.Property(t => t.ProductID).HasColumnName("ProductID").HasDatabaseGeneratedOption(DatabaseGeneratedOption.Identity);
            this.Property(t => t.ProductName).HasColumnName("productName").HasMaxLength(40);
            this.Property(t => t.SupplierID).HasColumnName("SupplierID");
            this.Property(t => t.CategoryID).HasColumnName("CategoryID");
            this.Property(t => t.QuantityPerUnit).HasColumnName("QuantityPerUnit").HasMaxLength(20);
            this.Property(t => t.UnitPrice).HasColumnName("UnitPrice");
            this.Property(t => t.UnitsInStock).HasColumnName("UnitsInStock");
            this.Property(t => t.UnitsOnOrder).HasColumnName("UnitsOnOrder");
            this.Property(t => t.ReorderLevel).HasColumnName("ReorderLevel");
            this.Property(t => t.Discontinued).HasColumnName("Discontinued").IsRequired();


            // Relationships HasOptional,HasRequired
            //this.HasRequired(t => t.Suppliers)         // 主表 
            //	.WithMany(m => m.Productss)             // 一对多 一个Suppliers可以有多个Products
            // 	.HasForeignKey(t => t.SupplierID);        // 外键 
            //this.HasRequired(t => t.Categories)         // 主表 
            //	.WithMany(m => m.Productss)             // 一对多 一个Categories可以有多个Products
            // 	.HasForeignKey(t => t.CategoryID);        // 外键 

        }
    }
}
