﻿using System.Data.Entity.ModelConfiguration;
using System.ComponentModel.DataAnnotations;

namespace Northwind.Model.Mapping
{
    /// <summary>
    /// 订单（Orders）  
    /// </summary>
    /// <remarks> 
    /// 创建人及日期：zhaoshunlu@163.com 2014-10-21 22:17:28
    /// <para>修改人、日期及内容:</para>
    /// </remarks>
    public class OrdersMap : EntityTypeConfiguration<Northwind.Model.Orders>
    {
        /// <summary>
        /// 订单
        /// </summary>
        public OrdersMap()
        {
            // Primary Key           
            this.HasKey(t => t.OrderID);
 
            // NotMapped
            this.Ignore(t => t._uid);
            this.Ignore(t => t._index);
            this.Ignore(t => t._state);
            this.Ignore(t => t._tag);
            this.Ignore(t => t._tag2);
            
            //属性赋值检查，如果失败就会抛出如下异常信息：
            //Validation failed for one or more entities. See 'EntityValidationErrors' property for more details.
            //用DbEntityValidationException异常类获取具体的是哪个属性赋值错误
          
            // Properties
            //YourProperties

            // Table & Column Mappings
            this.ToTable("Orders");
            this.Property(t => t.OrderID).HasColumnName("OrderID").HasDatabaseGeneratedOption(DatabaseGeneratedOption.Identity);
            this.Property(t => t.CustomerID).HasColumnName("CustomerID");
            this.Property(t => t.EmployeeID).HasColumnName("EmployeeID");
            this.Property(t => t.OrderDate).HasColumnName("OrderDate");
            this.Property(t => t.RequiredDate).HasColumnName("RequiredDate");
            this.Property(t => t.ShippedDate).HasColumnName("ShippedDate");
            this.Property(t => t.ShipVia).HasColumnName("ShipVia");
            this.Property(t => t.Freight).HasColumnName("Freight");
            this.Property(t => t.ShipName).HasColumnName("ShipName").HasMaxLength(40);
            this.Property(t => t.ShipAddress).HasColumnName("ShipAddress").HasMaxLength(60);
            this.Property(t => t.ShipCity).HasColumnName("ShipCity").HasMaxLength(15);
            this.Property(t => t.ShipRegion).HasColumnName("ShipRegion").HasMaxLength(15);
            this.Property(t => t.ShipPostalCode).HasColumnName("ShipPostalCode").HasMaxLength(10);
            this.Property(t => t.ShipCountry).HasColumnName("ShipCountry").HasMaxLength(15);


            // Relationships HasOptional,HasRequired
            //this.HasRequired(t => t.Employees)         // 主表 
            //	.WithMany(m => m.Orderss)             // 一对多 一个Employees可以有多个Orders
            // 	.HasForeignKey(t => t.EmployeeID);        // 外键 
            //this.HasRequired(t => t.Shippers)         // 主表 
            //	.WithMany(m => m.Orderss)             // 一对多 一个Shippers可以有多个Orders
            // 	.HasForeignKey(t => t.ShipVia);        // 外键 
            //this.HasRequired(t => t.Customers)         // 主表 
            //	.WithMany(m => m.Orderss)             // 一对多 一个Customers可以有多个Orders
            // 	.HasForeignKey(t => t.CustomerID);        // 外键 

        }
    }
}
