﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using System.Data.OleDb;
using System.Text;

namespace Mammonth.Common
{
    public class ExcelHelper
    {
        /// <summary>
        /// 从Excel文件读取指定表格的内容
        /// </summary>
        /// <param name="Path">Excel文件物理路径</param>
        /// <param name="SheetName">表格的名称</param>
        /// <returns></returns>
        public static DataTable GetTabelWithExcel(string Path, string SheetName)
        {
            if (!System.IO.File.Exists(Path))
            {
                return null;
            }
            DataSet ds = new DataSet();
            string strConn = string.Format("Provider=Microsoft.Jet.OleDb.4.0;data source={0};Extended Properties=Excel 8.0;", Path);
            using (OleDbConnection Conn = new OleDbConnection(strConn))
            {
                Conn.Open();
                string strSql = "Select * From [" + SheetName + "$]";
                OleDbCommand Cmd = new OleDbCommand(strSql, Conn);
                OleDbDataAdapter sqlada = new OleDbDataAdapter();
                sqlada.SelectCommand = Cmd;
                sqlada.Fill(ds);
                Conn.Close();
            }
            return (ds.Tables.Count > 0) ? ds.Tables[0] : null;
        }
    }
}
