﻿using System;
using System.Data;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Reflection;

namespace Mammonth.Common
{
    public class DataFormat
    {
        /// <summary>
        /// 将对象转换成 Hashtable
        /// 创建：赵 2012-12-6 
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="o"></param>
        /// <returns></returns>
        public static Hashtable Object2Hashtable<T>(T o)
        {            
            Hashtable record = new Hashtable();
            if (o != null)
            {
                //遍历所有属性并获取值
                PropertyInfo[] pinfoArray = o.GetType().GetProperties();
                for (int j = 0; j < pinfoArray.Length; j++)//
                {
                    record[pinfoArray[j].Name] = pinfoArray[j].GetValue(o, null);//插入Hashtable 键--值对
                }
            }
            return record;
        }
        /// <summary>
        /// 将一个对象转换成 JSON 字符串
        /// 创建：赵 2012-12-6 
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="o"></param>
        /// <returns></returns>
        public static String Object2JSONString<T>(T o)
        {
            StringBuilder s = new StringBuilder();
            if (o != null)
            {
                s.Append("{");
                //遍历所有属性并获取值
                PropertyInfo[] pinfoArray = o.GetType().GetProperties();
                for (int j = 0; j < pinfoArray.Length; j++)//
                {
                    if (j > 0)
                        s.Append(",");
                    s.AppendFormat("{0}:{1}", pinfoArray[j].Name, pinfoArray[j].GetValue(o, null));
                }
                s.Append("}");
            }
            return s.ToString();
        }

        /// <summary>
        /// 将一组对象转换成 JSON 字符串
        /// 创建：赵 2012-12-6 
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="o"></param>
        /// <returns></returns>
        public static String Objects2JSONString<T>(List<T> list)
        {
            StringBuilder s = new StringBuilder();
            if (list != null && list.Count>0)
            {
                s.Append("[");
                for (int j = 0; j < list.Count; j++)//
                {
                    if (j > 0)
                        s.Append(",");
                    s.Append(Object2JSONString<T>(list[j]));
                }
                s.Append("]");
            }
            return s.ToString();
        }

        /// <summary>
        /// 将DataTable转换成 Hashtable 的ArrayList 数组
        /// 创建：赵 2012-12-6 
        /// </summary>
        /// <param name="data">DataTable</param>
        /// <returns></returns>
        public static ArrayList DataTable2ArrayList(DataTable data)
        {
            ArrayList array = new ArrayList();
            for (int i = 0; i < data.Rows.Count; i++)//遍历行
            {
                DataRow row = data.Rows[i];

                Hashtable record = new Hashtable();
                for (int j = 0; j < data.Columns.Count; j++)//遍历列
                {
                    object cellValue = row[j];
                    if (cellValue.GetType() == typeof(DBNull))
                    {
                        cellValue = null;
                    }
                    record[data.Columns[j].ColumnName] = cellValue;//键--值对
                }
                array.Add(record);//插入Hashtable
            }
            return array;
        }
    }
}
