﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:variable name="number" select="1" />
  <xsl:template match="/">
    <html xmlns="http://www.w3.org/1999/xhtml">
      <meta http_equiv="Content-Type" content="text/html; charset=UTF-8"/> 
        <style type="text/css">
          html, body
          {
          font-size: 12px;
          padding: 0;
          margin: 0;
          border: 0;
          }
          table{margin: 0; border: 0;border:solid 1px #e0e0e0;}
          th{font-size: 12px;background-color:none;padding:4px;text-align:left;}
          td{font-size: 12px;padding:2px;border-bottom:solid 1px #f1f1f1;}
          .css1 {background-color: none;}
          .css2 {background-color: #DFFFBF;}
          .tbNameLink{cursor: pointer;color:black;text-decoration:none;}
        </style>
        <script language="javascript">
          function mouseOver(obj){
          if(obj.className="css1")
          obj.className="css2";
          }
          function mouseOut(obj){
          if(obj.className="css2")
          obj.className="css1";
          }
          function showColumns(tbId){
          if(document.getElementById(tbId).style.display=="block"){
          document.getElementById(tbId).style.display="none";
          }else{
          document.getElementById(tbId).style.display="block";
          }
          }
          function showTbIndex(){
          if(document.getElementById("tbx0").style.display=="block"){
          document.getElementById("tbx0").style.display="none";
          }else{
          document.getElementById("tbx0").style.display="block";
          }
          }
        </script>
      <body style="width:100%;height:100%;margin: 0; border: 0;background-image: url(_bg1.jpg); background-repeat: no-repeat; background-position: right top;background-attachment: fixed;">       
          <xsl:for-each select="MammonthCoder/Table">
            <table border="0" width="90%" style="margin-top:5px;border:none;">
              <tr >
                <th width="360">                 
                  表格：
                  <a title="点击展开/隐藏" class="tbNameLink">

                    <xsl:attribute name="name">
                      <xsl:value-of select="@Name" />
                    </xsl:attribute>
                    <xsl:attribute name="onclick">
                      <xsl:value-of select="concat('showColumns(&quot;tbx',position(),'&quot;)')" />
                    </xsl:attribute>
                    <xsl:value-of select="@Name"/>
                  </a>
                </th>
                <th>
                  <xsl:value-of select="@Remark"></xsl:value-of>
                </th>
              </tr>
            </table>

            <table border="0" width="90%" style="margin-top:5px;display:block; ">
              <xsl:attribute name="id">
                <xsl:value-of select="concat('tbx',position())" />
              </xsl:attribute>
              <tr>
                <th style="width:30px">
                  序号
                </th> 
                <th style="width:100px">
                  列名
                </th> 
                <th style="width:100px">
                  数据类型
                </th>
                <th style="width:60px">
                  长度
                </th>
                <th style="width:60px">
                  是否主键
                </th>
                <th style="width:60px">
                  是否自增
                </th>
                <th style="width:60px">
                  允许为空
                </th>
                <th >
                  默认值
                </th>
                <th >备注</th>
              </tr>
              <xsl:for-each select="./Column">
                <tr class="css1" onMouseOver="mouseOver(this)" onMouseOut="mouseOut(this)">
                  <td>
                    <xsl:value-of select="@No"></xsl:value-of>
                  </td>
                  
                  <td>
                    <xsl:value-of select="@Name"></xsl:value-of>
                  </td>
                  
                  <td>
                    <xsl:value-of select="@Datatype"></xsl:value-of>
                  </td>
                  <td>
                    <xsl:value-of select="@Length"></xsl:value-of>
                  </td>
                  <td> 
                    <xsl:choose>
                      <xsl:when test="@InPrimaryKey != ''">
                        <xsl:value-of select="@InPrimaryKey"></xsl:value-of>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
                      </xsl:otherwise>
                    </xsl:choose>
                  </td>
                  <td>
                    <xsl:choose>
                      <xsl:when test="@Identity != ''">
                        <xsl:value-of select="@Identity"></xsl:value-of>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
                      </xsl:otherwise>
                    </xsl:choose>
                  </td>
                  <td>
                    <xsl:choose>
                      <xsl:when test="@AllowNulls != ''">
                        <xsl:value-of select="@AllowNulls"></xsl:value-of>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
                      </xsl:otherwise>
                    </xsl:choose>
                  </td>
                  <td>
                    <xsl:choose>
                      <xsl:when test="@DefaultValue != ''">
                        <xsl:value-of select="@DefaultValue"></xsl:value-of>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
                      </xsl:otherwise>
                    </xsl:choose>
                  </td>
                  <td>
                    <xsl:choose>
                      <xsl:when test="@Remark != ''">
                        <xsl:value-of select="@Remark"></xsl:value-of>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
                      </xsl:otherwise>
                    </xsl:choose>
                  </td>
                </tr>
              </xsl:for-each>
            </table>
          </xsl:for-each> 
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>