/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile;

import java.io.InvalidObjectException;
import java.io.ObjectInputValidation;
import java.io.Serializable;
import sqlj.runtime.error.ProfileErrors;
import sqlj.runtime.profile.SetTransactionDescriptor;
import sqlj.runtime.profile.TypeInfo;

public abstract class EntryInfo
implements Serializable,
ObjectInputValidation {
    public static final int PREPARED_STATEMENT = 2;
    public static final int CALLABLE_STATEMENT = 4;
    public static final int EXECUTE_UPDATE = 8;
    public static final int EXECUTE_QUERY = 16;
    public static final int EXECUTE = 24;
    public static final int QUERY = 2;
    public static final int STATEMENT = 3;
    public static final int CALL = 4;
    public static final int VALUES = 5;
    public static final int POSITIONED = 6;
    public static final int QUERY_FOR_UPDATE = 7;
    public static final int SINGLE_ROW_QUERY = 8;
    public static final int BLOCK = 9;
    public static final int COMMIT = 11;
    public static final int ROLLBACK = 12;
    public static final int SET_TRANSACTION = 17;
    public static final int ITERATOR_CONVERSION = 18;
    public static final int UNTYPED_SELECT = 19;
    public static final int SCROLLABLE_RESULT = 256;
    public static final int HOLDABLE_RESULT = 512;
    public static final int AUTO_GENERATED_KEY_STMT = 576;
    public static final int OTHER = 1024;
    public static final int NO_RESULT = 128;
    public static final int NAMED_RESULT = 32;
    public static final int POSITIONED_RESULT = 64;
    static final long serialVersionUID = 241067723671289526L;

    public abstract String getSQLString();

    public abstract String getOriginalSQLString();

    public abstract int getStatementType();

    public static boolean isValidStatementType(int n2) {
        switch (n2) {
            case 2: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public static String statementTypeToString(int n2) {
        switch (n2) {
            case 2: {
                return "PREPARED_STATEMENT";
            }
            case 4: {
                return "CALLABLE_STATEMENT";
            }
        }
        return n2 + "";
    }

    public abstract int getExecuteType();

    public static boolean isValidExecuteType(int n2) {
        switch (n2) {
            case 8: 
            case 16: 
            case 24: {
                return true;
            }
        }
        return false;
    }

    public static String executeTypeToString(int n2) {
        switch (n2) {
            case 8: {
                return "EXECUTE_UPDATE";
            }
            case 16: {
                return "EXECUTE_QUERY";
            }
            case 24: {
                return "EXECUTE";
            }
        }
        return n2 + "";
    }

    public abstract int getRole();

    public static boolean isDefinedRole(int n2) {
        switch (n2) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 1024: {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidRole(int n2) {
        return EntryInfo.isDefinedRole(n2) || n2 > 1024;
    }

    public abstract boolean isScrollable();

    public abstract boolean isHoldable();

    public abstract boolean isDynamic();

    public static String roleToString(int n2) {
        Object var1_1 = null;
        switch (n2) {
            case 2: {
                return "QUERY";
            }
            case 3: {
                return "STATEMENT";
            }
            case 4: {
                return "CALL";
            }
            case 5: {
                return "VALUES";
            }
            case 6: {
                return "POSITIONED";
            }
            case 7: {
                return "QUERY_FOR_UPDATE";
            }
            case 8: {
                return "SINGLE_ROW_QUERY";
            }
            case 9: {
                return "BLOCK";
            }
            case 1024: {
                return "OTHER";
            }
            case 11: {
                return "COMMIT";
            }
            case 12: {
                return "ROLLBACK";
            }
            case 17: {
                return "SET_TRANSACTION";
            }
            case 18: {
                return "ITERATOR_CONVERSION";
            }
            case 19: {
                return "UNTYPED_SELECT";
            }
        }
        return n2 + "";
    }

    public abstract int getResultSetType();

    public static boolean isValidResultSetType(int n2) {
        switch (n2) {
            case 32: 
            case 64: 
            case 128: {
                return true;
            }
        }
        return false;
    }

    public static String resultSetTypeToString(int n2) {
        switch (n2) {
            case 128: {
                return "NO_RESULT";
            }
            case 32: {
                return "NAMED_RESULT";
            }
            case 64: {
                return "POSITIONED_RESULT";
            }
        }
        return n2 + "";
    }

    public abstract int getResultSetCount();

    public abstract TypeInfo getResultSetInfo(int var1);

    public abstract String getResultSetName();

    public abstract int getParamCount();

    public abstract TypeInfo getParamInfo(int var1);

    public abstract Object getDescriptor();

    public SetTransactionDescriptor getTransactionDescriptor() {
        switch (this.getRole()) {
            case 17: {
                return (SetTransactionDescriptor)this.getDescriptor();
            }
        }
        return null;
    }

    public static boolean isValidDescriptor(Object object, int n2) {
        switch (n2) {
            case 6: {
                return object instanceof Integer;
            }
            case 17: {
                return object instanceof SetTransactionDescriptor;
            }
            case 2: 
            case 4: 
            case 7: 
            case 19: {
                return object == null;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 18: {
                return object == null;
            }
        }
        return n2 >= 1024 || object == null;
    }

    public abstract int getLineNumber();

    public void validateObject() throws InvalidObjectException {
        int n2 = this.getStatementType();
        if (!EntryInfo.isValidStatementType(n2)) {
            String string = ProfileErrors.INVALID_STMT_TYPE_text(n2);
            throw new InvalidObjectException(string);
        }
        int n3 = this.getExecuteType();
        if (!EntryInfo.isValidExecuteType(n3)) {
            String string = ProfileErrors.INVALID_EXEC_TYPE_text(n3);
            throw new InvalidObjectException(string);
        }
        int n4 = this.getRole();
        if (!EntryInfo.isValidRole(n4)) {
            String string = ProfileErrors.INVALID_ROLE_text(n4);
            throw new InvalidObjectException(string);
        }
        int n5 = this.getResultSetType();
        if (!EntryInfo.isValidResultSetType(n5)) {
            String string = ProfileErrors.INVALID_RESULT_SET_TYPE_text(n5);
            throw new InvalidObjectException(string);
        }
        Object object = this.getDescriptor();
        if (!EntryInfo.isValidDescriptor(object, n4)) {
            String string = ProfileErrors.INVALID_DESCRIPTOR_text(object);
            throw new InvalidObjectException(string);
        }
    }
}

