/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql.converter;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.jdbc.driver.DatabaseError;
import oracle.sql.converter.CharacterConverterJDBC;

public class CharacterConverter1Byte
extends CharacterConverterJDBC {
    static final int ORACHARMASK = 255;
    static final int UCSCHARWIDTH = 16;
    public int m_ucsReplacement = 0;
    public int[] m_ucsChar = null;
    public char[] m_oraCharLevel1 = null;
    public char[] m_oraCharSurrogateLevel = null;
    public char[] m_oraCharLevel2 = null;
    public byte m_oraCharReplacement = 0;
    protected transient boolean noSurrogate = true;
    protected transient boolean strictASCII = true;
    protected transient int m_oraCharLevel2Size = 0;

    public CharacterConverter1Byte() {
        this.m_groupId = 0;
    }

    public void buildUnicodeToOracleMapping() {
        int n2;
        int n3;
        int n4;
        int n5;
        char[] cArray;
        Object object;
        Enumeration enumeration;
        int n6;
        this.m_oraCharLevel1 = new char[256];
        this.m_oraCharSurrogateLevel = null;
        this.m_oraCharLevel2 = null;
        Vector vector = new Vector(45055, 12287);
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        int n7 = this.m_ucsChar.length;
        char c2 = '\u0000';
        char c3 = '\u0000';
        int n8 = 0;
        while (n8 < 256) {
            this.m_oraCharLevel1[n8] = 65535;
            ++n8;
        }
        n8 = 0;
        while (n8 < n7) {
            n6 = this.m_ucsChar[n8];
            if (n6 != -1) {
                enumeration = (Enumeration)new int[2];
                enumeration[0] = n6;
                enumeration[1] = (Enumeration)n8;
                vector.addElement(enumeration);
                this.storeMappingRange(n6, hashtable, hashtable2);
            }
            ++n8;
        }
        if (this.extraUnicodeToOracleMapping != null) {
            n7 = this.extraUnicodeToOracleMapping.length;
            n8 = 0;
            while (n8 < n7) {
                n6 = this.extraUnicodeToOracleMapping[n8][0];
                this.storeMappingRange(n6, hashtable, hashtable2);
                ++n8;
            }
        }
        enumeration = hashtable.keys();
        int n9 = 0;
        int n10 = 0;
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            cArray = (char[])hashtable.get(object);
            if (cArray == null) continue;
            n9 += 256;
        }
        enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            cArray = (char[])hashtable2.get(object);
            if (cArray == null) continue;
            n10 += 256;
        }
        if (n9 != 0) {
            this.m_oraCharSurrogateLevel = new char[n9];
        }
        if (n10 != 0) {
            this.m_oraCharLevel2 = new char[n10 + 256];
        }
        n8 = 0;
        while (n8 < n9) {
            this.m_oraCharSurrogateLevel[n8] = 65535;
            ++n8;
        }
        n8 = 0;
        while (n8 < n10 + 256) {
            this.m_oraCharLevel2[n8] = 65535;
            ++n8;
        }
        n8 = 0;
        while (n8 < vector.size()) {
            int[] nArray = (int[])vector.elementAt(n8);
            n5 = nArray[0] >> 24 & 0xFF;
            n4 = nArray[0] >> 16 & 0xFF;
            n3 = nArray[0] >> 8 & 0xFF;
            n2 = nArray[0] & 0xFF;
            if (n5 >= 216 && n5 < 220) {
                if (this.m_oraCharLevel1[n5] == '\uffff') {
                    this.m_oraCharLevel1[n5] = c3;
                    c3 = (char)(c3 + 256);
                }
                if (this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] == '\uffff') {
                    this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] = c3;
                    c3 = (char)(c3 + 256);
                }
                if (this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] + n3] == '\uffff') {
                    this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] + n3] = c2;
                    c2 = (char)(c2 + 256);
                }
                if (this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] + n3] + n2] == '\uffff') {
                    this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] + n3] + n2] = (char)(nArray[1] & 0xFFFF);
                }
            } else {
                if (this.m_oraCharLevel1[n3] == '\uffff') {
                    this.m_oraCharLevel1[n3] = c2;
                    c2 = (char)(c2 + 256);
                }
                if (this.m_oraCharLevel2[this.m_oraCharLevel1[n3] + n2] == '\uffff') {
                    this.m_oraCharLevel2[this.m_oraCharLevel1[n3] + n2] = (char)(nArray[1] & 0xFFFF);
                }
            }
            ++n8;
        }
        if (this.extraUnicodeToOracleMapping != null) {
            n7 = this.extraUnicodeToOracleMapping.length;
            n8 = 0;
            while (n8 < n7) {
                n6 = this.extraUnicodeToOracleMapping[n8][0];
                n5 = n6 >>> 24 & 0xFF;
                n4 = n6 >>> 16 & 0xFF;
                n3 = n6 >>> 8 & 0xFF;
                n2 = n6 & 0xFF;
                if (n5 >= 216 && n5 < 220) {
                    if (this.m_oraCharLevel1[n5] == '\uffff') {
                        this.m_oraCharLevel1[n5] = c3;
                        c3 = (char)(c3 + 256);
                    }
                    if (this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] == '\uffff') {
                        this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] = c3;
                        c3 = (char)(c3 + 256);
                    }
                    if (this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] + n3] == '\uffff') {
                        this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] + n3] = c2;
                        c2 = (char)(c2 + 256);
                    }
                    this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] + n3] + n2] = (char)(this.extraUnicodeToOracleMapping[n8][1] & 0xFF);
                } else {
                    if (this.m_oraCharLevel1[n3] == '\uffff') {
                        this.m_oraCharLevel1[n3] = c2;
                        c2 = (char)(c2 + 256);
                    }
                    this.m_oraCharLevel2[this.m_oraCharLevel1[n3] + n2] = (char)(this.extraUnicodeToOracleMapping[n8][1] & 0xFFFF);
                }
                ++n8;
            }
        }
        this.noSurrogate = this.m_oraCharSurrogateLevel == null;
        this.strictASCII = true;
        n8 = 0;
        while (n8 < 128) {
            if (this.m_oraCharLevel2[n8] != n8) {
                this.strictASCII = false;
                break;
            }
            ++n8;
        }
        n8 = 0;
        while (n8 < 256) {
            if (this.m_oraCharLevel1[n8] == '\uffff') {
                this.m_oraCharLevel1[n8] = (char)n10;
            }
            ++n8;
        }
        this.m_oraCharLevel2Size = n10;
    }

    public void extractCodepoints(Vector vector) {
        int n2 = 0;
        int n3 = 255;
        int n4 = n2;
        while (n4 <= n3) {
            try {
                int[] nArray = new int[]{n4, this.toUnicode((byte)n4)};
                vector.addElement(nArray);
            }
            catch (SQLException sQLException) {}
            ++n4;
        }
    }

    public void extractExtraMappings(Vector vector) {
        if (this.extraUnicodeToOracleMapping == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.extraUnicodeToOracleMapping.length) {
            int[] nArray = new int[]{this.extraUnicodeToOracleMapping[n2][0], this.extraUnicodeToOracleMapping[n2][1]};
            vector.addElement(nArray);
            ++n2;
        }
    }

    public char getOraChar1ByteRep() {
        return (char)this.m_oraCharReplacement;
    }

    public char getOraChar2ByteRep() {
        return '\u0000';
    }

    public int getUCS2CharRep() {
        return this.m_ucsReplacement;
    }

    public boolean hasExtraMappings() {
        return this.extraUnicodeToOracleMapping != null;
    }

    byte toOracleCharacter(char c2) throws SQLException {
        int n2 = c2 >>> 8;
        int n3 = c2 & 0xFF;
        char c3 = this.m_oraCharLevel2[this.m_oraCharLevel1[n2] + n3];
        if (c3 != '\uffff') {
            return (byte)c3;
        }
        DatabaseError.throwSqlException(155);
        return 0;
    }

    byte toOracleCharacter(char c2, char c3) throws SQLException {
        int n2 = c2 >>> 8 & 0xFF;
        int n3 = c2 & 0xFF;
        int n4 = c3 >>> 8 & 0xFF;
        int n5 = c3 & 0xFF;
        if (this.m_oraCharLevel1[n2] != (char)this.m_oraCharLevel2Size && this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] + n5] != '\uffff') {
            return (byte)this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] + n5];
        }
        DatabaseError.throwSqlException(155);
        return 0;
    }

    byte toOracleCharacterWithReplacement(char c2) {
        int n2 = c2 >>> 8;
        int n3 = c2 & 0xFF;
        char c3 = this.m_oraCharLevel2[this.m_oraCharLevel1[n2] + n3];
        if (c3 != '\uffff') {
            return (byte)c3;
        }
        return this.m_oraCharReplacement;
    }

    byte toOracleCharacterWithReplacement(char c2, char c3) {
        int n2 = c2 >>> 8 & 0xFF;
        int n3 = c2 & 0xFF;
        int n4 = c3 >>> 8 & 0xFF;
        int n5 = c3 & 0xFF;
        if (this.m_oraCharLevel1[n2] != (char)this.m_oraCharLevel2Size && this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] + n5] != '\uffff') {
            return (byte)this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] + n5];
        }
        return this.m_oraCharReplacement;
    }

    public byte[] toOracleString(String string) throws SQLException {
        int n2 = string.length();
        if (n2 == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        byte[] byArray = new byte[n2 * 4];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            if (cArray[n4] >= '\ud800' && cArray[n4] < '\udc00') {
                if (n4 + 1 < n2 && cArray[n4 + 1] >= '\udc00' && cArray[n4 + 1] <= '\udfff') {
                    if (this.noSurrogate) {
                        DatabaseError.throwSqlException(155);
                    } else {
                        byArray[n3++] = this.toOracleCharacter(cArray[n4], cArray[n4 + 1]);
                    }
                    ++n4;
                } else {
                    DatabaseError.throwSqlException(155);
                }
            } else {
                byArray[n3++] = cArray[n4] < '\u0080' && this.strictASCII ? (byte)cArray[n4] : this.toOracleCharacter(cArray[n4]);
            }
            ++n4;
        }
        if (n3 < byArray.length) {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, 0, byArray2, 0, n3);
            return byArray2;
        }
        return byArray;
    }

    public byte[] toOracleStringWithReplacement(String string) {
        int n2 = string.length();
        if (n2 == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        byte[] byArray = new byte[n2 * 4];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            if (cArray[n4] >= '\ud800' && cArray[n4] < '\udc00') {
                if (n4 + 1 < n2 && cArray[n4 + 1] >= '\udc00' && cArray[n4 + 1] <= '\udfff') {
                    byArray[n3++] = this.noSurrogate ? this.m_oraCharReplacement : this.toOracleCharacterWithReplacement(cArray[n4], cArray[n4 + 1]);
                    ++n4;
                } else {
                    byArray[n3++] = this.m_oraCharReplacement;
                }
            } else {
                byArray[n3++] = cArray[n4] < '\u0080' && this.strictASCII ? (byte)cArray[n4] : this.toOracleCharacterWithReplacement(cArray[n4]);
            }
            ++n4;
        }
        if (n3 < byArray.length) {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, 0, byArray2, 0, n3);
            return byArray2;
        }
        return byArray;
    }

    int toUnicode(byte by) throws SQLException {
        int n2 = this.m_ucsChar[by & 0xFF];
        if (n2 == -1) {
            DatabaseError.throwSqlException(154);
            return -1;
        }
        return n2;
    }

    public String toUnicodeString(byte[] byArray, int n2, int n3) throws SQLException {
        int n4 = n2 + n3;
        StringBuffer stringBuffer = new StringBuffer(n3);
        int n5 = 0;
        int n6 = n2;
        while (n6 < n4) {
            n5 = this.m_ucsChar[byArray[n6] & 0xFF];
            if (n5 == this.m_ucsReplacement) {
                DatabaseError.throwSqlException(154);
            }
            if (((long)n5 & 0xFFFFFFFFL) > 65535L) {
                stringBuffer.append((char)(n5 >>> 16));
                stringBuffer.append((char)(n5 & 0xFFFF));
            } else {
                stringBuffer.append((char)n5);
            }
            ++n6;
        }
        return stringBuffer.toString();
    }

    public String toUnicodeStringWithReplacement(byte[] byArray, int n2, int n3) {
        int n4 = n2 + n3;
        StringBuffer stringBuffer = new StringBuffer(n3);
        int n5 = 0;
        int n6 = n2;
        while (n6 < n4) {
            n5 = this.m_ucsChar[byArray[n6] & 0xFF];
            if (n5 == -1) {
                stringBuffer.append((char)this.m_ucsReplacement);
            } else {
                stringBuffer.append((char)n5);
            }
            ++n6;
        }
        return stringBuffer.toString();
    }

    int toUnicodeWithReplacement(byte by) {
        int n2 = this.m_ucsChar[by & 0xFF];
        if (n2 == -1) {
            return this.m_ucsReplacement;
        }
        return n2;
    }
}

