/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMPLTZ;

public class TIMESTAMP
extends Datum
implements Serializable {
    private static final int CENTURY_DEFAULT = 119;
    private static final int DECADE_DEFAULT = 100;
    private static final int MONTH_DEFAULT = 1;
    private static final int DAY_DEFAULT = 1;
    private static final int DECADE_INIT = 170;
    private static final int JAVA_YEAR = 1970;
    private static final int JAVA_MONTH = 0;
    private static final int JAVA_DATE = 1;
    private static final int SIZE_TIMESTAMP = 11;
    private static final int SIZE_TIMESTAMP_NOFRAC = 7;
    private static final int SIZE_DATE = 7;
    private static final int MINYEAR = -4712;
    private static final int MAXYEAR = 9999;
    private static final int JANMONTH = 1;
    private static final int DECMONTH = 12;
    private static final int MINDAYS = 1;
    private static final int MAXDAYS = 31;
    private static final int MINHOURS = 1;
    private static final int MAXHOURS = 24;
    private static final int MINMINUTES = 1;
    private static final int MAXMINUTES = 60;
    private static final int MINSECONDS = 1;
    private static final int MAXSECONDS = 60;
    private static final int[] daysInMonth = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    static final long serialVersionUID = -7964732752952728545L;

    public TIMESTAMP() {
        super(TIMESTAMP.initTimestamp());
    }

    public TIMESTAMP(byte[] byArray) {
        super(byArray);
    }

    public TIMESTAMP(Time time) {
        super(TIMESTAMP.toBytes(time));
    }

    public TIMESTAMP(Date date) {
        super(TIMESTAMP.toBytes(date));
    }

    public TIMESTAMP(Timestamp timestamp) {
        super(TIMESTAMP.toBytes(timestamp));
    }

    public TIMESTAMP(DATE dATE) {
        super(TIMESTAMP.toBytes(dATE));
    }

    public TIMESTAMP(String string) {
        super(TIMESTAMP.toBytes(string));
    }

    public static Date toDate(byte[] byArray) throws SQLException {
        int n2;
        int n3 = byArray.length;
        int[] nArray = n3 == 11 ? new int[11] : new int[7];
        for (n2 = 0; n2 < byArray.length; ++n2) {
            nArray[n2] = byArray[n2] & 0xFF;
        }
        n2 = (nArray[0] - 100) * 100 + (nArray[1] - 100);
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, n2);
        calendar.set(2, nArray[2] - 1);
        calendar.set(5, nArray[3]);
        calendar.set(11, nArray[4] - 1);
        calendar.set(12, nArray[5] - 1);
        calendar.set(13, nArray[6] - 1);
        calendar.set(14, 0);
        long l2 = calendar.getTime().getTime();
        return new Date(l2);
    }

    public static Time toTime(byte[] byArray) throws SQLException {
        int n2 = byArray[4] & 0xFF;
        int n3 = byArray[5] & 0xFF;
        int n4 = byArray[6] & 0xFF;
        return new Time(n2 - 1, n3 - 1, n4 - 1);
    }

    public static Timestamp toTimestamp(byte[] byArray) throws SQLException {
        int n2;
        int n3 = byArray.length;
        int[] nArray = n3 == 11 ? new int[11] : new int[7];
        for (n2 = 0; n2 < byArray.length; ++n2) {
            nArray[n2] = byArray[n2] & 0xFF;
        }
        n2 = (nArray[0] - 100) * 100 + (nArray[1] - 100);
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, n2);
        calendar.set(2, nArray[2] - 1);
        calendar.set(5, nArray[3]);
        calendar.set(11, nArray[4] - 1);
        calendar.set(12, nArray[5] - 1);
        calendar.set(13, nArray[6] - 1);
        calendar.set(14, 0);
        long l2 = calendar.getTime().getTime();
        Timestamp timestamp = new Timestamp(l2);
        if (n3 == 11) {
            int n4 = nArray[7] << 24;
            n4 |= nArray[8] << 16;
            n4 |= nArray[9] << 8;
            timestamp.setNanos(n4 |= nArray[10] & 0xFF);
        } else {
            timestamp.setNanos(0);
        }
        return timestamp;
    }

    public static DATE toDATE(byte[] byArray) throws SQLException {
        byte[] byArray2 = new byte[7];
        System.arraycopy(byArray, 0, byArray2, 0, 7);
        return new DATE(byArray2);
    }

    public Timestamp timestampValue() throws SQLException {
        return TIMESTAMP.toTimestamp(this.getBytes());
    }

    public static String toString(byte[] byArray) {
        int n2 = 0;
        int n3 = byArray.length;
        int[] nArray = n3 == 11 ? new int[11] : new int[7];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            nArray[i2] = byArray[i2] < 0 ? byArray[i2] + 256 : byArray[i2];
        }
        nArray[4] = nArray[4] - 1;
        nArray[5] = nArray[5] - 1;
        nArray[6] = nArray[6] - 1;
        int n4 = (nArray[0] - 100) * 100 + (nArray[1] - 100);
        if (n3 == 11) {
            n2 = (nArray[7] & 0xFF) << 24;
            n2 |= (nArray[8] & 0xFF) << 16;
            n2 |= (nArray[9] & 0xFF) << 8;
            n2 |= nArray[10] & 0xFF & 0xFF;
        }
        return n4 + "-" + nArray[2] + "-" + nArray[3] + " " + nArray[4] + "." + nArray[5] + "." + nArray[6] + "." + n2;
    }

    public byte[] toBytes() {
        return this.getBytes();
    }

    public static byte[] toBytes(Time time) {
        if (time == null) {
            return null;
        }
        byte[] byArray = new byte[7];
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        byArray[0] = 119;
        byArray[1] = 100;
        byArray[2] = 1;
        byArray[3] = 1;
        byArray[4] = (byte)(calendar.get(11) + 1);
        byArray[5] = (byte)(calendar.get(12) + 1);
        byArray[6] = (byte)(calendar.get(13) + 1);
        return byArray;
    }

    public static byte[] toBytes(Date date) {
        if (date == null) {
            return null;
        }
        byte[] byArray = new byte[7];
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        byArray[0] = (byte)(calendar.get(1) / 100 + 100);
        byArray[1] = (byte)(calendar.get(1) % 100 + 100);
        byArray[2] = (byte)(calendar.get(2) + 1);
        byArray[3] = (byte)calendar.get(5);
        byArray[4] = 1;
        byArray[5] = 1;
        byArray[6] = 1;
        return byArray;
    }

    public static byte[] toBytes(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        int n2 = timestamp.getNanos();
        byte[] byArray = n2 == 0 ? new byte[7] : new byte[11];
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(timestamp);
        byArray[0] = (byte)(calendar.get(1) / 100 + 100);
        byArray[1] = (byte)(calendar.get(1) % 100 + 100);
        byArray[2] = (byte)(calendar.get(2) + 1);
        byArray[3] = (byte)calendar.get(5);
        byArray[4] = (byte)(calendar.get(11) + 1);
        byArray[5] = (byte)(calendar.get(12) + 1);
        byArray[6] = (byte)(calendar.get(13) + 1);
        if (n2 != 0) {
            byArray[7] = (byte)(n2 >> 24);
            byArray[8] = (byte)(n2 >> 16 & 0xFF);
            byArray[9] = (byte)(n2 >> 8 & 0xFF);
            byArray[10] = (byte)(n2 & 0xFF);
        }
        return byArray;
    }

    public static byte[] toBytes(DATE dATE) {
        if (dATE == null) {
            return null;
        }
        byte[] byArray = new byte[7];
        System.arraycopy(dATE.getBytes(), 0, byArray, 0, 7);
        return byArray;
    }

    public static byte[] toBytes(String string) {
        return TIMESTAMP.toBytes(Timestamp.valueOf(string));
    }

    public Object toJdbc() throws SQLException {
        return this.timestampValue();
    }

    public Object makeJdbcArray(int n2) {
        Timestamp[] timestampArray = new Timestamp[n2];
        return timestampArray;
    }

    public boolean isConvertibleTo(Class clazz) {
        return clazz.getName().compareTo("java.sql.Date") == 0 || clazz.getName().compareTo("java.sql.Time") == 0 || clazz.getName().compareTo("java.sql.Timestamp") == 0 || clazz.getName().compareTo("java.lang.String") == 0;
    }

    public static TIMESTAMP TimeZoneConvert(Connection connection, TIMESTAMP tIMESTAMP, TimeZone timeZone, TimeZone timeZone2) throws SQLException {
        byte[] byArray = tIMESTAMP.getBytes();
        int n2 = byArray.length;
        int[] nArray = n2 == 11 ? new int[11] : new int[7];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = byArray[i2] & 0xFF;
        }
        TimeZone timeZone3 = TimeZone.getDefault();
        int n3 = (nArray[0] - 100) * 100 + (nArray[1] - 100);
        Calendar calendar = Calendar.getInstance(timeZone);
        Calendar calendar2 = Calendar.getInstance(timeZone2);
        TimeZone.setDefault(calendar.getTimeZone());
        calendar.set(1, n3);
        calendar.set(2, nArray[2] - 1);
        calendar.set(5, nArray[3]);
        calendar.set(11, nArray[4] - 1);
        calendar.set(12, nArray[5] - 1);
        calendar.set(13, nArray[6] - 1);
        calendar.set(14, 0);
        TIMESTAMPLTZ.TimeZoneAdjust(connection, calendar, calendar2);
        long l2 = calendar2.getTime().getTime();
        TimeZone.setDefault(timeZone3);
        Timestamp timestamp = new Timestamp(l2);
        int n4 = 0;
        if (n2 == 11) {
            n4 = nArray[7] << 24;
            n4 |= nArray[8] << 16;
            n4 |= nArray[9] << 8;
            timestamp.setNanos(n4 |= nArray[10] & 0xFF);
        } else {
            timestamp.setNanos(0);
        }
        return new TIMESTAMP(timestamp);
    }

    public String stringValue() {
        return TIMESTAMP.toString(this.getBytes());
    }

    public Date dateValue() throws SQLException {
        return TIMESTAMP.toDate(this.getBytes());
    }

    public Time timeValue() throws SQLException {
        return TIMESTAMP.toTime(this.getBytes());
    }

    private static byte[] initTimestamp() {
        byte[] byArray = new byte[11];
        byArray[0] = 119;
        byArray[1] = -86;
        byArray[2] = 1;
        byArray[3] = 1;
        byArray[4] = 1;
        byArray[5] = 1;
        byArray[6] = 1;
        return byArray;
    }

    private boolean isLeapYear(int n2) {
        return n2 % 4 == 0 && (n2 <= 1582 ? n2 != -4712 : n2 % 100 != 0 || n2 % 400 == 0);
    }

    private boolean isValid() {
        byte[] byArray = this.getBytes();
        if (byArray.length != 11 && byArray.length != 7) {
            return false;
        }
        int n2 = ((byArray[0] & 0xFF) - 100) * 100 + ((byArray[1] & 0xFF) - 100);
        if (n2 < -4712 || n2 > 9999) {
            return false;
        }
        if (n2 == 0) {
            return false;
        }
        int n3 = byArray[2] & 0xFF;
        if (n3 < 1 || n3 > 12) {
            return false;
        }
        int n4 = byArray[3] & 0xFF;
        if (n4 < 1 || n4 > 31) {
            return false;
        }
        if (!(n4 <= daysInMonth[n3 - 1] || this.isLeapYear(n2) && n3 == 2 && n4 == 29)) {
            return false;
        }
        if (n2 == 1582 && n3 == 10 && n4 >= 5 && n4 < 15) {
            return false;
        }
        int n5 = byArray[4] & 0xFF;
        if (n5 < 1 || n5 > 24) {
            return false;
        }
        int n6 = byArray[5] & 0xFF;
        if (n6 < 1 || n6 > 60) {
            return false;
        }
        int n7 = byArray[6] & 0xFF;
        return n7 >= 1 && n7 <= 60;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (!this.isValid()) {
            throw new IOException("Invalid TIMESTAMP");
        }
    }
}

