/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.util.Map;
import java.util.Vector;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.OracleJdbc2SQLInput;
import oracle.sql.OracleSQLOutput;
import oracle.sql.SQLName;
import oracle.sql.STRUCT;
import oracle.sql.TypeDescriptor;

public class StructDescriptor
extends TypeDescriptor
implements Serializable {
    static final boolean DEBUG = false;
    static final long serialVersionUID = 1013921343538311063L;
    transient Boolean isInstanciable = null;
    transient String supertype = null;
    transient int numLocalAttrs = -1;
    transient String[] subtypes = null;
    transient String[] attrJavaNames = null;
    final int LOCAL_TYPE = 0;
    final int LOOK_FOR_USER_SYNONYM = 1;
    final int LOOK_FOR_PUBLIC_SYNONYM = 2;
    final String[] initMetaData1_9_0_SQL = new String[]{"SELECT INSTANTIABLE, supertype_owner, supertype_name, LOCAL_ATTRIBUTES FROM all_types WHERE type_name = :1 AND owner = :2 ", "DECLARE \n bind_synonym_name user_synonyms.synonym_name%type := :1; \n the_table_owner  user_synonyms.table_owner%type; \n the_table_name   user_synonyms.table_name%type; \n the_db_link      user_synonyms.db_link%type; \n sql_string       VARCHAR2(1000); \nBEGIN \n   SELECT /*+RULE*/ TABLE_NAME, TABLE_OWNER, DB_LINK INTO  \n         the_table_name, the_table_owner, the_db_link \n         FROM USER_SYNONYMS WHERE \n         SYNONYM_NAME = bind_synonym_name; \n \n   sql_string := 'SELECT /*+RULE*/ INSTANTIABLE, SUPERTYPE_OWNER,      SUPERTYPE_NAME, LOCAL_ATTRIBUTES FROM ALL_TYPES'; \n \n   IF the_db_link IS NOT NULL  \n   THEN \n     sql_string := sql_string || '@' || the_db_link; \n   END IF; \n   sql_string := sql_string       || ' WHERE TYPE_NAME = '''       || the_table_name   || ''' AND OWNER = '''       || the_table_owner  || ''''; \n   OPEN :2 FOR sql_string; \nEND;", "DECLARE \n bind_synonym_name user_synonyms.synonym_name%type := :1; \n the_table_owner  user_synonyms.table_owner%type; \n the_table_name   user_synonyms.table_name%type; \n the_db_link      user_synonyms.db_link%type; \n sql_string       VARCHAR2(1000); \nBEGIN \n   SELECT /*+RULE*/ TABLE_NAME, TABLE_OWNER, DB_LINK INTO  \n         the_table_name, the_table_owner, the_db_link \n         FROM ALL_SYNONYMS WHERE \n         OWNER = 'PUBLIC' AND \n         SYNONYM_NAME = bind_synonym_name; \n \n   sql_string := 'SELECT /*+RULE*/ INSTANTIABLE, SUPERTYPE_OWNER,      SUPERTYPE_NAME, LOCAL_ATTRIBUTES FROM ALL_TYPES'; \n \n   IF the_db_link IS NOT NULL  \n   THEN \n     sql_string := sql_string || '@' || the_db_link; \n   END IF; \n   sql_string := sql_string       || ' WHERE TYPE_NAME = '''       || the_table_name   || ''' AND OWNER = '''       || the_table_owner  || ''''; \n   OPEN :2 FOR sql_string; \nEND;"};
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:35_PDT_2005";

    public StructDescriptor(String string, Connection connection) throws SQLException {
        super(string, connection);
        this.initPickler();
    }

    public StructDescriptor(OracleTypeADT oracleTypeADT, Connection connection) throws SQLException {
        super(oracleTypeADT, connection);
    }

    public StructDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        super(sQLName, connection);
        this.initPickler();
    }

    public StructDescriptor(SQLName sQLName, OracleTypeADT oracleTypeADT, Connection connection) throws SQLException {
        super(sQLName, oracleTypeADT, connection);
    }

    public static StructDescriptor createDescriptor(String string, Connection connection) throws SQLException {
        return StructDescriptor.createDescriptor(string, connection, false, false);
    }

    public static StructDescriptor createDescriptor(String string, Connection connection, boolean bl2, boolean bl3) throws SQLException {
        if (string == null || string.length() == 0 || connection == null) {
            DatabaseError.throwSqlException(60, "Invalid arguments");
        }
        SQLName sQLName = new SQLName(string, (oracle.jdbc.OracleConnection)connection);
        return StructDescriptor.createDescriptor(sQLName, connection, bl2, bl3);
    }

    public static StructDescriptor createDescriptor(OracleTypeADT oracleTypeADT) throws SQLException {
        String string = oracleTypeADT.getFullName();
        OracleConnection oracleConnection = oracleTypeADT.getConnection();
        StructDescriptor structDescriptor = (StructDescriptor)oracleConnection.getDescriptor(string);
        if (structDescriptor == null) {
            SQLName sQLName = new SQLName(oracleTypeADT.getSchemaName(), oracleTypeADT.getSimpleName(), oracleTypeADT.getConnection());
            structDescriptor = new StructDescriptor(sQLName, oracleTypeADT, oracleConnection);
            structDescriptor.initNamesRecursively();
            oracleConnection.putDescriptor(string, (Object)structDescriptor);
        }
        return structDescriptor;
    }

    public static StructDescriptor createDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        return StructDescriptor.createDescriptor(sQLName, connection, false, false);
    }

    public static StructDescriptor createDescriptor(SQLName sQLName, Connection connection, boolean bl2, boolean bl3) throws SQLException {
        String string = sQLName.getName();
        StructDescriptor structDescriptor = null;
        if (!bl3 && (structDescriptor = (StructDescriptor)((oracle.jdbc.OracleConnection)connection).getDescriptor(string)) == null) {
            structDescriptor = new StructDescriptor(sQLName, connection);
            if (bl2) {
                structDescriptor.initNamesRecursively();
            }
            ((oracle.jdbc.OracleConnection)connection).putDescriptor(string, structDescriptor);
        }
        return structDescriptor;
    }

    static StructDescriptor createDescriptor(SQLName sQLName, byte[] byArray, int n2, byte[] byArray2, byte[] byArray3, OracleConnection oracleConnection, byte[] byArray4) throws SQLException {
        OracleTypeADT oracleTypeADT = new OracleTypeADT(sQLName, byArray, n2, byArray2, byArray3, oracleConnection, byArray4);
        return new StructDescriptor(sQLName, oracleTypeADT, oracleConnection);
    }

    public String descType() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        return this.descType(stringBuffer, 0);
    }

    String descType(StringBuffer stringBuffer, int n2) throws SQLException {
        String string = "";
        int n3 = 0;
        while (n3 < n2) {
            string = String.valueOf(string) + "  ";
            ++n3;
        }
        String string2 = String.valueOf(string) + "  ";
        stringBuffer.append(string);
        stringBuffer.append(this.getTypeName());
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("Subtype=" + this.getOracleTypeADT().isSubType());
        stringBuffer.append(" JavaObject=" + this.getOracleTypeADT().isJavaObject());
        stringBuffer.append(" FinalType=" + this.getOracleTypeADT().isFinalType());
        stringBuffer.append("\n");
        ResultSetMetaData resultSetMetaData = this.getMetaData();
        int n4 = resultSetMetaData.getColumnCount();
        int n5 = 0;
        while (n5 < n4) {
            TypeDescriptor typeDescriptor;
            int n6 = resultSetMetaData.getColumnType(n5 + 1);
            if (n6 == 2002 || n6 == 2008) {
                typeDescriptor = StructDescriptor.createDescriptor(resultSetMetaData.getColumnTypeName(n5 + 1), (Connection)this.connection);
                ((StructDescriptor)typeDescriptor).descType(stringBuffer, n2 + 1);
            } else if (n6 == 2003) {
                typeDescriptor = ArrayDescriptor.createDescriptor(resultSetMetaData.getColumnTypeName(n5 + 1), (Connection)this.connection);
                ((ArrayDescriptor)typeDescriptor).descType(stringBuffer, n2 + 1);
            } else if (n6 == 2007) {
                typeDescriptor = OpaqueDescriptor.createDescriptor(resultSetMetaData.getColumnTypeName(n5 + 1), (Connection)this.connection);
                ((OpaqueDescriptor)typeDescriptor).descType(stringBuffer, n2 + 1);
            } else {
                stringBuffer.append(string2);
                stringBuffer.append(resultSetMetaData.getColumnTypeName(n5 + 1));
                stringBuffer.append("\n");
            }
            ++n5;
        }
        String string3 = stringBuffer.substring(0, stringBuffer.length());
        return string3;
    }

    public String getAttributeJavaName(int n2) throws SQLException {
        String string = null;
        if (this.isJavaObject()) {
            if (this.attrJavaNames == null) {
                this.initMetaData3();
            }
            string = this.attrJavaNames[n2];
        }
        return string;
    }

    public String[] getAttributeJavaNames() throws SQLException {
        String[] stringArray = null;
        if (this.isJavaObject()) {
            if (this.attrJavaNames == null) {
                this.initMetaData3();
            }
            stringArray = this.attrJavaNames;
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public Class getClass(Map map) throws SQLException {
        String string = this.getName();
        Class clazz = (Class)map.get(string);
        String string2 = this.getSchemaName();
        String string3 = this.getTypeName();
        if (clazz == null && this.connection.getUserName().equals(string2)) {
            clazz = (Class)map.get(string3);
        }
        if (SQLName.s_parseAllFormat) {
            if (clazz == null && this.connection.getUserName().equals(string2)) {
                clazz = (Class)map.get("\"" + string3 + "\"");
            }
            if (clazz == null) {
                clazz = (Class)map.get("\"" + string2 + "\"" + "." + "\"" + string3 + "\"");
            }
            if (clazz == null) {
                clazz = (Class)map.get("\"" + string2 + "\"" + "." + string3);
            }
            if (clazz == null) {
                clazz = (Class)map.get(String.valueOf(string2) + "." + "\"" + string3 + "\"");
            }
        }
        return clazz;
    }

    private OracleType[] getFieldTypes() throws SQLException {
        OracleType[] oracleTypeArray = ((OracleTypeADT)this.pickler).getAttrTypes();
        return oracleTypeArray;
    }

    public String getJavaClassName() throws SQLException {
        String string = null;
        if (this.isJavaObject()) {
            string = StructDescriptor.getJavaObjectClassName(this.connection, this);
        }
        return string;
    }

    public static String getJavaObjectClassName(Connection connection, String string, String string2) throws SQLException {
        String string3;
        PreparedStatement preparedStatement;
        block9: {
            preparedStatement = null;
            ResultSet resultSet = null;
            string3 = null;
            try {
                try {
                    preparedStatement = connection.prepareStatement("select external_name from all_sqlj_types where owner = :1 and type_name = :2");
                    preparedStatement.setString(1, string);
                    preparedStatement.setString(2, string2);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        string3 = resultSet.getString(1);
                    } else {
                        DatabaseError.throwSqlException(100);
                    }
                }
                catch (SQLException sQLException) {
                }
                Object var7_6 = null;
                if (resultSet == null) break block9;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                throw throwable;
            }
            resultSet.close();
        }
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        return string3;
    }

    public static String getJavaObjectClassName(Connection connection, StructDescriptor structDescriptor) throws SQLException {
        String string = StructDescriptor.getJavaObjectClassName(connection, structDescriptor.getSchemaName(), structDescriptor.getTypeName());
        return string;
    }

    public String getLanguage() throws SQLException {
        String string = null;
        string = this.isJavaObject() ? "JAVA" : "SQL";
        return string;
    }

    public int getLength() throws SQLException {
        int n2 = this.getFieldTypes().length;
        return n2;
    }

    public int getLocalAttributeCount() throws SQLException {
        int n2;
        if (!this.isSubtype()) {
            n2 = this.getOracleTypeADT().getAttrTypes().length;
        } else {
            if (this.numLocalAttrs == -1) {
                this.initMetaData1();
            }
            n2 = this.numLocalAttrs;
        }
        return n2;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSetMetaData resultSetMetaData = this.connection.newStructMetaData(this);
        return resultSetMetaData;
    }

    public OracleTypeADT getOracleTypeADT() {
        OracleTypeADT oracleTypeADT = (OracleTypeADT)this.pickler;
        return oracleTypeADT;
    }

    public String[] getSubtypeNames() throws SQLException {
        if (this.subtypes == null) {
            this.initMetaData2();
        }
        return this.subtypes;
    }

    public String getSupertypeName() throws SQLException {
        String string = null;
        if (this.isSubtype()) {
            if (this.supertype == null) {
                this.initMetaData1();
            }
            string = this.supertype;
        }
        return string;
    }

    public int getTypeCode() throws SQLException {
        int n2 = this.pickler.getTypeCode();
        return n2;
    }

    public int getTypeVersion() throws SQLException {
        int n2 = this.pickler.getTypeVersion();
        return n2;
    }

    private void initMetaData1() throws SQLException {
        short s2 = this.connection.getVersionNumber();
        if (s2 >= 9000) {
            this.initMetaData1_9_0();
        } else {
            this.initMetaData1_pre_9_0();
        }
    }

    private void initMetaData1_9_0() throws SQLException {
        block25: {
            int n2 = 0;
            OracleConnection oracleConnection = this.connection;
            synchronized (oracleConnection) {
                StructDescriptor structDescriptor = this;
                synchronized (structDescriptor) {
                    int n3;
                    OracleCallableStatement oracleCallableStatement;
                    PreparedStatement preparedStatement;
                    block24: {
                        if (this.numLocalAttrs != -1) break block25;
                        preparedStatement = null;
                        oracleCallableStatement = null;
                        ResultSet resultSet = null;
                        n3 = -1;
                        try {
                            block14: while (true) {
                                switch (n2) {
                                    case 0: {
                                        preparedStatement = this.connection.prepareStatement(this.initMetaData1_9_0_SQL[n2]);
                                        preparedStatement.setString(1, this.getTypeName());
                                        preparedStatement.setString(2, this.getSchemaName());
                                        preparedStatement.setFetchSize(1);
                                        resultSet = preparedStatement.executeQuery();
                                        break;
                                    }
                                    case 1: 
                                    case 2: {
                                        try {
                                            oracleCallableStatement = (OracleCallableStatement)this.connection.prepareCall(this.initMetaData1_9_0_SQL[n2]);
                                            oracleCallableStatement.setString(1, this.getTypeName());
                                            oracleCallableStatement.registerOutParameter(2, -10);
                                            oracleCallableStatement.execute();
                                            resultSet = oracleCallableStatement.getCursor(2);
                                            resultSet.setFetchSize(1);
                                            break;
                                        }
                                        catch (SQLException sQLException) {
                                            if (sQLException.getErrorCode() == 1403) {
                                                if (n2 == 1) {
                                                    oracleCallableStatement.close();
                                                    ++n2;
                                                    continue block14;
                                                }
                                                DatabaseError.throwSqlException(1, "Inconsistent catalog view");
                                                break;
                                            }
                                            throw sQLException;
                                        }
                                    }
                                }
                                if (resultSet.next()) break;
                                if (n2 == 2) {
                                    DatabaseError.throwSqlException(1, "Inconsistent catalog view");
                                    continue;
                                }
                                resultSet.close();
                                if (oracleCallableStatement != null) {
                                    oracleCallableStatement.close();
                                }
                                ++n2;
                            }
                            this.isInstanciable = new Boolean(resultSet.getString(1).equals("YES"));
                            this.supertype = String.valueOf(resultSet.getString(2)) + "." + resultSet.getString(3);
                            n3 = resultSet.getInt(4);
                            Object var11_9 = null;
                            if (resultSet == null) break block24;
                        }
                        catch (Throwable throwable) {
                            Object var11_10 = null;
                            if (resultSet != null) {
                                resultSet.close();
                            }
                            if (preparedStatement != null) {
                                preparedStatement.close();
                            }
                            if (oracleCallableStatement != null) {
                                oracleCallableStatement.close();
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    if (oracleCallableStatement != null) {
                        oracleCallableStatement.close();
                    }
                    this.numLocalAttrs = n3;
                }
            }
        }
    }

    private synchronized void initMetaData1_pre_9_0() throws SQLException {
        this.isInstanciable = new Boolean(true);
        this.supertype = "";
        this.numLocalAttrs = 0;
    }

    private void initMetaData2() throws SQLException {
        short s2 = this.connection.getVersionNumber();
        if (s2 >= 9000) {
            this.initMetaData2_9_0();
        } else {
            this.initMetaData2_pre_9_0();
        }
    }

    private void initMetaData2_9_0() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            StructDescriptor structDescriptor = this;
            synchronized (structDescriptor) {
                if (this.subtypes == null) {
                    PreparedStatement preparedStatement = null;
                    ResultSet resultSet = null;
                    String[] stringArray = null;
                    try {
                        preparedStatement = this.connection.prepareStatement("select owner, type_name from all_types where supertype_name = :1 and supertype_owner = :2");
                        preparedStatement.setString(1, this.getTypeName());
                        preparedStatement.setString(2, this.getSchemaName());
                        resultSet = preparedStatement.executeQuery();
                        Vector<String> vector = new Vector<String>();
                        while (resultSet.next()) {
                            vector.addElement(String.valueOf(resultSet.getString(1)) + "." + resultSet.getString(2));
                        }
                        stringArray = new String[vector.size()];
                        int n2 = 0;
                        while (n2 < stringArray.length) {
                            stringArray[n2] = (String)vector.elementAt(n2);
                            ++n2;
                        }
                        vector.removeAllElements();
                        vector = null;
                    }
                    finally {
                        Object var9_8 = null;
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    this.subtypes = stringArray;
                }
            }
        }
    }

    private void initMetaData2_pre_9_0() throws SQLException {
        this.subtypes = new String[0];
    }

    private void initMetaData3() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            StructDescriptor structDescriptor = this;
            synchronized (structDescriptor) {
                if (this.attrJavaNames == null) {
                    String[] stringArray = null;
                    PreparedStatement preparedStatement = null;
                    ResultSet resultSet = null;
                    try {
                        preparedStatement = this.connection.prepareStatement("select EXTERNAL_ATTR_NAME from all_sqlj_type_attrs where owner = :1 and type_name = :2");
                        preparedStatement.setString(1, this.getSchemaName());
                        preparedStatement.setString(2, this.getTypeName());
                        resultSet = preparedStatement.executeQuery();
                        stringArray = new String[this.getOracleTypeADT().getAttrTypes().length];
                        int n2 = 0;
                        while (resultSet.next()) {
                            stringArray[n2] = resultSet.getString(1);
                            ++n2;
                        }
                    }
                    finally {
                        Object var9_7 = null;
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    this.attrJavaNames = stringArray;
                }
            }
        }
    }

    private void initPickler() throws SQLException {
        try {
            this.pickler = new OracleTypeADT(this.getName(), (Connection)this.connection);
            ((OracleTypeADT)this.pickler).init(this.connection);
            this.pickler.setDescriptor(this);
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            DatabaseError.throwSqlException(60, "Unable to resolve type \"" + this.getName() + "\"");
        }
    }

    public boolean isFinalType() throws SQLException {
        boolean bl2 = this.getOracleTypeADT().isFinalType();
        return bl2;
    }

    public boolean isInHierarchyOf(String string) throws SQLException {
        StructDescriptor structDescriptor = this;
        String string2 = structDescriptor.getName();
        boolean bl2 = false;
        if (string.equals(string2)) {
            bl2 = true;
        } else {
            while (true) {
                if ((string2 = structDescriptor.getSupertypeName()) == null) {
                    bl2 = false;
                    break;
                }
                if (string.equals(string2)) {
                    bl2 = true;
                    break;
                }
                structDescriptor = StructDescriptor.createDescriptor(string2, (Connection)this.connection);
            }
        }
        return bl2;
    }

    public boolean isInstantiable() throws SQLException {
        if (this.isInstanciable == null) {
            this.initMetaData1();
        }
        boolean bl2 = this.isInstanciable;
        return bl2;
    }

    public boolean isJavaObject() throws SQLException {
        boolean bl2 = this.getOracleTypeADT().isJavaObject();
        return bl2;
    }

    public boolean isSubtype() throws SQLException {
        boolean bl2 = this.getOracleTypeADT().isSubType();
        return bl2;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }

    Object[] toArray(STRUCT sTRUCT, Map map, boolean bl2) throws SQLException {
        Object[] objectArray = null;
        if (sTRUCT.objectArray == null) {
            if (sTRUCT.datumArray != null) {
                objectArray = new Object[sTRUCT.datumArray.length];
                int n2 = 0;
                while (n2 < sTRUCT.datumArray.length) {
                    if (sTRUCT.datumArray[n2] != null) {
                        objectArray[n2] = sTRUCT.datumArray[n2] instanceof STRUCT ? ((STRUCT)sTRUCT.datumArray[n2]).toJdbc(map) : sTRUCT.datumArray[n2].toJdbc();
                    }
                    ++n2;
                }
            } else if (sTRUCT.shareBytes() != null) {
                if ((sTRUCT.shareBytes()[0] & 0x80) <= 0 && ((OracleTypeADT)this.pickler).isEmbeddedADT()) {
                    this.pickler = OracleTypeADT.shallowClone((OracleTypeADT)this.pickler);
                }
                this.pickler.unlinearize(sTRUCT.shareBytes(), sTRUCT.imageOffset, sTRUCT, 2, map);
                objectArray = sTRUCT.objectArray;
                sTRUCT.objectArray = null;
            } else {
                DatabaseError.throwSqlException(1);
            }
        } else {
            objectArray = (Object[])sTRUCT.objectArray.clone();
        }
        return objectArray;
    }

    public Datum[] toArray(byte[] byArray) throws SQLException {
        STRUCT sTRUCT = new STRUCT(this, byArray, this.connection);
        return this.toOracleArray(sTRUCT, false);
    }

    public Datum[] toArray(Object[] objectArray) throws SQLException {
        return this.toOracleArray(objectArray);
    }

    byte[] toBytes(STRUCT sTRUCT, boolean bl2) throws SQLException {
        byte[] byArray = sTRUCT.shareBytes();
        if (byArray == null) {
            if (sTRUCT.datumArray != null) {
                byArray = this.pickler.linearize(sTRUCT);
                if (!bl2) {
                    sTRUCT.setShareBytes(null);
                }
            } else if (sTRUCT.objectArray != null) {
                sTRUCT.datumArray = this.toOracleArray(sTRUCT.objectArray);
                byArray = this.pickler.linearize(sTRUCT);
                if (!bl2) {
                    sTRUCT.datumArray = null;
                    sTRUCT.setShareBytes(null);
                }
            } else {
                DatabaseError.throwSqlException(1);
            }
        } else if (sTRUCT.imageLength != 0L && (sTRUCT.imageOffset != 0L || sTRUCT.imageLength != (long)byArray.length)) {
            byte[] byArray2 = new byte[(int)sTRUCT.imageLength];
            System.arraycopy(byArray, (int)sTRUCT.imageOffset, byArray2, 0, (int)sTRUCT.imageLength);
            sTRUCT.setImage(byArray2, 0L, 0L);
            byArray = byArray2;
        }
        return byArray;
    }

    public byte[] toBytes(Object[] objectArray) throws SQLException {
        Datum[] datumArray = this.toOracleArray(objectArray);
        return this.toBytes(datumArray);
    }

    public byte[] toBytes(Datum[] datumArray) throws SQLException {
        STRUCT sTRUCT = new STRUCT(this, null, this.connection);
        sTRUCT.setDatumArray(datumArray);
        return this.pickler.linearize(sTRUCT);
    }

    public SQLInput toJdbc2SQLInput(STRUCT sTRUCT, Map map) throws SQLException {
        OracleJdbc2SQLInput oracleJdbc2SQLInput = new OracleJdbc2SQLInput(this.toOracleArray(sTRUCT, false), map, this.connection);
        return oracleJdbc2SQLInput;
    }

    public SQLOutput toJdbc2SQLOutput() throws SQLException {
        OracleSQLOutput oracleSQLOutput = new OracleSQLOutput(this, this.connection);
        return oracleSQLOutput;
    }

    public Datum[] toOracleArray(Map map) throws SQLException {
        Datum[] datumArray = null;
        int n2 = 0;
        if (map != null) {
            OracleType[] oracleTypeArray = this.getFieldTypes();
            int n3 = oracleTypeArray.length;
            int n4 = map.size();
            datumArray = new Datum[n3];
            OracleConnection oracleConnection = this.connection;
            int n5 = 0;
            while (n5 < n3) {
                Object v2 = map.get(((OracleTypeADT)this.pickler).getAttributeName(n5 + 1));
                datumArray[n5] = oracleTypeArray[n5].toDatum(v2, oracleConnection);
                if (v2 != null || map.containsKey(((OracleTypeADT)this.pickler).getAttributeName(n5 + 1))) {
                    ++n2;
                }
                ++n5;
            }
            if (n2 < n4) {
                DatabaseError.throwSqlException(68, null);
            }
        }
        return datumArray;
    }

    Datum[] toOracleArray(STRUCT sTRUCT, boolean bl2) throws SQLException {
        Datum[] datumArray = sTRUCT.datumArray;
        Datum[] datumArray2 = null;
        if (datumArray == null) {
            if (sTRUCT.objectArray != null) {
                datumArray = this.toOracleArray(sTRUCT.objectArray);
            } else if (sTRUCT.shareBytes() != null) {
                if ((sTRUCT.shareBytes()[0] & 0x80) <= 0 && ((OracleTypeADT)this.pickler).isEmbeddedADT()) {
                    this.pickler = OracleTypeADT.shallowClone((OracleTypeADT)this.pickler);
                }
                this.pickler.unlinearize(sTRUCT.shareBytes(), sTRUCT.imageOffset, sTRUCT, 1, null);
                datumArray = sTRUCT.datumArray;
                if (!bl2) {
                    sTRUCT.datumArray = null;
                }
            } else {
                DatabaseError.throwSqlException(1);
            }
        }
        if (bl2) {
            sTRUCT.datumArray = datumArray;
            datumArray2 = (Datum[])datumArray.clone();
        } else {
            datumArray2 = datumArray;
        }
        return datumArray2;
    }

    public Datum[] toOracleArray(Object[] objectArray) throws SQLException {
        Datum[] datumArray = null;
        if (objectArray != null) {
            OracleType[] oracleTypeArray = this.getFieldTypes();
            int n2 = oracleTypeArray.length;
            if (objectArray.length != n2) {
                DatabaseError.throwSqlException(49, null);
            }
            datumArray = new Datum[n2];
            OracleConnection oracleConnection = this.connection;
            int n3 = 0;
            while (n3 < n2) {
                datumArray[n3] = oracleTypeArray[n3].toDatum(objectArray[n3], oracleConnection);
                ++n3;
            }
        }
        return datumArray;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }
}

