/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.DatabaseError;

public class SQLName
implements Serializable {
    static boolean DEBUG = false;
    static boolean s_parseAllFormat = false;
    static final long serialVersionUID = 2266340348729491526L;
    String name;
    String schema;
    String simple;
    int version;
    boolean synonym;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:35_PDT_2005";

    protected SQLName() {
    }

    public SQLName(String string, String string2, OracleConnection oracleConnection) throws SQLException {
        this.schema = string;
        this.simple = string2;
        this.name = String.valueOf(this.schema) + "." + this.simple;
        this.version = 2;
        this.synonym = false;
    }

    public SQLName(String string, OracleConnection oracleConnection) throws SQLException {
        this.init(string, oracleConnection);
        this.version = 2;
        this.synonym = false;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SQLName)) {
            return false;
        }
        return ((SQLName)object).name.equals(this.name);
    }

    public static boolean getHandleDoubleQuote() throws SQLException {
        return s_parseAllFormat;
    }

    public String getName() throws SQLException {
        return this.name;
    }

    public String getSchema() throws SQLException {
        return this.schema;
    }

    public String getSimpleName() throws SQLException {
        return this.simple;
    }

    public int getVersion() throws SQLException {
        return this.version;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    private void init(String string, OracleConnection oracleConnection) throws SQLException {
        String[] stringArray = new String[1];
        String[] stringArray2 = new String[1];
        if (SQLName.parse(string, stringArray, stringArray2, true)) {
            this.schema = stringArray[0];
            this.simple = stringArray2[0];
        } else {
            this.schema = oracleConnection.getUserName();
            this.simple = stringArray2[0];
        }
        this.name = String.valueOf(this.schema) + "." + this.simple;
    }

    public static boolean parse(String string, String[] stringArray, String[] stringArray2) throws SQLException {
        return SQLName.parse(string, stringArray, stringArray2, s_parseAllFormat);
    }

    public static boolean parse(String string, String[] stringArray, String[] stringArray2, boolean bl2) throws SQLException {
        if (string == null) {
            return false;
        }
        if (stringArray == null || stringArray.length < 1 || stringArray2 == null || stringArray2.length < 1) {
            DatabaseError.throwSqlException(68);
        }
        if (!bl2) {
            int n2 = string.indexOf(".");
            if (n2 < 0) {
                stringArray2[0] = string;
                return false;
            }
            stringArray[0] = string.substring(0, n2);
            stringArray2[0] = string.substring(n2 + 1);
            return true;
        }
        int n3 = string.length();
        int n4 = string.indexOf("\"");
        int n5 = string.indexOf("\"", n4 + 1);
        int n6 = -1;
        if (n4 < 0) {
            n6 = string.indexOf(".");
            if (n6 < 0) {
                stringArray2[0] = string;
                return false;
            }
            stringArray[0] = string.substring(0, n6);
            stringArray2[0] = string.substring(n6 + 1);
            return true;
        }
        if (n4 == 0) {
            if (n5 == n3 - 1) {
                stringArray2[0] = string.substring(n4 + 1, n5);
                return false;
            }
            n6 = string.indexOf(".", n5);
            stringArray[0] = string.substring(n4 + 1, n5);
            n4 = string.indexOf("\"", n6);
            n5 = string.indexOf("\"", n4 + 1);
            if (n4 < 0) {
                stringArray2[0] = string.substring(n6 + 1);
                return true;
            }
            stringArray2[0] = string.substring(n4 + 1, n5);
            return true;
        }
        n6 = string.indexOf(".");
        stringArray[0] = string.substring(0, n6);
        stringArray2[0] = string.substring(n4 + 1, n5);
        return true;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.name = objectInputStream.readUTF();
        this.schema = objectInputStream.readUTF();
        this.simple = objectInputStream.readUTF();
        this.version = objectInputStream.readInt();
        this.synonym = objectInputStream.readBoolean();
    }

    public static void setHandleDoubleQuote(boolean bl2) throws SQLException {
        s_parseAllFormat = bl2;
    }

    public String toString() {
        return this.name;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeUTF(this.name);
        objectOutputStream.writeUTF(this.schema);
        objectOutputStream.writeUTF(this.simple);
        objectOutputStream.writeInt(this.version);
        objectOutputStream.writeBoolean(this.synonym);
    }
}

