/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.sql.Datum;

public class BINARY_FLOAT
extends Datum {
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:33_PDT_2005";

    public BINARY_FLOAT() {
    }

    public BINARY_FLOAT(float f2) {
        super(BINARY_FLOAT.floatToCanonicalFormatBytes(f2));
    }

    public BINARY_FLOAT(Float f2) {
        super(BINARY_FLOAT.floatToCanonicalFormatBytes(f2.floatValue()));
    }

    public BINARY_FLOAT(byte[] byArray) {
        super(byArray);
    }

    static float canonicalFormatBytesToFloat(byte[] byArray) {
        int n2 = byArray[0];
        int n3 = byArray[1];
        int n4 = byArray[2];
        int n5 = byArray[3];
        if ((n2 & 0x80) != 0) {
            n2 &= 0x7F;
            n3 &= 0xFF;
            n4 &= 0xFF;
            n5 &= 0xFF;
        } else {
            n2 = ~n2 & 0xFF;
            n3 = ~n3 & 0xFF;
            n4 = ~n4 & 0xFF;
            n5 = ~n5 & 0xFF;
        }
        int n6 = n2 << 24 | n3 << 16 | n4 << 8 | n5;
        return Float.intBitsToFloat(n6);
    }

    static byte[] floatToCanonicalFormatBytes(float f2) {
        float f3 = f2;
        if (f3 == 0.0f) {
            f3 = 0.0f;
        } else if (f3 != f3) {
            f3 = Float.NaN;
        }
        int n2 = Float.floatToIntBits(f3);
        byte[] byArray = new byte[4];
        int n3 = n2;
        int n4 = n2 >>= 8;
        int n5 = n2 >>= 8;
        int n6 = n2 >>= 8;
        if ((n6 & 0x80) == 0) {
            n6 |= 0x80;
        } else {
            n6 ^= 0xFFFFFFFF;
            n5 ^= 0xFFFFFFFF;
            n4 ^= 0xFFFFFFFF;
            n3 ^= 0xFFFFFFFF;
        }
        byArray[3] = (byte)n3;
        byArray[2] = (byte)n4;
        byArray[1] = (byte)n5;
        byArray[0] = (byte)n6;
        return byArray;
    }

    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        return string.compareTo("java.lang.String") == 0 || string.compareTo("java.lang.Float") == 0;
    }

    public Object makeJdbcArray(int n2) {
        return new Float[n2];
    }

    public String stringValue() {
        String string = Float.toString(BINARY_FLOAT.canonicalFormatBytesToFloat(this.getBytes()));
        return string;
    }

    public Object toJdbc() throws SQLException {
        return new Float(BINARY_FLOAT.canonicalFormatBytesToFloat(this.getBytes()));
    }
}

