/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.InterruptedIOException;
import oracle.net.nl.RepConversion;
import oracle.net.ns.NetException;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

public class Packet
implements SQLnetDef {
    private int buffer2send;
    protected int sdu;
    protected int tdu;
    protected int length;
    public int type;
    protected int flags;
    protected int dataLen;
    protected int dataOff;
    protected String data;
    protected byte[] buffer;
    protected byte[] header = new byte[8];
    public SessionAtts sAtts;

    public Packet(Packet packet) {
        this(packet.sAtts);
        this.length = packet.length;
        this.type = packet.type;
        this.flags = packet.flags;
        this.dataLen = packet.dataLen;
        this.dataOff = packet.dataOff;
        this.buffer = packet.buffer;
    }

    public Packet(SessionAtts sessionAtts) {
        this.sAtts = sessionAtts;
        this.sdu = sessionAtts.getSDU();
        this.tdu = sessionAtts.getTDU();
    }

    public Packet(SessionAtts sessionAtts, int n2) {
        this(sessionAtts);
        this.createBuffer(n2);
    }

    public Packet(SessionAtts sessionAtts, int n2, int n3, int n4) {
        this(sessionAtts);
        this.createBuffer(n2, n3, n4);
    }

    protected void createBuffer(int n2) {
        this.buffer = new byte[n2];
        this.buffer[0] = (byte)(n2 / 256);
        this.buffer[1] = (byte)(n2 % 256);
    }

    protected void createBuffer(int n2, int n3, int n4) {
        this.buffer = new byte[n2];
        this.buffer[0] = (byte)(n2 / 256);
        this.buffer[1] = (byte)(n2 % 256);
        this.buffer[5] = (byte)n4;
        this.buffer[4] = (byte)n3;
    }

    protected void dump(byte[] byArray, int n2, int n3) {
        int n4 = 0;
        System.out.println("Packet dump");
        System.out.println("buffer.length=" + byArray.length);
        System.out.println("offset       =" + n2);
        System.out.println("len          =" + n3);
        int n5 = n2;
        while (n5 < n3) {
            System.out.print("|");
            int n6 = 0;
            while (n6 < 8 && n4 < n3 - 1) {
                n4 = n5 + n6;
                RepConversion.printInHex(byArray[n4]);
                System.out.print(" ");
                ++n6;
            }
            System.out.println("|");
            n5 += 8;
        }
        System.out.println("finish dump");
    }

    protected void extractData() throws IOException, NetException {
        if (this.dataLen <= 0) {
            this.data = new String();
        } else if (this.length > this.dataOff) {
            this.data = new String(this.buffer, 0, this.dataOff, this.dataLen);
        } else {
            byte[] byArray = new byte[this.dataLen];
            if (this.sAtts.nsInputStream.read(byArray) < 0) {
                throw new NetException(0);
            }
            this.data = new String(byArray, 0);
        }
    }

    protected String getData() {
        return this.data;
    }

    protected void receive() throws IOException, NetException {
        int n2;
        for (n2 = 0; n2 < this.header.length; n2 += this.sAtts.ntInputStream.read(this.header, n2, this.header.length - n2)) {
            try {
                if (n2 > 0) continue;
                throw new NetException(0);
            }
            catch (InterruptedIOException interruptedIOException) {
                throw new NetException(504);
            }
        }
        this.length = this.header[0] & 0xFF;
        this.length <<= 8;
        this.length |= this.header[1] & 0xFF;
        this.type = this.header[4];
        this.flags = this.header[5];
        if (this.type > 19) {
            throw new NetException(204);
        }
        if (this.length > Short.MAX_VALUE || this.length > this.sdu) {
            throw new NetException(203);
        }
        if (this.length < 8) {
            throw new NetException(207);
        }
        this.buffer[5] = (byte)this.flags;
        this.buffer[4] = (byte)this.type;
        while (n2 < this.length) {
            try {
                n2 += this.sAtts.ntInputStream.read(this.buffer, n2, this.length - n2);
                if (n2 > 0) continue;
                throw new NetException(0);
            }
            catch (InterruptedIOException interruptedIOException) {}
        }
    }

    protected void send() throws IOException {
        this.sAtts.ntOutputStream.write(this.buffer, 0, this.buffer.length);
    }
}

