/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.TNSAddress;

import java.util.Vector;
import oracle.net.TNSAddress.SOException;
import oracle.net.TNSAddress.SchemaObject;
import oracle.net.TNSAddress.SchemaObjectFactoryInterface;
import oracle.net.nl.NLException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVPair;

public class DescriptionList
implements SchemaObject {
    public Vector children = new Vector();
    private SchemaObject child;
    private NVPair childnv;
    public boolean sourceRoute = false;
    public boolean loadBalance = true;
    public boolean failover = true;
    protected SchemaObjectFactoryInterface f = null;

    public DescriptionList(SchemaObjectFactoryInterface schemaObjectFactoryInterface) {
        this.f = schemaObjectFactoryInterface;
    }

    protected void init() {
        this.children.removeAllElements();
        this.child = null;
        this.childnv = null;
        this.sourceRoute = false;
        this.loadBalance = true;
        this.failover = true;
    }

    public void initFromNVPair(NVPair nVPair) throws SOException {
        this.init();
        int n2 = nVPair.getListSize();
        if (n2 == 0) {
            throw new SOException();
        }
        int n3 = 0;
        while (n3 < n2) {
            this.childnv = nVPair.getListElement(n3);
            if (this.childnv.getName().equalsIgnoreCase("SOURCE_ROUTE")) {
                this.sourceRoute = this.childnv.getAtom().equalsIgnoreCase("yes") || this.childnv.getAtom().equalsIgnoreCase("on") || this.childnv.getAtom().equalsIgnoreCase("true");
            } else if (this.childnv.getName().equalsIgnoreCase("LOAD_BALANCE")) {
                this.loadBalance = this.childnv.getAtom().equalsIgnoreCase("yes") || this.childnv.getAtom().equalsIgnoreCase("on") || this.childnv.getAtom().equalsIgnoreCase("true");
            } else if (this.childnv.getName().equalsIgnoreCase("FAILOVER")) {
                this.failover = this.childnv.getAtom().equalsIgnoreCase("yes") || this.childnv.getAtom().equalsIgnoreCase("on") || this.childnv.getAtom().equalsIgnoreCase("true");
            } else if (this.childnv.getName().equalsIgnoreCase("DESCRIPTION")) {
                this.child = this.f.create(2);
                this.child.initFromNVPair(this.childnv);
                this.children.addElement(this.child);
            } else {
                throw new SOException();
            }
            ++n3;
        }
        if (this.children.size() == 0) {
            throw new SOException();
        }
    }

    public void initFromString(String string) throws NLException, SOException {
        NVPair nVPair = new NVFactory().createNVPair(string);
        this.initFromNVPair(nVPair);
    }

    public int isA() {
        return 3;
    }

    public String isA_String() {
        return "DESCRIPTION_LIST";
    }

    public String toString() {
        String string = new String("");
        if (this.children.size() < 1) {
            return string;
        }
        String string2 = new String("");
        int n2 = 0;
        while (n2 < this.children.size()) {
            string2 = ((SchemaObject)this.children.elementAt(n2)).toString();
            if (!string2.equals("")) {
                string = String.valueOf(string) + string2;
            }
            ++n2;
        }
        if (string.equals("") && this.sourceRoute) {
            string = String.valueOf(string) + "(SOURCE_ROUTE=yes)";
        }
        if (string.equals("") && !this.loadBalance) {
            string = String.valueOf(string) + "(LOAD_BALANCE=no)";
        }
        if (string.equals("") && !this.failover) {
            string = String.valueOf(string) + "(FAILOVER=false)";
        }
        if (!string.equals("")) {
            string = "(DESCRIPTION_LIST=" + string + ")";
        }
        return string;
    }
}

