/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.TNSAddress;

import java.util.Vector;
import oracle.net.TNSAddress.SOException;
import oracle.net.TNSAddress.SchemaObject;
import oracle.net.TNSAddress.SchemaObjectFactoryInterface;
import oracle.net.nl.InvalidSyntaxException;
import oracle.net.nl.NLException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVPair;

public class Description
implements SchemaObject {
    public Vector children = new Vector();
    private SchemaObject child;
    private NVPair childnv;
    protected SchemaObjectFactoryInterface f = null;
    public boolean sourceRoute = false;
    public boolean loadBalance = false;
    public boolean failover = true;
    public boolean keepAlive = false;
    public String SDU;
    public String TDU;
    public Vector protocolStacks = new Vector();
    public String sendBufSize;
    public String receiveBufSize;
    public String connectData;
    public String SID;
    public String server;
    public String failoverMode;
    public String instanceRole;
    public String serviceName;
    public String instanceName;
    public String handlerName;
    public String oracleHome;
    public String authTypes;
    public String sslServerCertDN;
    public Vector authParams = new Vector();
    public Vector extraConnInfo = new Vector();
    public Vector extraInfo = new Vector();

    public Description(SchemaObjectFactoryInterface schemaObjectFactoryInterface) {
        this.f = schemaObjectFactoryInterface;
    }

    protected void init() {
        this.children.removeAllElements();
        this.child = null;
        this.childnv = null;
        this.sourceRoute = false;
        this.loadBalance = false;
        this.failover = true;
        this.keepAlive = false;
        this.protocolStacks.removeAllElements();
        this.SDU = null;
        this.TDU = null;
        this.SID = null;
        this.server = null;
        this.serviceName = null;
        this.instanceName = null;
        this.handlerName = null;
        this.oracleHome = null;
        this.authTypes = null;
        this.sendBufSize = null;
        this.receiveBufSize = null;
        this.failoverMode = null;
        this.instanceRole = null;
        this.authParams.removeAllElements();
        this.extraConnInfo.removeAllElements();
        this.extraInfo.removeAllElements();
    }

    public void initFromNVPair(NVPair nVPair) throws SOException {
        this.init();
        int n2 = nVPair.getListSize();
        if (n2 == 0) {
            throw new SOException();
        }
        int n3 = 0;
        while (n3 < n2) {
            NVPair nVPair2;
            int n4;
            this.childnv = nVPair.getListElement(n3);
            if (this.childnv.getName().equalsIgnoreCase("SOURCE_ROUTE")) {
                this.sourceRoute = this.childnv.getAtom().equalsIgnoreCase("yes") || this.childnv.getAtom().equalsIgnoreCase("on") || this.childnv.getAtom().equalsIgnoreCase("true");
            } else if (this.childnv.getName().equalsIgnoreCase("LOAD_BALANCE")) {
                this.loadBalance = this.childnv.getAtom().equalsIgnoreCase("yes") || this.childnv.getAtom().equalsIgnoreCase("on") || this.childnv.getAtom().equalsIgnoreCase("true");
            } else if (this.childnv.getName().equalsIgnoreCase("FAILOVER")) {
                this.failover = this.childnv.getAtom().equalsIgnoreCase("yes") || this.childnv.getAtom().equalsIgnoreCase("on") || this.childnv.getAtom().equalsIgnoreCase("true");
            } else if (this.childnv.getName().equalsIgnoreCase("ENABLE")) {
                this.keepAlive = this.childnv.getAtom().equalsIgnoreCase("broken");
            } else if (this.childnv.getName().equalsIgnoreCase("PROTOCOL_STACK")) {
                this.protocolStacks.addElement(this.childnv.toString());
            } else if (this.childnv.getName().equalsIgnoreCase("ADDRESS")) {
                this.child = this.f.create(0);
                this.child.initFromNVPair(this.childnv);
                this.children.addElement(this.child);
            } else if (this.childnv.getName().equalsIgnoreCase("ADDRESS_LIST")) {
                this.child = this.f.create(1);
                this.child.initFromNVPair(this.childnv);
                this.children.addElement(this.child);
            } else if (this.childnv.getName().equalsIgnoreCase("SDU")) {
                this.SDU = this.childnv.getAtom();
            } else if (this.childnv.getName().equalsIgnoreCase("TDU")) {
                this.TDU = this.childnv.getAtom();
            } else if (this.childnv.getName().equalsIgnoreCase("SEND_BUF_SIZE")) {
                this.sendBufSize = this.childnv.getAtom();
            } else if (this.childnv.getName().equalsIgnoreCase("RECV_BUF_SIZE")) {
                this.receiveBufSize = this.childnv.getAtom();
            } else if (this.childnv.getName().equalsIgnoreCase("CONNECT_DATA")) {
                this.connectData = this.childnv.valueToString();
                int n5 = this.childnv.getListSize();
                if (n5 == 0) {
                    throw new SOException();
                }
                n4 = 0;
                while (n4 < n5) {
                    nVPair2 = this.childnv.getListElement(n4);
                    if (nVPair2.getName().equalsIgnoreCase("SID")) {
                        this.SID = nVPair2.getAtom();
                    } else if (nVPair2.getName().equalsIgnoreCase("SERVER")) {
                        this.server = nVPair2.getAtom();
                    } else if (nVPair2.getName().equalsIgnoreCase("SERVICE_NAME")) {
                        this.serviceName = nVPair2.getAtom();
                    } else if (nVPair2.getName().equalsIgnoreCase("INSTANCE_NAME")) {
                        this.instanceName = nVPair2.getAtom();
                    } else if (nVPair2.getName().equalsIgnoreCase("HANDLER_NAME")) {
                        this.handlerName = nVPair2.getAtom();
                    } else if (nVPair2.getName().equalsIgnoreCase("ORACLE_HOME")) {
                        this.oracleHome = nVPair2.getAtom();
                    } else if (nVPair2.getName().equalsIgnoreCase("FAILOVER_MODE")) {
                        this.failoverMode = this.childnv.getListElement(n4).toString();
                    } else if (nVPair2.getName().equalsIgnoreCase("INSTANCE_ROLE")) {
                        this.instanceRole = nVPair2.getAtom();
                    } else {
                        String string = nVPair2.toString().trim();
                        string = string.substring(1, string.length() - 1);
                        this.extraConnInfo.addElement(string);
                    }
                    ++n4;
                }
            } else if (this.childnv.getName().equalsIgnoreCase("SECURITY")) {
                int n6 = this.childnv.getListSize();
                if (n6 == 0) {
                    throw new SOException();
                }
                n4 = 0;
                while (n4 < n6) {
                    nVPair2 = this.childnv.getListElement(n4);
                    if (nVPair2.getName().equalsIgnoreCase("AUTHENTICATION")) {
                        this.authTypes = nVPair2.toString();
                    }
                    if (nVPair2.getName().equalsIgnoreCase("ssl_server_cert_dn")) {
                        this.sslServerCertDN = nVPair2.getAtom();
                        if (this.sslServerCertDN != null && this.sslServerCertDN.startsWith("\"") && this.sslServerCertDN.endsWith("\"")) {
                            this.sslServerCertDN = this.sslServerCertDN.substring(1, this.sslServerCertDN.length() - 1);
                        }
                    } else {
                        this.authParams.addElement(nVPair2.toString());
                    }
                    ++n4;
                }
            } else {
                if (this.childnv.getName().equalsIgnoreCase("HS") && this.childnv.getAtom() == null) {
                    try {
                        this.childnv.setAtom("OK");
                    }
                    catch (InvalidSyntaxException invalidSyntaxException) {}
                }
                String string = this.childnv.toString().trim();
                string = string.substring(1, string.length() - 1);
                this.extraInfo.addElement(string);
            }
            ++n3;
        }
    }

    public void initFromString(String string) throws NLException, SOException {
        NVPair nVPair = new NVFactory().createNVPair(string);
        this.initFromNVPair(nVPair);
    }

    public int isA() {
        return 2;
    }

    public String isA_String() {
        return "DESCRIPTION";
    }

    public String toString() {
        int n2;
        String string = new String("");
        String string2 = new String("");
        int n3 = 0;
        while (n3 < this.children.size()) {
            string2 = ((SchemaObject)this.children.elementAt(n3)).toString();
            if (!string2.equals("")) {
                string = String.valueOf(string) + string2;
            }
            ++n3;
        }
        if (!string.equals("") && this.sourceRoute) {
            string = String.valueOf(string) + "(SOURCE_ROUTE=yes)";
        }
        if (!string.equals("") && this.loadBalance) {
            string = String.valueOf(string) + "(LOAD_BALANCE=yes)";
        }
        if (!string.equals("") && !this.failover) {
            string = String.valueOf(string) + "(FAILOVER=false)";
        }
        if (this.keepAlive) {
            string = String.valueOf(string) + "(ENABLE=broken)";
        }
        if (this.SDU != null) {
            string = String.valueOf(string) + "(SDU=" + this.SDU + ")";
        }
        if (this.TDU != null) {
            string = String.valueOf(string) + "(TDU=" + this.TDU + ")";
        }
        if (this.sendBufSize != null) {
            string = String.valueOf(string) + "(SEND_BUF_SIZE=" + this.sendBufSize + ")";
        }
        if (this.receiveBufSize != null) {
            string = String.valueOf(string) + "(RECV_BUF_SIZE=" + this.receiveBufSize + ")";
        }
        if (this.protocolStacks.size() != 0) {
            n2 = 0;
            while (n2 < this.protocolStacks.size()) {
                string = String.valueOf(string) + (String)this.protocolStacks.elementAt(n2);
                ++n2;
            }
        }
        if (this.SID != null || this.server != null || this.serviceName != null || this.instanceName != null || this.handlerName != null || this.extraConnInfo.size() != 0 || this.oracleHome != null) {
            string = String.valueOf(string) + "(CONNECT_DATA=";
            if (this.SID != null) {
                string = String.valueOf(string) + "(SID=" + this.SID + ")";
            }
            if (this.server != null) {
                string = String.valueOf(string) + "(SERVER=" + this.server + ")";
            }
            if (this.serviceName != null) {
                string = String.valueOf(string) + "(SERVICE_NAME=" + this.serviceName + ")";
            }
            if (this.instanceName != null) {
                string = String.valueOf(string) + "(INSTANCE_NAME=" + this.instanceName + ")";
            }
            if (this.handlerName != null) {
                string = String.valueOf(string) + "(HANDLER_NAME=" + this.handlerName + ")";
            }
            if (this.oracleHome != null) {
                string = String.valueOf(string) + "(ORACLE_HOME=" + this.oracleHome + ")";
            }
            if (this.instanceRole != null) {
                string = String.valueOf(string) + "(INSTANCE_ROLE=" + this.instanceRole + ")";
            }
            if (this.failoverMode != null) {
                string = String.valueOf(string) + this.failoverMode;
            }
            n2 = 0;
            while (n2 < this.extraConnInfo.size()) {
                string = String.valueOf(string) + "(" + (String)this.extraConnInfo.elementAt(n2) + ")";
                ++n2;
            }
            string = String.valueOf(string) + ")";
        }
        if (this.authTypes != null || this.authParams.size() != 0) {
            string = String.valueOf(string) + "(SECURITY=";
            if (this.authTypes != null) {
                string = String.valueOf(string) + "(AUTHENTICATION=" + this.authTypes + ")";
            }
            n2 = 0;
            while (n2 < this.authParams.size()) {
                string = String.valueOf(string) + (String)this.authParams.elementAt(n2);
                ++n2;
            }
            string = String.valueOf(string) + ")";
        }
        n2 = 0;
        while (n2 < this.extraInfo.size()) {
            string = String.valueOf(string) + "(" + (String)this.extraInfo.elementAt(n2) + ")";
            ++n2;
        }
        if (!string.equals("")) {
            string = "(DESCRIPTION=" + string + ")";
        }
        return string;
    }
}

