/*
 * Decompiled with CFR 0.152.
 */
package oracle.jpub.runtime;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jpub.runtime.Util;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public class MutableArray {
    int length;
    Object[] elements;
    Datum[] datums;
    ARRAY pickled;
    boolean pickledCorrect;
    int sqlType;
    ORADataFactory factory;
    CustomDatumFactory old_factory;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:49_PDT_2005";

    public MutableArray(int n2, ARRAY aRRAY, ORADataFactory oRADataFactory) {
        this.length = -1;
        this.elements = null;
        this.datums = null;
        this.pickled = aRRAY;
        this.pickledCorrect = true;
        this.sqlType = n2;
        this.factory = oRADataFactory;
    }

    public MutableArray(int n2, double[] dArray, ORADataFactory oRADataFactory) {
        this.sqlType = n2;
        this.factory = oRADataFactory;
        this.setArray(dArray);
    }

    public MutableArray(int n2, float[] fArray, ORADataFactory oRADataFactory) {
        this.sqlType = n2;
        this.factory = oRADataFactory;
        this.setArray(fArray);
    }

    public MutableArray(int n2, int[] nArray, ORADataFactory oRADataFactory) {
        this.sqlType = n2;
        this.factory = oRADataFactory;
        this.setArray(nArray);
    }

    public MutableArray(int n2, Object[] objectArray, ORADataFactory oRADataFactory) {
        this.sqlType = n2;
        this.factory = oRADataFactory;
        this.setObjectArray(objectArray);
    }

    public MutableArray(int n2, Datum[] datumArray, ORADataFactory oRADataFactory) {
        this.sqlType = n2;
        this.factory = oRADataFactory;
        this.setDatumArray(datumArray);
    }

    public MutableArray(int n2, short[] sArray, ORADataFactory oRADataFactory) {
        this.sqlType = n2;
        this.factory = oRADataFactory;
        this.setArray(sArray);
    }

    public MutableArray(ARRAY aRRAY, int n2, CustomDatumFactory customDatumFactory) {
        this.length = -1;
        this.elements = null;
        this.datums = null;
        this.pickled = aRRAY;
        this.pickledCorrect = true;
        this.sqlType = n2;
        this.old_factory = customDatumFactory;
    }

    public MutableArray(double[] dArray, int n2, CustomDatumFactory customDatumFactory) {
        this.sqlType = n2;
        this.old_factory = customDatumFactory;
        this.setArray(dArray);
    }

    public MutableArray(float[] fArray, int n2, CustomDatumFactory customDatumFactory) {
        this.sqlType = n2;
        this.old_factory = customDatumFactory;
        this.setArray(fArray);
    }

    public MutableArray(int[] nArray, int n2, CustomDatumFactory customDatumFactory) {
        this.sqlType = n2;
        this.old_factory = customDatumFactory;
        this.setArray(nArray);
    }

    public MutableArray(Object[] objectArray, int n2, CustomDatumFactory customDatumFactory) {
        this.sqlType = n2;
        this.old_factory = customDatumFactory;
        this.setObjectArray(objectArray);
    }

    public MutableArray(Datum[] datumArray, int n2, CustomDatumFactory customDatumFactory) {
        this.sqlType = n2;
        this.old_factory = customDatumFactory;
        this.setDatumArray(datumArray);
    }

    public MutableArray(short[] sArray, int n2, CustomDatumFactory customDatumFactory) {
        this.sqlType = n2;
        this.old_factory = customDatumFactory;
        this.setArray(sArray);
    }

    public Object getArray() throws SQLException {
        return this.getArray(0L, Integer.MAX_VALUE);
    }

    public Object getArray(long l2, int n2) throws SQLException {
        int n3 = this.sliceLength(l2, n2);
        int n4 = (int)l2;
        if (n3 < 0) {
            return null;
        }
        switch (this.sqlType) {
            case 6: 
            case 8: 
            case 101: {
                double[] dArray = new double[n3];
                int n5 = 0;
                while (n5 < n3) {
                    dArray[n5] = (Double)this.getObjectElement(n4++);
                    ++n5;
                }
                return dArray;
            }
            case 100: {
                float[] fArray = new float[n3];
                int n6 = 0;
                while (n6 < n3) {
                    fArray[n6] = ((Float)this.getObjectElement(n4++)).floatValue();
                    ++n6;
                }
                return fArray;
            }
            case 4: {
                int[] nArray = new int[n3];
                int n7 = 0;
                while (n7 < n3) {
                    nArray[n7] = (Integer)this.getObjectElement(n4++);
                    ++n7;
                }
                return nArray;
            }
            case 5: {
                short[] sArray = new short[n3];
                int n8 = 0;
                while (n8 < n3) {
                    sArray[n8] = (short)((Integer)this.getObjectElement(n4++)).intValue();
                    ++n8;
                }
                return sArray;
            }
            case 7: {
                float[] fArray = new float[n3];
                int n9 = 0;
                while (n9 < n3) {
                    fArray[n9] = ((Float)this.getObjectElement(n4++)).floatValue();
                    ++n9;
                }
                return fArray;
            }
        }
        return this.getObjectArray(l2, n2);
    }

    public int getBaseType() throws SQLException {
        return this.pickled.getBaseType();
    }

    public String getBaseTypeName() throws SQLException {
        return this.pickled.getBaseTypeName();
    }

    Datum[] getDatumArray(Connection connection) throws SQLException {
        if (this.length < 0) {
            this.getLazyOracleArray();
        }
        if (this.datums == null) {
            return null;
        }
        Datum[] datumArray = new Datum[this.length];
        int n2 = 0;
        while (n2 < this.length) {
            datumArray[n2] = this.getDatumElement(n2, connection);
            ++n2;
        }
        return datumArray;
    }

    Datum getDatumElement(long l2, Connection connection) throws SQLException {
        Datum datum = this.getLazyOracleArray()[(int)l2];
        if (datum == null) {
            Object object = this.getLazyArray()[(int)l2];
            this.datums[(int)l2] = datum = Util.convertToOracle(object, connection);
        }
        return datum;
    }

    public ArrayDescriptor getDescriptor() throws SQLException {
        return this.pickled.getDescriptor();
    }

    Object[] getLazyArray() throws SQLException {
        if (this.length == -1) {
            this.getLazyOracleArray();
        }
        if (this.elements == null) {
            this.elements = new Object[this.length];
        }
        return this.elements;
    }

    Datum[] getLazyOracleArray() throws SQLException {
        if (this.datums == null) {
            if (this.pickled != null) {
                this.datums = this.pickled.getOracleArray();
                this.length = this.datums.length;
                this.pickledCorrect = true;
                if (this.elements != null) {
                    int n2 = 0;
                    while (n2 < this.length) {
                        if (this.elements[n2] != null) {
                            this.datums[n2] = null;
                            this.pickledCorrect = false;
                        }
                        ++n2;
                    }
                }
            } else if (this.length >= 0) {
                this.datums = new Datum[this.length];
            }
        }
        return this.datums;
    }

    public Object[] getObjectArray() throws SQLException {
        return this.getObjectArray(0L, Integer.MAX_VALUE);
    }

    public Object[] getObjectArray(long l2, int n2) throws SQLException {
        Object[] objectArray;
        int n3 = this.sliceLength(l2, n2);
        if (n3 < 0) {
            return null;
        }
        switch (this.sqlType) {
            case 1: 
            case 12: {
                objectArray = new String[n3];
                break;
            }
            case 91: {
                objectArray = new Date[n3];
                break;
            }
            case 93: {
                objectArray = new Timestamp[n3];
                break;
            }
            case 2: 
            case 3: {
                objectArray = new BigDecimal[n3];
                break;
            }
            case 6: 
            case 8: {
                objectArray = new Double[n3];
                break;
            }
            case 4: 
            case 5: {
                objectArray = new Integer[n3];
                break;
            }
            case 7: {
                objectArray = new Float[n3];
                break;
            }
            case -2: {
                objectArray = (Object[])new byte[n3][];
                break;
            }
            default: {
                return this.getOracleArray(l2, n2);
            }
        }
        return this.getObjectArray(l2, objectArray);
    }

    public Object[] getObjectArray(long l2, Object[] objectArray) throws SQLException {
        if (objectArray == null) {
            return null;
        }
        int n2 = this.sliceLength(l2, objectArray.length);
        int n3 = (int)l2;
        if (n2 != objectArray.length) {
            return null;
        }
        switch (this.sqlType) {
            case -2: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 91: 
            case 93: {
                int n4 = 0;
                while (n4 < n2) {
                    objectArray[n4] = this.getObjectElement(n3++);
                    ++n4;
                }
                return objectArray;
            }
        }
        return this.getOracleArray(l2, objectArray);
    }

    public Object[] getObjectArray(Object[] objectArray) throws SQLException {
        return this.getObjectArray(0L, objectArray);
    }

    public Object getObjectElement(long l2) throws SQLException {
        Object object = this.getLazyArray()[(int)l2];
        if (object == null) {
            if (this.old_factory == null) {
                Datum datum = this.getLazyOracleArray()[(int)l2];
                this.elements[(int)l2] = object = Util.convertToObject(datum, this.sqlType, this.factory);
                if (Util.isMutable(datum, this.factory)) {
                    this.resetOracleElement(l2);
                }
            } else {
                Datum datum = this.getLazyOracleArray()[(int)l2];
                this.elements[(int)l2] = object = Util.convertToObject(datum, this.sqlType, this.old_factory);
                if (Util.isMutable(datum, this.old_factory)) {
                    this.resetOracleElement(l2);
                }
            }
        }
        return object;
    }

    public Object[] getOracleArray() throws SQLException {
        return this.getOracleArray(0L, Integer.MAX_VALUE);
    }

    public Object[] getOracleArray(long l2, int n2) throws SQLException {
        Object[] objectArray;
        int n3 = this.sliceLength(l2, n2);
        if (n3 < 0) {
            return null;
        }
        switch (this.sqlType) {
            case -13: {
                objectArray = new BFILE[n3];
                break;
            }
            case 2004: {
                objectArray = new BLOB[n3];
                break;
            }
            case 1: 
            case 12: {
                objectArray = new CHAR[n3];
                break;
            }
            case 2005: {
                objectArray = new CLOB[n3];
                break;
            }
            case 91: {
                objectArray = new DATE[n3];
                break;
            }
            case 93: {
                objectArray = new TIMESTAMP[n3];
                break;
            }
            case -101: {
                objectArray = new TIMESTAMPTZ[n3];
                break;
            }
            case -102: {
                objectArray = new TIMESTAMPLTZ[n3];
                break;
            }
            case -104: {
                objectArray = new INTERVALDS[n3];
                break;
            }
            case -103: {
                objectArray = new INTERVALYM[n3];
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = new NUMBER[n3];
                break;
            }
            case -2: {
                objectArray = new RAW[n3];
                break;
            }
            case 100: {
                objectArray = new BINARY_FLOAT[n3];
                break;
            }
            case 101: {
                objectArray = new BINARY_DOUBLE[n3];
                break;
            }
            case 0: 
            case 2002: 
            case 2003: 
            case 2006: 
            case 2007: {
                if (this.old_factory == null) {
                    objectArray = new ORAData[n3];
                    break;
                }
                objectArray = new CustomDatum[n3];
                break;
            }
            default: {
                throw new SQLException("Unexpected OracleTypes type code: " + this.sqlType);
            }
        }
        return this.getOracleArray(l2, objectArray);
    }

    public Object[] getOracleArray(long l2, Object[] objectArray) throws SQLException {
        if (objectArray == null) {
            return null;
        }
        int n2 = this.sliceLength(l2, objectArray.length);
        int n3 = (int)l2;
        if (n2 != objectArray.length) {
            return null;
        }
        if (this.sqlType == 2002 || this.sqlType == 2007 || this.sqlType == 2003 || this.sqlType == 2006 || this.sqlType == 0) {
            if (this.old_factory == null) {
                int n4 = 0;
                while (n4 < n2) {
                    objectArray[n4] = this.factory.create(this.getDatumElement(n3++, null), this.sqlType);
                    ++n4;
                }
            } else {
                int n5 = 0;
                while (n5 < n2) {
                    objectArray[n5] = this.old_factory.create(this.getDatumElement(n3++, null), this.sqlType);
                    ++n5;
                }
            }
        } else {
            int n6 = 0;
            while (n6 < n2) {
                objectArray[n6] = this.getDatumElement(n3++, null);
                ++n6;
            }
        }
        return objectArray;
    }

    public Object[] getOracleArray(Object[] objectArray) throws SQLException {
        return this.getOracleArray(0L, objectArray);
    }

    public Object getOracleElement(long l2) throws SQLException {
        if (this.factory == null && this.old_factory == null) {
            Datum datum = this.getDatumElement(l2, null);
            if (Util.isMutable(datum, this.factory)) {
                this.pickledCorrect = false;
            }
            return datum;
        }
        return this.getObjectElement(l2);
    }

    public int length() throws SQLException {
        if (this.length < 0) {
            this.getLazyOracleArray();
        }
        return this.length;
    }

    void resetElement(long l2) throws SQLException {
        if (this.elements != null) {
            this.elements[(int)l2] = null;
        }
    }

    void resetOracleElement(long l2) throws SQLException {
        if (this.datums != null) {
            this.datums[(int)l2] = null;
        }
        this.pickledCorrect = false;
    }

    public void setArray(double[] dArray) {
        if (dArray == null) {
            this.setNullArray();
        } else {
            this.setArrayGeneric(dArray.length);
            this.elements = new Object[this.length];
            int n2 = 0;
            while (n2 < this.length) {
                this.elements[n2] = new Double(dArray[n2]);
                ++n2;
            }
        }
    }

    public void setArray(double[] dArray, long l2) throws SQLException {
        if (dArray == null) {
            return;
        }
        int n2 = this.sliceLength(l2, dArray.length);
        int n3 = (int)l2;
        int n4 = 0;
        while (n4 < n2) {
            this.setObjectElement(new Double(dArray[n4]), n3++);
            ++n4;
        }
    }

    public void setArray(float[] fArray) {
        if (fArray == null) {
            this.setNullArray();
        } else {
            this.setArrayGeneric(fArray.length);
            this.elements = new Object[this.length];
            int n2 = 0;
            while (n2 < this.length) {
                this.elements[n2] = new Float(fArray[n2]);
                ++n2;
            }
        }
    }

    public void setArray(float[] fArray, long l2) throws SQLException {
        if (fArray == null) {
            return;
        }
        int n2 = this.sliceLength(l2, fArray.length);
        int n3 = (int)l2;
        int n4 = 0;
        while (n4 < n2) {
            this.setObjectElement(new Float(fArray[n4]), n3++);
            ++n4;
        }
    }

    public void setArray(int[] nArray) {
        if (nArray == null) {
            this.setNullArray();
        } else {
            this.setArrayGeneric(nArray.length);
            this.elements = new Object[this.length];
            int n2 = 0;
            while (n2 < this.length) {
                this.elements[n2] = new Integer(nArray[n2]);
                ++n2;
            }
        }
    }

    public void setArray(int[] nArray, long l2) throws SQLException {
        if (nArray == null) {
            return;
        }
        int n2 = this.sliceLength(l2, nArray.length);
        int n3 = (int)l2;
        int n4 = 0;
        while (n4 < n2) {
            this.setObjectElement(new Integer(nArray[n4]), n3++);
            ++n4;
        }
    }

    public void setArray(short[] sArray) {
        if (sArray == null) {
            this.setNullArray();
        } else {
            this.setArrayGeneric(sArray.length);
            this.elements = new Object[this.length];
            int n2 = 0;
            while (n2 < this.length) {
                this.elements[n2] = new Integer(sArray[n2]);
                ++n2;
            }
        }
    }

    public void setArray(short[] sArray, long l2) throws SQLException {
        if (sArray == null) {
            return;
        }
        int n2 = this.sliceLength(l2, sArray.length);
        int n3 = (int)l2;
        int n4 = 0;
        while (n4 < n2) {
            this.setObjectElement(new Integer(sArray[n4]), n3++);
            ++n4;
        }
    }

    void setArrayGeneric(int n2) {
        this.length = n2;
        this.datums = new Datum[n2];
        this.pickled = null;
        this.pickledCorrect = false;
    }

    void setDatumArray(Datum[] datumArray) {
        if (datumArray == null) {
            this.setNullArray();
        } else {
            this.length = datumArray.length;
            this.elements = null;
            this.datums = (Datum[])datumArray.clone();
            this.pickled = null;
            this.pickledCorrect = false;
        }
    }

    void setDatumArray(Datum[] datumArray, long l2) throws SQLException {
        if (datumArray == null) {
            return;
        }
        int n2 = this.sliceLength(l2, datumArray.length);
        int n3 = (int)l2;
        int n4 = 0;
        while (n4 < n2) {
            this.setDatumElement(datumArray[n4], n3++);
            ++n4;
        }
    }

    void setDatumElement(Datum datum, long l2) throws SQLException {
        this.resetElement(l2);
        this.getLazyOracleArray()[(int)l2] = datum;
        this.pickledCorrect = false;
    }

    void setNullArray() {
        this.length = -1;
        this.elements = null;
        this.datums = null;
        this.pickled = null;
        this.pickledCorrect = false;
    }

    public void setObjectArray(Object[] objectArray) {
        if (objectArray == null) {
            this.setNullArray();
        } else {
            this.setArrayGeneric(objectArray.length);
            this.elements = new Object[this.length];
            int n2 = 0;
            while (n2 < this.length) {
                this.elements[n2] = objectArray[n2];
                ++n2;
            }
        }
    }

    public void setObjectArray(Object[] objectArray, long l2) throws SQLException {
        if (objectArray == null) {
            return;
        }
        int n2 = this.sliceLength(l2, objectArray.length);
        int n3 = (int)l2;
        int n4 = 0;
        while (n4 < n2) {
            this.setObjectElement(objectArray[n4], n3++);
            ++n4;
        }
    }

    public void setObjectElement(Object object, long l2) throws SQLException {
        OracleLog.print(this, 2048, 2, 64, "MutableArray.setObjectElement( element = " + object + ",  n = " + l2 + ")");
        if (object == null) {
            this.getLazyOracleArray();
        }
        this.resetOracleElement(l2);
        this.getLazyArray()[(int)l2] = object;
    }

    public void setOracleArray(Object[] objectArray) {
        if (this.factory == null && this.old_factory == null) {
            this.setDatumArray((Datum[])objectArray);
        } else {
            this.setObjectArray(objectArray);
        }
    }

    public void setOracleArray(Object[] objectArray, long l2) throws SQLException {
        if (this.factory == null && this.old_factory == null) {
            this.setDatumArray((Datum[])objectArray, l2);
        } else {
            this.setObjectArray(objectArray, l2);
        }
    }

    public void setOracleElement(Object object, long l2) throws SQLException {
        if (this.factory == null && this.old_factory == null) {
            this.setDatumElement((Datum)object, l2);
        } else {
            this.setObjectElement(object, l2);
        }
    }

    public int sliceLength(long l2, int n2) throws SQLException {
        if (this.length < 0) {
            this.getLazyOracleArray();
        }
        if (l2 < 0L) {
            return (int)l2;
        }
        return Math.min(this.length - (int)l2, n2);
    }

    public Datum toDatum(Connection connection, String string) throws SQLException {
        if (!this.pickledCorrect) {
            this.pickled = new ARRAY(ArrayDescriptor.createDescriptor(string, connection), connection, this.getDatumArray(connection));
            this.pickledCorrect = true;
        }
        return this.pickled;
    }

    public Datum toDatum(oracle.jdbc.OracleConnection oracleConnection, String string) throws SQLException {
        return this.toDatum((Connection)oracleConnection, string);
    }

    public Datum toDatum(OracleConnection oracleConnection, String string) throws SQLException {
        return this.toDatum((Connection)oracleConnection, string);
    }
}

