/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.Util;
import oracle.jdbc.xa.OracleXAConnection;
import oracle.jdbc.xa.OracleXAException;

public class OracleXAResource
extends oracle.jdbc.xa.OracleXAResource {
    private short m_version = 0;
    private static String xa_start_816 = "begin ? := JAVA_XA.xa_start(?,?,?,?); end;";
    private static String xa_start_post_816 = "begin ? := JAVA_XA.xa_start_new(?,?,?,?,?); end;";
    private static String xa_end_816 = "begin ? := JAVA_XA.xa_end(?,?); end;";
    private static String xa_end_post_816 = "begin ? := JAVA_XA.xa_end_new(?,?,?,?); end;";
    private static String xa_commit_816 = "begin ? := JAVA_XA.xa_commit (?,?,?); end;";
    private static String xa_commit_post_816 = "begin ? := JAVA_XA.xa_commit_new (?,?,?,?); end;";
    private static String xa_prepare_816 = "begin ? := JAVA_XA.xa_prepare (?,?); end;";
    private static String xa_prepare_post_816 = "begin ? := JAVA_XA.xa_prepare_new (?,?,?); end;";
    private static String xa_rollback_816 = "begin ? := JAVA_XA.xa_rollback (?,?); end;";
    private static String xa_rollback_post_816 = "begin ? := JAVA_XA.xa_rollback_new (?,?,?); end;";
    private static String xa_forget_816 = "begin ? := JAVA_XA.xa_forget (?,?); end;";
    private static String xa_forget_post_816 = "begin ? := JAVA_XA.xa_forget_new (?,?,?); end;";
    boolean isTransLoose = false;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:49_PDT_2005";

    public OracleXAResource() {
    }

    public OracleXAResource(Connection connection, OracleXAConnection oracleXAConnection) throws XAException {
        super(connection, oracleXAConnection);
        try {
            this.m_version = ((OracleConnection)connection).getVersionNumber();
        }
        catch (SQLException sQLException) {}
        if (this.m_version < 8170) {
            throw new XAException(-6);
        }
    }

    public void commit(Xid xid, boolean bl2) throws XAException {
        int n2 = -1;
        boolean bl3 = false;
        if (xid == null) {
            throw new XAException(-5);
        }
        int n3 = bl2 ? 1 : 0;
        Xid xid2 = super.suspendStacked(xid);
        n2 = this.doCommit(xid, n3);
        super.resumeStacked(xid2);
        this.checkError(n2);
    }

    protected int doCommit(Xid xid, int n2) throws XAException {
        int n3 = -1;
        CallableStatement callableStatement = null;
        boolean bl2 = false;
        try {
            block9: {
                try {
                    callableStatement = this.connection.prepareCall(xa_commit_post_816);
                    callableStatement.registerOutParameter(1, 2);
                    callableStatement.setInt(2, xid.getFormatId());
                    callableStatement.setBytes(3, xid.getGlobalTransactionId());
                    callableStatement.setBytes(4, xid.getBranchQualifier());
                    callableStatement.setInt(5, n2);
                    callableStatement.execute();
                    n3 = callableStatement.getInt(1);
                }
                catch (SQLException sQLException) {
                    n3 = sQLException.getErrorCode();
                    if (n3 != 0) break block9;
                    throw new XAException(-6);
                }
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
            throw throwable;
        }
        try {
            if (callableStatement != null) {
                callableStatement.close();
            }
        }
        catch (SQLException sQLException) {}
        callableStatement = null;
        return n3;
    }

    protected int doDoTwoPhaseAction(int n2, int n3, String[] stringArray, Xid[] xidArray) throws XAException {
        throw new XAException(-6);
    }

    protected int doEnd(Xid xid, int n2) throws XAException {
        CallableStatement callableStatement = null;
        int n3 = -1;
        try {
            block9: {
                try {
                    callableStatement = this.connection.prepareCall(xa_end_post_816);
                    callableStatement.registerOutParameter(1, 2);
                    callableStatement.setInt(2, xid.getFormatId());
                    callableStatement.setBytes(3, xid.getGlobalTransactionId());
                    callableStatement.setBytes(4, xid.getBranchQualifier());
                    callableStatement.setInt(5, n2);
                    callableStatement.execute();
                    n3 = callableStatement.getInt(1);
                }
                catch (SQLException sQLException) {
                    n3 = sQLException.getErrorCode();
                    if (n3 != 0) break block9;
                    throw new XAException(-6);
                }
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
            throw throwable;
        }
        try {
            if (callableStatement != null) {
                callableStatement.close();
            }
        }
        catch (SQLException sQLException) {}
        callableStatement = null;
        return n3;
    }

    protected int doForget(Xid xid) throws XAException {
        int n2 = 0;
        boolean bl2 = false;
        CallableStatement callableStatement = null;
        try {
            block9: {
                try {
                    callableStatement = this.connection.prepareCall(xa_forget_post_816);
                    callableStatement.registerOutParameter(1, 2);
                    callableStatement.setInt(2, xid.getFormatId());
                    callableStatement.setBytes(3, xid.getGlobalTransactionId());
                    callableStatement.setBytes(4, xid.getBranchQualifier());
                    callableStatement.execute();
                    n2 = callableStatement.getInt(1);
                }
                catch (SQLException sQLException) {
                    n2 = sQLException.getErrorCode();
                    if (n2 != 0) break block9;
                    throw new XAException(-6);
                }
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
            throw throwable;
        }
        try {
            if (callableStatement != null) {
                callableStatement.close();
            }
        }
        catch (SQLException sQLException) {}
        callableStatement = null;
        return n2;
    }

    protected int doPrepare(Xid xid) throws XAException {
        int n2 = 0;
        boolean bl2 = false;
        CallableStatement callableStatement = null;
        try {
            block9: {
                try {
                    callableStatement = this.connection.prepareCall(xa_prepare_post_816);
                    callableStatement.registerOutParameter(1, 2);
                    callableStatement.setInt(2, xid.getFormatId());
                    callableStatement.setBytes(3, xid.getGlobalTransactionId());
                    callableStatement.setBytes(4, xid.getBranchQualifier());
                    callableStatement.execute();
                    n2 = callableStatement.getInt(1);
                }
                catch (SQLException sQLException) {
                    n2 = sQLException.getErrorCode();
                    if (n2 != 0) break block9;
                    throw new XAException(-6);
                }
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
            throw throwable;
        }
        try {
            if (callableStatement != null) {
                callableStatement.close();
            }
        }
        catch (SQLException sQLException) {}
        callableStatement = null;
        return n2;
    }

    protected int doRollback(Xid xid) throws XAException {
        int n2 = 0;
        boolean bl2 = false;
        CallableStatement callableStatement = null;
        try {
            block9: {
                try {
                    callableStatement = this.connection.prepareCall(xa_rollback_post_816);
                    callableStatement.registerOutParameter(1, 2);
                    callableStatement.setInt(2, xid.getFormatId());
                    callableStatement.setBytes(3, xid.getGlobalTransactionId());
                    callableStatement.setBytes(4, xid.getBranchQualifier());
                    callableStatement.execute();
                    n2 = callableStatement.getInt(1);
                }
                catch (SQLException sQLException) {
                    n2 = sQLException.getErrorCode();
                    if (n2 != 0) break block9;
                    throw new XAException(-6);
                }
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
            throw throwable;
        }
        try {
            if (callableStatement != null) {
                callableStatement.close();
            }
        }
        catch (SQLException sQLException) {}
        callableStatement = null;
        return n2;
    }

    protected int doStart(Xid xid, int n2) throws XAException {
        int n3 = -1;
        CallableStatement callableStatement = null;
        try {
            block9: {
                try {
                    callableStatement = this.connection.prepareCall(xa_start_post_816);
                    callableStatement.registerOutParameter(1, 2);
                    callableStatement.setInt(2, xid.getFormatId());
                    callableStatement.setBytes(3, xid.getGlobalTransactionId());
                    callableStatement.setBytes(4, xid.getBranchQualifier());
                    callableStatement.setInt(5, this.timeout);
                    callableStatement.setInt(6, n2);
                    callableStatement.execute();
                    n3 = callableStatement.getInt(1);
                }
                catch (SQLException sQLException) {
                    n3 = sQLException.getErrorCode();
                    if (n3 != 0) break block9;
                    throw new XAException(-6);
                }
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
            throw throwable;
        }
        try {
            if (callableStatement != null) {
                callableStatement.close();
            }
        }
        catch (SQLException sQLException) {}
        callableStatement = null;
        return n3;
    }

    public void doTwoPhaseAction(int n2, int n3, String[] stringArray, Xid[] xidArray) throws XAException {
        this.doDoTwoPhaseAction(n2, n3, stringArray, xidArray);
    }

    public void end(Xid xid, int n2) throws XAException {
        int n3 = -1;
        try {
            if (xid == null) {
                throw new XAException(-5);
            }
            if (n2 != 0x2000000 && n2 != 0x4000000 && n2 != 0x20000000 && (n2 & 2) != 2) {
                throw new XAException(-5);
            }
            Xid xid2 = super.suspendStacked(xid, n2);
            super.pop();
            n3 = this.doEnd(xid, n2);
            super.resumeStacked(xid2);
            this.checkError(n3);
        }
        finally {
            Object var5_5 = null;
            this.restoreAutoCommitModeForGlobalTransaction();
        }
    }

    public void forget(Xid xid) throws XAException {
        int n2 = 0;
        if (xid == null) {
            throw new XAException(-5);
        }
        n2 = this.doForget(xid);
        this.checkError(n2);
    }

    private static byte[] getSerializedBytes(Xid xid) {
        try {
            return Util.serializeObject(xid);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public int prepare(Xid xid) throws XAException {
        int n2;
        int n3 = 0;
        if (xid == null) {
            throw new XAException(-5);
        }
        Xid xid2 = super.suspendStacked(xid);
        n3 = this.doPrepare(xid);
        super.resumeStacked(xid2);
        int n4 = n2 = n3 == 0 ? 0 : OracleXAException.errorConvert(n3);
        if (n2 != 0 && n2 != 3) {
            throw new OracleXAException(n3);
        }
        return n2;
    }

    public void rollback(Xid xid) throws XAException {
        int n2 = 0;
        boolean bl2 = false;
        if (xid == null) {
            throw new XAException(-5);
        }
        Xid xid2 = super.suspendStacked(xid);
        n2 = this.doRollback(xid);
        super.resumeStacked(xid2);
        this.checkError(n2);
    }

    public void start(Xid xid, int n2) throws XAException {
        int n3 = -1;
        Object var4_4 = null;
        try {
            if (xid == null) {
                throw new XAException(-5);
            }
            int n4 = n2 & 0xFF00;
            int n5 = (n2 &= 0xFFFF00FF) & 0x10000 | (this.isTransLoose ? 65536 : 0);
            if (((n2 &= 0xFFFEFFFF) & 0x8200002) != n2 || n5 != 0 && (n5 & 0x10000) != 65536) {
                throw new XAException(-5);
            }
            if ((n4 & 0xFF00) != 0 && n4 != 256 && n4 != 512 && n4 != 1024) {
                throw new XAException(-5);
            }
            if ((n2 & 0x8200000) != 0 && ((n4 & 0xFF00) != 0 || (n5 & 0x10000) != 0)) {
                throw new XAException(-5);
            }
            this.saveAndAlterAutoCommitModeForGlobalTransaction();
            n3 = this.doStart(xid, n2 |= n4 | n5);
            this.checkError(n3);
            super.push(xid);
        }
        catch (XAException xAException) {
            this.restoreAutoCommitModeForGlobalTransaction();
            throw xAException;
        }
    }
}

