/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.io.IOException;
import java.sql.Connection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.jdbc.oracore.Util;
import oracle.jdbc.xa.client.OracleXAConnection;
import oracle.jdbc.xa.client.OracleXAResource;

public class OracleXAHeteroResource
extends OracleXAResource {
    private int rmid = -1;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:49_PDT_2005";

    public OracleXAHeteroResource(Connection connection, OracleXAConnection oracleXAConnection) throws XAException {
        this.connection = connection;
        this.xaconnection = oracleXAConnection;
        if (this.connection == null) {
            throw new XAException(-7);
        }
    }

    private void checkStatus(int n2) throws XAException {
        if (n2 != 0) {
            throw new XAException(n2);
        }
    }

    public void commit(Xid xid, boolean bl2) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        int n2 = bl2 ? 0x40000000 : 0;
        int n3 = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        Xid xid2 = super.suspendStacked(xid);
        int n4 = this.doXaCommit(n3, byArray, byArray2, this.rmid, n2, 0);
        super.resumeStacked(xid2);
        this.checkStatus(n4);
    }

    private native int doXaCommit(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int doXaEnd(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int doXaForget(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int doXaPrepare(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int doXaRollback(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int doXaStart(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    public void end(Xid xid, int n2) throws XAException {
        try {
            if (xid == null) {
                throw new XAException(-5);
            }
            if (n2 != 0x2000000 && n2 != 0x4000000 && n2 != 0x20000000 && (n2 & 2) != 2) {
                throw new XAException(-5);
            }
            int n3 = xid.getFormatId();
            byte[] byArray = xid.getGlobalTransactionId();
            byte[] byArray2 = xid.getBranchQualifier();
            Xid xid2 = super.suspendStacked(xid, n2);
            super.pop();
            int n4 = this.doXaEnd(n3, byArray, byArray2, this.rmid, n2, 0);
            super.resumeStacked(xid2);
            this.checkStatus(n4);
        }
        finally {
            Object var4_8 = null;
            this.restoreAutoCommitModeForGlobalTransaction();
        }
    }

    public void forget(Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        int n2 = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        int n3 = this.doXaForget(n2, byArray, byArray2, this.rmid, 0, 0);
        this.checkStatus(n3);
    }

    synchronized int getRmid() {
        return this.rmid;
    }

    private static byte[] getSerializedBytes(Xid xid) {
        try {
            return Util.serializeObject(xid);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public int prepare(Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        int n2 = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        Xid xid2 = super.suspendStacked(xid);
        int n3 = this.doXaPrepare(n2, byArray, byArray2, this.rmid, 0, 0);
        super.resumeStacked(xid2);
        if (n3 != 0 && n3 != 3) {
            this.checkStatus(n3);
        }
        return n3;
    }

    public void rollback(Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        int n2 = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        Xid xid2 = super.suspendStacked(xid);
        int n3 = this.doXaRollback(n2, byArray, byArray2, this.rmid, 0, 0);
        super.resumeStacked(xid2);
        this.checkStatus(n3);
    }

    synchronized void setRmid(int n2) {
        this.rmid = n2;
    }

    public void start(Xid xid, int n2) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        int n3 = n2 & 0xFF00;
        if (((n2 &= 0xFFFF00FF) & 0x8200002) != n2) {
            throw new XAException(-5);
        }
        if ((n3 & 0xFF00) != 0 && n3 != 256 && n3 != 512 && n3 != 1024) {
            throw new XAException(-5);
        }
        if ((n3 & 0xFF00) != 0 && (n2 & 0x8200000) != 0) {
            throw new XAException(-5);
        }
        try {
            this.saveAndAlterAutoCommitModeForGlobalTransaction();
            int n4 = xid.getFormatId();
            byte[] byArray = xid.getGlobalTransactionId();
            byte[] byArray2 = xid.getBranchQualifier();
            int n5 = this.doXaStart(n4, byArray, byArray2, this.rmid, n2 |= n3, 0);
            this.checkStatus(n5);
            super.push(xid);
        }
        catch (XAException xAException) {
            this.restoreAutoCommitModeForGlobalTransaction();
            throw xAException;
        }
    }
}

