/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.sql.SQLException;
import oracle.jdbc.rowset.OraclePredicate;
import oracle.jdbc.rowset.OracleWebRowSet;

public class OracleFilteredRowSet
extends OracleWebRowSet {
    private OraclePredicate predicate;

    public boolean absolute(int n2) throws SQLException {
        int n3;
        if (this.rowsetType == 1003) {
            throw new SQLException("The RowSet type is TYPE_FORWARD_ONLY");
        }
        if (n2 == 0 || Math.abs(n2) > this.rowCount) {
            return false;
        }
        int n4 = n2 < 0 ? this.rowCount + n2 + 1 : n2;
        this.presentRow = 0;
        for (n3 = 0; n3 < n4 && this.presentRow <= this.rowCount; ++n3) {
            if (this.next()) {
                continue;
            }
            return false;
        }
        if (n3 == n4) {
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    protected void checkAndFilterObject(int n2, Object object) throws SQLException {
        if (this.predicate != null && !this.predicate.evaluate(object, n2)) {
            throw new SQLException("The object does not satisfy filtering criterion");
        }
    }

    public OraclePredicate getFilter() {
        return this.predicate;
    }

    public boolean next() throws SQLException {
        if (this.rowCount <= 0) {
            return false;
        }
        if (this.presentRow >= this.rowCount) {
            return false;
        }
        boolean bl2 = false;
        do {
            ++this.presentRow;
            if (this.predicate != null && (this.predicate == null || !this.predicate.evaluate(this))) continue;
            bl2 = true;
            break;
        } while (this.presentRow <= this.rowCount);
        if (bl2) {
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    public boolean previous() throws SQLException {
        if (this.rowsetType == 1003) {
            throw new SQLException("The RowSet type is TYPE_FORWARD_ONLY");
        }
        if (this.rowCount <= 0) {
            return false;
        }
        if (this.presentRow <= 1) {
            return false;
        }
        boolean bl2 = false;
        do {
            --this.presentRow;
            if (this.predicate != null && (this.predicate == null || !this.predicate.evaluate(this))) continue;
            bl2 = true;
            break;
        } while (this.presentRow >= 1);
        if (bl2) {
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    public void setFilter(OraclePredicate oraclePredicate) throws SQLException {
        this.predicate = oraclePredicate;
    }
}

