/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.StringTokenizer;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.RowSetWriter;
import oracle.jdbc.rowset.OracleCachedRowSet;
import oracle.jdbc.rowset.OracleCachedRowSetReader;
import oracle.jdbc.rowset.OracleRow;

public class OracleCachedRowSetWriter
implements RowSetWriter,
Serializable {
    private StringBuffer updateClause = new StringBuffer("");
    private StringBuffer deleteClause = new StringBuffer("");
    private StringBuffer insertClause = new StringBuffer("");
    private PreparedStatement insertStmt;
    private PreparedStatement updateStmt;
    private PreparedStatement deleteStmt;
    private ResultSetMetaData rsmd;
    private transient Connection connection;
    private int columnCount;

    private boolean deleteRow(RowSet rowSet, OracleRow oracleRow) throws SQLException {
        this.deleteStmt.clearParameters();
        int n2 = 1;
        while (n2 <= this.columnCount) {
            if (oracleRow.isOriginalNull(n2)) {
                return this.deleteRowWithNull(rowSet, oracleRow);
            }
            Object object = oracleRow.getColumn(n2);
            if (object == null) {
                this.deleteStmt.setNull(n2, this.rsmd.getColumnType(n2));
            } else {
                this.deleteStmt.setObject(n2, object);
            }
            ++n2;
        }
        return this.deleteStmt.executeUpdate() == 1;
    }

    private boolean deleteRowWithNull(RowSet rowSet, OracleRow oracleRow) throws SQLException {
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer("DELETE FROM " + this.getTableName(rowSet) + " WHERE ");
        int n2 = 1;
        while (n2 <= this.columnCount) {
            if (n2 != 1) {
                stringBuffer.append(" AND ");
            }
            if (oracleRow.isOriginalNull(n2)) {
                stringBuffer.append(String.valueOf(this.rsmd.getColumnName(n2)) + " IS NULL ");
            } else {
                stringBuffer.append(String.valueOf(this.rsmd.getColumnName(n2)) + " = :" + n2);
            }
            ++n2;
        }
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.connection.prepareStatement(stringBuffer.substring(0, stringBuffer.length()));
            int n3 = 1;
            int n4 = 1;
            while (n3 <= this.columnCount) {
                if (!oracleRow.isOriginalNull(n3)) {
                    preparedStatement.setObject(n4++, oracleRow.getColumn(n3));
                }
                ++n3;
            }
            bl2 = preparedStatement.executeUpdate() == 1;
        }
        finally {
            Object var8_9 = null;
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        return bl2;
    }

    private String getSchemaName(RowSet rowSet) throws SQLException {
        return rowSet.getUsername();
    }

    private String getTableName(RowSet rowSet) throws SQLException {
        String string = ((OracleCachedRowSet)rowSet).getTableName();
        if (string != null) {
            return string;
        }
        String string2 = rowSet.getCommand().toUpperCase();
        int n2 = string2.indexOf(" FROM ");
        if (n2 == -1) {
            throw new SQLException("Could not parse the SQL String to get the table name.\n" + (string2 != "" ? string2 : "Please use RowSet.setCommand (String) to set the SQL query string."));
        }
        String string3 = string2.substring(n2 + 6).trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string3);
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        return string3;
    }

    private void initSQLStatement(RowSet rowSet) throws SQLException {
        this.insertClause = new StringBuffer("INSERT INTO " + this.getTableName(rowSet) + "(");
        this.updateClause = new StringBuffer("UPDATE " + this.getTableName(rowSet) + " SET ");
        this.deleteClause = new StringBuffer("DELETE FROM " + this.getTableName(rowSet) + " WHERE ");
        this.rsmd = rowSet.getMetaData();
        this.columnCount = this.rsmd.getColumnCount();
        int n2 = 0;
        while (n2 < this.columnCount) {
            if (n2 != 0) {
                this.insertClause.append(", ");
            }
            this.insertClause.append(this.rsmd.getColumnName(n2 + 1));
            if (n2 != 0) {
                this.updateClause.append(", ");
            }
            this.updateClause.append(String.valueOf(this.rsmd.getColumnName(n2 + 1)) + " = :" + n2);
            if (n2 != 0) {
                this.deleteClause.append(" AND ");
            }
            this.deleteClause.append(String.valueOf(this.rsmd.getColumnName(n2 + 1)) + " = :" + n2);
            ++n2;
        }
        this.insertClause.append(") VALUES (");
        this.updateClause.append(" WHERE ");
        int n3 = 0;
        while (n3 < this.columnCount) {
            if (n3 != 0) {
                this.insertClause.append(", ");
            }
            this.insertClause.append(":" + n3);
            if (n3 != 0) {
                this.updateClause.append(" AND ");
            }
            this.updateClause.append(String.valueOf(this.rsmd.getColumnName(n3 + 1)) + " = :" + n3);
            ++n3;
        }
        this.insertClause.append(")");
        this.insertStmt = this.connection.prepareStatement(this.insertClause.substring(0, this.insertClause.length()));
        this.updateStmt = this.connection.prepareStatement(this.updateClause.substring(0, this.updateClause.length()));
        this.deleteStmt = this.connection.prepareStatement(this.deleteClause.substring(0, this.deleteClause.length()));
    }

    private boolean insertRow(OracleRow oracleRow) throws SQLException {
        this.insertStmt.clearParameters();
        int n2 = 1;
        while (n2 <= this.columnCount) {
            Object object = null;
            Object object2 = object = oracleRow.isColumnChanged(n2) ? oracleRow.getModifiedColumn(n2) : oracleRow.getColumn(n2);
            if (object == null) {
                this.insertStmt.setNull(n2, this.rsmd.getColumnType(n2));
            } else {
                this.insertStmt.setObject(n2, object);
            }
            ++n2;
        }
        return this.insertStmt.executeUpdate() == 1;
    }

    private boolean updateRow(RowSet rowSet, OracleRow oracleRow) throws SQLException {
        this.updateStmt.clearParameters();
        int n2 = 1;
        while (n2 <= this.columnCount) {
            Object object = null;
            Object object2 = object = oracleRow.isColumnChanged(n2) ? oracleRow.getModifiedColumn(n2) : oracleRow.getColumn(n2);
            if (object == null) {
                this.updateStmt.setNull(n2, this.rsmd.getColumnType(n2));
            } else {
                this.updateStmt.setObject(n2, object);
            }
            ++n2;
        }
        int n3 = 1;
        while (n3 <= this.columnCount) {
            if (oracleRow.isOriginalNull(n3)) {
                return this.updateRowWithNull(rowSet, oracleRow);
            }
            this.updateStmt.setObject(n3 + this.columnCount, oracleRow.getColumn(n3));
            ++n3;
        }
        return this.updateStmt.executeUpdate() == 1;
    }

    private boolean updateRowWithNull(RowSet rowSet, OracleRow oracleRow) throws SQLException {
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer("UPDATE " + this.getTableName(rowSet) + " SET ");
        int n2 = 1;
        while (n2 <= this.columnCount) {
            if (n2 != 1) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(String.valueOf(this.rsmd.getColumnName(n2)) + " = :" + n2);
            ++n2;
        }
        stringBuffer.append(" WHERE ");
        int n3 = 1;
        while (n3 <= this.columnCount) {
            if (n3 != 1) {
                stringBuffer.append(" AND ");
            }
            if (oracleRow.isOriginalNull(n3)) {
                stringBuffer.append(String.valueOf(this.rsmd.getColumnName(n3)) + " IS NULL ");
            } else {
                stringBuffer.append(String.valueOf(this.rsmd.getColumnName(n3)) + " = :" + n3);
            }
            ++n3;
        }
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.connection.prepareStatement(stringBuffer.substring(0, stringBuffer.length()));
            int n4 = 1;
            while (n4 <= this.columnCount) {
                Object object = null;
                Object object2 = object = oracleRow.isColumnChanged(n4) ? oracleRow.getModifiedColumn(n4) : oracleRow.getColumn(n4);
                if (object == null) {
                    preparedStatement.setNull(n4, this.rsmd.getColumnType(n4));
                } else {
                    preparedStatement.setObject(n4, object);
                }
                ++n4;
            }
            int n5 = 1;
            int n6 = 1;
            while (n5 <= this.columnCount) {
                if (!oracleRow.isOriginalNull(n5)) {
                    preparedStatement.setObject(n6 + this.columnCount, oracleRow.getColumn(n5));
                    ++n6;
                }
                ++n5;
            }
            bl2 = preparedStatement.executeUpdate() == 1;
        }
        finally {
            Object var9_12 = null;
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        return bl2;
    }

    public synchronized boolean writeData(RowSetInternal rowSetInternal) throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = (OracleCachedRowSet)rowSetInternal;
        this.connection = ((OracleCachedRowSetReader)oracleCachedRowSet.getReader()).getConnection(rowSetInternal);
        if (this.connection == null) {
            throw new SQLException("Unable to get Connection");
        }
        if (this.connection.getAutoCommit()) {
            this.connection.setAutoCommit(false);
        }
        this.connection.setTransactionIsolation(oracleCachedRowSet.getTransactionIsolation());
        this.initSQLStatement(oracleCachedRowSet);
        if (this.columnCount < 1) {
            this.connection.close();
            return true;
        }
        boolean bl2 = oracleCachedRowSet.getShowDeleted();
        oracleCachedRowSet.setShowDeleted(true);
        oracleCachedRowSet.beforeFirst();
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = true;
        OracleRow oracleRow = null;
        while (oracleCachedRowSet.next()) {
            if (oracleCachedRowSet.rowInserted()) {
                if (oracleCachedRowSet.rowDeleted()) continue;
                oracleRow = oracleCachedRowSet.getCurrentRow();
                bl4 = this.insertRow(oracleRow) || bl4;
                continue;
            }
            if (oracleCachedRowSet.rowUpdated()) {
                oracleRow = oracleCachedRowSet.getCurrentRow();
                bl3 = this.updateRow(oracleCachedRowSet, oracleRow) || bl3;
                continue;
            }
            if (!oracleCachedRowSet.rowDeleted()) continue;
            oracleRow = oracleCachedRowSet.getCurrentRow();
            boolean bl6 = bl5 = this.deleteRow(oracleCachedRowSet, oracleRow) || bl5;
        }
        if (bl3 && bl4 && bl5) {
            this.connection.commit();
            oracleCachedRowSet.setOriginal();
        } else {
            this.connection.rollback();
        }
        this.insertStmt.close();
        this.updateStmt.close();
        this.deleteStmt.close();
        if (!oracleCachedRowSet.isConnectionStayingOpen()) {
            this.connection.close();
        }
        oracleCachedRowSet.setShowDeleted(bl2);
        return true;
    }
}

