/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OracleConnectionCacheCallback;
import oracle.jdbc.pool.OracleImplicitConnectionCache;
import oracle.jdbc.pool.OraclePooledConnection;

class OracleImplicitConnectionCacheThread
extends Thread {
    private OracleImplicitConnectionCache implicitCache = null;
    protected boolean timeToLive = true;
    protected boolean isSleeping = false;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:49_PDT_2005";

    OracleImplicitConnectionCacheThread(OracleImplicitConnectionCache oracleImplicitConnectionCache) throws SQLException {
        this.implicitCache = oracleImplicitConnectionCache;
    }

    public void run() {
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        while (this.timeToLive) {
            try {
                if (this.timeToLive && (l2 = (long)this.implicitCache.getCacheTimeToLiveTimeout()) > 0L) {
                    this.runTimeToLiveTimeout(l2);
                }
                if (this.timeToLive && (l3 = (long)this.implicitCache.getCacheInactivityTimeout()) > 0L) {
                    this.runInactivityTimeout();
                }
                if (this.timeToLive && (l4 = (long)this.implicitCache.getCacheAbandonedTimeout()) > 0L) {
                    this.runAbandonedTimeout(l4);
                }
                if (this.timeToLive) {
                    this.isSleeping = true;
                    try {
                        Thread.sleep(this.implicitCache.getCachePropertyCheckInterval() * 1000);
                    }
                    catch (InterruptedException interruptedException) {}
                    this.isSleeping = false;
                }
                if (this.implicitCache != null && (l2 > 0L || l3 > 0L || l4 > 0L)) continue;
                this.timeToLive = false;
            }
            catch (SQLException sQLException) {}
        }
    }

    private void runAbandonedTimeout(long l2) throws SQLException {
        if (this.implicitCache.getNumberOfCheckedOutConnections() > 0) {
            OraclePooledConnection oraclePooledConnection = null;
            OracleImplicitConnectionCache oracleImplicitConnectionCache = this.implicitCache;
            synchronized (oracleImplicitConnectionCache) {
                Object[] objectArray = this.implicitCache.checkedOutConnectionList.toArray();
                int n2 = 0;
                while (n2 < objectArray.length) {
                    oraclePooledConnection = (OraclePooledConnection)objectArray[n2];
                    OracleConnection oracleConnection = (OracleConnection)oraclePooledConnection.getLogicalHandle();
                    if (oracleConnection != null) {
                        OracleConnectionCacheCallback oracleConnectionCacheCallback = oracleConnection.getConnectionCacheCallbackObj();
                        if (oracleConnectionCacheCallback != null && (oracleConnection.getConnectionCacheCallbackFlag() == 4 || oracleConnection.getConnectionCacheCallbackFlag() == 1)) {
                            try {
                                oracleConnectionCacheCallback.handleAbandonedConnection(oracleConnection, oracleConnection.getConnectionCacheCallbackPrivObj());
                            }
                            catch (SQLException sQLException) {}
                        } else if ((long)(oracleConnection.getHeartbeatNoChangeCount() * this.implicitCache.getCachePropertyCheckInterval()) > l2) {
                            try {
                                this.implicitCache.closeCheckedOutConnection(oraclePooledConnection, true);
                            }
                            catch (SQLException sQLException) {}
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    private void runInactivityTimeout() {
        try {
            this.implicitCache.doForEveryCachedConnection(4);
        }
        catch (SQLException sQLException) {}
    }

    private void runTimeToLiveTimeout(long l2) throws SQLException {
        long l3 = 0L;
        long l4 = 0L;
        if (this.implicitCache.getNumberOfCheckedOutConnections() > 0) {
            OraclePooledConnection oraclePooledConnection = null;
            OracleImplicitConnectionCache oracleImplicitConnectionCache = this.implicitCache;
            synchronized (oracleImplicitConnectionCache) {
                Object[] objectArray = this.implicitCache.checkedOutConnectionList.toArray();
                int n2 = this.implicitCache.checkedOutConnectionList.size();
                int n3 = 0;
                while (n3 < n2) {
                    oraclePooledConnection = (OraclePooledConnection)objectArray[n3];
                    Connection connection = oraclePooledConnection.getLogicalHandle();
                    if (connection != null) {
                        l4 = ((OracleConnection)connection).getStartTime();
                        l3 = System.currentTimeMillis();
                        if (l3 - l4 > l2 * 1000L) {
                            try {
                                this.implicitCache.closeCheckedOutConnection(oraclePooledConnection, true);
                            }
                            catch (SQLException sQLException) {}
                        }
                    }
                    ++n3;
                }
            }
        }
    }
}

