/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import javax.sql.PooledConnection;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OracleConnectionCacheCallback;
import oracle.jdbc.pool.OracleConnectionCacheEntry;
import oracle.jdbc.pool.OracleConnectionCacheEventListener;
import oracle.jdbc.pool.OracleConnectionCacheManager;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OracleDatabaseInstance;
import oracle.jdbc.pool.OracleFailoverWorkerThread;
import oracle.jdbc.pool.OracleGravitateConnectionCacheThread;
import oracle.jdbc.pool.OracleImplicitConnectionCacheThread;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.pool.OracleRuntimeLoadBalancingEventHandlerThread;
import oracle.jdbc.xa.client.OracleXADataSource;

class OracleImplicitConnectionCache {
    protected OracleDataSource cacheEnabledDS = null;
    protected String cacheName = null;
    protected OracleConnectionPoolDataSource connectionPoolDS = null;
    protected boolean fastConnectionFailoverEnabled = false;
    protected String defaultUser = null;
    protected String defaultPassword = null;
    protected static final int DEFAULT_MIN_LIMIT = 0;
    protected static final int DEFAULT_MAX_LIMIT = Integer.MAX_VALUE;
    protected static final int DEFAULT_INITIAL_LIMIT = 0;
    protected static final int DEFAULT_MAX_STATEMENTS_LIMIT = 0;
    protected static final int DEFAULT_INACTIVITY_TIMEOUT = 0;
    protected static final int DEFAULT_TIMETOLIVE_TIMEOUT = 0;
    protected static final int DEFAULT_ABANDONED_CONN_TIMEOUT = 0;
    protected static final int DEFAULT_CONNECTION_WAIT_TIMEOUT = 0;
    protected static final String DEFAULT_ATTRIBUTE_WEIGHT = "0";
    protected static final int DEFAULT_LOWER_THRESHOLD_LIMIT = 20;
    protected static final int DEFAULT_PROPERTY_CHECK_INTERVAL = 900;
    protected static final int CLOSE_AND_REMOVE_ALL_CONNECTIONS = 1;
    protected static final int CLOSE_AND_REMOVE_FAILOVER_CONNECTIONS = 2;
    protected static final int PROCESS_INACTIVITY_TIMEOUT = 4;
    protected static final int CLOSE_AND_REMOVE_N_CONNECTIONS = 8;
    protected static final int DISABLE_STATEMENT_CACHING = 16;
    protected static final int RESET_STATEMENT_CACHE_SIZE = 18;
    protected static final int CLOSE_AND_REMOVE_RLB_CONNECTIONS = 24;
    private static final String ATTRKEY_DELIM = "0xffff";
    protected int cacheMinLimit = 0;
    protected int cacheMaxLimit = Integer.MAX_VALUE;
    protected int cacheInitialLimit = 0;
    protected int cacheMaxStatementsLimit = 0;
    protected Properties cacheAttributeWeights = null;
    protected int cacheInactivityTimeout = 0;
    protected int cacheTimeToLiveTimeout = 0;
    protected int cacheAbandonedConnectionTimeout = 0;
    protected int cacheLowerThresholdLimit = 20;
    protected int cachePropertyCheckInterval = 900;
    protected boolean cacheClosestConnectionMatch = false;
    protected boolean cacheValidateConnection = false;
    protected int cacheConnectionWaitTimeout = 0;
    static final String MIN_LIMIT_KEY = "MinLimit";
    static final String MAX_LIMIT_KEY = "MaxLimit";
    static final String INITIAL_LIMIT_KEY = "InitialLimit";
    static final String MAX_STATEMENTS_LIMIT_KEY = "MaxStatementsLimit";
    static final String ATTRIBUTE_WEIGHTS_KEY = "AttributeWeights";
    static final String INACTIVITY_TIMEOUT_KEY = "InactivityTimeout";
    static final String TIME_TO_LIVE_TIMEOUT_KEY = "TimeToLiveTimeout";
    static final String ABANDONED_CONNECTION_TIMEOUT_KEY = "AbandonedConnectionTimeout";
    static final String LOWER_THRESHOLD_LIMIT_KEY = "LowerThresholdLimit";
    static final String PROPERTY_CHECK_INTERVAL_KEY = "PropertyCheckInterval";
    static final String VALIDATE_CONNECTION_KEY = "ValidateConnection";
    static final String CLOSEST_CONNECTION_MATCH_KEY = "ClosestConnectionMatch";
    static final String CONNECTION_WAIT_TIMEOUT_KEY = "ConnectionWaitTimeout";
    static final int INSTANCE_GOOD = 1;
    static final int INSTANCE_UNKNOWN = 2;
    static final int INSTANCE_VIOLATING = 3;
    static final int INSTANCE_NO_DATA = 4;
    static final int INSTANCE_BLOCKED = 5;
    static final int RLB_NUMBER_OF_HITS_PER_INSTANCE = 1000;
    int dbInstancePercentTotal = 0;
    boolean useGoodGroup = false;
    LinkedList instancesToRetireList = null;
    OracleDatabaseInstance instanceToRetire = null;
    int retireConnectionsCount = 0;
    int countTotal = 0;
    protected OracleConnectionCacheManager cacheManager = null;
    protected boolean disableConnectionRequest = false;
    protected OracleImplicitConnectionCacheThread timeoutThread = null;
    protected OracleRuntimeLoadBalancingEventHandlerThread runtimeLoadBalancingThread = null;
    protected OracleGravitateConnectionCacheThread gravitateCacheThread = null;
    protected int connectionsToRemove = 0;
    private HashMap userMap = null;
    Vector checkedOutConnectionList = null;
    LinkedList databaseInstancesList = null;
    int cacheSize = 0;
    protected static final String EVENT_DELIMITER = " ";
    protected boolean isEntireServiceDownProcessed = false;
    protected int defaultUserPreFailureSize = 0;
    protected String dataSourceServiceName = null;
    protected OracleFailoverWorkerThread failoverWorkerThread = null;
    protected Random rand = null;
    protected int downEventCount = 0;
    protected int upEventCount = 0;
    protected int pendingCreationRequests = 0;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:49_PDT_2005";

    OracleImplicitConnectionCache(OracleDataSource oracleDataSource, Properties properties) throws SQLException {
        this.cacheEnabledDS = oracleDataSource;
        this.initializeConnectionCache();
        this.setConnectionCacheProperties(properties);
        this.defaultUserPrePopulateCache(this.cacheInitialLimit);
    }

    private void abortConnection(OraclePooledConnection oraclePooledConnection) {
        try {
            ((OracleConnection)oraclePooledConnection.getPhysicalHandle()).abort();
        }
        catch (Exception exception) {}
    }

    private void actualPooledConnectionClose(OraclePooledConnection oraclePooledConnection) throws SQLException {
        int n2 = 0;
        if (this.databaseInstancesList != null && (n2 = this.databaseInstancesList.size()) > 0) {
            LinkedList linkedList = this.databaseInstancesList;
            synchronized (linkedList) {
                OracleDatabaseInstance oracleDatabaseInstance = null;
                int n3 = 0;
                while (n3 < n2) {
                    oracleDatabaseInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(n3);
                    if (oracleDatabaseInstance.databaseUniqName == oraclePooledConnection.dataSourceDbUniqNameKey && oracleDatabaseInstance.instanceName == oraclePooledConnection.dataSourceInstanceNameKey) {
                        if (oracleDatabaseInstance.numberOfConnectionsCount <= 0) break;
                        --oracleDatabaseInstance.numberOfConnectionsCount;
                        break;
                    }
                    ++n3;
                }
            }
        }
        try {
            oraclePooledConnection.close();
        }
        catch (SQLException sQLException) {}
    }

    private String buildAttrKey(Properties properties) throws SQLException {
        int n2;
        int n3 = ((Hashtable)properties).keySet().size();
        Object[] objectArray = ((Hashtable)properties).keySet().toArray();
        boolean bl2 = true;
        StringBuffer stringBuffer = new StringBuffer();
        while (bl2) {
            bl2 = false;
            n2 = 0;
            while (n2 < n3 - 1) {
                if (((String)objectArray[n2]).compareTo((String)objectArray[n2 + 1]) > 0) {
                    bl2 = true;
                    Object object = objectArray[n2];
                    objectArray[n2] = objectArray[n2 + 1];
                    objectArray[n2 + 1] = object;
                }
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < n3) {
            stringBuffer.append(String.valueOf(String.valueOf(objectArray[n2])) + ATTRKEY_DELIM + ((Hashtable)properties).get(objectArray[n2]));
            ++n2;
        }
        return stringBuffer.toString();
    }

    synchronized void cleanupFailoverConnections(boolean bl2, boolean bl3, String string, String string2, String string3, String string4) {
        OraclePooledConnection oraclePooledConnection = null;
        Object[] objectArray = this.checkedOutConnectionList.toArray();
        int n2 = this.checkedOutConnectionList.size();
        OraclePooledConnection[] oraclePooledConnectionArray = new OraclePooledConnection[n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            try {
                oraclePooledConnection = (OraclePooledConnection)objectArray[n4];
                if (bl2 && (string == null || string == oraclePooledConnection.dataSourceInstanceNameKey) && string2 == oraclePooledConnection.dataSourceDbUniqNameKey || bl3 && string3 == oraclePooledConnection.dataSourceHostNameKey) {
                    if (this.defaultUser != null && this.defaultUser.equalsIgnoreCase(oraclePooledConnection.pcUser) && oraclePooledConnection.cachedConnectionAttributes != null && ((Hashtable)oraclePooledConnection.cachedConnectionAttributes).isEmpty()) {
                        ++this.defaultUserPreFailureSize;
                    }
                    this.checkedOutConnectionList.removeElement(oraclePooledConnection);
                    this.abortConnection(oraclePooledConnection);
                    oraclePooledConnection.isHostDown = true;
                    oraclePooledConnectionArray[n3++] = oraclePooledConnection;
                }
            }
            catch (Exception exception) {}
            ++n4;
        }
        int n5 = 0;
        while (n5 < n3) {
            try {
                this.closeCheckedOutConnection(oraclePooledConnectionArray[n5], false);
            }
            catch (SQLException sQLException) {}
            ++n5;
        }
        if (this.checkedOutConnectionList.size() < n2 && this.cacheConnectionWaitTimeout > 0) {
            this.notifyAll();
        }
        try {
            this.doForEveryCachedConnection(2);
        }
        catch (SQLException sQLException) {}
        if (this.databaseInstancesList != null && (n2 = this.databaseInstancesList.size()) > 0) {
            LinkedList linkedList = this.databaseInstancesList;
            synchronized (linkedList) {
                OracleDatabaseInstance oracleDatabaseInstance = null;
                objectArray = this.databaseInstancesList.toArray();
                int n6 = 0;
                while (n6 < n2) {
                    oracleDatabaseInstance = (OracleDatabaseInstance)objectArray[n6];
                    if (oracleDatabaseInstance.databaseUniqName == string2 && oracleDatabaseInstance.instanceName == string) {
                        if (oracleDatabaseInstance.flag <= 3) {
                            this.dbInstancePercentTotal -= oracleDatabaseInstance.percent;
                        }
                        this.databaseInstancesList.remove(oracleDatabaseInstance);
                    }
                    ++n6;
                }
            }
        }
    }

    protected void cleanupRLBThreads() {
        if (this.gravitateCacheThread != null) {
            try {
                this.gravitateCacheThread.interrupt();
                this.gravitateCacheThread.join();
            }
            catch (InterruptedException interruptedException) {}
            this.gravitateCacheThread = null;
        }
        if (this.runtimeLoadBalancingThread != null) {
            try {
                this.runtimeLoadBalancingThread.interrupt();
            }
            catch (Exception exception) {}
            this.runtimeLoadBalancingThread = null;
        }
    }

    private void cleanupTimeoutThread() throws SQLException {
        if (this.timeoutThread != null) {
            this.timeoutThread.timeToLive = false;
            if (this.timeoutThread.isSleeping) {
                this.timeoutThread.interrupt();
            }
            this.timeoutThread = null;
        }
    }

    protected synchronized void closeAndRemovePooledConnection(OraclePooledConnection oraclePooledConnection) throws SQLException {
        if (oraclePooledConnection != null) {
            if (oraclePooledConnection.isHostDown) {
                this.abortConnection(oraclePooledConnection);
            }
            this.actualPooledConnectionClose(oraclePooledConnection);
            this.removeCacheConnection(oraclePooledConnection);
        }
    }

    protected void closeCheckedOutConnection(OraclePooledConnection oraclePooledConnection, boolean bl2) throws SQLException {
        if (oraclePooledConnection != null) {
            OracleConnection oracleConnection = (OracleConnection)oraclePooledConnection.getLogicalHandle();
            try {
                if (!oracleConnection.getAutoCommit() && !oraclePooledConnection.isHostDown) {
                    oracleConnection.rollback();
                }
            }
            catch (SQLException sQLException) {}
            if (bl2) {
                try {
                    oracleConnection.close();
                }
                catch (SQLException sQLException) {}
            } else {
                this.actualPooledConnectionClose(oraclePooledConnection);
            }
        }
    }

    protected synchronized void closeConnectionCache() throws SQLException {
        this.cleanupTimeoutThread();
        this.purgeCacheConnections(true);
        this.connectionPoolDS = null;
        this.cacheEnabledDS = null;
        this.checkedOutConnectionList = null;
        this.userMap = null;
        this.cacheManager = null;
    }

    protected void closePooledConnection(PooledConnection pooledConnection) throws SQLException {
        if (pooledConnection != null) {
            this.actualPooledConnectionClose((OraclePooledConnection)pooledConnection);
            if (((OraclePooledConnection)pooledConnection).closeOption == 4096) {
                this.checkedOutConnectionList.removeElement(pooledConnection);
            }
            pooledConnection = null;
            if (this.getTotalCachedConnections() < this.cacheMinLimit) {
                this.defaultUserPrePopulateCache(1);
            }
        }
    }

    private void defaultUserPrePopulateCache(int n2) throws SQLException {
        if (n2 > 0) {
            String string = this.defaultUser;
            String string2 = this.defaultPassword;
            this.validateUser(string, string2);
            OraclePooledConnection oraclePooledConnection = null;
            int n3 = 0;
            while (n3 < n2) {
                if (this.getTotalCachedConnections() < this.cacheMaxLimit && (oraclePooledConnection = this.makeCacheConnection(string, string2)) != null) {
                    OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
                    synchronized (oracleImplicitConnectionCache) {
                        --this.cacheSize;
                    }
                    this.storeCacheConnection(string, null, oraclePooledConnection);
                }
                ++n3;
            }
        }
    }

    protected synchronized void disableConnectionCache() throws SQLException {
        this.disableConnectionRequest = true;
    }

    protected void doForEveryCachedConnection(int n2) throws SQLException {
        int n3 = 0;
        OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
        synchronized (oracleImplicitConnectionCache) {
            if (this.userMap != null && !this.userMap.isEmpty()) {
                Iterator iterator = this.userMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    OraclePooledConnection oraclePooledConnection;
                    Object object;
                    Object object2;
                    Map.Entry entry = iterator.next();
                    OracleConnectionCacheEntry oracleConnectionCacheEntry = (OracleConnectionCacheEntry)entry.getValue();
                    if (oracleConnectionCacheEntry.userConnList != null && !oracleConnectionCacheEntry.userConnList.isEmpty()) {
                        object2 = oracleConnectionCacheEntry.userConnList;
                        object = ((Vector)object2).toArray();
                        int n4 = 0;
                        while (n4 < ((Object[])object).length) {
                            oraclePooledConnection = (OraclePooledConnection)object[n4];
                            if (oraclePooledConnection != null && this.performPooledConnectionTask(oraclePooledConnection, n2)) {
                                ++n3;
                            }
                            ++n4;
                        }
                    }
                    if (oracleConnectionCacheEntry.attrConnMap == null || oracleConnectionCacheEntry.attrConnMap.isEmpty()) continue;
                    object2 = oracleConnectionCacheEntry.attrConnMap.entrySet().iterator();
                    while (object2.hasNext()) {
                        object = (Map.Entry)object2.next();
                        Vector vector = (Vector)object.getValue();
                        Object[] objectArray = vector.toArray();
                        int n5 = 0;
                        while (n5 < objectArray.length) {
                            oraclePooledConnection = (OraclePooledConnection)objectArray[n5];
                            if (oraclePooledConnection != null && this.performPooledConnectionTask(oraclePooledConnection, n2)) {
                                ++n3;
                            }
                            ++n5;
                        }
                    }
                    if (n2 != 1) continue;
                    oracleConnectionCacheEntry.attrConnMap.clear();
                }
                if (n2 == 1) {
                    this.userMap.clear();
                    this.cacheSize = 0;
                }
            }
        }
        if (n3 > 0) {
            this.defaultUserPrePopulateCache(n3);
        }
    }

    protected synchronized void doForEveryCheckedOutConnection(int n2) throws SQLException {
        int n3 = this.checkedOutConnectionList.size();
        if (n2 == 1) {
            int n4 = 0;
            while (n4 < n3) {
                this.closeCheckedOutConnection((OraclePooledConnection)this.checkedOutConnectionList.get(n4), false);
                ++n4;
            }
            this.checkedOutConnectionList.removeAllElements();
        } else if (n2 == 24) {
            int n5 = 0;
            while (n5 < n3 && this.retireConnectionsCount > 0) {
                OraclePooledConnection oraclePooledConnection = (OraclePooledConnection)this.checkedOutConnectionList.get(n5);
                if (this.instanceToRetire.databaseUniqName == oraclePooledConnection.dataSourceDbUniqNameKey && this.instanceToRetire.instanceName == oraclePooledConnection.dataSourceInstanceNameKey) {
                    oraclePooledConnection.closeOption = 4096;
                    this.retireConnectionsCount -= 2;
                }
                ++n5;
            }
        }
    }

    protected synchronized void enableConnectionCache() throws SQLException {
        this.disableConnectionRequest = false;
    }

    private int getAttributesMatchCount(Properties properties, Properties properties2) throws SQLException {
        int n2 = 0;
        Map.Entry entry = null;
        Object var5_5 = null;
        Object object = null;
        Iterator iterator = ((Hashtable)properties).entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            var5_5 = entry.getKey();
            object = entry.getValue();
            if (!((Hashtable)properties2).containsKey(var5_5) || !object.equals(((Hashtable)properties2).get(var5_5))) continue;
            ++n2;
        }
        return n2;
    }

    private int getAttributesWeightCount(Properties properties, Properties properties2) throws SQLException {
        Map.Entry entry = null;
        Object var4_4 = null;
        Object object = null;
        int n2 = 0;
        Iterator iterator = ((Hashtable)properties).entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            var4_4 = entry.getKey();
            object = entry.getValue();
            if (properties2 == null) {
                if (!((Hashtable)this.cacheAttributeWeights).containsKey(var4_4)) continue;
                n2 += Integer.parseInt((String)((Hashtable)this.cacheAttributeWeights).get(var4_4));
                continue;
            }
            if (!((Hashtable)properties2).containsKey(var4_4) || !object.equals(((Hashtable)properties2).get(var4_4))) continue;
            if (((Hashtable)this.cacheAttributeWeights).containsKey(var4_4)) {
                n2 += Integer.parseInt((String)((Hashtable)this.cacheAttributeWeights).get(var4_4));
                continue;
            }
            ++n2;
        }
        return n2;
    }

    protected int getCacheAbandonedTimeout() {
        return this.cacheAbandonedConnectionTimeout;
    }

    private OraclePooledConnection getCacheConnection(String string, String string2, Properties properties) throws SQLException {
        OraclePooledConnection oraclePooledConnection = this.retrieveCacheConnection(string, string2, properties);
        boolean bl2 = false;
        if (oraclePooledConnection == null) {
            OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
            synchronized (oracleImplicitConnectionCache) {
                if (this.getTotalCachedConnections() + this.pendingCreationRequests < this.cacheMaxLimit) {
                    ++this.pendingCreationRequests;
                    bl2 = true;
                }
            }
        }
        if (bl2) {
            try {
                oraclePooledConnection = this.makeCacheConnection(string, string2);
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
                synchronized (oracleImplicitConnectionCache) {
                    --this.pendingCreationRequests;
                }
                throw throwable;
            }
            Object var7_8 = null;
            OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
            synchronized (oracleImplicitConnectionCache) {
                --this.pendingCreationRequests;
            }
            if (properties != null && !((Hashtable)properties).isEmpty()) {
                this.setUnMatchedAttributes(properties, oraclePooledConnection);
            }
        }
        return oraclePooledConnection;
    }

    protected int getCacheInactivityTimeout() {
        return this.cacheInactivityTimeout;
    }

    protected int getCachePropertyCheckInterval() {
        return this.cachePropertyCheckInterval;
    }

    protected int getCacheTimeToLiveTimeout() {
        return this.cacheTimeToLiveTimeout;
    }

    protected Connection getConnection(String string, String string2, Properties properties) throws SQLException {
        Connection connection;
        block20: {
            OraclePooledConnection oraclePooledConnection = null;
            connection = null;
            try {
                if (this.disableConnectionRequest) {
                    DatabaseError.throwSqlException(142);
                }
                this.validateUser(string, string2);
                if (!string.startsWith("\"")) {
                    string = string.toLowerCase();
                }
                if (this.getNumberOfCheckedOutConnections() < this.cacheMaxLimit) {
                    oraclePooledConnection = this.getCacheConnection(string, string2, properties);
                }
                if (oraclePooledConnection == null) {
                    this.processConnectionCacheCallback();
                    if (this.cacheSize > 0) {
                        oraclePooledConnection = this.getCacheConnection(string, string2, properties);
                    }
                    if (oraclePooledConnection == null && this.cacheConnectionWaitTimeout > 0) {
                        long l2 = (long)this.cacheConnectionWaitTimeout * 1000L;
                        long l3 = System.currentTimeMillis();
                        long l4 = 0L;
                        do {
                            this.processConnectionWaitTimeout(l2);
                            if (this.cacheSize > 0) {
                                oraclePooledConnection = this.getCacheConnection(string, string2, properties);
                            }
                            l4 = System.currentTimeMillis();
                            l3 = l4;
                        } while (oraclePooledConnection == null && (l2 -= System.currentTimeMillis() - l3) > 0L);
                    }
                }
                if (oraclePooledConnection == null || oraclePooledConnection.physicalConn == null || (connection = oraclePooledConnection.getConnection()) == null) break block20;
                if (this.cacheValidateConnection && this.testDatabaseConnection((OracleConnection)connection) != 0) {
                    ((OracleConnection)connection).close(4096);
                    DatabaseError.throwSqlException(143);
                }
                if (this.cacheAbandonedConnectionTimeout > 0) {
                    ((OracleConnection)connection).setAbandonedTimeoutEnabled(true);
                }
                if (this.cacheTimeToLiveTimeout > 0) {
                    ((OracleConnection)connection).setStartTime(System.currentTimeMillis());
                }
                OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
                synchronized (oracleImplicitConnectionCache) {
                    --this.cacheSize;
                    this.checkedOutConnectionList.addElement(oraclePooledConnection);
                }
            }
            catch (SQLException sQLException) {
                OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
                synchronized (oracleImplicitConnectionCache) {
                    if (oraclePooledConnection != null) {
                        --this.cacheSize;
                        this.abortConnection(oraclePooledConnection);
                    }
                }
                throw sQLException;
            }
        }
        return connection;
    }

    protected Properties getConnectionCacheProperties() throws SQLException {
        Properties properties = new Properties();
        properties.setProperty(MIN_LIMIT_KEY, String.valueOf(this.cacheMinLimit));
        properties.setProperty(MAX_LIMIT_KEY, String.valueOf(this.cacheMaxLimit));
        properties.setProperty(INITIAL_LIMIT_KEY, String.valueOf(this.cacheInitialLimit));
        properties.setProperty(MAX_STATEMENTS_LIMIT_KEY, String.valueOf(this.cacheMaxStatementsLimit));
        if (this.cacheAttributeWeights != null) {
            ((Hashtable)properties).put(ATTRIBUTE_WEIGHTS_KEY, this.cacheAttributeWeights);
        } else {
            properties.setProperty(ATTRIBUTE_WEIGHTS_KEY, "NULL");
        }
        properties.setProperty(INACTIVITY_TIMEOUT_KEY, String.valueOf(this.cacheInactivityTimeout));
        properties.setProperty(TIME_TO_LIVE_TIMEOUT_KEY, String.valueOf(this.cacheTimeToLiveTimeout));
        properties.setProperty(ABANDONED_CONNECTION_TIMEOUT_KEY, String.valueOf(this.cacheAbandonedConnectionTimeout));
        properties.setProperty(LOWER_THRESHOLD_LIMIT_KEY, String.valueOf(this.cacheLowerThresholdLimit));
        properties.setProperty(PROPERTY_CHECK_INTERVAL_KEY, String.valueOf(this.cachePropertyCheckInterval));
        properties.setProperty(CONNECTION_WAIT_TIMEOUT_KEY, String.valueOf(this.cacheConnectionWaitTimeout));
        properties.setProperty(VALIDATE_CONNECTION_KEY, String.valueOf(this.cacheValidateConnection));
        properties.setProperty(CLOSEST_CONNECTION_MATCH_KEY, String.valueOf(this.cacheClosestConnectionMatch));
        return properties;
    }

    protected int getNumberOfCheckedOutConnections() {
        return this.checkedOutConnectionList.size();
    }

    private int getNumberOfDefaultUserConnections() {
        OracleConnectionCacheEntry oracleConnectionCacheEntry;
        int n2 = 0;
        if (this.userMap != null && !this.userMap.isEmpty() && (oracleConnectionCacheEntry = (OracleConnectionCacheEntry)this.userMap.get(String.valueOf(this.defaultUser) + this.defaultPassword.toUpperCase())) != null && oracleConnectionCacheEntry.userConnList != null && !oracleConnectionCacheEntry.userConnList.isEmpty()) {
            n2 = oracleConnectionCacheEntry.userConnList.size();
        }
        return n2;
    }

    protected int getTotalCachedConnections() {
        return this.cacheSize + this.getNumberOfCheckedOutConnections();
    }

    protected void gravitateCache() {
        if (this.instancesToRetireList != null) {
            LinkedList linkedList = this.instancesToRetireList;
            synchronized (linkedList) {
                int n2 = this.instancesToRetireList.size();
                int n3 = 0;
                while (n3 < n2) {
                    this.instanceToRetire = (OracleDatabaseInstance)this.instancesToRetireList.get(n3);
                    this.retireConnectionsCount = (int)((double)this.instanceToRetire.numberOfConnectionsCount * 0.25);
                    try {
                        this.doForEveryCachedConnection(24);
                    }
                    catch (SQLException sQLException) {}
                    if (this.retireConnectionsCount > 0) {
                        try {
                            this.doForEveryCheckedOutConnection(24);
                        }
                        catch (SQLException sQLException) {}
                    }
                    ++n3;
                }
            }
        }
        this.retireConnectionsCount = 0;
        this.instanceToRetire = null;
        this.instancesToRetireList = null;
        this.countTotal = 0;
    }

    protected void initFailoverParameters(OraclePooledConnection oraclePooledConnection) throws SQLException {
        String string = null;
        String string2 = null;
        String string3 = null;
        Properties properties = ((OracleConnection)oraclePooledConnection.getPhysicalHandle()).getServerSessionInfo();
        string3 = properties.getProperty("INSTANCE_NAME");
        if (string3 != null) {
            string = oraclePooledConnection.dataSourceInstanceNameKey = string3.trim().intern();
        }
        if ((string3 = properties.getProperty("SERVER_HOST")) != null) {
            oraclePooledConnection.dataSourceHostNameKey = string3.trim().intern();
        }
        if ((string3 = properties.getProperty("SERVICE_NAME")) != null) {
            this.dataSourceServiceName = string3.trim();
        }
        if ((string3 = properties.getProperty("DATABASE_NAME")) != null) {
            string2 = oraclePooledConnection.dataSourceDbUniqNameKey = string3.trim().intern();
        }
        if (this.databaseInstancesList == null) {
            this.databaseInstancesList = new LinkedList();
        }
        int n2 = this.databaseInstancesList.size();
        LinkedList linkedList = this.databaseInstancesList;
        synchronized (linkedList) {
            OracleDatabaseInstance oracleDatabaseInstance = null;
            boolean bl2 = false;
            int n3 = 0;
            while (n3 < n2) {
                oracleDatabaseInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(n3);
                if (oracleDatabaseInstance.databaseUniqName == string2 && oracleDatabaseInstance.instanceName == string) {
                    ++oracleDatabaseInstance.numberOfConnectionsCount;
                    bl2 = true;
                    break;
                }
                ++n3;
            }
            if (!bl2) {
                OracleDatabaseInstance oracleDatabaseInstance2 = new OracleDatabaseInstance(string2, string);
                ++oracleDatabaseInstance2.numberOfConnectionsCount;
                this.databaseInstancesList.add(oracleDatabaseInstance2);
            }
        }
    }

    protected void initializeConnectionCache() throws SQLException {
        this.userMap = new HashMap();
        this.checkedOutConnectionList = new Vector();
        if (this.cacheManager == null) {
            this.cacheManager = OracleConnectionCacheManager.getConnectionCacheManagerInstance();
        }
        this.defaultUser = this.cacheEnabledDS.getUser();
        this.defaultPassword = this.cacheEnabledDS.getPassword();
        if (this.connectionPoolDS == null) {
            this.connectionPoolDS = this.cacheEnabledDS instanceof OracleXADataSource ? new OracleXADataSource() : new OracleConnectionPoolDataSource();
            this.cacheEnabledDS.copy(this.connectionPoolDS);
        }
        if (this.fastConnectionFailoverEnabled = this.cacheEnabledDS.getFastConnectionFailoverEnabled()) {
            this.rand = new Random(0L);
            ++this.cacheManager.failoverEnabledCacheCount;
        }
    }

    private void loadBalanceConnections(int n2, boolean bl2) throws SQLException {
        if (bl2) {
            this.connectionsToRemove = n2;
            this.doForEveryCachedConnection(8);
            this.connectionsToRemove = 0;
        }
        if (n2 <= 10) {
            try {
                this.defaultUserPrePopulateCache(n2);
            }
            catch (Exception exception) {}
        } else {
            int n3 = (int)((double)n2 * 0.25);
            int n4 = 0;
            while (n4 < 4) {
                try {
                    this.defaultUserPrePopulateCache(n3);
                }
                catch (Exception exception) {}
                ++n4;
            }
        }
    }

    protected OraclePooledConnection makeCacheConnection(String string, String string2) throws SQLException {
        OraclePooledConnection oraclePooledConnection = (OraclePooledConnection)this.connectionPoolDS.getPooledConnection(string, string2);
        if (oraclePooledConnection != null) {
            if (this.cacheMaxStatementsLimit > 0) {
                this.setStatementCaching(oraclePooledConnection, this.cacheMaxStatementsLimit, true);
            }
            oraclePooledConnection.registerImplicitCacheConnectionEventListener(new OracleConnectionCacheEventListener(this));
            oraclePooledConnection.cachedConnectionAttributes = new Properties();
            if (this.fastConnectionFailoverEnabled) {
                this.initFailoverParameters(oraclePooledConnection);
            }
            OracleImplicitConnectionCache oracleImplicitConnectionCache = this;
            synchronized (oracleImplicitConnectionCache) {
                ++this.cacheSize;
                if (this.fastConnectionFailoverEnabled && this.runtimeLoadBalancingThread == null) {
                    this.runtimeLoadBalancingThread = new OracleRuntimeLoadBalancingEventHandlerThread(this.dataSourceServiceName);
                    this.cacheManager.checkAndStartThread(this.runtimeLoadBalancingThread);
                }
            }
        }
        return oraclePooledConnection;
    }

    private boolean markDownConnectionsForHostEvent(String string, OraclePooledConnection oraclePooledConnection) {
        boolean bl2 = false;
        if (string == oraclePooledConnection.dataSourceHostNameKey) {
            oraclePooledConnection.connectionMarkedDown = true;
            oraclePooledConnection.isHostDown = true;
            bl2 = true;
        }
        return bl2;
    }

    private boolean markDownConnectionsForServiceEvent(String string, String string2, OraclePooledConnection oraclePooledConnection) {
        boolean bl2 = false;
        if (string == null || string2 == oraclePooledConnection.dataSourceDbUniqNameKey && string == oraclePooledConnection.dataSourceInstanceNameKey) {
            oraclePooledConnection.connectionMarkedDown = true;
            bl2 = true;
        }
        return bl2;
    }

    synchronized void markDownLostConnections(boolean bl2, boolean bl3, String string, String string2, String string3, String string4) {
        if (!this.isEntireServiceDownProcessed) {
            if (this.userMap != null && !this.userMap.isEmpty()) {
                Iterator iterator = this.userMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Object object;
                    Object object2;
                    OracleConnectionCacheEntry oracleConnectionCacheEntry;
                    boolean bl4 = false;
                    Map.Entry entry = iterator.next();
                    if (this.defaultUser != null && this.defaultUser.equalsIgnoreCase((String)entry.getKey())) {
                        bl4 = true;
                    }
                    if ((oracleConnectionCacheEntry = (OracleConnectionCacheEntry)entry.getValue()) != null && oracleConnectionCacheEntry.userConnList != null && !oracleConnectionCacheEntry.userConnList.isEmpty()) {
                        boolean bl5 = false;
                        object2 = ((AbstractList)oracleConnectionCacheEntry.userConnList).iterator();
                        while (object2.hasNext()) {
                            object = (OraclePooledConnection)object2.next();
                            if (bl2) {
                                bl5 = this.markDownConnectionsForServiceEvent(string, string2, (OraclePooledConnection)object);
                            } else if (bl3) {
                                bl5 = this.markDownConnectionsForHostEvent(string3, (OraclePooledConnection)object);
                            }
                            if (!bl5 || !bl4) continue;
                            ++this.defaultUserPreFailureSize;
                        }
                    }
                    if (oracleConnectionCacheEntry == null || oracleConnectionCacheEntry.attrConnMap == null || oracleConnectionCacheEntry.attrConnMap.isEmpty()) continue;
                    Iterator iterator2 = oracleConnectionCacheEntry.attrConnMap.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        object2 = iterator2.next();
                        object = ((AbstractList)((Vector)object2.getValue())).iterator();
                        while (object.hasNext()) {
                            OraclePooledConnection oraclePooledConnection = (OraclePooledConnection)object.next();
                            if (bl2) {
                                this.markDownConnectionsForServiceEvent(string, string2, oraclePooledConnection);
                                continue;
                            }
                            if (!bl3) continue;
                            this.markDownConnectionsForHostEvent(string3, oraclePooledConnection);
                        }
                    }
                }
            }
            if (string == null) {
                this.isEntireServiceDownProcessed = true;
            }
        }
    }

    private boolean performPooledConnectionTask(OraclePooledConnection oraclePooledConnection, int n2) throws SQLException {
        boolean bl2 = false;
        switch (n2) {
            case 2: {
                if (!oraclePooledConnection.connectionMarkedDown) break;
                this.closeAndRemovePooledConnection(oraclePooledConnection);
                break;
            }
            case 8: {
                if (this.connectionsToRemove <= 0) break;
                this.closeAndRemovePooledConnection(oraclePooledConnection);
                --this.connectionsToRemove;
                break;
            }
            case 24: {
                if (this.retireConnectionsCount <= 0 || this.instanceToRetire.databaseUniqName != oraclePooledConnection.dataSourceDbUniqNameKey || this.instanceToRetire.instanceName != oraclePooledConnection.dataSourceInstanceNameKey) break;
                this.closeAndRemovePooledConnection(oraclePooledConnection);
                --this.retireConnectionsCount;
                if (this.getTotalCachedConnections() >= this.cacheMinLimit) break;
                bl2 = true;
                break;
            }
            case 4096: {
                Connection connection = oraclePooledConnection.getLogicalHandle();
                if (connection == null || this.testDatabaseConnection((OracleConnection)connection) == 0) break;
                this.closeAndRemovePooledConnection(oraclePooledConnection);
                bl2 = true;
                break;
            }
            case 8192: {
                this.closeAndRemovePooledConnection(oraclePooledConnection);
                bl2 = true;
                break;
            }
            case 1: {
                this.closeAndRemovePooledConnection(oraclePooledConnection);
                break;
            }
            case 4: {
                this.processInactivityTimeout(oraclePooledConnection);
                break;
            }
            case 16: {
                this.setStatementCaching(oraclePooledConnection, this.cacheMaxStatementsLimit, false);
                break;
            }
            case 18: {
                this.setStatementCaching(oraclePooledConnection, this.cacheMaxStatementsLimit, true);
                break;
            }
        }
        return bl2;
    }

    private synchronized void processConnectionCacheCallback() throws SQLException {
        float f2 = (float)this.cacheMaxLimit / 100.0f;
        int n2 = (int)((float)this.cacheLowerThresholdLimit * f2);
        this.releaseBasedOnPriority(1024, n2);
        if (this.cacheSize < n2) {
            this.releaseBasedOnPriority(512, n2);
        }
    }

    private synchronized void processConnectionWaitTimeout(long l2) throws SQLException {
        try {
            this.wait(l2);
        }
        catch (InterruptedException interruptedException) {}
    }

    protected void processDatabaseInstances() throws SQLException {
        OracleDatabaseInstance oracleDatabaseInstance = null;
        LinkedList<OracleDatabaseInstance> linkedList = new LinkedList<OracleDatabaseInstance>();
        if (this.databaseInstancesList != null) {
            LinkedList linkedList2 = this.databaseInstancesList;
            synchronized (linkedList2) {
                int n2 = 0;
                boolean bl2 = false;
                this.useGoodGroup = false;
                int n3 = this.databaseInstancesList.size();
                int n4 = 0;
                while (n4 < n3) {
                    oracleDatabaseInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(n4);
                    if (oracleDatabaseInstance.flag <= 3) {
                        n2 += oracleDatabaseInstance.percent;
                    }
                    ++n4;
                }
                if (n2 > 0) {
                    this.dbInstancePercentTotal = n2;
                    this.useGoodGroup = true;
                }
                if (n3 > 1) {
                    int n5 = 0;
                    while (n5 < n3) {
                        oracleDatabaseInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(n5);
                        this.countTotal += oracleDatabaseInstance.attemptedConnRequestCount;
                        ++n5;
                    }
                    if (this.countTotal > n3 * 1000) {
                        int n6 = 0;
                        while (n6 < n3) {
                            oracleDatabaseInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(n6);
                            float f2 = (float)oracleDatabaseInstance.attemptedConnRequestCount / (float)this.countTotal;
                            float f3 = (float)oracleDatabaseInstance.numberOfConnectionsCount / (float)this.getTotalCachedConnections();
                            if (f3 > f2 * 2.0f) {
                                if ((int)((double)oracleDatabaseInstance.numberOfConnectionsCount * 0.25) >= 1) {
                                    linkedList.add(oracleDatabaseInstance);
                                }
                                bl2 = true;
                            }
                            ++n6;
                        }
                        if (bl2) {
                            int n7 = 0;
                            while (n7 < n3) {
                                oracleDatabaseInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(n7);
                                oracleDatabaseInstance.attemptedConnRequestCount = 0;
                                ++n7;
                            }
                            bl2 = false;
                        }
                    }
                }
            }
            if (linkedList.size() > 0) {
                this.instancesToRetireList = linkedList;
                if (this.gravitateCacheThread != null) {
                    try {
                        this.gravitateCacheThread.interrupt();
                        this.gravitateCacheThread.join();
                    }
                    catch (InterruptedException interruptedException) {}
                    this.gravitateCacheThread = null;
                }
                this.gravitateCacheThread = new OracleGravitateConnectionCacheThread(this);
                this.cacheManager.checkAndStartThread(this.gravitateCacheThread);
            }
        }
    }

    protected void processFailoverEvent(int n2, String string, String string2, String string3, String string4, int n3) {
        if (n2 == 256) {
            if (string4.equalsIgnoreCase("down") || string4.equalsIgnoreCase("not_restarting") || string4.equalsIgnoreCase("restart_failed")) {
                ++this.downEventCount;
                this.markDownLostConnections(true, false, string, string2, string3, string4);
                this.cleanupFailoverConnections(true, false, string, string2, string3, string4);
            } else if (string4.equalsIgnoreCase("up")) {
                if (this.downEventCount > 0) {
                    ++this.upEventCount;
                }
                try {
                    this.processUpEvent(n3);
                }
                catch (Exception exception) {}
                this.isEntireServiceDownProcessed = false;
            }
        } else if (n2 == 512 && string4.equalsIgnoreCase("nodedown")) {
            this.markDownLostConnections(false, true, string, string2, string3, string4);
            this.cleanupFailoverConnections(false, true, string, string2, string3, string4);
        }
    }

    private void processInactivityTimeout(OraclePooledConnection oraclePooledConnection) throws SQLException {
        long l2 = oraclePooledConnection.getLastAccessedTime();
        long l3 = System.currentTimeMillis();
        if (this.getTotalCachedConnections() > this.cacheMinLimit && l3 - l2 > (long)(this.cacheInactivityTimeout * 1000)) {
            this.closeAndRemovePooledConnection(oraclePooledConnection);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized void processUpEvent(int n2) throws SQLException {
        int n3 = 0;
        int n4 = 0;
        int n5 = this.getTotalCachedConnections();
        boolean bl2 = false;
        if (n2 <= 1) {
            n2 = 2;
        }
        if ((n3 = this.downEventCount == 0 && this.upEventCount == 0 && this.getNumberOfDefaultUserConnections() > 0 ? (int)((double)this.cacheSize * 0.25) : this.defaultUserPreFailureSize) <= 0) {
            if (this.getNumberOfDefaultUserConnections() <= 0) return;
            n4 = (int)((double)this.cacheSize * 0.25);
            bl2 = true;
        } else {
            n4 = n3 / n2;
            if (n4 + n5 > this.cacheMaxLimit) {
                bl2 = true;
            }
        }
        if (n4 > 0) {
            this.loadBalanceConnections(n4, bl2);
        }
        if (this.downEventCount != this.upEventCount) return;
        this.defaultUserPreFailureSize = 0;
        this.downEventCount = 0;
        this.upEventCount = 0;
    }

    protected void purgeCacheConnections(boolean bl2) {
        try {
            if (bl2) {
                this.doForEveryCheckedOutConnection(1);
            }
            this.doForEveryCachedConnection(1);
        }
        catch (SQLException sQLException) {}
    }

    protected void refreshCacheConnections(int n2) throws SQLException {
        this.doForEveryCachedConnection(n2);
    }

    protected synchronized void reinitializeCacheConnections(Properties properties) throws SQLException {
        this.defaultUser = this.cacheEnabledDS.getUser();
        this.defaultPassword = this.cacheEnabledDS.getPassword();
        this.fastConnectionFailoverEnabled = this.cacheEnabledDS.getFastConnectionFailoverEnabled();
        this.cleanupTimeoutThread();
        this.doForEveryCheckedOutConnection(1);
        int n2 = this.cacheInitialLimit;
        int n3 = this.cacheMaxLimit;
        int n4 = this.cacheMaxStatementsLimit;
        this.setConnectionCacheProperties(properties);
        if (this.cacheInitialLimit > n2) {
            int n5 = this.cacheInitialLimit - n2;
            this.defaultUserPrePopulateCache(n5);
        }
        if (n3 != Integer.MAX_VALUE && this.cacheMaxLimit < n3 && this.cacheSize > this.cacheMaxLimit) {
            this.connectionsToRemove = this.cacheSize - this.cacheMaxLimit;
            this.doForEveryCachedConnection(8);
            this.connectionsToRemove = 0;
        }
        if (this.cacheMaxStatementsLimit != n4) {
            if (this.cacheMaxStatementsLimit == 0) {
                this.doForEveryCachedConnection(16);
            } else {
                this.doForEveryCachedConnection(18);
            }
        }
    }

    private void releaseBasedOnPriority(int n2, int n3) throws SQLException {
        Object[] objectArray = this.checkedOutConnectionList.toArray();
        int n4 = 0;
        while (n4 < objectArray.length && this.cacheSize < n3) {
            OracleConnectionCacheCallback oracleConnectionCacheCallback;
            OraclePooledConnection oraclePooledConnection = (OraclePooledConnection)objectArray[n4];
            OracleConnection oracleConnection = null;
            if (oraclePooledConnection != null) {
                oracleConnection = (OracleConnection)oraclePooledConnection.getLogicalHandle();
            }
            if (oracleConnection != null && (oracleConnectionCacheCallback = oracleConnection.getConnectionCacheCallbackObj()) != null && (oracleConnection.getConnectionCacheCallbackFlag() == 2 || oracleConnection.getConnectionCacheCallbackFlag() == 4) && n2 == oracleConnection.getConnectionReleasePriority()) {
                Object object = oracleConnection.getConnectionCacheCallbackPrivObj();
                oracleConnectionCacheCallback.releaseConnection(oracleConnection, object);
            }
            ++n4;
        }
    }

    private void removeCacheConnection(OraclePooledConnection oraclePooledConnection) throws SQLException {
        boolean bl2 = false;
        String string = oraclePooledConnection.pcUser;
        OracleConnectionCacheEntry oracleConnectionCacheEntry = oraclePooledConnection.removeFromImplictCache(this.userMap);
        if (oracleConnectionCacheEntry != null) {
            String string2;
            Vector vector;
            Properties properties = oraclePooledConnection.cachedConnectionAttributes;
            if (properties == null || properties != null && ((Hashtable)properties).isEmpty()) {
                if (oracleConnectionCacheEntry.userConnList != null) {
                    bl2 = oracleConnectionCacheEntry.userConnList.removeElement(oraclePooledConnection);
                }
            } else if (oracleConnectionCacheEntry.attrConnMap != null && (vector = (Vector)oracleConnectionCacheEntry.attrConnMap.get(string2 = this.buildAttrKey(properties))) != null) {
                if (oraclePooledConnection.unMatchedCachedConnAttr != null) {
                    ((Hashtable)oraclePooledConnection.unMatchedCachedConnAttr).clear();
                    oraclePooledConnection.unMatchedCachedConnAttr = null;
                }
                if (oraclePooledConnection.cachedConnectionAttributes != null) {
                    ((Hashtable)oraclePooledConnection.cachedConnectionAttributes).clear();
                    oraclePooledConnection.cachedConnectionAttributes = null;
                }
                properties = null;
                bl2 = vector.removeElement(oraclePooledConnection);
            }
        }
        if (bl2) {
            --this.cacheSize;
        }
    }

    private synchronized OraclePooledConnection retrieveCacheConnection(String string, String string2, Properties properties) throws SQLException {
        OraclePooledConnection oraclePooledConnection = null;
        OracleConnectionCacheEntry oracleConnectionCacheEntry = (OracleConnectionCacheEntry)this.userMap.get(String.valueOf(string) + string2.toUpperCase());
        if (oracleConnectionCacheEntry != null) {
            if (properties == null || properties != null && ((Hashtable)properties).isEmpty()) {
                if (oracleConnectionCacheEntry.userConnList != null) {
                    oraclePooledConnection = this.retrieveFromConnectionList(oracleConnectionCacheEntry.userConnList);
                }
            } else if (oracleConnectionCacheEntry.attrConnMap != null) {
                String string3 = this.buildAttrKey(properties);
                Vector vector = (Vector)oracleConnectionCacheEntry.attrConnMap.get(string3);
                if (vector != null) {
                    oraclePooledConnection = this.retrieveFromConnectionList(vector);
                }
                if (oraclePooledConnection == null && this.cacheClosestConnectionMatch) {
                    oraclePooledConnection = this.retrieveClosestConnectionMatch(oracleConnectionCacheEntry.attrConnMap, properties);
                }
                if (oraclePooledConnection == null && oracleConnectionCacheEntry.userConnList != null) {
                    oraclePooledConnection = this.retrieveFromConnectionList(oracleConnectionCacheEntry.userConnList);
                }
            }
        }
        if (oraclePooledConnection != null && properties != null && !((Hashtable)properties).isEmpty()) {
            this.setUnMatchedAttributes(properties, oraclePooledConnection);
        }
        return oraclePooledConnection;
    }

    private OraclePooledConnection retrieveClosestConnectionMatch(HashMap hashMap, Properties properties) throws SQLException {
        OraclePooledConnection oraclePooledConnection = null;
        OraclePooledConnection oraclePooledConnection2 = null;
        int n2 = ((Hashtable)properties).size();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (this.cacheAttributeWeights != null) {
            n3 = this.getAttributesWeightCount(properties, null);
        }
        if (hashMap != null && !hashMap.isEmpty()) {
            Iterator iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Vector vector = (Vector)entry.getValue();
                Object[] objectArray = vector.toArray();
                int n8 = vector.size();
                int n9 = 0;
                while (n9 < n8) {
                    oraclePooledConnection = (OraclePooledConnection)objectArray[n9];
                    if (oraclePooledConnection.cachedConnectionAttributes != null && !((Hashtable)oraclePooledConnection.cachedConnectionAttributes).isEmpty() && ((Hashtable)oraclePooledConnection.cachedConnectionAttributes).size() <= n2) {
                        if (n3 > 0) {
                            n5 = this.getAttributesWeightCount(properties, oraclePooledConnection.cachedConnectionAttributes);
                            if (n5 > n4) {
                                oraclePooledConnection2 = oraclePooledConnection;
                                n4 = n5;
                            }
                        } else {
                            n7 = this.getAttributesMatchCount(properties, oraclePooledConnection.cachedConnectionAttributes);
                            if (n7 > n6) {
                                oraclePooledConnection2 = oraclePooledConnection;
                                n6 = n7;
                            }
                        }
                    }
                    ++n9;
                }
            }
        }
        return oraclePooledConnection2;
    }

    private OraclePooledConnection retrieveFromConnectionList(Vector vector) throws SQLException {
        if (vector.isEmpty()) {
            return null;
        }
        OraclePooledConnection oraclePooledConnection = null;
        if (this.fastConnectionFailoverEnabled) {
            if (this.useGoodGroup && this.databaseInstancesList != null && this.databaseInstancesList.size() > 0) {
                LinkedList linkedList = this.databaseInstancesList;
                synchronized (linkedList) {
                    int n2 = this.databaseInstancesList.size();
                    OracleDatabaseInstance oracleDatabaseInstance = null;
                    int n3 = 0;
                    boolean[] blArray = new boolean[n2];
                    int n4 = this.dbInstancePercentTotal;
                    int n5 = 0;
                    block3: while (n5 < n2) {
                        int n6 = 0;
                        n3 = n4 <= 1 ? 0 : this.rand.nextInt(n4 - 1);
                        int n7 = 0;
                        while (n7 < n2) {
                            oracleDatabaseInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(n7);
                            if (!blArray[n7] && oracleDatabaseInstance.flag <= 3 && n3 <= (n6 += oracleDatabaseInstance.percent)) {
                                if (n5 == 0) {
                                    ++oracleDatabaseInstance.attemptedConnRequestCount;
                                }
                                if ((oraclePooledConnection = this.selectConnectionFromList(vector, oracleDatabaseInstance)) != null) break block3;
                                n4 -= oracleDatabaseInstance.percent;
                                blArray[n7] = true;
                                break;
                            }
                            ++n7;
                        }
                        ++n5;
                    }
                }
            }
            int n8 = vector.size();
            int n9 = this.rand.nextInt(n8);
            OraclePooledConnection oraclePooledConnection2 = null;
            int n10 = 0;
            while (n10 < n8) {
                oraclePooledConnection2 = (OraclePooledConnection)vector.get((n9++ + n8) % n8);
                if (!oraclePooledConnection2.connectionMarkedDown) {
                    oraclePooledConnection = oraclePooledConnection2;
                    vector.remove(oraclePooledConnection);
                    break;
                }
                ++n10;
            }
        } else {
            oraclePooledConnection = (OraclePooledConnection)vector.remove(0);
        }
        return oraclePooledConnection;
    }

    protected synchronized void reusePooledConnection(PooledConnection pooledConnection) throws SQLException {
        OraclePooledConnection oraclePooledConnection = (OraclePooledConnection)pooledConnection;
        if (oraclePooledConnection != null && oraclePooledConnection.physicalConn != null) {
            this.storeCacheConnection(oraclePooledConnection.pcUser, oraclePooledConnection.cachedConnectionAttributes, oraclePooledConnection);
            this.checkedOutConnectionList.removeElement(oraclePooledConnection);
        }
    }

    private OraclePooledConnection selectConnectionFromList(Vector vector, OracleDatabaseInstance oracleDatabaseInstance) {
        OraclePooledConnection oraclePooledConnection = null;
        OraclePooledConnection oraclePooledConnection2 = null;
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            oraclePooledConnection2 = (OraclePooledConnection)vector.get(n3);
            if (!oraclePooledConnection2.connectionMarkedDown && oraclePooledConnection2.dataSourceDbUniqNameKey == oracleDatabaseInstance.databaseUniqName && oraclePooledConnection2.dataSourceInstanceNameKey == oracleDatabaseInstance.instanceName) {
                oraclePooledConnection = oraclePooledConnection2;
                vector.remove(oraclePooledConnection);
                break;
            }
            ++n3;
        }
        return oraclePooledConnection;
    }

    protected synchronized void setConnectionCacheProperties(Properties properties) throws SQLException {
        try {
            if (properties != null) {
                Properties properties2;
                String string = null;
                string = properties.getProperty(MIN_LIMIT_KEY);
                if (string != null && (this.cacheMinLimit = Integer.parseInt(string)) < 0) {
                    this.cacheMinLimit = 0;
                }
                if ((string = properties.getProperty(MAX_LIMIT_KEY)) != null && (this.cacheMaxLimit = Integer.parseInt(string)) < 0) {
                    this.cacheMaxLimit = Integer.MAX_VALUE;
                }
                if (this.cacheMaxLimit < this.cacheMinLimit) {
                    this.cacheMinLimit = this.cacheMaxLimit;
                }
                if ((string = properties.getProperty(INITIAL_LIMIT_KEY)) != null && (this.cacheInitialLimit = Integer.parseInt(string)) < 0) {
                    this.cacheInitialLimit = 0;
                }
                if (this.cacheInitialLimit > this.cacheMaxLimit) {
                    this.cacheInitialLimit = this.cacheMaxLimit;
                }
                if ((string = properties.getProperty(MAX_STATEMENTS_LIMIT_KEY)) != null && (this.cacheMaxStatementsLimit = Integer.parseInt(string)) < 0) {
                    this.cacheMaxStatementsLimit = 0;
                }
                if ((properties2 = (Properties)((Hashtable)properties).get(ATTRIBUTE_WEIGHTS_KEY)) != null) {
                    Map.Entry entry = null;
                    int n2 = 0;
                    Object k2 = null;
                    Iterator iterator = ((Hashtable)properties2).entrySet().iterator();
                    while (iterator.hasNext()) {
                        entry = iterator.next();
                        k2 = entry.getKey();
                        string = (String)((Hashtable)properties2).get(k2);
                        if (string == null || (n2 = Integer.parseInt(string)) >= 0) continue;
                        ((Hashtable)properties2).put(k2, DEFAULT_ATTRIBUTE_WEIGHT);
                    }
                    if (this.cacheAttributeWeights == null) {
                        this.cacheAttributeWeights = new Properties();
                    }
                    ((Hashtable)this.cacheAttributeWeights).putAll(properties2);
                }
                if ((string = properties.getProperty(INACTIVITY_TIMEOUT_KEY)) != null && (this.cacheInactivityTimeout = Integer.parseInt(string)) < 0) {
                    this.cacheInactivityTimeout = 0;
                }
                if ((string = properties.getProperty(TIME_TO_LIVE_TIMEOUT_KEY)) != null && (this.cacheTimeToLiveTimeout = Integer.parseInt(string)) < 0) {
                    this.cacheTimeToLiveTimeout = 0;
                }
                if ((string = properties.getProperty(ABANDONED_CONNECTION_TIMEOUT_KEY)) != null && (this.cacheAbandonedConnectionTimeout = Integer.parseInt(string)) < 0) {
                    this.cacheAbandonedConnectionTimeout = 0;
                }
                if ((string = properties.getProperty(LOWER_THRESHOLD_LIMIT_KEY)) != null) {
                    this.cacheLowerThresholdLimit = Integer.parseInt(string);
                    if (this.cacheLowerThresholdLimit < 0 || this.cacheLowerThresholdLimit > 100) {
                        this.cacheLowerThresholdLimit = 20;
                    }
                }
                if ((string = properties.getProperty(PROPERTY_CHECK_INTERVAL_KEY)) != null && (this.cachePropertyCheckInterval = Integer.parseInt(string)) < 0) {
                    this.cachePropertyCheckInterval = 900;
                }
                if ((string = properties.getProperty(VALIDATE_CONNECTION_KEY)) != null) {
                    this.cacheValidateConnection = Boolean.valueOf(string);
                }
                if ((string = properties.getProperty(CLOSEST_CONNECTION_MATCH_KEY)) != null) {
                    this.cacheClosestConnectionMatch = Boolean.valueOf(string);
                }
                if ((string = properties.getProperty(CONNECTION_WAIT_TIMEOUT_KEY)) != null && (this.cacheConnectionWaitTimeout = Integer.parseInt(string)) < 0) {
                    this.cacheConnectionWaitTimeout = 0;
                }
            } else {
                this.cacheMinLimit = 0;
                this.cacheMaxLimit = Integer.MAX_VALUE;
                this.cacheInitialLimit = 0;
                this.cacheMaxStatementsLimit = 0;
                this.cacheAttributeWeights = null;
                this.cacheInactivityTimeout = 0;
                this.cacheTimeToLiveTimeout = 0;
                this.cacheAbandonedConnectionTimeout = 0;
                this.cacheLowerThresholdLimit = 20;
                this.cachePropertyCheckInterval = 900;
                this.cacheClosestConnectionMatch = false;
                this.cacheValidateConnection = false;
                this.cacheConnectionWaitTimeout = 0;
            }
            if (this.cacheInactivityTimeout > 0 || this.cacheTimeToLiveTimeout > 0 || this.cacheAbandonedConnectionTimeout > 0) {
                if (this.timeoutThread == null) {
                    this.timeoutThread = new OracleImplicitConnectionCacheThread(this);
                }
                this.cacheManager.checkAndStartThread(this.timeoutThread);
            }
        }
        catch (NumberFormatException numberFormatException) {
            DatabaseError.throwSqlException(139);
        }
    }

    private void setStatementCaching(OraclePooledConnection oraclePooledConnection, int n2, boolean bl2) throws SQLException {
        if (n2 > 0) {
            oraclePooledConnection.setStatementCacheSize(n2);
        }
        oraclePooledConnection.setImplicitCachingEnabled(bl2);
        oraclePooledConnection.setExplicitCachingEnabled(bl2);
    }

    private void setUnMatchedAttributes(Properties properties, OraclePooledConnection oraclePooledConnection) throws SQLException {
        if (oraclePooledConnection.unMatchedCachedConnAttr == null) {
            oraclePooledConnection.unMatchedCachedConnAttr = new Properties();
        } else {
            ((Hashtable)oraclePooledConnection.unMatchedCachedConnAttr).clear();
        }
        if (!this.cacheClosestConnectionMatch) {
            ((Hashtable)oraclePooledConnection.unMatchedCachedConnAttr).putAll(properties);
        } else {
            Properties properties2 = oraclePooledConnection.cachedConnectionAttributes;
            Map.Entry entry = null;
            Object k2 = null;
            Object object = null;
            Iterator iterator = ((Hashtable)properties).entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                k2 = entry.getKey();
                object = entry.getValue();
                if (((Hashtable)properties2).containsKey(k2) || object.equals(((Hashtable)properties2).get(k2))) continue;
                ((Hashtable)oraclePooledConnection.unMatchedCachedConnAttr).put(k2, object);
            }
        }
    }

    private synchronized void storeCacheConnection(String string, Properties properties, OraclePooledConnection oraclePooledConnection) throws SQLException {
        OracleConnectionCacheEntry oracleConnectionCacheEntry;
        boolean bl2 = false;
        if (oraclePooledConnection == null || oraclePooledConnection.physicalConn == null) {
            return;
        }
        if (this.cacheInactivityTimeout > 0) {
            oraclePooledConnection.setLastAccessedTime(System.currentTimeMillis());
        }
        if (oraclePooledConnection.unMatchedCachedConnAttr != null) {
            ((Hashtable)oraclePooledConnection.unMatchedCachedConnAttr).clear();
            oraclePooledConnection.unMatchedCachedConnAttr = null;
        }
        if (!string.startsWith("\"")) {
            string = string.toLowerCase();
        }
        if ((oracleConnectionCacheEntry = oraclePooledConnection.removeFromImplictCache(this.userMap)) != null) {
            if (properties == null || properties != null && ((Hashtable)properties).isEmpty()) {
                if (oracleConnectionCacheEntry.userConnList == null) {
                    oracleConnectionCacheEntry.userConnList = new Vector();
                }
                bl2 = oracleConnectionCacheEntry.userConnList.add(oraclePooledConnection);
            } else {
                String string2;
                Vector<OraclePooledConnection> vector;
                oraclePooledConnection.cachedConnectionAttributes = properties;
                if (oracleConnectionCacheEntry.attrConnMap == null) {
                    oracleConnectionCacheEntry.attrConnMap = new HashMap();
                }
                if ((vector = (Vector<OraclePooledConnection>)oracleConnectionCacheEntry.attrConnMap.get(string2 = this.buildAttrKey(properties))) != null) {
                    bl2 = vector.add(oraclePooledConnection);
                } else {
                    vector = new Vector<OraclePooledConnection>();
                    bl2 = vector.add(oraclePooledConnection);
                    oracleConnectionCacheEntry.attrConnMap.put(string2, vector);
                }
            }
        } else {
            oracleConnectionCacheEntry = new OracleConnectionCacheEntry();
            oraclePooledConnection.addToImplicitCache(this.userMap, oracleConnectionCacheEntry);
            if (properties == null || properties != null && ((Hashtable)properties).isEmpty()) {
                Vector<OraclePooledConnection> vector = new Vector<OraclePooledConnection>();
                bl2 = vector.add(oraclePooledConnection);
                oracleConnectionCacheEntry.userConnList = vector;
            } else {
                String string3 = this.buildAttrKey(properties);
                oraclePooledConnection.cachedConnectionAttributes = properties;
                HashMap hashMap = new HashMap();
                Vector<OraclePooledConnection> vector = new Vector<OraclePooledConnection>();
                bl2 = vector.add(oraclePooledConnection);
                hashMap.put(string3, vector);
                oracleConnectionCacheEntry.attrConnMap = hashMap;
            }
        }
        if (bl2) {
            ++this.cacheSize;
        }
        if (this.cacheConnectionWaitTimeout > 0) {
            this.notifyAll();
        }
    }

    protected int testDatabaseConnection(OracleConnection oracleConnection) throws SQLException {
        return oracleConnection.pingDatabase(0);
    }

    protected void updateDatabaseInstance(String string, String string2, int n2, int n3) {
        if (this.databaseInstancesList == null) {
            this.databaseInstancesList = new LinkedList();
        }
        LinkedList linkedList = this.databaseInstancesList;
        synchronized (linkedList) {
            OracleDatabaseInstance oracleDatabaseInstance;
            int n4 = this.databaseInstancesList.size();
            boolean bl2 = false;
            int n5 = 0;
            while (n5 < n4) {
                oracleDatabaseInstance = (OracleDatabaseInstance)this.databaseInstancesList.get(n5);
                if (oracleDatabaseInstance.databaseUniqName == string && oracleDatabaseInstance.instanceName == string2) {
                    oracleDatabaseInstance.percent = n2;
                    oracleDatabaseInstance.flag = n3;
                    bl2 = true;
                    break;
                }
                ++n5;
            }
            if (!bl2) {
                oracleDatabaseInstance = new OracleDatabaseInstance(string, string2);
                oracleDatabaseInstance.percent = n2;
                oracleDatabaseInstance.flag = n3;
                this.databaseInstancesList.add(oracleDatabaseInstance);
            }
        }
    }

    private void validateUser(String string, String string2) throws SQLException {
        if (string == null || string2 == null) {
            DatabaseError.throwSqlException(79);
        }
    }

    void zapRLBInfo() {
        this.databaseInstancesList.clear();
    }
}

