/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.sql.PooledConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OracleConnectionCacheImpl;
import oracle.jdbc.pool.OraclePooledConnection;

public class OracleConnectionCacheTimeOutThread
extends Thread
implements Serializable {
    private OracleConnectionCacheImpl occi = null;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:48_PDT_2005";

    OracleConnectionCacheTimeOutThread(OracleConnectionCacheImpl oracleConnectionCacheImpl) throws SQLException {
        this.occi = oracleConnectionCacheImpl;
    }

    public void run() {
        long l2 = 0L;
        long l3 = 0L;
        boolean bl2 = true;
        try {
            while (bl2) {
                l2 = this.occi.getCacheTimeToLiveTimeout();
                if (l2 > 0L) {
                    this.runTimeToLiveTimeOut(l2);
                }
                if ((l3 = this.occi.getCacheInactivityTimeout()) > 0L) {
                    this.runInactivityTimeOut(l3);
                }
                Thread.sleep(this.occi.getThreadWakeUpInterval() * 1000L);
                if (this.occi.cache != null && (l2 > 0L || l3 > 0L)) continue;
                bl2 = false;
            }
        }
        catch (SQLException sQLException) {
        }
        catch (InterruptedException interruptedException) {}
    }

    public void runInactivityTimeOut(long l2) throws SQLException {
        long l3 = 0L;
        long l4 = 0L;
        long l5 = l2 * 1000L;
        OraclePooledConnection oraclePooledConnection = null;
        try {
            if (this.occi.cache != null && this.occi.cache.size() > 0 && this.occi.cacheSize > this.occi._MIN_LIMIT) {
                Enumeration enumeration = this.occi.cache.elements();
                while (this.occi.cacheSize > this.occi._MIN_LIMIT && enumeration.hasMoreElements()) {
                    oraclePooledConnection = (OraclePooledConnection)enumeration.nextElement();
                    l3 = oraclePooledConnection.getLastAccessedTime();
                    l4 = System.currentTimeMillis();
                    if (l4 - l3 <= l5) continue;
                    try {
                        this.occi.closeSingleConnection(oraclePooledConnection, false);
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {}
    }

    public void runTimeToLiveTimeOut(long l2) throws SQLException {
        long l3 = 0L;
        long l4 = 0L;
        int n2 = 0;
        PooledConnection pooledConnection = null;
        n2 = this.occi.getActiveSize();
        if (n2 > 0) {
            Enumeration enumeration = this.occi.activeCache.keys();
            while (enumeration.hasMoreElements()) {
                pooledConnection = (PooledConnection)enumeration.nextElement();
                Connection connection = ((OraclePooledConnection)pooledConnection).getLogicalHandle();
                if (connection != null) {
                    l4 = ((OracleConnection)connection).getStartTime();
                }
                if ((l3 = System.currentTimeMillis()) - l4 <= l2 * 1000L) continue;
                try {
                    ((OracleConnection)connection).cancel();
                }
                catch (SQLException sQLException) {}
                try {
                    if (!connection.getAutoCommit()) {
                        ((OracleConnection)connection).rollback();
                    }
                }
                catch (SQLException sQLException) {}
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }
}

