/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.jdbc.oracore.Util;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMP;

public class OracleTypeDATE
extends OracleType
implements Serializable {
    static final long serialVersionUID = -5858803341118747965L;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:37_PDT_2005";

    public OracleTypeDATE() {
    }

    public OracleTypeDATE(int n2) {
        super(n2);
    }

    public int getAlignLDS(byte[] byArray) {
        if (this.sizeForLds == 0) {
            this.sizeForLds = Util.fdoGetSize(byArray, 11);
            this.alignForLds = Util.fdoGetAlign(byArray, 11);
        }
        return this.alignForLds;
    }

    public int getSizeLDS(byte[] byArray) {
        if (this.sizeForLds == 0) {
            this.sizeForLds = Util.fdoGetSize(byArray, 11);
            this.alignForLds = Util.fdoGetAlign(byArray, 11);
        }
        return this.sizeForLds;
    }

    public int getTypeCode() {
        return 91;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        DATE dATE;
        block4: {
            dATE = null;
            if (object == null) break block4;
            try {
                if (object instanceof DATE) {
                    dATE = (DATE)object;
                    break block4;
                }
                if (object instanceof TIMESTAMP) {
                    dATE = new DATE(((TIMESTAMP)object).timestampValue());
                    break block4;
                }
                dATE = new DATE(object);
            }
            catch (SQLException sQLException) {
                DatabaseError.throwSqlException(59, object);
            }
        }
        return dATE;
    }

    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection, long l2, int n2) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof char[][]) {
                char[][] cArray = (char[][])object;
                int n3 = (int)(n2 == -1 ? (long)cArray.length : Math.min((long)cArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n3];
                int n4 = 0;
                while (n4 < n3) {
                    datumArray[n4] = this.toDatum(new String(cArray[(int)l2 + n4 - 1]), oracleConnection);
                    ++n4;
                }
            } else {
                if (object instanceof Object[]) {
                    return super.toDatumArray(object, oracleConnection, l2, n2);
                }
                DatabaseError.throwSqlException(59, object);
            }
        }
        return datumArray;
    }

    protected Object toObject(byte[] byArray, int n2, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        if (n2 == 1) {
            return new DATE(byArray);
        }
        if (n2 == 2) {
            return DATE.toTimestamp(byArray);
        }
        if (n2 == 3) {
            return byArray;
        }
        DatabaseError.throwSqlException(59, byArray);
        return null;
    }

    protected Object unpickle80rec(UnpickleContext unpickleContext, int n2, int n3, Map map) throws SQLException {
        switch (n2) {
            case 1: {
                if (unpickleContext.isNull(this.nullOffset)) {
                    return null;
                }
                unpickleContext.skipTo(unpickleContext.ldsOffsets[this.ldsOffset]);
                break;
            }
            case 2: {
                if ((unpickleContext.readByte() & 1) != 1) break;
                unpickleContext.skipBytes(8);
                return null;
            }
            default: {
                DatabaseError.throwSqlException(1, "format=" + n2);
            }
            case 3: 
        }
        if (n3 == 9) {
            unpickleContext.skipBytes(8);
            return null;
        }
        byte[] byArray = unpickleContext.image();
        int n4 = unpickleContext.absoluteOffset();
        byte[] byArray2 = new byte[7];
        int n5 = unpickleContext.bigEndian ? (byArray[n4] & 0xFF) * 256 + (byArray[n4 + 1] & 0xFF) : (byArray[n4 + 1] & 0xFF) * 256 + (byArray[n4] & 0xFF);
        if (n5 < 0) {
            byArray2[0] = (byte)(100 - -n5 / 100);
            byArray2[1] = (byte)(100 - -n5 % 100);
        } else {
            byArray2[0] = (byte)(n5 / 100 + 100);
            byArray2[1] = (byte)(n5 % 100 + 100);
        }
        byArray2[2] = byArray[n4 + 2];
        byArray2[3] = byArray[n4 + 3];
        byArray2[4] = (byte)(byArray[n4 + 4] + 1);
        byArray2[5] = (byte)(byArray[n4 + 5] + 1);
        byArray2[6] = (byte)(byArray[n4 + 6] + 1);
        unpickleContext.skipBytes(8);
        return this.toObject(byArray2, n3, map);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }
}

