/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeFLOAT;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.OracleTypeSINT32;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.TDSReader;
import oracle.jdbc.oracore.TypeTreeElement;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.SQLName;
import oracle.sql.StructDescriptor;

public class OracleTypeCOLLECTION
extends OracleTypeADT
implements Serializable {
    static final long serialVersionUID = -7279638692691669378L;
    public static final int TYPE_PLSQL_INDEX_TABLE = 1;
    public static final int TYPE_NESTED_TABLE = 2;
    public static final int TYPE_VARRAY = 3;
    int userCode = 0;
    long maxSize = 0L;
    OracleType elementType = null;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:37_PDT_2005";

    public OracleTypeCOLLECTION(String string, OracleConnection oracleConnection) throws SQLException {
        super(string, (Connection)oracleConnection);
    }

    public OracleTypeCOLLECTION(OracleTypeADT oracleTypeADT, int n2, OracleConnection oracleConnection) throws SQLException {
        super(oracleTypeADT, n2, (Connection)oracleConnection);
    }

    public OracleTypeCOLLECTION(SQLName sQLName, byte[] byArray, int n2, byte[] byArray2, byte[] byArray3, OracleConnection oracleConnection, byte[] byArray4) throws SQLException {
        super(sQLName, byArray, n2, byArray2, byArray3, oracleConnection, byArray4);
    }

    public void cacheDescriptor() throws SQLException {
        this.descriptor = ArrayDescriptor.createDescriptor(this);
    }

    ArrayDescriptor createArrayDescriptor() throws SQLException {
        return new ArrayDescriptor(this, (Connection)this.connection);
    }

    ArrayDescriptor createArrayDescriptorWithItsOwnTree() throws SQLException {
        if (this.descriptor == null) {
            this.descriptor = this.sqlName == null && this.getFullName(false) == null ? new ArrayDescriptor(this, (Connection)this.connection) : ArrayDescriptor.createDescriptor(this.sqlName, (Connection)this.connection);
        }
        return (ArrayDescriptor)this.descriptor;
    }

    private long getAccessLength(long l2, long l3, int n2) throws SQLException {
        if (l3 > l2) {
            return 0L;
        }
        if (n2 < 0) {
            return l2 - l3 + 1L;
        }
        return Math.min(l2 - l3 + 1L, (long)n2);
    }

    public OracleType getAttrTypeAt(int n2) throws SQLException {
        return null;
    }

    public String getAttributeName(int n2) throws SQLException {
        DatabaseError.throwSqlException(1);
        return null;
    }

    public String getAttributeName(int n2, boolean bl2) throws SQLException {
        return this.getAttributeName(n2);
    }

    public String getAttributeType(int n2) throws SQLException {
        if (n2 != 1) {
            DatabaseError.throwSqlException(68);
        }
        if (this.sqlName == null) {
            this.getFullName();
        }
        if (this.attrTypeNames == null) {
            this.initCollElemTypeName();
        }
        return this.attrTypeNames[0];
    }

    public String getAttributeType(int n2, boolean bl2) throws SQLException {
        if (bl2) {
            return this.getAttributeType(n2);
        }
        if (n2 != 1) {
            DatabaseError.throwSqlException(68);
        }
        if (this.sqlName != null && this.attrTypeNames != null) {
            return this.attrTypeNames[0];
        }
        return null;
    }

    public OracleType getElementType() throws SQLException {
        return this.elementType;
    }

    public long getMaxLength() throws SQLException {
        return this.maxSize;
    }

    public int getNumAttrs() throws SQLException {
        return 0;
    }

    public int getTypeCode() {
        return 2003;
    }

    public int getUserCode() throws SQLException {
        return this.userCode;
    }

    public void initChildNamesRecursively(Map map) throws SQLException {
        TypeTreeElement typeTreeElement = (TypeTreeElement)map.get(this.sqlName);
        if (this.elementType != null) {
            this.elementType.setNames(typeTreeElement.getChildSchemaName(0), typeTreeElement.getChildTypeName(0));
            this.elementType.initChildNamesRecursively(map);
            this.elementType.cacheDescriptor();
        }
    }

    private synchronized void initCollElemTypeName() throws SQLException {
        Statement statement = this.connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM ALL_COLL_TYPES WHERE TYPE_NAME='" + this.sqlName.getSimpleName() + "' AND OWNER='" + this.sqlName.getSchema() + "'");
        if (resultSet.next()) {
            if (this.attrTypeNames == null) {
                this.attrTypeNames = new String[1];
            }
            this.attrTypeNames[0] = String.valueOf(resultSet.getString(2)) + "." + resultSet.getString(1);
        } else {
            DatabaseError.throwSqlException(1);
        }
        resultSet.close();
        statement.close();
    }

    public void initMetadataRecursively() throws SQLException {
        this.initMetadata(this.connection);
        if (this.elementType != null) {
            this.elementType.initMetadataRecursively();
        }
    }

    public boolean isInHierarchyOf(OracleType oracleType) throws SQLException {
        if (oracleType == null) {
            return false;
        }
        if (oracleType == this) {
            return true;
        }
        if (oracleType.getClass() != this.getClass()) {
            return false;
        }
        return oracleType.getTypeDescriptor().getName().equals(this.descriptor.getName());
    }

    public boolean isInHierarchyOf(StructDescriptor structDescriptor) throws SQLException {
        return false;
    }

    public synchronized boolean isInlineImage(byte[] byArray, int n2) throws SQLException {
        if (byArray == null) {
            return false;
        }
        if ((byArray[n2] & 0x80) > 0) {
            if (PickleContext.isCollectionImage_pctx(byArray[n2])) {
                return true;
            }
            if (PickleContext.isDegenerateImage_pctx(byArray[n2])) {
                return false;
            }
            DatabaseError.throwSqlException(1, "Image is not a collection image");
            return false;
        }
        if (byArray[n2] == 0 && byArray[n2 + 1] == 0 && byArray[n2 + 2] == 0 && byArray[n2 + 3] == 0) {
            return false;
        }
        return (byArray[n2 + 10] & 1) == 1;
    }

    public boolean isObjectType() {
        return false;
    }

    public void parseTDSrec(TDSReader tDSReader) throws SQLException {
        long l2 = tDSReader.readLong();
        this.maxSize = tDSReader.readLong();
        this.userCode = tDSReader.readByte();
        tDSReader.addSimplePatch(l2, this);
    }

    protected int pickle81(PickleContext pickleContext, Datum datum) throws SQLException {
        ARRAY aRRAY = (ARRAY)datum;
        boolean bl2 = aRRAY.hasDataSeg();
        int n2 = 0;
        int n3 = pickleContext.offset() + 2;
        if (bl2) {
            Datum[] datumArray = aRRAY.getOracleArray();
            if (this.userCode == 3 && (long)datumArray.length > this.maxSize) {
                DatabaseError.throwSqlException(71, null);
            }
            n2 += pickleContext.writeCollImageHeader(datumArray.length);
            int n4 = 0;
            while (n4 < datumArray.length) {
                n2 = datumArray[n4] == null ? (n2 += pickleContext.writeElementNull()) : (n2 += this.elementType.pickle81(pickleContext, datumArray[n4]));
                ++n4;
            }
        } else {
            n2 += pickleContext.writeCollImageHeader(aRRAY.getLocator());
        }
        pickleContext.patchImageLen(n3, n2);
        return n2;
    }

    public void printXML(PrintWriter printWriter, int n2) throws SQLException {
        int n3 = 0;
        while (n3 < n2) {
            printWriter.print("  ");
            ++n3;
        }
        printWriter.println("<OracleTypeCOLLECTION sqlName=\"" + this.sqlName + "\" " + " toid=\"" + this.toid + "\" " + ">");
        if (this.elementType != null) {
            this.elementType.printXML(printWriter, n2 + 1);
        }
        int n4 = 0;
        while (n4 < n2) {
            printWriter.print("  ");
            ++n4;
        }
        printWriter.println("</OracleTypeCOLLECTION>");
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.userCode = objectInputStream.readInt();
        this.maxSize = objectInputStream.readLong();
        this.elementType = (OracleType)objectInputStream.readObject();
    }

    public void setConnection(OracleConnection oracleConnection) throws SQLException {
        this.connection = oracleConnection;
        this.elementType.setConnection(oracleConnection);
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        if (object != null) {
            if (object instanceof ARRAY) {
                return (ARRAY)object;
            }
            ArrayDescriptor arrayDescriptor = this.createArrayDescriptor();
            return new ARRAY(arrayDescriptor, this.connection, object);
        }
        return null;
    }

    public Datum unlinearize(byte[] byArray, long l2, Datum datum, int n2, Map map) throws SQLException {
        return this.unlinearize(byArray, l2, datum, 1L, -1, n2, map);
    }

    public Datum unlinearize(byte[] byArray, long l2, Datum datum, long l3, int n2, int n3, Map map) throws SQLException {
        OracleConnection oracleConnection = this.getConnection();
        Datum datum2 = null;
        if (oracleConnection == null) {
            datum2 = this.unlinearizeInternal(byArray, l2, datum, l3, n2, n3, map);
        } else {
            OracleConnection oracleConnection2 = oracleConnection;
            synchronized (oracleConnection2) {
                datum2 = this.unlinearizeInternal(byArray, l2, datum, l3, n2, n3, map);
            }
        }
        return datum2;
    }

    public synchronized Datum unlinearizeInternal(byte[] byArray, long l2, Datum datum, long l3, int n2, int n3, Map map) throws SQLException {
        if (byArray == null) {
            return null;
        }
        if ((byArray[0] & 0x80) > 0) {
            PickleContext pickleContext = new PickleContext(byArray, l2);
            return this.unpickle81(pickleContext, (ARRAY)datum, l3, n2, 1, n3, map);
        }
        UnpickleContext unpickleContext = new UnpickleContext(byArray, (int)l2, null, null, this.bigEndian);
        return this.unpickle80(unpickleContext, (ARRAY)datum, l3, n2, 1, n3, map);
    }

    protected ARRAY unpickle80(UnpickleContext unpickleContext, ARRAY aRRAY, int n2, int n3, Map map) throws SQLException {
        return this.unpickle80(unpickleContext, aRRAY, 1L, -1, n2, n3, map);
    }

    protected ARRAY unpickle80(UnpickleContext unpickleContext, ARRAY aRRAY, long l2, int n2, int n3, int n4, Map map) throws SQLException {
        boolean bl2;
        long l3;
        ARRAY aRRAY2 = aRRAY;
        if (n3 == 3) {
            if (aRRAY2 == null) {
                ArrayDescriptor arrayDescriptor = this.createArrayDescriptor();
                aRRAY2 = new ARRAY(arrayDescriptor, null, this.connection);
            }
            aRRAY2.setImage(unpickleContext.image(), unpickleContext.absoluteOffset(), 0L);
        }
        if ((l3 = unpickleContext.readLong()) == 0L) {
            return null;
        }
        if (n3 == 9) {
            unpickleContext.skipBytes((int)l3);
            return aRRAY2;
        }
        if (n3 == 3) {
            aRRAY2.setImageLength(l3 + 4L);
            unpickleContext.skipBytes((int)l3);
            return aRRAY2;
        }
        if (aRRAY2 == null) {
            ArrayDescriptor arrayDescriptor = this.createArrayDescriptor();
            aRRAY2 = new ARRAY(arrayDescriptor, null, this.connection);
        }
        unpickleContext.skipBytes(2);
        long l4 = unpickleContext.readLong();
        byte by = unpickleContext.readByte();
        aRRAY2.setLocator(unpickleContext.readBytes((int)l4 - 1));
        boolean bl3 = bl2 = (by & 1) == 1;
        if (bl2) {
            long l5 = unpickleContext.readLong() + (long)unpickleContext.offset();
            UnpickleContext unpickleContext2 = new UnpickleContext(unpickleContext.image(), unpickleContext.absoluteOffset(), null, null, this.bigEndian);
            aRRAY2 = l2 == 1L && n2 == -1 ? (ARRAY)this.unpickle80rec(unpickleContext2, aRRAY2, n4, map) : (ARRAY)this.unpickle80rec(unpickleContext2, aRRAY2, l2, n2, n4, map);
            unpickleContext.skipTo(l5);
        }
        return aRRAY2;
    }

    protected Object unpickle80rec(UnpickleContext unpickleContext, int n2, int n3, Map map) throws SQLException {
        return this.unpickle80rec(unpickleContext, null, n3, map);
    }

    private Object unpickle80rec(UnpickleContext unpickleContext, ARRAY aRRAY, int n2, Map map) throws SQLException {
        ARRAY aRRAY2 = aRRAY;
        if (aRRAY2 == null) {
            ArrayDescriptor arrayDescriptor = this.createArrayDescriptor();
            aRRAY2 = new ARRAY(arrayDescriptor, null, this.connection);
        }
        int n3 = (int)unpickleContext.readLong();
        aRRAY2.setLength(n3);
        if (n2 == 0) {
            return aRRAY2;
        }
        byte by = unpickleContext.readByte();
        if (by != 0 && by != 2) {
            DatabaseError.throwSqlException(23, "collection flag = " + by);
        }
        int n4 = by == 0 ? 2 : 3;
        this.unpickle80rec_elems(unpickleContext, aRRAY2, 1, n3, n2, map, n4);
        return aRRAY2;
    }

    private Object unpickle80rec(UnpickleContext unpickleContext, ARRAY aRRAY, long l2, int n2, int n3, Map map) throws SQLException {
        boolean bl2;
        ARRAY aRRAY2 = aRRAY;
        if (aRRAY2 == null) {
            ArrayDescriptor arrayDescriptor = this.createArrayDescriptor();
            aRRAY2 = new ARRAY(arrayDescriptor, null, this.connection);
        }
        long l3 = unpickleContext.readLong();
        aRRAY2.setLength((int)l3);
        byte by = unpickleContext.readByte();
        if (by != 0 && by != 2) {
            DatabaseError.throwSqlException(23, "collection flag = " + by);
        }
        int n4 = by == 0 ? 2 : 3;
        int n5 = (int)this.getAccessLength(l3, l2, n2);
        boolean bl3 = bl2 = ArrayDescriptor.getCacheStyle(aRRAY2) == 1;
        if (l2 > 1L && n5 > 0) {
            if (this.elementType instanceof OracleTypeNUMBER || this.elementType instanceof OracleTypeFLOAT || this.elementType instanceof OracleTypeSINT32) {
                switch (n4) {
                    case 2: {
                        unpickleContext.skipBytes(23 * ((int)l2 - 1));
                        break;
                    }
                    case 3: {
                        unpickleContext.skipBytes(22 * ((int)l2 - 1));
                        break;
                    }
                    default: {
                        DatabaseError.throwSqlException(1);
                        break;
                    }
                }
            } else {
                long l4 = aRRAY2.getLastIndex();
                if (l4 < l2) {
                    if (l4 > 0L) {
                        unpickleContext.skipTo(aRRAY2.getLastOffset());
                    } else {
                        l4 = 1L;
                    }
                    if (bl2) {
                        long l5 = l4;
                        while (l5 < l2) {
                            aRRAY2.setIndexOffset(l5, unpickleContext.offset());
                            this.elementType.unpickle80rec(unpickleContext, n4, 9, null);
                            ++l5;
                        }
                    } else {
                        long l6 = l4;
                        while (l6 < l2) {
                            this.elementType.unpickle80rec(unpickleContext, n4, 9, null);
                            ++l6;
                        }
                    }
                } else if (l4 > l2) {
                    long l7 = aRRAY2.getOffset(l2);
                    if (l7 != -1L) {
                        unpickleContext.skipTo(l7);
                    } else if (bl2) {
                        long l8 = 1L;
                        while (l8 < l2) {
                            aRRAY2.setIndexOffset(l8, unpickleContext.offset());
                            this.elementType.unpickle80rec(unpickleContext, n4, 9, null);
                            ++l8;
                        }
                    } else {
                        int n6 = 1;
                        while ((long)n6 < l2) {
                            this.elementType.unpickle80rec(unpickleContext, n4, 9, null);
                            ++n6;
                        }
                    }
                } else {
                    unpickleContext.skipTo(aRRAY2.getLastOffset());
                }
                aRRAY2.setLastIndexOffset(l2, unpickleContext.offset());
            }
        }
        this.unpickle80rec_elems(unpickleContext, aRRAY2, (int)l2, n5, n3, map, n4);
        return aRRAY2;
    }

    private Object unpickle80rec_elems(UnpickleContext unpickleContext, ARRAY aRRAY, int n2, int n3, int n4, Map map, int n5) throws SQLException {
        boolean bl2 = ArrayDescriptor.getCacheStyle(aRRAY) == 1;
        switch (n4) {
            case 1: {
                Datum[] datumArray = new Datum[n3];
                if (bl2) {
                    int n6 = 0;
                    while (n6 < n3) {
                        aRRAY.setIndexOffset(n2 + n6, unpickleContext.offset());
                        datumArray[n6] = (Datum)this.elementType.unpickle80rec(unpickleContext, n5, n4, map);
                        ++n6;
                    }
                } else {
                    int n7 = 0;
                    while (n7 < n3) {
                        datumArray[n7] = (Datum)this.elementType.unpickle80rec(unpickleContext, n5, n4, map);
                        ++n7;
                    }
                }
                aRRAY.setDatumArray(datumArray);
                break;
            }
            case 2: {
                Object[] objectArray = ArrayDescriptor.makeJavaArray(n3, this.elementType.getTypeCode());
                if (bl2) {
                    int n8 = 0;
                    while (n8 < n3) {
                        aRRAY.setIndexOffset(n2 + n8, unpickleContext.offset());
                        objectArray[n8] = this.elementType.unpickle80rec(unpickleContext, n5, n4, map);
                        ++n8;
                    }
                } else {
                    int n9 = 0;
                    while (n9 < n3) {
                        objectArray[n9] = this.elementType.unpickle80rec(unpickleContext, n5, n4, map);
                        ++n9;
                    }
                }
                aRRAY.setObjArray(objectArray);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (this.elementType instanceof OracleTypeNUMBER || this.elementType instanceof OracleTypeFLOAT) {
                    aRRAY.setObjArray(OracleTypeNUMBER.unpickle80NativeArray(unpickleContext, 1L, n3, n4, n5));
                    break;
                }
                DatabaseError.throwSqlException(23);
                break;
            }
            default: {
                DatabaseError.throwSqlException(1);
            }
        }
        aRRAY.setLastIndexOffset(n2 + n3, unpickleContext.offset());
        return aRRAY;
    }

    ARRAY unpickle81(PickleContext pickleContext, ARRAY aRRAY, int n2, int n3, Map map) throws SQLException {
        return this.unpickle81(pickleContext, aRRAY, 1L, -1, n2, n3, map);
    }

    ARRAY unpickle81(PickleContext pickleContext, ARRAY aRRAY, long l2, int n2, int n3, int n4, Map map) throws SQLException {
        ARRAY aRRAY2 = aRRAY;
        if (aRRAY2 == null) {
            ArrayDescriptor arrayDescriptor = this.createArrayDescriptor();
            aRRAY2 = new ARRAY(arrayDescriptor, null, this.connection);
        }
        if (this.unpickle81ImgHeader(pickleContext, aRRAY2, n3, n4)) {
            if (l2 == 1L && n2 == -1) {
                this.unpickle81ImgBody(pickleContext, aRRAY2, n4, map);
            } else {
                this.unpickle81ImgBody(pickleContext, aRRAY2, l2, n2, n4, map);
            }
        }
        return aRRAY2;
    }

    void unpickle81ImgBody(PickleContext pickleContext, ARRAY aRRAY, int n2, Map map) throws SQLException {
        pickleContext.readByte();
        int n3 = pickleContext.readLength();
        aRRAY.setLength(n3);
        if (n2 == 0) {
            return;
        }
        this.unpickle81ImgBodyElements(pickleContext, aRRAY, 1, n3, n2, map);
    }

    void unpickle81ImgBody(PickleContext pickleContext, ARRAY aRRAY, long l2, int n2, int n3, Map map) throws SQLException {
        boolean bl2;
        pickleContext.readByte();
        int n4 = pickleContext.readLength();
        aRRAY.setLength(n4);
        if (n3 == 0) {
            return;
        }
        int n5 = (int)this.getAccessLength(n4, l2, n2);
        boolean bl3 = bl2 = ArrayDescriptor.getCacheStyle(aRRAY) == 1;
        if (l2 > 1L && n5 > 0) {
            long l3 = aRRAY.getLastIndex();
            if (l3 < l2) {
                if (l3 > 0L) {
                    pickleContext.skipTo(aRRAY.getLastOffset());
                } else {
                    l3 = 1L;
                }
                if (bl2) {
                    long l4 = l3;
                    while (l4 < l2) {
                        aRRAY.setIndexOffset(l4, pickleContext.offset());
                        this.elementType.unpickle81rec(pickleContext, 9, null);
                        ++l4;
                    }
                } else {
                    long l5 = l3;
                    while (l5 < l2) {
                        this.elementType.unpickle81rec(pickleContext, 9, null);
                        ++l5;
                    }
                }
            } else if (l3 > l2) {
                long l6 = aRRAY.getOffset(l2);
                if (l6 != -1L) {
                    pickleContext.skipTo(l6);
                } else if (bl2) {
                    int n6 = 1;
                    while ((long)n6 < l2) {
                        aRRAY.setIndexOffset(n6, pickleContext.offset());
                        this.elementType.unpickle81rec(pickleContext, 9, null);
                        ++n6;
                    }
                } else {
                    int n7 = 1;
                    while ((long)n7 < l2) {
                        this.elementType.unpickle81rec(pickleContext, 9, null);
                        ++n7;
                    }
                }
            } else {
                pickleContext.skipTo(aRRAY.getLastOffset());
            }
            aRRAY.setLastIndexOffset(l2, pickleContext.offset());
        }
        this.unpickle81ImgBodyElements(pickleContext, aRRAY, (int)l2, n5, n3, map);
    }

    private void unpickle81ImgBodyElements(PickleContext pickleContext, ARRAY aRRAY, int n2, int n3, int n4, Map map) throws SQLException {
        boolean bl2 = ArrayDescriptor.getCacheStyle(aRRAY) == 1;
        switch (n4) {
            case 1: {
                Datum[] datumArray = new Datum[n3];
                if (bl2) {
                    int n5 = 0;
                    while (n5 < n3) {
                        aRRAY.setIndexOffset(n2 + n5, pickleContext.offset());
                        datumArray[n5] = (Datum)this.elementType.unpickle81rec(pickleContext, n4, map);
                        ++n5;
                    }
                } else {
                    int n6 = 0;
                    while (n6 < n3) {
                        datumArray[n6] = (Datum)this.elementType.unpickle81rec(pickleContext, n4, map);
                        ++n6;
                    }
                }
                aRRAY.setDatumArray(datumArray);
                break;
            }
            case 2: {
                Object[] objectArray = ArrayDescriptor.makeJavaArray(n3, this.elementType.getTypeCode());
                if (bl2) {
                    int n7 = 0;
                    while (n7 < n3) {
                        aRRAY.setIndexOffset(n2 + n7, pickleContext.offset());
                        objectArray[n7] = this.elementType.unpickle81rec(pickleContext, n4, map);
                        ++n7;
                    }
                } else {
                    int n8 = 0;
                    while (n8 < n3) {
                        objectArray[n8] = this.elementType.unpickle81rec(pickleContext, n4, map);
                        ++n8;
                    }
                }
                aRRAY.setObjArray(objectArray);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (this.elementType instanceof OracleTypeNUMBER || this.elementType instanceof OracleTypeFLOAT) {
                    aRRAY.setObjArray(OracleTypeNUMBER.unpickle81NativeArray(pickleContext, 1L, n3, n4));
                    break;
                }
                DatabaseError.throwSqlException(23, "This feature is limited to numeric collection");
                break;
            }
            default: {
                DatabaseError.throwSqlException(68, "Invalid conversion type " + this.elementType);
            }
        }
        aRRAY.setLastIndexOffset(n2 + n3, pickleContext.offset());
    }

    boolean unpickle81ImgHeader(PickleContext pickleContext, ARRAY aRRAY, int n2, int n3) throws SQLException {
        byte by;
        boolean bl2 = true;
        if (n2 == 3) {
            aRRAY.setImage(pickleContext.image(), pickleContext.absoluteOffset(), 0L);
        }
        if (!PickleContext.is81format(by = pickleContext.readByte())) {
            DatabaseError.throwSqlException(1, "Image is not in 8.1 format");
        }
        if (!PickleContext.hasPrefix(by)) {
            DatabaseError.throwSqlException(1, "Image has no prefix segment");
        }
        if (PickleContext.isCollectionImage_pctx(by)) {
            bl2 = true;
        } else if (PickleContext.isDegenerateImage_pctx(by)) {
            bl2 = false;
        } else {
            DatabaseError.throwSqlException(1, "Image is not a collection image");
        }
        pickleContext.readByte();
        if (n2 == 9) {
            pickleContext.skipBytes(pickleContext.readLength(true) - 2);
            return false;
        }
        if (n2 == 3) {
            long l2 = pickleContext.readLength();
            aRRAY.setImageLength(l2);
            pickleContext.skipTo(aRRAY.getImageOffset() + l2);
            return false;
        }
        pickleContext.skipLength();
        int n4 = pickleContext.readLength();
        aRRAY.setPrefixFlag(pickleContext.readByte());
        if (aRRAY.isInline()) {
            pickleContext.readDataValue(n4 - 1);
        } else {
            aRRAY.setLocator(pickleContext.readDataValue(n4 - 1));
        }
        return aRRAY.isInline();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.userCode);
        objectOutputStream.writeLong(this.maxSize);
        objectOutputStream.writeObject(this.elementType);
    }
}

