/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.Serializable;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;
import java.util.TimeZone;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateTimeCommonAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMP;

class TimestampAccessor
extends DateTimeCommonAccessor {
    TimestampAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl2) throws SQLException {
        this.init(oracleStatement, 180, 180, s2, bl2);
        this.initForDataAccess(n3, n2, null);
    }

    TimestampAccessor(OracleStatement oracleStatement, int n2, boolean bl2, int n3, int n4, int n5, int n6, int n7, short s2) throws SQLException {
        this.init(oracleStatement, 180, 180, s2, false);
        this.initForDescribe(180, n2, bl2, n3, n4, n5, n6, n7, s2, null);
        this.initForDataAccess(0, n2, null);
    }

    Object getObject(int n2) throws SQLException {
        Serializable serializable = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            if (this.externalType == 0) {
                serializable = this.statement.connection.j2ee13Compliant ? this.getTimestamp(n2) : this.getTIMESTAMP(n2);
            } else {
                switch (this.externalType) {
                    case 93: {
                        return this.getTimestamp(n2);
                    }
                }
                DatabaseError.throwSqlException(4);
                return null;
            }
        }
        return serializable;
    }

    Object getObject(int n2, Map map) throws SQLException {
        return this.getObject(n2);
    }

    Datum getOracleObject(int n2) throws SQLException {
        return this.getTIMESTAMP(n2);
    }

    String getString(int n2) throws SQLException {
        String string = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            short s2 = this.rowSpaceIndicator[this.lengthIndex + n2];
            int n3 = this.columnIndex + this.byteLength * n2;
            int n4 = ((this.rowSpaceByte[n3] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n3] & 0xFF) - 100;
            int n5 = 0;
            if (s2 == 11) {
                n5 = this.oracleNanos(n3);
            }
            string = String.valueOf(n4) + "-" + this.rowSpaceByte[2 + n3] + "-" + this.rowSpaceByte[3 + n3] + "." + (this.rowSpaceByte[4 + n3] - 1) + "." + (this.rowSpaceByte[5 + n3] - 1) + ". " + (this.rowSpaceByte[6 + n3] - 1) + ". " + n5;
        }
        return string;
    }

    TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        TIMESTAMP tIMESTAMP = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            short s2 = this.rowSpaceIndicator[this.lengthIndex + n2];
            int n3 = this.columnIndex + this.byteLength * n2;
            byte[] byArray = new byte[s2];
            System.arraycopy(this.rowSpaceByte, n3, byArray, 0, s2);
            tIMESTAMP = new TIMESTAMP(byArray);
        }
        return tIMESTAMP;
    }

    Timestamp getTimestamp(int n2) throws SQLException {
        Timestamp timestamp = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            short s2 = this.rowSpaceIndicator[this.lengthIndex + n2];
            int n3 = this.columnIndex + this.byteLength * n2;
            TimeZone timeZone = this.statement.getDefaultTimeZone();
            int n4 = ((this.rowSpaceByte[n3] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n3] & 0xFF) - 100;
            if (n4 <= 0) {
                ++n4;
            }
            timestamp = new Timestamp(DateTimeCommonAccessor.getMillis(n4, this.oracleMonth(n3), this.oracleDay(n3), this.oracleTime(n3), timeZone));
            if (s2 == 11) {
                timestamp.setNanos(this.oracleNanos(n3));
            }
        }
        return timestamp;
    }

    void initForDataAccess(int n2, int n3, String string) throws SQLException {
        if (n2 != 0) {
            this.externalType = n2;
        }
        this.internalTypeMaxLength = 11;
        if (n3 > 0 && n3 < this.internalTypeMaxLength) {
            this.internalTypeMaxLength = n3;
        }
        this.byteLength = this.internalTypeMaxLength;
    }
}

