/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.ResultSetAccessor;
import oracle.jdbc.driver.T2CConnection;

class T2CResultSetAccessor
extends ResultSetAccessor {
    T2CResultSetAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl2) throws SQLException {
        super(oracleStatement, n2 * 2, s2, n3, bl2);
    }

    T2CResultSetAccessor(OracleStatement oracleStatement, int n2, boolean bl2, int n3, int n4, int n5, int n6, int n7, short s2) throws SQLException {
        super(oracleStatement, n2 * 2, bl2, n3, n4, n5, n6, n7, s2);
    }

    byte[] getBytes(int n2) throws SQLException {
        byte[] byArray = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            short s2 = this.rowSpaceIndicator[this.lengthIndex + n2];
            byte by = ((T2CConnection)this.statement.connection).byteAlign;
            int n3 = this.columnIndex + (by - 1) & ~(by - 1);
            int n4 = n3 + s2 * n2;
            byArray = new byte[s2];
            System.arraycopy(this.rowSpaceByte, n4, byArray, 0, s2);
        }
        return byArray;
    }
}

