/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.ScrollableResultSet;

class SensitiveScrollableResultSet
extends ScrollableResultSet {
    int beginLastFetchedIndex;
    int endLastFetchedIndex;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:43_PDT_2005";

    SensitiveScrollableResultSet(ScrollRsetStatement scrollRsetStatement, OracleResultSetImpl oracleResultSetImpl, int n2, int n3) throws SQLException {
        super(scrollRsetStatement, oracleResultSetImpl, n2, n3);
        int n4 = oracleResultSetImpl.getValidRows();
        if (n4 > 0) {
            this.beginLastFetchedIndex = 1;
            this.endLastFetchedIndex = n4;
        } else {
            this.beginLastFetchedIndex = 0;
            this.endLastFetchedIndex = 0;
        }
    }

    public synchronized boolean absolute(int n2) throws SQLException {
        if (super.absolute(n2)) {
            this.handle_refetch();
            return true;
        }
        return false;
    }

    public synchronized boolean first() throws SQLException {
        if (super.first()) {
            this.handle_refetch();
            return true;
        }
        return false;
    }

    private boolean handle_refetch() throws SQLException {
        if (this.currentRow >= this.beginLastFetchedIndex && this.currentRow <= this.endLastFetchedIndex || this.currentRow >= this.endLastFetchedIndex && this.currentRow <= this.beginLastFetchedIndex) {
            return false;
        }
        this.refreshRow();
        return true;
    }

    public synchronized boolean last() throws SQLException {
        if (super.last()) {
            this.handle_refetch();
            return true;
        }
        return false;
    }

    public synchronized boolean next() throws SQLException {
        if (super.next()) {
            this.handle_refetch();
            return true;
        }
        return false;
    }

    public synchronized boolean previous() throws SQLException {
        if (super.previous()) {
            this.handle_refetch();
            return true;
        }
        return false;
    }

    public synchronized void refreshRow() throws SQLException {
        if (!this.isValidRow(this.currentRow)) {
            DatabaseError.throwSqlException(11);
        }
        int n2 = this.getFetchDirection();
        int n3 = 0;
        try {
            n3 = this.refreshRowsInCache(this.currentRow, this.getFetchSize(), n2);
        }
        catch (SQLException sQLException) {
            DatabaseError.throwSqlException(sQLException, 90, "Unsupported syntax for refreshRow()");
        }
        if (n3 != 0) {
            this.beginLastFetchedIndex = this.currentRow;
            this.endLastFetchedIndex = this.currentRow + n3 - 1;
        }
    }

    public synchronized boolean relative(int n2) throws SQLException {
        if (super.relative(n2)) {
            this.handle_refetch();
            return true;
        }
        return false;
    }

    synchronized int removeRowInCache(int n2) throws SQLException {
        int n3 = super.removeRowInCache(n2);
        if (n3 != 0) {
            if (n2 >= this.beginLastFetchedIndex && n2 <= this.endLastFetchedIndex && this.beginLastFetchedIndex != this.endLastFetchedIndex) {
                --this.endLastFetchedIndex;
            } else {
                this.endLastFetchedIndex = 0;
                this.beginLastFetchedIndex = 0;
            }
        }
        return n3;
    }
}

