/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetCache;
import oracle.jdbc.driver.OracleResultSetCacheImpl;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.SQLUtil;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.UpdatableResultSet;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

class ScrollableResultSet
extends BaseResultSet {
    PhysicalConnection connection;
    OracleResultSetImpl resultSet;
    ScrollRsetStatement scrollStmt;
    ResultSetMetaData metadata;
    private int rsetType;
    private int rsetConcurency;
    private int beginColumnIndex;
    private int columnCount;
    private int wasNull;
    OracleResultSetCache rsetCache;
    int currentRow;
    private int numRowsCached;
    private boolean allRowsCached;
    private int lastRefetchSz;
    private Vector refetchRowids;
    private OraclePreparedStatement refetchStmt;
    private int usrFetchDirection;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:43_PDT_2005";

    ScrollableResultSet(ScrollRsetStatement scrollRsetStatement, OracleResultSetImpl oracleResultSetImpl, int n2, int n3) throws SQLException {
        this.connection = ((OracleStatement)scrollRsetStatement).connection;
        this.resultSet = oracleResultSetImpl;
        this.metadata = null;
        this.scrollStmt = scrollRsetStatement;
        this.rsetType = n2;
        this.rsetConcurency = n3;
        this.autoRefetch = scrollRsetStatement.getAutoRefetch();
        this.beginColumnIndex = ScrollableResultSet.needIdentifier(n2, n3) ? 1 : 0;
        this.columnCount = 0;
        this.wasNull = -1;
        this.rsetCache = scrollRsetStatement.getResultSetCache();
        if (this.rsetCache == null) {
            this.rsetCache = new OracleResultSetCacheImpl();
        } else {
            try {
                this.rsetCache.clear();
            }
            catch (IOException iOException) {
                DatabaseError.throwSqlException(iOException);
            }
        }
        this.currentRow = 0;
        this.numRowsCached = 0;
        this.allRowsCached = false;
        this.lastRefetchSz = 0;
        this.refetchRowids = null;
        this.refetchStmt = null;
        this.usrFetchDirection = 1000;
    }

    public synchronized boolean absolute(int n2) throws SQLException {
        if (n2 == 0) {
            DatabaseError.throwSqlException(68, "absolute (0)");
        }
        if (this.isEmptyResultSet()) {
            return false;
        }
        if (n2 > 0) {
            this.currentRow = n2;
        } else if (n2 < 0) {
            this.currentRow = this.getLastRow() + 1 + n2;
        }
        return this.isValidRow(this.currentRow);
    }

    public synchronized void afterLast() throws SQLException {
        if (!this.isEmptyResultSet()) {
            this.currentRow = this.getLastRow() + 1;
        }
    }

    public synchronized void beforeFirst() throws SQLException {
        if (!this.isEmptyResultSet()) {
            this.currentRow = 0;
        }
    }

    private int cacheAllRows() throws SQLException {
        while (this.resultSet.next()) {
            int n2 = 0;
            while (n2 < this.getColumnCount()) {
                this.putCachedValueAt(this.numRowsCached + 1, n2 + 1, this.resultSet.privateGetBytes(n2 + 1));
                ++n2;
            }
            ++this.numRowsCached;
        }
        this.allRowsCached = true;
        return this.numRowsCached;
    }

    private boolean cacheRowAt(int n2) throws SQLException {
        while (this.numRowsCached < n2 && this.resultSet.next()) {
            int n3 = 0;
            while (n3 < this.getColumnCount()) {
                byte[] byArray = this.resultSet.privateGetBytes(n3 + 1);
                this.putCachedValueAt(this.numRowsCached + 1, n3 + 1, byArray);
                ++n3;
            }
            ++this.numRowsCached;
        }
        if (this.numRowsCached < n2) {
            this.allRowsCached = true;
            return false;
        }
        return true;
    }

    public synchronized void close() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
        }
        if (this.refetchStmt != null) {
            this.refetchStmt.close();
        }
        if (this.scrollStmt != null) {
            this.scrollStmt.notifyCloseRset();
        }
        if (this.refetchRowids != null) {
            this.refetchRowids.removeAllElements();
        }
        this.resultSet = null;
        this.scrollStmt = null;
        this.refetchStmt = null;
        this.refetchRowids = null;
        this.metadata = null;
        this.connection = null;
        try {
            if (this.rsetCache != null) {
                this.rsetCache.clear();
                this.rsetCache.close();
            }
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
        }
        this.rsetCache = null;
    }

    public synchronized int findColumn(String string) throws SQLException {
        return this.resultSet.findColumn(string) - this.beginColumnIndex;
    }

    public synchronized boolean first() throws SQLException {
        if (this.isEmptyResultSet()) {
            return false;
        }
        this.currentRow = 1;
        return this.isValidRow(this.currentRow);
    }

    public synchronized ARRAY getARRAY(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof ARRAY) {
                return (ARRAY)datum;
            }
            DatabaseError.throwSqlException(4, "getARRAY");
        }
        return null;
    }

    public synchronized Array getArray(int n2) throws SQLException {
        return this.getARRAY(n2);
    }

    public synchronized InputStream getAsciiStream(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.asciiStreamValue();
        }
        return null;
    }

    public synchronized BFILE getBFILE(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof BFILE) {
                return (BFILE)datum;
            }
            DatabaseError.throwSqlException(4, "getBFILE");
        }
        return null;
    }

    public synchronized BLOB getBLOB(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof BLOB) {
                return (BLOB)datum;
            }
            DatabaseError.throwSqlException(4, "getBLOB");
        }
        return null;
    }

    public synchronized BFILE getBfile(int n2) throws SQLException {
        return this.getBFILE(n2);
    }

    public BigDecimal getBigDecimal(int n2) throws SQLException {
        return this.getBigDecimal(n2, 0);
    }

    public synchronized BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.bigDecimalValue();
        }
        return null;
    }

    public synchronized InputStream getBinaryStream(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.binaryStreamValue();
        }
        return null;
    }

    public synchronized Blob getBlob(int n2) throws SQLException {
        return this.getBLOB(n2);
    }

    public synchronized boolean getBoolean(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.booleanValue();
        }
        return false;
    }

    public synchronized byte getByte(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.byteValue();
        }
        return 0;
    }

    public synchronized byte[] getBytes(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof RAW) {
                return ((RAW)datum).shareBytes();
            }
            DatabaseError.throwSqlException(4, "getBytes");
        }
        return null;
    }

    public synchronized CHAR getCHAR(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof CHAR) {
                return (CHAR)datum;
            }
            DatabaseError.throwSqlException(4, "getCHAR");
        }
        return null;
    }

    public synchronized CLOB getCLOB(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof CLOB) {
                return (CLOB)datum;
            }
            DatabaseError.throwSqlException(4, "getCLOB");
        }
        return null;
    }

    private Datum getCachedDatumValueAt(int n2, int n3) throws SQLException {
        Datum datum;
        block12: {
            Object object = null;
            try {
                object = this.rsetCache.get(n2, n3);
            }
            catch (IOException iOException) {
                DatabaseError.throwSqlException(iOException);
            }
            datum = null;
            if (object == null) break block12;
            if (object instanceof Datum) {
                datum = (Datum)object;
            } else if (((byte[])object).length > 0) {
                int n4 = this.getInternalMetadata().getColumnType(n3);
                int n5 = this.getInternalMetadata().getColumnDisplaySize(n3);
                int n6 = this.scrollStmt.getMaxFieldSize();
                if (n6 > 0 && n6 < n5) {
                    n5 = n6;
                }
                String string = null;
                if (n4 == 2006 || n4 == 2002 || n4 == 2008 || n4 == 2007 || n4 == 2003) {
                    string = this.getInternalMetadata().getColumnTypeName(n3);
                }
                int n7 = SQLUtil.getInternalType(n4);
                short s2 = this.resultSet.statement.accessors[n3 - 1].formOfUse;
                datum = s2 == 2 && (n7 == 96 || n7 == 1 || n7 == 8 || n7 == 112) ? SQLUtil.makeNDatum(this.connection, (byte[])object, n7, string, s2, n5) : SQLUtil.makeDatum((OracleConnection)this.connection, (byte[])object, n7, string, n5);
                try {
                    this.rsetCache.put(n2, n3, datum);
                }
                catch (IOException iOException) {
                    DatabaseError.throwSqlException(iOException);
                }
            } else {
                try {
                    this.rsetCache.put(n2, n3, null);
                }
                catch (IOException iOException) {
                    DatabaseError.throwSqlException(iOException);
                }
            }
        }
        return datum;
    }

    private Object getCachedValueAt(int n2, int n3) throws SQLException {
        try {
            return this.rsetCache.get(n2, n3);
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
            return null;
        }
    }

    public synchronized Reader getCharacterStream(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.characterStreamValue();
        }
        return null;
    }

    public synchronized Clob getClob(int n2) throws SQLException {
        return this.getCLOB(n2);
    }

    int getColumnCount() throws SQLException {
        if (this.columnCount == 0) {
            int n2 = this.resultSet.statement.numberOfDefinePositions;
            this.columnCount = this.resultSet.statement.accessors != null && n2 > 0 ? n2 : this.getInternalMetadata().getColumnCount();
        }
        return this.columnCount;
    }

    public int getConcurrency() throws SQLException {
        return this.rsetConcurency;
    }

    public synchronized ResultSet getCursor(int n2) throws SQLException {
        DatabaseError.throwSqlException(4, "getCursor");
        return null;
    }

    public synchronized CustomDatum getCustomDatum(int n2, CustomDatumFactory customDatumFactory) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        return customDatumFactory.create(datum, 0);
    }

    public synchronized DATE getDATE(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof DATE) {
                return (DATE)datum;
            }
            DatabaseError.throwSqlException(4, "getDATE");
        }
        return null;
    }

    public synchronized Date getDate(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.dateValue();
        }
        return null;
    }

    public synchronized Date getDate(int n2, Calendar calendar) throws SQLException {
        DATE dATE = this.getDATE(n2);
        return dATE != null ? dATE.dateValue(calendar) : null;
    }

    public synchronized double getDouble(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.doubleValue();
        }
        return 0.0;
    }

    public synchronized int getFetchDirection() throws SQLException {
        return 1000;
    }

    public synchronized int getFetchSize() throws SQLException {
        return this.resultSet.getFetchSize();
    }

    int getFirstUserColumnIndex() {
        return this.beginColumnIndex;
    }

    public synchronized float getFloat(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.floatValue();
        }
        return 0.0f;
    }

    public synchronized INTERVALDS getINTERVALDS(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof INTERVALDS) {
                return (INTERVALDS)datum;
            }
            DatabaseError.throwSqlException(4, "getINTERVALDS");
        }
        return null;
    }

    public synchronized INTERVALYM getINTERVALYM(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof INTERVALYM) {
                return (INTERVALYM)datum;
            }
            DatabaseError.throwSqlException(4, "getINTERVALYM");
        }
        return null;
    }

    public synchronized int getInt(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.intValue();
        }
        return 0;
    }

    private ResultSetMetaData getInternalMetadata() throws SQLException {
        if (this.metadata == null) {
            this.metadata = this.resultSet.getMetaData();
        }
        return this.metadata;
    }

    private int getLastRow() throws SQLException {
        if (!this.allRowsCached) {
            this.cacheAllRows();
        }
        return this.numRowsCached;
    }

    public synchronized long getLong(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.longValue();
        }
        return 0L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ScrollableResultSet scrollableResultSet = this;
            synchronized (scrollableResultSet) {
                return new OracleResultSetMetaData(this.connection, (OracleStatement)this.scrollStmt, this.beginColumnIndex);
            }
        }
    }

    public synchronized NUMBER getNUMBER(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof NUMBER) {
                return (NUMBER)datum;
            }
            DatabaseError.throwSqlException(4, "getNUMBER");
        }
        return null;
    }

    public synchronized OPAQUE getOPAQUE(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof OPAQUE) {
                return (OPAQUE)datum;
            }
            DatabaseError.throwSqlException(4, "getOPAQUE");
        }
        return null;
    }

    public synchronized ORAData getORAData(int n2, ORADataFactory oRADataFactory) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        return oRADataFactory.create(datum, 0);
    }

    public synchronized Object getObject(int n2) throws SQLException {
        return this.getObject(n2, this.connection.getTypeMap());
    }

    public synchronized Object getObject(int n2, Map map) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof STRUCT) {
                return ((STRUCT)datum).toJdbc(map);
            }
            return datum.toJdbc();
        }
        return null;
    }

    public synchronized Datum getOracleObject(int n2) throws SQLException {
        Datum datum;
        this.wasNull = -1;
        if (!this.isValidRow(this.currentRow)) {
            DatabaseError.throwSqlException(11);
        }
        if (n2 < 1 || n2 > this.getColumnCount()) {
            DatabaseError.throwSqlException(3);
        }
        this.wasNull = (datum = this.getCachedDatumValueAt(this.currentRow, n2 + this.beginColumnIndex)) == null ? 1 : 0;
        return datum;
    }

    public synchronized RAW getRAW(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof RAW) {
                return (RAW)datum;
            }
            DatabaseError.throwSqlException(4, "getRAW");
        }
        return null;
    }

    public synchronized REF getREF(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof REF) {
                return (REF)datum;
            }
            DatabaseError.throwSqlException(4, "getREF");
        }
        return null;
    }

    public synchronized ROWID getROWID(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof ROWID) {
                return (ROWID)datum;
            }
            DatabaseError.throwSqlException(4, "getROWID");
        }
        return null;
    }

    public synchronized Ref getRef(int n2) throws SQLException {
        return this.getREF(n2);
    }

    synchronized ResultSet getResultSet() {
        return this.resultSet;
    }

    public synchronized int getRow() throws SQLException {
        if (this.isValidRow(this.currentRow)) {
            return this.currentRow;
        }
        return 0;
    }

    public synchronized STRUCT getSTRUCT(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof STRUCT) {
                return (STRUCT)datum;
            }
            DatabaseError.throwSqlException(4, "getSTRUCT");
        }
        return null;
    }

    public synchronized short getShort(int n2) throws SQLException {
        long l2 = this.getLong(n2);
        if (l2 > 65537L || l2 < -65538L) {
            DatabaseError.throwSqlException(26, "getShort");
        }
        return (short)l2;
    }

    public synchronized Statement getStatement() throws SQLException {
        return (Statement)((Object)this.scrollStmt);
    }

    public synchronized String getString(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.stringValue();
        }
        return null;
    }

    public synchronized TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof TIMESTAMP) {
                return (TIMESTAMP)datum;
            }
            DatabaseError.throwSqlException(4, "getTIMESTAMP");
        }
        return null;
    }

    public synchronized TIMESTAMPLTZ getTIMESTAMPLTZ(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof TIMESTAMPLTZ) {
                return (TIMESTAMPLTZ)datum;
            }
            DatabaseError.throwSqlException(4, "getTIMESTAMPLTZ");
        }
        return null;
    }

    public synchronized TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof TIMESTAMPTZ) {
                return (TIMESTAMPTZ)datum;
            }
            DatabaseError.throwSqlException(4, "getTIMESTAMPTZ");
        }
        return null;
    }

    public synchronized Time getTime(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.timeValue();
        }
        return null;
    }

    public synchronized Time getTime(int n2, Calendar calendar) throws SQLException {
        DATE dATE = this.getDATE(n2);
        return dATE != null ? dATE.timeValue(calendar) : null;
    }

    public synchronized Timestamp getTimestamp(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.timestampValue();
        }
        return null;
    }

    public synchronized Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        DATE dATE = this.getDATE(n2);
        return dATE != null ? dATE.timestampValue(calendar) : null;
    }

    public int getType() throws SQLException {
        return this.rsetType;
    }

    public synchronized URL getURL(int n2) throws SQLException {
        URL uRL = null;
        int n3 = this.getInternalMetadata().getColumnType(n2);
        int n4 = SQLUtil.getInternalType(n3);
        if (n4 == 96 || n4 == 1 || n4 == 8) {
            try {
                uRL = new URL(this.getString(n2));
            }
            catch (MalformedURLException malformedURLException) {
                DatabaseError.throwSqlException(136);
            }
        } else {
            throw new SQLException("Conversion to java.net.URL not supported.");
        }
        return uRL;
    }

    public synchronized InputStream getUnicodeStream(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            DBConversion dBConversion = this.connection.conversion;
            byte[] byArray = datum.shareBytes();
            if (datum instanceof RAW) {
                return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 3);
            }
            if (datum instanceof CHAR) {
                return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 1);
            }
            DatabaseError.throwSqlException(4, "getUnicodeStream");
        }
        return null;
    }

    private int get_refetch_size(int n2, int n3, int n4) throws SQLException {
        int n5 = n4 == 1001 ? -1 : 1;
        int n6 = 0;
        if (this.refetchRowids == null) {
            this.refetchRowids = new Vector(10);
        } else {
            this.refetchRowids.removeAllElements();
        }
        while (n6 < n3 && this.isValidRow(n2 + n6 * n5)) {
            this.refetchRowids.addElement(this.getCachedDatumValueAt(n2 + n6 * n5, 1));
            ++n6;
        }
        return n6;
    }

    public synchronized boolean isAfterLast() throws SQLException {
        return !this.isEmptyResultSet() && this.currentRow > 0 && !this.isValidRow(this.currentRow);
    }

    public synchronized boolean isBeforeFirst() throws SQLException {
        return !this.isEmptyResultSet() && this.currentRow < 1;
    }

    private boolean isEmptyResultSet() throws SQLException {
        if (this.numRowsCached != 0) {
            return false;
        }
        if (this.numRowsCached == 0 && this.allRowsCached) {
            return true;
        }
        return this.isValidRow(1) ^ true;
    }

    public synchronized boolean isFirst() throws SQLException {
        return this.currentRow == 1;
    }

    public synchronized boolean isLast() throws SQLException {
        return !this.isEmptyResultSet() && this.isValidRow(this.currentRow) && !this.isValidRow(this.currentRow + 1);
    }

    boolean isValidRow(int n2) throws SQLException {
        if (n2 > 0 && n2 <= this.numRowsCached) {
            return true;
        }
        if (n2 <= 0) {
            return false;
        }
        return this.cacheRowAt(n2);
    }

    public synchronized boolean last() throws SQLException {
        if (this.isEmptyResultSet()) {
            return false;
        }
        this.currentRow = this.getLastRow();
        return this.isValidRow(this.currentRow);
    }

    public static boolean needCache(int n2, int n3) {
        return n2 != 1003 && (n2 != 1004 || n3 != 1007);
    }

    public static boolean needIdentifier(int n2, int n3) {
        return (n2 != 1003 || n3 != 1007) && (n2 != 1004 || n3 != 1007);
    }

    public synchronized boolean next() throws SQLException {
        if (this.isEmptyResultSet()) {
            return false;
        }
        this.currentRow = this.currentRow < 1 ? 1 : ++this.currentRow;
        return this.isValidRow(this.currentRow);
    }

    private void prepare_refetch_binds(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
        int n3 = this.scrollStmt.copyBinds(oraclePreparedStatement, 0);
        int n4 = 0;
        while (n4 < n2) {
            oraclePreparedStatement.setROWID(n3 + n4 + 1, (ROWID)this.refetchRowids.elementAt(n4));
            ++n4;
        }
    }

    private OraclePreparedStatement prepare_refetch_statement(int n2) throws SQLException {
        if (n2 < 1) {
            DatabaseError.throwSqlException(68);
        }
        return (OraclePreparedStatement)this.connection.prepareStatement(((OracleStatement)this.scrollStmt).sqlObject.getRefetchSqlForScrollableResultSet(this, n2));
    }

    public synchronized boolean previous() throws SQLException {
        if (this.isEmptyResultSet()) {
            return false;
        }
        this.currentRow = this.isAfterLast() ? this.getLastRow() : --this.currentRow;
        return this.isValidRow(this.currentRow);
    }

    private void putCachedValueAt(int n2, int n3, Object object) throws SQLException {
        try {
            this.rsetCache.put(n2, n3, object);
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
        }
    }

    public void refreshRow() throws SQLException {
        if (!ScrollableResultSet.needIdentifier(this.rsetType, this.rsetConcurency)) {
            DatabaseError.throwSqlException(23, "refreshRow");
        }
        if (this.isValidRow(this.currentRow)) {
            int n2 = this.getFetchDirection();
            try {
                this.refreshRowsInCache(this.currentRow, this.getFetchSize(), n2);
            }
            catch (SQLException sQLException) {
                DatabaseError.throwSqlException(sQLException, 90, "Unsupported syntax for refreshRow()");
            }
        } else {
            DatabaseError.throwSqlException(82, "refreshRow");
        }
    }

    synchronized int refreshRowsInCache(int n2, int n3, int n4) throws SQLException {
        int n5;
        OracleResultSet oracleResultSet;
        block6: {
            oracleResultSet = null;
            n5 = 0;
            n5 = this.get_refetch_size(n2, n3, n4);
            try {
                if (n5 <= 0) break block6;
                if (n5 != this.lastRefetchSz) {
                    if (this.refetchStmt != null) {
                        this.refetchStmt.close();
                    }
                    this.refetchStmt = this.prepare_refetch_statement(n5);
                    this.refetchStmt.setQueryTimeout(((OracleStatement)this.scrollStmt).getQueryTimeout());
                    this.lastRefetchSz = n5;
                }
                this.prepare_refetch_binds(this.refetchStmt, n5);
                oracleResultSet = (OracleResultSet)this.refetchStmt.executeQuery();
                this.save_refetch_results(oracleResultSet, n2, n5, n4);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (oracleResultSet != null) {
                    oracleResultSet.close();
                }
                throw throwable;
            }
        }
        Object var7_6 = null;
        if (oracleResultSet != null) {
            oracleResultSet.close();
        }
        return n5;
    }

    public synchronized boolean relative(int n2) throws SQLException {
        if (this.isEmptyResultSet()) {
            return false;
        }
        if (this.isValidRow(this.currentRow)) {
            this.currentRow += n2;
            return this.isValidRow(this.currentRow);
        }
        DatabaseError.throwSqlException(82, "relative");
        return false;
    }

    private void removeCachedRowAt(int n2) throws SQLException {
        try {
            this.rsetCache.remove(n2);
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
        }
    }

    synchronized int removeRowInCache(int n2) throws SQLException {
        if (!this.isEmptyResultSet() && this.isValidRow(n2)) {
            this.removeCachedRowAt(n2);
            --this.numRowsCached;
            if (n2 >= this.currentRow) {
                --this.currentRow;
            }
            return 1;
        }
        return 0;
    }

    synchronized void resetBeginColumnIndex() {
        this.beginColumnIndex = 0;
    }

    private void save_refetch_results(OracleResultSet oracleResultSet, int n2, int n3, int n4) throws SQLException {
        int n5 = n4 == 1001 ? -1 : 1;
        while (oracleResultSet.next()) {
            ROWID rOWID = oracleResultSet.getROWID(1);
            boolean bl2 = false;
            int n6 = n2;
            while (!bl2 && n6 < n2 + n3 * n5) {
                if (((ROWID)this.getCachedDatumValueAt(n6, 1)).stringValue().equals(rOWID.stringValue())) {
                    bl2 = true;
                    continue;
                }
                n6 += n5;
            }
            if (!bl2) continue;
            int n7 = 0;
            while (n7 < this.getColumnCount()) {
                this.putCachedValueAt(n6, n7 + 1, oracleResultSet.getOracleObject(n7 + 1));
                ++n7;
            }
        }
    }

    public void setCurrentRowValueAt(Object object, int n2, Object object2) throws SQLException {
        if (object instanceof UpdatableResultSet) {
            this.putCachedValueAt(this.currentRow, n2, object2);
        } else {
            DatabaseError.throwSqlException(1);
        }
    }

    public synchronized void setFetchDirection(int n2) throws SQLException {
        if (n2 == 1000) {
            this.usrFetchDirection = n2;
        } else if (n2 == 1001 || n2 == 1002) {
            this.usrFetchDirection = n2;
            this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 87);
        } else {
            DatabaseError.throwSqlException(68, "setFetchDirection");
        }
    }

    public synchronized void setFetchSize(int n2) throws SQLException {
        this.resultSet.setFetchSize(n2);
    }

    public static boolean supportRefreshRow(int n2, int n3) {
        return n2 != 1003 && (n2 != 1004 || n3 != 1007);
    }

    public synchronized boolean wasNull() throws SQLException {
        if (this.wasNull == -1) {
            DatabaseError.throwSqlException(24);
        }
        return this.wasNull == 1;
    }
}

