/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleSqlReadOnly;
import oracle.jdbc.driver.ScrollableResultSet;
import oracle.jdbc.driver.UpdatableResultSet;

public class OracleSql {
    static final int UNINITIALIZED = -1;
    static final String[] EMPTY_LIST = new String[0];
    DBConversion conversion;
    String originalSql;
    String parameterSql;
    String utickSql;
    String processedSql;
    String rowidSql;
    String actualSql;
    byte[] sqlBytes;
    byte sqlKind = (byte)-1;
    int parameterCount = -1;
    boolean currentConvertNcharLiterals = true;
    boolean currentProcessEscapes = true;
    boolean includeRowid = false;
    String[] parameterList = EMPTY_LIST;
    char[] currentParameter = null;
    boolean isV8Compatible = false;
    int bindParameterCount = -1;
    String[] bindParameterList = null;
    int cachedBindParameterCount = -1;
    String[] cachedBindParameterList = null;
    String cachedParameterSql;
    String cachedUtickSql;
    String cachedProcessedSql;
    String cachedRowidSql;
    String cachedActualSql;
    byte[] cachedSqlBytes;
    int selectEndIndex = -1;
    int orderByStartIndex = -1;
    int orderByEndIndex = -1;
    int whereStartIndex = -1;
    int whereEndIndex = -1;
    int forUpdateStartIndex = -1;
    int forUpdateEndIndex = -1;
    final int[] ncharLiteralLocation = new int[513];
    int lastNcharLiteralLocation = -1;
    static final String paramPrefix = "rowid";
    int paramSuffix = 0;
    StringBuffer stringBufferForScrollableStatement = null;
    private static final int cMax = 127;
    private static final int[][] TRANSITION = OracleSqlReadOnly.TRANSITION;
    private static final int[][] ACTION = OracleSqlReadOnly.ACTION;
    private static final int NO_ACTION = 0;
    private static final int DML_ACTION = 1;
    private static final int PLSQL_ACTION = 2;
    private static final int CALL_ACTION = 3;
    private static final int SELECT_ACTION = 4;
    private static final int ORDER_ACTION = 7;
    private static final int ORDER_BY_ACTION = 8;
    private static final int WHERE_ACTION = 6;
    private static final int FOR_ACTION = 9;
    private static final int FOR_UPDATE_ACTION = 10;
    private static final int OTHER_ACTION = 5;
    private static final int QUESTION_ACTION = 11;
    private static final int PARAMETER_ACTION = 12;
    private static final int END_PARAMETER_ACTION = 13;
    private static final int START_NCHAR_LITERAL_ACTION = 14;
    private static final int END_NCHAR_LITERAL_ACTION = 15;
    int current_argument;
    int i;
    int length;
    char c;
    boolean first;
    boolean in_string;
    String odbc_sql;
    StringBuffer oracle_sql;
    StringBuffer token_buffer;
    boolean isLocate = false;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:41_PDT_2005";

    OracleSql(DBConversion dBConversion) {
        this.conversion = dBConversion;
    }

    private String addRowid(String string) throws SQLException {
        if (this.selectEndIndex == -1) {
            DatabaseError.throwSqlException(88);
        }
        String string2 = "select rowid," + string.substring(this.selectEndIndex);
        return string2;
    }

    void appendChar(StringBuffer stringBuffer, char c2) {
        if (c2 == '?') {
            stringBuffer.append(this.nextArgument());
        } else {
            stringBuffer.append(c2);
        }
    }

    void appendForUpdate(StringBuffer stringBuffer) throws SQLException {
        if (this.orderByStartIndex != -1 && (this.forUpdateStartIndex == -1 || this.forUpdateStartIndex > this.orderByStartIndex)) {
            stringBuffer.append(this.originalSql.substring(this.orderByStartIndex));
        } else if (this.forUpdateStartIndex != -1) {
            stringBuffer.append(this.originalSql.substring(this.forUpdateStartIndex));
        }
    }

    void computeBasicInfo(String string) throws SQLException {
        this.parameterCount = 0;
        this.lastNcharLiteralLocation = 0;
        this.ncharLiteralLocation[this.lastNcharLiteralLocation++] = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        int n5 = -1;
        int n6 = -1;
        int n7 = n4 + 1;
        int n8 = 0;
        while (n8 < n7) {
            int n9;
            int n10 = n9 = n8 < n4 ? (int)string.charAt(n8) : 32;
            if (n9 > 127) {
                n10 = Character.isLetterOrDigit((char)n9) ? 88 : 32;
            }
            switch (ACTION[n3][n10]) {
                case 1: {
                    this.sqlKind = (byte)2;
                    break;
                }
                case 2: {
                    this.sqlKind = 1;
                    break;
                }
                case 3: {
                    this.sqlKind = (byte)4;
                    break;
                }
                case 4: {
                    this.sqlKind = 0;
                    this.selectEndIndex = n8;
                    break;
                }
                case 5: {
                    this.sqlKind = (byte)3;
                    break;
                }
                case 6: {
                    this.whereStartIndex = n8 - 5;
                    this.whereEndIndex = n8;
                    break;
                }
                case 7: {
                    n5 = n8 - 5;
                    break;
                }
                case 8: {
                    this.orderByStartIndex = n5;
                    this.orderByEndIndex = n8;
                    break;
                }
                case 9: {
                    n6 = n8 - 3;
                    break;
                }
                case 10: {
                    this.forUpdateStartIndex = n6;
                    this.forUpdateEndIndex = n8;
                    break;
                }
                case 11: {
                    ++this.parameterCount;
                    break;
                }
                case 12: {
                    if (this.currentParameter == null) {
                        this.currentParameter = new char[32];
                    }
                    if (n2 >= this.currentParameter.length) {
                        DatabaseError.throwSqlException(134, new String(this.currentParameter));
                    }
                    this.currentParameter[n2++] = n9;
                    break;
                }
                case 13: {
                    if (n2 <= 0) break;
                    if (this.parameterList == EMPTY_LIST) {
                        this.parameterList = new String[8];
                    } else if (this.parameterList.length <= this.parameterCount) {
                        String[] stringArray = new String[this.parameterList.length * 4];
                        System.arraycopy(this.parameterList, 0, stringArray, 0, this.parameterList.length);
                        this.parameterList = stringArray;
                    }
                    this.parameterList[this.parameterCount] = new String(this.currentParameter, 0, n2).intern();
                    n2 = 0;
                    ++this.parameterCount;
                    break;
                }
                case 14: {
                    this.ncharLiteralLocation[this.lastNcharLiteralLocation++] = n8 - 1;
                    break;
                }
                case 15: {
                    this.ncharLiteralLocation[this.lastNcharLiteralLocation++] = n8 + 1;
                    break;
                }
            }
            n3 = TRANSITION[n3][n10];
            ++n8;
        }
        this.ncharLiteralLocation[this.lastNcharLiteralLocation++] = n4;
        this.ncharLiteralLocation[this.lastNcharLiteralLocation] = n4;
    }

    String convertNcharLiterals(String string) throws SQLException {
        if (this.lastNcharLiteralLocation <= 2) {
            return string;
        }
        String string2 = "";
        int n2 = 0;
        block0: while (true) {
            int n3 = this.ncharLiteralLocation[n2++];
            int n4 = this.ncharLiteralLocation[n2++];
            string2 = String.valueOf(string2) + string.substring(n3, n4);
            if (n2 >= this.lastNcharLiteralLocation) break;
            n3 = this.ncharLiteralLocation[n2];
            string2 = String.valueOf(string2) + "u'";
            int n5 = n4 + 2;
            while (true) {
                if (n5 >= n3) continue block0;
                char c2 = string.charAt(n5);
                string2 = c2 == '\\' ? String.valueOf(string2) + "\\\\" : (c2 < '\u0080' ? String.valueOf(string2) + c2 : String.valueOf(string2) + this.hexUnicode(c2));
                ++n5;
            }
            break;
        }
        return string2;
    }

    String generateParameterName() {
        String string;
        if (this.parameterCount == 0 || this.parameterList == null) {
            return paramPrefix + this.paramSuffix++;
        }
        block0: while (true) {
            string = paramPrefix + this.paramSuffix++;
            int n2 = 0;
            while (n2 < this.parameterList.length) {
                if (string.equals(this.parameterList[n2])) continue block0;
                ++n2;
            }
            break;
        }
        return string;
    }

    String getDeleteSqlForUpdatableResultSet(UpdatableResultSet updatableResultSet) throws SQLException {
        String string = this.getRevisedSql();
        if (this.stringBufferForScrollableStatement == null) {
            this.stringBufferForScrollableStatement = new StringBuffer(string.length() + 100);
        } else {
            this.stringBufferForScrollableStatement.delete(0, this.stringBufferForScrollableStatement.length());
        }
        this.stringBufferForScrollableStatement.append("delete from (");
        this.stringBufferForScrollableStatement.append(string);
        this.stringBufferForScrollableStatement.append(") where ");
        this.stringBufferForScrollableStatement.append(" ROWID = :" + this.generateParameterName());
        return this.stringBufferForScrollableStatement.substring(0, this.stringBufferForScrollableStatement.length());
    }

    String getInsertSqlForUpdatableResultSet(UpdatableResultSet updatableResultSet) throws SQLException {
        String string = this.getOriginalSql();
        if (this.stringBufferForScrollableStatement == null) {
            this.stringBufferForScrollableStatement = new StringBuffer(string.length() + 100);
        } else {
            this.stringBufferForScrollableStatement.delete(0, this.stringBufferForScrollableStatement.length());
        }
        this.stringBufferForScrollableStatement.append("insert into (");
        this.stringBufferForScrollableStatement.append(this.removeForUpdate(string));
        this.stringBufferForScrollableStatement.append(") values ( ");
        int n2 = 1;
        while (n2 < updatableResultSet.getColumnCount()) {
            if (n2 != 1) {
                this.stringBufferForScrollableStatement.append(", ");
            }
            this.stringBufferForScrollableStatement.append(":" + this.generateParameterName());
            ++n2;
        }
        this.stringBufferForScrollableStatement.append(")");
        return this.stringBufferForScrollableStatement.substring(0, this.stringBufferForScrollableStatement.length());
    }

    String getOriginalSql() {
        return this.originalSql;
    }

    int getParameterCount() throws SQLException {
        if (this.parameterCount == -1) {
            this.computeBasicInfo(this.parameterSql);
        }
        return this.parameterCount;
    }

    String[] getParameterList() throws SQLException {
        if (this.parameterCount == -1) {
            this.computeBasicInfo(this.parameterSql);
        }
        return this.parameterList;
    }

    String getRefetchSqlForScrollableResultSet(ScrollableResultSet scrollableResultSet, int n2) throws SQLException {
        String string = this.getRevisedSql();
        if (this.stringBufferForScrollableStatement == null) {
            this.stringBufferForScrollableStatement = new StringBuffer(string.length() + 100);
        } else {
            this.stringBufferForScrollableStatement.delete(0, this.stringBufferForScrollableStatement.length());
        }
        this.stringBufferForScrollableStatement.append(string);
        this.stringBufferForScrollableStatement.append(this.whereStartIndex != -1 ? " AND ( ROWID = :" + this.generateParameterName() : " WHERE ( ROWID = :" + this.generateParameterName());
        int n3 = 0;
        while (n3 < n2 - 1) {
            this.stringBufferForScrollableStatement.append(" OR ROWID = :" + this.generateParameterName());
            ++n3;
        }
        this.stringBufferForScrollableStatement.append(" ) ");
        this.appendForUpdate(this.stringBufferForScrollableStatement);
        return this.stringBufferForScrollableStatement.substring(0, this.stringBufferForScrollableStatement.length());
    }

    String getRevisedSql() throws SQLException {
        String string = this.originalSql;
        if (this.sqlKind == -1) {
            this.computeBasicInfo(this.parameterSql);
        }
        string = this.removeForUpdate(string);
        return this.addRowid(string);
    }

    String getSql(boolean bl2, boolean bl3) throws SQLException {
        if (this.sqlKind == -1) {
            this.computeBasicInfo(this.parameterSql);
        }
        if (bl2 != this.currentProcessEscapes || bl3 != this.currentConvertNcharLiterals) {
            if (bl3 != this.currentConvertNcharLiterals) {
                this.utickSql = null;
            }
            this.processedSql = null;
            this.rowidSql = null;
            this.actualSql = null;
            this.sqlBytes = null;
        }
        this.currentConvertNcharLiterals = bl3;
        this.currentProcessEscapes = bl2;
        if (this.actualSql == null) {
            if (this.utickSql == null) {
                String string = this.utickSql = this.currentConvertNcharLiterals ? this.convertNcharLiterals(this.parameterSql) : this.parameterSql;
            }
            if (this.processedSql == null) {
                String string = this.processedSql = this.currentProcessEscapes ? this.parse(this.utickSql) : this.utickSql;
            }
            if (this.rowidSql == null) {
                this.rowidSql = this.includeRowid ? this.addRowid(this.processedSql) : this.processedSql;
            }
            this.actualSql = this.rowidSql;
        }
        return this.actualSql;
    }

    byte[] getSqlBytes(boolean bl2, boolean bl3) throws SQLException {
        if (this.sqlBytes == null || bl2 != this.currentProcessEscapes) {
            this.sqlBytes = this.conversion.StringToCharBytes(this.getSql(bl2, bl3));
        }
        return this.sqlBytes;
    }

    byte getSqlKind() throws SQLException {
        if (this.sqlKind == -1) {
            this.computeBasicInfo(this.parameterSql);
        }
        return this.sqlKind;
    }

    String getUpdateSqlForUpdatableResultSet(UpdatableResultSet updatableResultSet, int n2, Object[] objectArray, int[] nArray) throws SQLException {
        String string = this.getRevisedSql();
        if (this.stringBufferForScrollableStatement == null) {
            this.stringBufferForScrollableStatement = new StringBuffer(string.length() + 100);
        } else {
            this.stringBufferForScrollableStatement.delete(0, this.stringBufferForScrollableStatement.length());
        }
        this.stringBufferForScrollableStatement.append("update (");
        this.stringBufferForScrollableStatement.append(string);
        this.stringBufferForScrollableStatement.append(") set ");
        if (objectArray != null) {
            int n3 = 0;
            while (n3 < n2) {
                if (n3 > 0) {
                    this.stringBufferForScrollableStatement.append(", ");
                }
                this.stringBufferForScrollableStatement.append(updatableResultSet.getInternalMetadata().getColumnName(nArray[n3] + 1));
                this.stringBufferForScrollableStatement.append(" = :" + this.generateParameterName());
                ++n3;
            }
        }
        this.stringBufferForScrollableStatement.append(" WHERE ");
        this.stringBufferForScrollableStatement.append(" ROWID = :" + this.generateParameterName());
        return this.stringBufferForScrollableStatement.substring(0, this.stringBufferForScrollableStatement.length());
    }

    void handleCall() throws SQLException {
        boolean bl2 = this.first;
        if (bl2) {
            this.oracle_sql.append("BEGIN ");
        }
        this.skipSpace();
        this.handleODBC();
        this.skipSpace();
        if (bl2) {
            this.oracle_sql.append("; END;");
        }
    }

    void handleDate() throws SQLException {
        this.oracle_sql.append("TO_DATE (");
        this.skipSpace();
        this.handleODBC();
        this.oracle_sql.append(", 'YYYY-MM-DD')");
    }

    void handleEscape() throws SQLException {
        this.oracle_sql.append("ESCAPE ");
        this.skipSpace();
        this.handleODBC();
    }

    void handleFunction() throws SQLException {
        String string;
        boolean bl2 = this.first;
        if (bl2) {
            this.oracle_sql.append("BEGIN ");
        }
        this.appendChar(this.oracle_sql, '?');
        this.skipSpace();
        if (this.c != '=') {
            string = new String(String.valueOf(this.i) + ". Expecting \"=\" got \"" + this.c + "\"");
            DatabaseError.throwSqlException(33, string);
        }
        ++this.i;
        this.skipSpace();
        if (!this.odbc_sql.startsWith("call", this.i)) {
            string = new String(String.valueOf(this.i) + ". Expecting \"call\"");
            DatabaseError.throwSqlException(33, string);
        }
        this.i += 4;
        this.oracle_sql.append(" := ");
        this.skipSpace();
        this.handleODBC();
        if (bl2) {
            this.oracle_sql.append("; END;");
        }
    }

    void handleODBC() throws SQLException {
        StringBuffer stringBuffer = null;
        StringBuffer stringBuffer2 = null;
        boolean bl2 = false;
        while (this.i < this.length) {
            this.c = this.odbc_sql.charAt(this.i);
            if (this.in_string) {
                this.oracle_sql.append(this.c);
                if (this.c == '\'') {
                    this.in_string = false;
                }
                ++this.i;
                continue;
            }
            switch (this.c) {
                case '\'': {
                    if (this.isLocate) {
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer();
                            stringBuffer2 = new StringBuffer();
                        }
                        if (!bl2) {
                            stringBuffer.append(this.c);
                        } else {
                            stringBuffer2.append(this.c);
                        }
                        ++this.i;
                        break;
                    }
                    this.oracle_sql.append(this.c);
                    this.in_string = true;
                    ++this.i;
                    this.first = false;
                    break;
                }
                case '{': {
                    this.token_buffer.delete(0, this.token_buffer.length());
                    ++this.i;
                    this.skipSpace();
                    while (this.i < this.length && (Character.isJavaLetterOrDigit(this.c = this.odbc_sql.charAt(this.i)) || this.c == '?')) {
                        this.token_buffer.append(this.c);
                        ++this.i;
                    }
                    this.handleToken(this.token_buffer.substring(0, this.token_buffer.length()));
                    this.c = this.odbc_sql.charAt(this.i);
                    if (this.c != '}') {
                        String string = new String(String.valueOf(this.i) + ": Expecting \"}\" got \"" + this.c + "\"");
                        DatabaseError.throwSqlException(33, string);
                    }
                    ++this.i;
                    break;
                }
                case '}': {
                    return;
                }
                default: {
                    if (this.c != ' ' && this.c != '(' && this.isLocate) {
                        if (this.c == ')') {
                            if (stringBuffer2.substring(0, stringBuffer2.length()).trim().equals("?")) {
                                this.oracle_sql.append(this.nextArgument());
                            } else {
                                this.oracle_sql.append((Object)stringBuffer2);
                            }
                            this.oracle_sql.append(", ");
                            if (stringBuffer.substring(0, stringBuffer.length()).trim().equals("?")) {
                                this.oracle_sql.append(this.nextArgument());
                            } else {
                                this.oracle_sql.append((Object)stringBuffer);
                            }
                            this.appendChar(this.oracle_sql, this.c);
                            this.isLocate = false;
                        }
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer();
                            stringBuffer2 = new StringBuffer();
                        }
                        if (this.c == ',') {
                            bl2 = true;
                            ++this.i;
                            this.first = false;
                            break;
                        }
                        if (!bl2) {
                            stringBuffer.append(this.c);
                        } else {
                            stringBuffer2.append(this.c);
                        }
                    } else {
                        this.appendChar(this.oracle_sql, this.c);
                    }
                    ++this.i;
                    this.first = false;
                }
            }
        }
    }

    void handleOuterJoin() throws SQLException {
        this.oracle_sql.append(" ( ");
        this.skipSpace();
        this.handleODBC();
        this.oracle_sql.append(" ) ");
    }

    void handleScalarFunction() throws SQLException {
        this.token_buffer.delete(0, this.token_buffer.length());
        ++this.i;
        this.skipSpace();
        while (this.i < this.length && (Character.isJavaLetterOrDigit(this.c = this.odbc_sql.charAt(this.i)) || this.c == '?')) {
            this.token_buffer.append(this.c);
            ++this.i;
        }
        String string = this.token_buffer.substring(0, this.token_buffer.length()).toUpperCase().intern();
        if (string == "ABS") {
            this.usingFunctionName(string);
        } else if (string == "ACOS") {
            this.usingFunctionName(string);
        } else if (string == "ASIN") {
            this.usingFunctionName(string);
        } else if (string == "ATAN") {
            this.usingFunctionName(string);
        } else if (string == "ATAN2") {
            this.usingFunctionName(string);
        } else if (string == "CEILING") {
            this.usingFunctionName("CEIL");
        } else if (string == "COS") {
            this.usingFunctionName(string);
        } else if (string == "COT") {
            DatabaseError.throwSqlException(34, string);
        } else if (string == "DEGREES") {
            DatabaseError.throwSqlException(34, string);
        } else if (string == "EXP") {
            this.usingFunctionName(string);
        } else if (string == "FLOOR") {
            this.usingFunctionName(string);
        } else if (string == "LOG") {
            this.usingFunctionName("LN");
        } else if (string == "LOG10") {
            this.replacingFunctionPrefix("LOG ( 10, ");
        } else if (string == "MOD") {
            this.usingFunctionName(string);
        } else if (string == "PI") {
            this.replacingFunctionPrefix("( 3.141592653589793238462643383279502884197169399375 ");
        } else if (string == "POWER") {
            this.usingFunctionName(string);
        } else if (string == "RADIANS") {
            DatabaseError.throwSqlException(34, string);
        } else if (string == "RAND") {
            DatabaseError.throwSqlException(34, string);
        } else if (string == "ROUND") {
            this.usingFunctionName(string);
        } else if (string == "SIGN") {
            this.usingFunctionName(string);
        } else if (string == "SIN") {
            this.usingFunctionName(string);
        } else if (string == "SQRT") {
            this.usingFunctionName(string);
        } else if (string == "TAN") {
            this.usingFunctionName(string);
        } else if (string == "TRUNCATE") {
            this.usingFunctionName("TRUNC");
        } else if (string == "ASCII") {
            this.usingFunctionName(string);
        } else if (string == "CHAR") {
            this.usingFunctionName("CHR");
        } else if (string == "CONCAT") {
            this.usingFunctionName(string);
        } else if (string == "DIFFERENCE") {
            DatabaseError.throwSqlException(34, string);
        } else if (string == "INSERT") {
            DatabaseError.throwSqlException(34, string);
        } else if (string == "LCASE") {
            this.usingFunctionName("LOWER");
        } else if (string == "LEFT") {
            DatabaseError.throwSqlException(34, string);
        } else if (string == "LENGTH") {
            this.usingFunctionName(string);
        } else if (string == "LOCATE") {
            this.isLocate = true;
            this.usingFunctionName("INSTR");
        } else if (string == "LTRIM") {
            this.usingFunctionName(string);
        } else if (string == "REPEAT") {
            DatabaseError.throwSqlException(34, string);
        } else if (string == "REPLACE") {
            this.usingFunctionName(string);
        } else if (string == "RIGHT") {
            DatabaseError.throwSqlException(34, string);
        } else if (string == "RTRIM") {
            this.usingFunctionName(string);
        } else if (string == "SOUNDEX") {
            this.usingFunctionName(string);
        } else if (string == "SPACE") {
            DatabaseError.throwSqlException(34, string);
        } else if (string == "SUBSTRING") {
            this.usingFunctionName("SUBSTR");
        } else if (string == "UCASE") {
            this.usingFunctionName("UPPER");
        } else if (string == "CURDATE") {
            this.replacingFunctionPrefix("(CURRENT_DATE");
        } else if (string == "CURTIME") {
            this.replacingFunctionPrefix("(CURRENT_TIMESTAMP");
        } else if (string == "DAYNAME") {
            DatabaseError.throwSqlException(34, string);
        } else if (string == "DAYOFMONTH") {
            this.replacingFunctionPrefix("EXTRACT ( DAY FROM ");
        } else if (string == "DAYOFWEEK") {
            DatabaseError.throwSqlException(34, string);
        } else if (string == "DAYOFYEAR") {
            DatabaseError.throwSqlException(34, string);
        } else if (string == "HOUR") {
            this.replacingFunctionPrefix("EXTRACT ( HOUR FROM ");
        } else if (string == "MINUTE") {
            this.replacingFunctionPrefix("EXTRACT ( MINUTE FROM ");
        } else if (string == "MONTH") {
            this.replacingFunctionPrefix("EXTRACT ( MONTH FROM ");
        } else if (string == "MONTHNAME") {
            DatabaseError.throwSqlException(34, string);
        } else if (string == "NOW") {
            this.replacingFunctionPrefix("(CURRENT_TIMESTAMP");
        } else if (string == "QUARTER") {
            DatabaseError.throwSqlException(34, string);
        } else if (string == "SECOND") {
            this.replacingFunctionPrefix("EXTRACT ( SECOND FROM ");
        } else if (string == "TIMESTAMPADD") {
            DatabaseError.throwSqlException(34, string);
        } else if (string == "TIMESTAMPDIFF") {
            DatabaseError.throwSqlException(34, string);
        } else if (string == "WEEK") {
            DatabaseError.throwSqlException(34, string);
        } else if (string == "YEAR") {
            this.replacingFunctionPrefix("EXTRACT ( YEAR FROM ");
        } else if (string == "DATABASE") {
            DatabaseError.throwSqlException(34, string);
        } else if (string == "IFNULL") {
            DatabaseError.throwSqlException(34, string);
        } else if (string == "USER") {
            this.replacingFunctionPrefix("(USER");
        } else if (string == "CONVERT") {
            DatabaseError.throwSqlException(34, string);
        } else {
            DatabaseError.throwSqlException(34, string);
        }
    }

    void handleTime() throws SQLException {
        this.oracle_sql.append("TO_DATE (");
        this.skipSpace();
        this.handleODBC();
        this.oracle_sql.append(", 'HH24:MI:SS')");
    }

    void handleTimestamp() throws SQLException {
        if (this.isV8Compatible) {
            this.oracle_sql.append("TO_DATE (");
            this.skipSpace();
            boolean bl2 = false;
            while (this.i < this.length && (this.c = this.odbc_sql.charAt(this.i)) != '}') {
                if (!bl2) {
                    if (this.c == '.') {
                        bl2 = true;
                    } else {
                        this.oracle_sql.append(this.c);
                    }
                }
                ++this.i;
            }
            if (bl2) {
                this.oracle_sql.append('\'');
            }
            this.oracle_sql.append(", 'YYYY-MM-DD HH24:MI:SS')");
        } else {
            this.oracle_sql.append("TO_TIMESTAMP (");
            this.skipSpace();
            this.handleODBC();
            this.oracle_sql.append(", 'YYYY-MM-DD HH24:MI:SS.FF')");
        }
    }

    void handleToken(String string) throws SQLException {
        if (string.equalsIgnoreCase("?")) {
            this.handleFunction();
        } else if (string.equalsIgnoreCase("call")) {
            this.handleCall();
        } else if (string.equalsIgnoreCase("ts")) {
            this.handleTimestamp();
        } else if (string.equalsIgnoreCase("t")) {
            this.handleTime();
        } else if (string.equalsIgnoreCase("d")) {
            this.handleDate();
        } else if (string.equalsIgnoreCase("escape")) {
            this.handleEscape();
        } else if (string.equalsIgnoreCase("fn")) {
            this.handleScalarFunction();
        } else if (string.equalsIgnoreCase("oj")) {
            this.handleOuterJoin();
        } else {
            String string2 = new String(String.valueOf(this.i) + ": " + string);
            DatabaseError.throwSqlException(34, string2);
        }
    }

    private String hexUnicode(int n2) throws SQLException {
        String string = Integer.toHexString(n2);
        switch (string.length()) {
            case 0: {
                return "\\0000";
            }
            case 1: {
                return "\\000" + string;
            }
            case 2: {
                return "\\00" + string;
            }
            case 3: {
                return "\\0" + string;
            }
            case 4: {
                return "\\" + string;
            }
        }
        DatabaseError.throwSqlException(89, "Unexpected case in OracleSql.hexUnicode: " + n2);
        return "never happen";
    }

    void initialize(String string) throws SQLException {
        if (string == null || string == "") {
            DatabaseError.throwSqlException(104);
        }
        this.originalSql = string;
        this.utickSql = null;
        this.processedSql = null;
        this.rowidSql = null;
        this.actualSql = null;
        this.sqlBytes = null;
        this.sqlKind = (byte)-1;
        this.parameterCount = -1;
        this.includeRowid = false;
        this.parameterSql = this.originalSql;
        this.bindParameterCount = -1;
        this.bindParameterList = null;
        this.cachedBindParameterCount = -1;
        this.cachedBindParameterList = null;
        this.cachedParameterSql = null;
        this.cachedActualSql = null;
        this.cachedProcessedSql = null;
        this.cachedRowidSql = null;
        this.cachedSqlBytes = null;
        this.selectEndIndex = -1;
        this.orderByStartIndex = -1;
        this.orderByEndIndex = -1;
        this.whereStartIndex = -1;
        this.whereEndIndex = -1;
        this.forUpdateStartIndex = -1;
        this.forUpdateEndIndex = -1;
    }

    public static boolean isValidObjectName(String string) throws SQLException {
        if (string.startsWith("\"")) {
            return true;
        }
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        boolean bl2 = true;
        cArray[0] = Character.toUpperCase(cArray[0]);
        if (cArray[0] < 'A' || cArray[0] > 'Z') {
            return bl2;
        }
        int n3 = 1;
        while (n3 < n2) {
            if (!Character.isLetterOrDigit(cArray[n3]) && cArray[n3] != '$' && cArray[n3] != '#' && cArray[n3] != '_') break;
            ++n3;
        }
        return bl2;
    }

    static boolean isValidPlsqlWarning(String string) throws SQLException {
        boolean bl2;
        int n2 = 0;
        char[] cArray = string.toCharArray();
        int n3 = cArray.length - 1;
        boolean bl3 = false;
        boolean bl4 = bl2 = cArray[n2] == '\'';
        if (n3 > 0 && bl2) {
            n2 = 1;
            while (n2 < n3) {
                if (cArray[n2] == '\'' && n2 != n3) {
                    bl2 ^= true;
                } else if (!Character.isLetterOrDigit(cArray[n2]) && cArray[n2] != ':' && cArray[n2] != ',' && cArray[n2] != ' ' && cArray[n2] != '(' && cArray[n2] != ')' && !Character.isWhitespace(cArray[n2])) break;
                ++n2;
            }
            if (n2 == n3 && bl2 && cArray[n2] == '\'') {
                bl3 = true;
            }
        }
        return bl3;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"IS_UNINITIALIZED", "IS_SELECT", "IS_PLSQL_BLOCK", "IS_DML", "IS_OTHER", "IS_CALL_BLOCK"};
        try {
            int n2;
            OracleSql oracleSql = new OracleSql(null);
            boolean bl2 = stringArray[0].equals("true");
            boolean bl3 = stringArray[1].equals("true");
            oracleSql.initialize(stringArray[2]);
            String string = oracleSql.getSql(bl2, bl3);
            System.out.println(String.valueOf(stringArray2[oracleSql.sqlKind + 1]) + ", " + oracleSql.parameterCount);
            String[] stringArray3 = oracleSql.getParameterList();
            if (stringArray3 == EMPTY_LIST) {
                System.out.println("parameterList is empty");
            } else {
                n2 = 0;
                while (n2 < stringArray3.length) {
                    System.out.println("parameterList[" + n2 + "] = " + stringArray3[n2]);
                    ++n2;
                }
            }
            if (oracleSql.lastNcharLiteralLocation == 2) {
                System.out.println("No NCHAR literals");
            } else {
                System.out.println("NCHAR Literals");
                n2 = 1;
                while (n2 < oracleSql.lastNcharLiteralLocation - 1) {
                    System.out.println(string.substring(oracleSql.ncharLiteralLocation[n2++], oracleSql.ncharLiteralLocation[n2++]));
                }
            }
            System.out.println("Keywords");
            if (oracleSql.selectEndIndex == -1) {
                System.out.println("no select");
            } else {
                System.out.println("'" + string.substring(oracleSql.selectEndIndex - 6, oracleSql.selectEndIndex) + "'");
            }
            if (oracleSql.orderByStartIndex == -1) {
                System.out.println("no order by");
            } else {
                System.out.println("'" + string.substring(oracleSql.orderByStartIndex, oracleSql.orderByEndIndex) + "'");
            }
            if (oracleSql.whereStartIndex == -1) {
                System.out.println("no where");
            } else {
                System.out.println("'" + string.substring(oracleSql.whereStartIndex, oracleSql.whereEndIndex) + "'");
            }
            if (oracleSql.forUpdateStartIndex == -1) {
                System.out.println("no for update");
            } else {
                System.out.println("'" + string.substring(oracleSql.forUpdateStartIndex, oracleSql.forUpdateEndIndex) + "'");
            }
            System.out.println("\"" + string + "\"");
            System.out.println("\"" + oracleSql.getRevisedSql() + "\"");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    String nextArgument() {
        String string = ":" + this.current_argument;
        ++this.current_argument;
        return string;
    }

    String parse(String string) throws SQLException {
        this.current_argument = 1;
        this.i = 0;
        this.first = true;
        this.in_string = false;
        this.odbc_sql = string;
        this.length = this.odbc_sql.length();
        if (this.oracle_sql == null) {
            this.oracle_sql = new StringBuffer(this.length);
            this.token_buffer = new StringBuffer(32);
        } else {
            this.oracle_sql.ensureCapacity(this.length);
        }
        this.oracle_sql.delete(0, this.oracle_sql.length());
        this.skipSpace();
        this.handleODBC();
        if (this.i < this.length) {
            Integer n2 = new Integer(this.i);
            DatabaseError.throwSqlException(33, n2);
        }
        return this.oracle_sql.substring(0, this.oracle_sql.length());
    }

    String removeForUpdate(String string) throws SQLException {
        if (this.orderByStartIndex != -1 && (this.forUpdateStartIndex == -1 || this.forUpdateStartIndex > this.orderByStartIndex)) {
            string = string.substring(0, this.orderByStartIndex);
        } else if (this.forUpdateStartIndex != -1) {
            string = string.substring(0, this.forUpdateStartIndex);
        }
        return string;
    }

    void replacingFunctionPrefix(String string) throws SQLException {
        this.skipSpace();
        if (this.i < this.length && (this.c = this.odbc_sql.charAt(this.i)) == '(') {
            ++this.i;
        } else {
            DatabaseError.throwSqlException(33);
        }
        this.oracle_sql.append(string);
        this.skipSpace();
        this.handleODBC();
    }

    void resetNamedParameters() {
        this.cachedBindParameterCount = this.bindParameterCount;
        if (this.bindParameterCount != -1) {
            if (this.cachedBindParameterList == null || this.cachedBindParameterList == this.bindParameterList || this.cachedBindParameterList.length < this.bindParameterCount) {
                this.cachedBindParameterList = new String[this.bindParameterCount];
            }
            System.arraycopy(this.bindParameterList, 0, this.cachedBindParameterList, 0, this.bindParameterCount);
            this.cachedParameterSql = this.parameterSql;
            this.cachedActualSql = this.actualSql;
            this.cachedUtickSql = this.utickSql;
            this.cachedProcessedSql = this.processedSql;
            this.cachedRowidSql = this.rowidSql;
            this.cachedSqlBytes = this.sqlBytes;
            this.bindParameterCount = -1;
            this.bindParameterList = null;
            this.parameterSql = this.originalSql;
            this.actualSql = null;
            this.utickSql = null;
            this.processedSql = null;
            this.rowidSql = null;
            this.sqlBytes = null;
        }
    }

    void setIncludeRowid(boolean bl2) {
        if (bl2 != this.includeRowid) {
            this.includeRowid = bl2;
            this.rowidSql = null;
            this.actualSql = null;
            this.sqlBytes = null;
        }
    }

    boolean setNamedParameters(int n2, String[] stringArray) throws SQLException {
        boolean bl2 = false;
        if (n2 == 0) {
            this.bindParameterCount = -1;
            bl2 = this.bindParameterCount != this.cachedBindParameterCount;
        } else {
            this.bindParameterCount = n2;
            this.bindParameterList = stringArray;
            boolean bl3 = bl2 = this.bindParameterCount != this.cachedBindParameterCount;
            if (!bl2) {
                int n3 = 0;
                while (n3 < n2) {
                    if (this.bindParameterList[n3] != this.cachedBindParameterList[n3]) {
                        bl2 = true;
                        break;
                    }
                    ++n3;
                }
            }
            if (bl2) {
                if (this.bindParameterCount != this.getParameterCount()) {
                    throw new SQLException("Incorrectly set or registered parameters.");
                }
                char[] cArray = this.originalSql.toCharArray();
                StringBuffer stringBuffer = new StringBuffer();
                int n4 = 0;
                int n5 = 0;
                while (n5 < cArray.length) {
                    if (cArray[n5] != '?') {
                        stringBuffer.append(cArray[n5]);
                    } else {
                        stringBuffer.append(this.bindParameterList[n4++]);
                        stringBuffer.append("=>?");
                    }
                    ++n5;
                }
                if (n4 != this.bindParameterCount) {
                    throw new SQLException("Incorrectly set or registered parameters.");
                }
                this.parameterSql = new String(stringBuffer);
                this.actualSql = null;
                this.utickSql = null;
                this.processedSql = null;
                this.rowidSql = null;
                this.sqlBytes = null;
            } else {
                this.parameterSql = this.cachedParameterSql;
                this.actualSql = this.cachedActualSql;
                this.utickSql = this.cachedUtickSql;
                this.processedSql = this.cachedProcessedSql;
                this.rowidSql = this.cachedRowidSql;
                this.sqlBytes = this.cachedSqlBytes;
            }
        }
        this.cachedBindParameterList = null;
        this.cachedParameterSql = null;
        this.cachedActualSql = null;
        this.cachedUtickSql = null;
        this.cachedProcessedSql = null;
        this.cachedRowidSql = null;
        this.cachedSqlBytes = null;
        return bl2;
    }

    void skipSpace() {
        while (this.i < this.length && (this.c = this.odbc_sql.charAt(this.i)) == ' ') {
            ++this.i;
        }
    }

    public String toString() {
        return this.parameterSql == null ? "null" : this.parameterSql;
    }

    void usingFunctionName(String string) throws SQLException {
        this.oracle_sql.append(string);
        this.skipSpace();
        this.handleODBC();
    }
}

