/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;

class OracleReturnResultSet
extends BaseResultSet {
    OracleStatement statement;
    boolean closed;
    Accessor[] returnAccessors;

    OracleReturnResultSet(OracleStatement oracleStatement) throws SQLException {
        this.statement = oracleStatement;
        this.closed = false;
        this.returnAccessors = new Accessor[oracleStatement.numReturnParams];
        int n2 = 0;
        int n3 = 0;
        while (n3 < oracleStatement.numberOfBindPositions) {
            Accessor accessor = oracleStatement.returnParamAccessors[n3];
            if (accessor != null) {
                this.returnAccessors[n2++] = accessor;
            }
            ++n3;
        }
    }

    public synchronized void close() throws SQLException {
        this.closed = true;
        this.statement.returnResultSet = null;
        this.statement.numReturnParams = 0;
        this.statement.totalRowsVisited = 0;
        this.statement.currentRow = -1;
        this.statement.returnParamsFetched = false;
        this.statement.rowsDmlReturned = 0;
        this.statement.returnParamBytes = null;
        this.statement.returnParamChars = null;
        this.statement.returnParamIndicators = null;
    }

    public synchronized int findColumn(String string) throws SQLException {
        DatabaseError.throwSqlException(23);
        return -1;
    }

    public synchronized ARRAY getARRAY(int n2) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getARRAY(n3);
    }

    public synchronized Array getArray(int n2) throws SQLException {
        DatabaseError.throwSqlException(23);
        return null;
    }

    public synchronized InputStream getAsciiStream(int n2) throws SQLException {
        DatabaseError.throwSqlException(23);
        return null;
    }

    public synchronized BFILE getBFILE(int n2) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getBFILE(n3);
    }

    public synchronized BLOB getBLOB(int n2) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getBLOB(n3);
    }

    public synchronized BFILE getBfile(int n2) throws SQLException {
        return this.getBFILE(n2);
    }

    public BigDecimal getBigDecimal(int n2) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getBigDecimal(n3);
    }

    public synchronized BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        int n4;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n4 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getBigDecimal(n4, n3);
    }

    public synchronized InputStream getBinaryStream(int n2) throws SQLException {
        DatabaseError.throwSqlException(23);
        return null;
    }

    public synchronized Blob getBlob(int n2) throws SQLException {
        return this.getBLOB(n2);
    }

    public synchronized boolean getBoolean(int n2) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getBoolean(n3);
    }

    public synchronized byte getByte(int n2) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getByte(n3);
    }

    public synchronized byte[] getBytes(int n2) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getBytes(n3);
    }

    public synchronized CHAR getCHAR(int n2) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getCHAR(n3);
    }

    public synchronized CLOB getCLOB(int n2) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getCLOB(n3);
    }

    public synchronized Reader getCharacterStream(int n2) throws SQLException {
        DatabaseError.throwSqlException(23);
        return null;
    }

    public synchronized Clob getClob(int n2) throws SQLException {
        return this.getCLOB(n2);
    }

    public synchronized ResultSet getCursor(int n2) throws SQLException {
        DatabaseError.throwSqlException(23);
        return null;
    }

    public synchronized CustomDatum getCustomDatum(int n2, CustomDatumFactory customDatumFactory) throws SQLException {
        DatabaseError.throwSqlException(23);
        return null;
    }

    public synchronized DATE getDATE(int n2) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getDATE(n3);
    }

    public synchronized Date getDate(int n2) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getDate(n3);
    }

    public Date getDate(int n2, Calendar calendar) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getDate(n3, calendar);
    }

    public synchronized double getDouble(int n2) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getDouble(n3);
    }

    public int getFetchSize() throws SQLException {
        DatabaseError.throwSqlException(23);
        return -1;
    }

    public synchronized float getFloat(int n2) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getFloat(n3);
    }

    public INTERVALDS getINTERVALDS(int n2) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getINTERVALDS(n3);
    }

    public INTERVALYM getINTERVALYM(int n2) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getINTERVALYM(n3);
    }

    public synchronized int getInt(int n2) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getInt(n3);
    }

    public synchronized long getLong(int n2) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getLong(n3);
    }

    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        if (!this.statement.isAutoGeneratedKey) {
            DatabaseError.throwSqlException(23);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(10);
        }
        if (this.statement.closed) {
            DatabaseError.throwSqlException(9);
        }
        AutoKeyInfo autoKeyInfo = this.statement.autoKeyInfo;
        autoKeyInfo.statement = this.statement;
        autoKeyInfo.connection = this.statement.connection;
        autoKeyInfo.initMetaData(this);
        return autoKeyInfo;
    }

    public synchronized NUMBER getNUMBER(int n2) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getNUMBER(n3);
    }

    public synchronized OPAQUE getOPAQUE(int n2) throws SQLException {
        DatabaseError.throwSqlException(23);
        return null;
    }

    public synchronized ORAData getORAData(int n2, ORADataFactory oRADataFactory) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getORAData(n3, oRADataFactory);
    }

    public synchronized Object getObject(int n2) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getObject(n3);
    }

    public synchronized Object getObject(int n2, Map map) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getObject(n3, map);
    }

    public synchronized Datum getOracleObject(int n2) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getOracleObject(n3);
    }

    public synchronized RAW getRAW(int n2) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getRAW(n3);
    }

    public synchronized REF getREF(int n2) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getREF(n3);
    }

    public synchronized ROWID getROWID(int n2) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getROWID(n3);
    }

    public synchronized Ref getRef(int n2) throws SQLException {
        return this.getREF(n2);
    }

    public int getRow() throws SQLException {
        return this.statement.totalRowsVisited;
    }

    public synchronized STRUCT getSTRUCT(int n2) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getSTRUCT(n3);
    }

    public synchronized short getShort(int n2) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getShort(n3);
    }

    public synchronized Statement getStatement() throws SQLException {
        return this.statement;
    }

    public synchronized String getString(int n2) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getString(n3);
    }

    public TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getTIMESTAMP(n3);
    }

    public TIMESTAMPLTZ getTIMESTAMPLTZ(int n2) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getTIMESTAMPLTZ(n3);
    }

    public synchronized Time getTime(int n2) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getTime(n3);
    }

    public Time getTime(int n2, Calendar calendar) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getTime(n3, calendar);
    }

    public synchronized Timestamp getTimestamp(int n2) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getTimestamp(n3);
    }

    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getTimestamp(n3, calendar);
    }

    public synchronized URL getURL(int n2) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n2 <= 0 || n2 > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        return this.returnAccessors[n2 - 1].getURL(n3);
    }

    public synchronized InputStream getUnicodeStream(int n2) throws SQLException {
        DatabaseError.throwSqlException(23);
        return null;
    }

    public boolean isAfterLast() throws SQLException {
        return !this.isEmptyResultSet() && this.closed;
    }

    public boolean isBeforeFirst() throws SQLException {
        return !this.isEmptyResultSet() && this.statement.currentRow == -1 && !this.closed;
    }

    boolean isEmptyResultSet() {
        return this.statement.rowsDmlReturned == 0;
    }

    public boolean isFirst() throws SQLException {
        return this.getRow() == 1;
    }

    public boolean isLast() throws SQLException {
        return this.getRow() == this.statement.rowsDmlReturned;
    }

    public synchronized boolean next() throws SQLException {
        if (this.closed) {
            return false;
        }
        if (!this.statement.returnParamsFetched) {
            this.statement.fetchDmlReturnParams();
            this.statement.setupReturnParamAccessors();
        }
        ++this.statement.currentRow;
        ++this.statement.totalRowsVisited;
        return this.statement.currentRow < this.statement.rowsDmlReturned;
    }

    public void setFetchSize(int n2) throws SQLException {
        DatabaseError.throwSqlException(23);
    }

    public synchronized boolean wasNull() throws SQLException {
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (this.statement.currentRow == -1 || this.statement.lastIndex == 0) {
            DatabaseError.throwSqlException(24);
        }
        return this.returnAccessors[this.statement.lastIndex - 1].isNull(this.statement.currentRow);
    }
}

