/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

class OracleResultSetImpl
extends BaseResultSet {
    PhysicalConnection connection;
    OracleStatement statement;
    boolean closed;
    boolean explicitly_closed;
    boolean m_emptyRset;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:41_PDT_2005";

    OracleResultSetImpl(PhysicalConnection physicalConnection, OracleStatement oracleStatement) throws SQLException {
        this.connection = physicalConnection;
        this.statement = oracleStatement;
        this.close_statement_on_close = false;
        this.closed = false;
        this.explicitly_closed = false;
        this.m_emptyRset = false;
    }

    public synchronized void close() throws SQLException {
        this.internal_close(false);
        if (this.close_statement_on_close) {
            try {
                this.statement.close();
            }
            catch (SQLException sQLException) {}
        }
        this.explicitly_closed = true;
    }

    private boolean close_or_fetch_from_next(boolean bl2) throws SQLException {
        if (bl2) {
            this.internal_close(false);
            return false;
        }
        if (this.statement.gotLastBatch) {
            this.internal_close(false);
            return false;
        }
        this.statement.check_row_prefetch_changed();
        PhysicalConnection physicalConnection = this.statement.connection;
        if (physicalConnection.protocolId == 3) {
            this.sqlWarning = null;
        } else {
            if (this.statement.streamList != null) {
                while (this.statement.nextStream != null) {
                    try {
                        this.statement.nextStream.close();
                    }
                    catch (IOException iOException) {
                        DatabaseError.throwSqlException(iOException);
                    }
                    this.statement.nextStream = this.statement.nextStream.nextStream;
                }
            }
            this.clearWarnings();
            physicalConnection.needLine();
        }
        PhysicalConnection physicalConnection2 = physicalConnection;
        synchronized (physicalConnection2) {
            this.statement.fetch();
        }
        if (this.statement.validRows == 0) {
            this.internal_close(false);
            return false;
        }
        this.statement.currentRow = 0;
        this.statement.checkValidRowsStatus();
        return true;
    }

    public synchronized int findColumn(String string) throws SQLException {
        return this.statement.getColumnIndex(string);
    }

    public synchronized ARRAY getARRAY(int n2) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getARRAY(n3);
    }

    public synchronized Array getArray(int n2) throws SQLException {
        return this.getARRAY(n2);
    }

    public synchronized InputStream getAsciiStream(int n2) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getAsciiStream(n3);
    }

    public synchronized BFILE getBFILE(int n2) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getBFILE(n3);
    }

    public synchronized BLOB getBLOB(int n2) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getBLOB(n3);
    }

    public synchronized BFILE getBfile(int n2) throws SQLException {
        return this.getBFILE(n2);
    }

    public BigDecimal getBigDecimal(int n2) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getBigDecimal(n3);
    }

    public synchronized BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        int n4;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n4 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getBigDecimal(this.statement.currentRow, n3);
    }

    public synchronized InputStream getBinaryStream(int n2) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getBinaryStream(n3);
    }

    public synchronized Blob getBlob(int n2) throws SQLException {
        return this.getBLOB(n2);
    }

    public synchronized boolean getBoolean(int n2) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getBoolean(n3);
    }

    public synchronized byte getByte(int n2) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getByte(n3);
    }

    public synchronized byte[] getBytes(int n2) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getBytes(n3);
    }

    public synchronized CHAR getCHAR(int n2) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getCHAR(n3);
    }

    public synchronized CLOB getCLOB(int n2) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getCLOB(n3);
    }

    public synchronized Reader getCharacterStream(int n2) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getCharacterStream(n3);
    }

    public synchronized Clob getClob(int n2) throws SQLException {
        return this.getCLOB(n2);
    }

    public synchronized ResultSet getCursor(int n2) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getCursor(n3);
    }

    public synchronized CustomDatum getCustomDatum(int n2, CustomDatumFactory customDatumFactory) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getCustomDatum(this.statement.currentRow, customDatumFactory);
    }

    public synchronized DATE getDATE(int n2) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getDATE(n3);
    }

    public synchronized Date getDate(int n2) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getDate(n3);
    }

    public Date getDate(int n2, Calendar calendar) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getDate(this.statement.currentRow, calendar);
    }

    public synchronized double getDouble(int n2) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getDouble(n3);
    }

    public int getFetchSize() throws SQLException {
        return this.statement.getPrefetchInternal(false);
    }

    public synchronized float getFloat(int n2) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getFloat(n3);
    }

    public INTERVALDS getINTERVALDS(int n2) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getINTERVALDS(n3);
    }

    public INTERVALYM getINTERVALYM(int n2) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getINTERVALYM(n3);
    }

    public synchronized int getInt(int n2) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getInt(n3);
    }

    public synchronized long getLong(int n2) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getLong(n3);
    }

    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        if (this.explicitly_closed) {
            DatabaseError.throwSqlException(10, "getMetaData");
        }
        if (this.statement.closed) {
            DatabaseError.throwSqlException(9, "getMetaData");
        }
        if (!this.statement.isOpen) {
            DatabaseError.throwSqlException(144, "getMetaData");
        }
        return new OracleResultSetMetaData(this.connection, this.statement);
    }

    public synchronized NUMBER getNUMBER(int n2) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getNUMBER(n3);
    }

    public synchronized OPAQUE getOPAQUE(int n2) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getOPAQUE(n3);
    }

    public synchronized ORAData getORAData(int n2, ORADataFactory oRADataFactory) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getORAData(this.statement.currentRow, oRADataFactory);
    }

    public synchronized Object getObject(int n2) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getObject(n3);
    }

    public synchronized Object getObject(int n2, Map map) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getObject(this.statement.currentRow, map);
    }

    public synchronized Datum getOracleObject(int n2) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getOracleObject(n3);
    }

    public synchronized RAW getRAW(int n2) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getRAW(n3);
    }

    public synchronized REF getREF(int n2) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getREF(n3);
    }

    public synchronized ROWID getROWID(int n2) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getROWID(n3);
    }

    public synchronized Ref getRef(int n2) throws SQLException {
        return this.getREF(n2);
    }

    public int getRow() throws SQLException {
        return this.statement.totalRowsVisited;
    }

    public synchronized STRUCT getSTRUCT(int n2) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getSTRUCT(n3);
    }

    public synchronized short getShort(int n2) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getShort(n3);
    }

    public synchronized Statement getStatement() throws SQLException {
        return this.statement;
    }

    public synchronized String getString(int n2) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getString(n3);
    }

    public TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getTIMESTAMP(n3);
    }

    public TIMESTAMPLTZ getTIMESTAMPLTZ(int n2) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getTIMESTAMPLTZ(n3);
    }

    public TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getTIMESTAMPTZ(n3);
    }

    public synchronized Time getTime(int n2) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getTime(n3);
    }

    public Time getTime(int n2, Calendar calendar) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getTime(this.statement.currentRow, calendar);
    }

    public synchronized Timestamp getTimestamp(int n2) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getTimestamp(n3);
    }

    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getTimestamp(this.statement.currentRow, calendar);
    }

    public synchronized URL getURL(int n2) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getURL(n3);
    }

    public synchronized InputStream getUnicodeStream(int n2) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].getUnicodeStream(n3);
    }

    int getValidRows() {
        return this.statement.validRows;
    }

    void internal_close(boolean bl2) throws SQLException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.statement.gotLastBatch && this.statement.validRows == 0) {
            this.m_emptyRset = true;
        }
        PhysicalConnection physicalConnection = this.statement.connection;
        try {
            physicalConnection.needLine();
            PhysicalConnection physicalConnection2 = physicalConnection;
            synchronized (physicalConnection2) {
                this.statement.closeQuery();
            }
        }
        catch (SQLException sQLException) {}
        this.statement.endOfResultSet(bl2);
    }

    public boolean isAfterLast() throws SQLException {
        return !this.isEmptyResultSet() && this.closed;
    }

    public boolean isBeforeFirst() throws SQLException {
        return !this.isEmptyResultSet() && this.statement.currentRow == -1 && !this.closed;
    }

    boolean isEmptyResultSet() {
        return this.m_emptyRset || !this.m_emptyRset && this.statement.gotLastBatch && this.statement.validRows == 0;
    }

    public boolean isFirst() throws SQLException {
        return this.getRow() == 1;
    }

    public boolean isLast() throws SQLException {
        DatabaseError.throwSqlException(75, "isLast");
        return false;
    }

    public synchronized boolean next() throws SQLException {
        boolean bl2 = true;
        PhysicalConnection physicalConnection = this.statement.connection;
        if (this.explicitly_closed) {
            DatabaseError.throwSqlException(10, "next");
        }
        if (physicalConnection == null || physicalConnection.lifecycle != 1) {
            DatabaseError.throwSqlException(8, "next");
        }
        if (this.statement.closed) {
            DatabaseError.throwSqlException(9, "next");
        }
        if (this.statement.sqlKind == 1 || this.statement.sqlKind == 4) {
            DatabaseError.throwSqlException(166, "next");
        }
        if (this.closed) {
            return false;
        }
        ++this.statement.currentRow;
        ++this.statement.totalRowsVisited;
        if (this.statement.maxRows != 0 && this.statement.totalRowsVisited > this.statement.maxRows) {
            this.internal_close(false);
            return false;
        }
        if (this.statement.currentRow >= this.statement.validRows) {
            bl2 = this.close_or_fetch_from_next(false);
        }
        if (bl2 && physicalConnection.useFetchSizeWithLongColumn) {
            this.statement.reopenStreams();
        }
        return bl2;
    }

    synchronized byte[] privateGetBytes(int n2) throws SQLException {
        int n3;
        if (n2 <= 0 || n2 > this.statement.numberOfDefinePositions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n2;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n2);
        }
        return this.statement.accessors[n2 - 1].privateGetBytes(n3);
    }

    public void setFetchSize(int n2) throws SQLException {
        this.statement.setPrefetchInternal(n2, false, false);
    }

    public synchronized boolean wasNull() throws SQLException {
        return this.statement.wasNullValue();
    }
}

