/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;

public class OracleLog {
    public static final int MASK_ALL_SET = 0xFFFFFFF;
    public static final int MAX_VECTOR_BITS = 32;
    public static final int MAX_MODULES = 32;
    public static final int MODULE_ALL = 0xFFFFFFF;
    public static final int MODULE_DRIVER = 1;
    public static final int MODULE_POOL = 2;
    public static final int MODULE_DBCONV = 4;
    public static final int MODULE_unused2 = 8;
    public static final int MODULE_PICKLE = 16;
    public static final int MODULE_JTTC = 32;
    public static final int MODULE_DATUM = 64;
    public static final int MODULE_KPRB = 128;
    public static final int MODULE_XA = 256;
    public static final int MODULE_SQLJ = 512;
    public static final int MODULE_JOCI = 1024;
    public static final int MODULE_JPUB = 2048;
    public static final int MODULE_T2C = 4096;
    public static final int MODULE_TOTAL = 13;
    public static final String[] ModuleName = new String[]{"DRVR ", "POOL", "DBCV ", "unused", "PIKL ", "JTTC ", "DATM ", "KPRB ", "XA   ", "SQLJ ", "JOCI ", "JPUB ", "T2C"};
    public static final int SUBMOD_ALL = 0xFFFFFFF;
    public static final int SUBMOD_DEFAULT = 1;
    public static final int SUBMOD_DRVR_LOG = 2;
    public static final int SUBMOD_DRVR_ERR = 4;
    public static final int SUBMOD_DRVR_CONN = 8;
    public static final int SUBMOD_DRVR_STMT = 16;
    public static final int SUBMOD_DRVR_RSET = 32;
    public static final int SUBMOD_DRVR_UTIL = 64;
    public static final int SUBMOD_DRVR_SQL = 128;
    public static final int SUBMOD_DRVR_RWST = 256;
    public static final int SUBMOD_DRVR_POOL = 512;
    public static final int SUBMOD_DRVR_SCCH = 1024;
    public static final int SUBMOD_DRVR_CNTR = 2048;
    public static final int SUBMOD_T2C_DRVEXT = 2;
    public static final int SUBMOD_T2C_STATEMENT = 4;
    public static final int SUBMOD_T2C_PREPSTATEMENT = 8;
    public static final int SUBMOD_T2C_CALLSTATEMENT = 16;
    public static final int SUBMOD_T2C_INPUTSTREAM = 32;
    public static final int SUBMOD_T2C_CLOB = 64;
    public static final int SUBMOD_T2C_BLOB = 128;
    public static final int SUBMOD_T2C_BFILE = 256;
    public static final int SUBMOD_DBAC_DATA = 2;
    public static final int SUBMOD_PCKL_INIT = 2;
    public static final int SUBMOD_PCKL_TYPE = 4;
    public static final int SUBMOD_PCKL_PCKL = 8;
    public static final int SUBMOD_PCKL_UNPK = 16;
    public static final int SUBMOD_PCKL_CONV = 32;
    public static final int SUBMOD_PCKL_DESC = 64;
    public static final int SUBMOD_PCKL_PARS = 128;
    public static final int SUBMOD_PCKL_SERL = 256;
    public static final int SUBMOD_JTTC_BASE = 2;
    public static final int SUBMOD_JTTC_TX = 4;
    public static final int SUBMOD_JTTC_RX = 8;
    public static final int SUBMOD_JTTC_MARS = 16;
    public static final int SUBMOD_JTTC_UNMA = 32;
    public static final int SUBMOD_JTTC_CONN = 64;
    public static final int SUBMOD_JTTC_COMM = 128;
    public static final int SUBMOD_JTTC_STMT = 256;
    public static final int SUBMOD_JTTC_LOBS = 512;
    public static final int SUBMOD_JTTC_ADTS = 1024;
    public static final int SUBMOD_JTTC_ACCE = 2048;
    public static final int SUBMOD_KPRB_ERR = 2;
    public static final int SUBMOD_KPRB_CONN = 4;
    public static final int SUBMOD_KPRB_STMT = 8;
    public static final int SUBMOD_KPRB_RSET = 16;
    public static final int SUBMOD_KPRB_UTIL = 32;
    public static final int SUBMOD_KPRB_SQL = 64;
    public static final int SUBMOD_KPRB_DATA = 128;
    public static final int SUBMOD_KPRB_CONV = 256;
    public static final int SUBMOD_POOL_ALL = 2;
    public static final int SUBMOD_XA_DSRC = 2;
    public static final int SUBMOD_XA_CONN = 4;
    public static final int SUBMOD_XA_RSRC = 8;
    public static final int SUBMOD_XA_ARGS = 16;
    public static final int SUBMOD_XA_EXC = 32;
    public static final int SUBMOD_XA_XID = 64;
    public static final int SUBMOD_XA_HCON = 128;
    public static final int SUBMOD_XA_HCCB = 256;
    public static final int SUBMOD_XA_HRSC = 512;
    public static final int SUBMOD_SQLJ_RUN = 2;
    public static final int SUBMOD_JOCI_ACCS = 2;
    public static final int SUBMOD_JOCI_DSET = 4;
    public static final int SUBMOD_JOCI_ITEM = 8;
    public static final int SUBMOD_JOCI_STMT = 16;
    public static final int SUBMOD_JOCI_TYPE = 32;
    public static final int SUBMOD_JOCI_ENV = 64;
    public static final int SUBMOD_JPUB_RUNTIME = 2;
    public static final int CATEGORY_ALL = 0xFFFFFFF;
    public static final int USER_OPER = 1;
    public static final int PROG_ERROR = 2;
    public static final int ERROR = 4;
    public static final int WARNING = 8;
    public static final int FUNCTION = 16;
    public static final int DEBUG1 = 32;
    public static final int DEBUG2 = 64;
    public static final int SQL_STR = 128;
    public static final int CATEGORY_TOTAL = 8;
    public static final String[] CategoryName = new String[]{"OPER ", "PERR ", "ERRO ", "WARN ", "FUNC ", "DBG1 ", "DBG2 ", "SQLS "};
    public static final int CATEGORY_LOW_VOL = 142;
    public static final int CATEGORY_MED_VOL = 143;
    public static final int CATEGORY_HIGH_VOL = 0xFFFFFFF;
    public static final int FIELD_NONE = 0;
    public static final int FIELD_ALL = 0xFFFFFFF;
    public static final int FIELD_NUMBER = 1;
    public static final int FIELD_TIME = 2;
    public static final int FIELD_MODULE = 4;
    public static final int FIELD_SUBMOD = 8;
    public static final int FIELD_CATEGORY = 16;
    public static final int FIELD_OBJECT = 32;
    public static final int FIELD_THREAD = 64;
    public static final int FIELD_DEFAULT = 20;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    private static PrintWriter logWriter = null;
    private static PrintStream logStream = null;
    private static int printMask = 20;
    private static int moduleMask = 0xFFFFFFF;
    private static int[] submodMasks = null;
    private static int categoryMask = 143;
    private static int maxPrintBytes = 200;
    private static boolean warningEnabled = true;
    private static int msgNumber = 0;
    static boolean securityExceptionWhileGettingSystemProperties;

    static {
        submodMasks = new int[32];
        int n2 = 0;
        while (n2 < 32) {
            OracleLog.submodMasks[n2] = 0xFFFFFFF;
            ++n2;
        }
        OracleLog.initialize();
    }

    public static String byteToHexString(byte by) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = 0xFF & by;
        if (n2 <= 15) {
            stringBuffer.append("0x0");
        } else {
            stringBuffer.append("0x");
        }
        stringBuffer.append(Integer.toHexString(n2));
        return stringBuffer.toString();
    }

    public static String bytesToFormattedStr(byte[] byArray, int n2, String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (string == null) {
            string = new String("");
        }
        stringBuffer.append(string);
        if (byArray == null) {
            stringBuffer.append("byte [] is null");
            return stringBuffer.toString();
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            if (n3 >= maxPrintBytes) {
                stringBuffer.append("\n" + string + "... last " + (n2 - maxPrintBytes) + " bytes were not printed to limit the output size");
                break;
            }
            if (n3 > 0 && n3 % 20 == 0) {
                stringBuffer.append("\n" + string);
            }
            if (n3 % 20 == 10) {
                stringBuffer.append(" ");
            }
            if ((n4 = 0xFF & byArray[n3]) <= 15) {
                stringBuffer.append("0");
            }
            stringBuffer.append(String.valueOf(Integer.toHexString(n4)) + " ");
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static String bytesToPrintableForm(String string, byte[] byArray) {
        int n2 = byArray == null ? 0 : byArray.length;
        return OracleLog.bytesToPrintableForm(string, byArray, n2);
    }

    public static String bytesToPrintableForm(String string, byte[] byArray, int n2) {
        String string2 = null;
        string2 = byArray == null ? String.valueOf(string) + ": null" : String.valueOf(string) + " (" + byArray.length + " bytes):\n" + OracleLog.bytesToFormattedStr(byArray, n2, "  ");
        return string2;
    }

    public static byte[] charsToUcs2Bytes(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        return OracleLog.charsToUcs2Bytes(cArray, cArray.length);
    }

    public static byte[] charsToUcs2Bytes(char[] cArray, int n2) {
        if (cArray == null) {
            return null;
        }
        if (n2 < 0) {
            return null;
        }
        return OracleLog.charsToUcs2Bytes(cArray, n2, 0);
    }

    public static byte[] charsToUcs2Bytes(char[] cArray, int n2, int n3) {
        if (cArray == null) {
            return null;
        }
        if (n2 > cArray.length - n3) {
            n2 = cArray.length - n3;
        }
        if (n2 < 0) {
            return null;
        }
        byte[] byArray = new byte[2 * n2];
        int n4 = n3;
        int n5 = 0;
        while (n4 < n2) {
            byArray[n5++] = (byte)(cArray[n4] >> 8 & 0xFF);
            byArray[n5++] = (byte)(cArray[n4] & 0xFF);
            ++n4;
        }
        return byArray;
    }

    public static void config(int n2, int n3, int n4) {
        printMask = n2;
        moduleMask = n3;
        categoryMask = n4;
        OracleLog.print(null, 1, 2, 1, "Set logging masks (printMask " + OracleLog.getMaskHexStr(printMask) + ", moduleMask " + OracleLog.getMaskHexStr(moduleMask) + ", categoryMask " + OracleLog.getMaskHexStr(categoryMask) + ")");
    }

    public static void enableWarning(boolean bl2) {
        warningEnabled = bl2;
    }

    public static int getBitNumFromVector(int n2) {
        int n3 = 0;
        int n4 = 1;
        int n5 = 0;
        while (n5 < 32) {
            if ((n2 & n4) != 0) {
                n3 = n5;
                break;
            }
            n4 <<= 1;
            ++n5;
        }
        return n3;
    }

    public static String getCategoryName(int n2) {
        String string = null;
        int n3 = 1;
        int n4 = 0;
        while (n4 < 8) {
            if ((n3 & n2) != 0) {
                string = CategoryName[n4];
                break;
            }
            n3 <<= 1;
            ++n4;
        }
        return string;
    }

    private static String getCurrTimeStr() {
        Date date = new Date();
        return String.valueOf(date.toString()) + " ";
    }

    public static PrintStream getLogStream() {
        return logStream;
    }

    public static PrintWriter getLogWriter() {
        return logWriter;
    }

    public static String getMaskHexStr(int n2) {
        int n3 = 8;
        String string = Integer.toHexString(n2);
        char[] cArray = new char[n3 - string.length()];
        int n4 = 0;
        while (n4 < cArray.length) {
            cArray[n4] = 48;
            ++n4;
        }
        String string2 = new String(cArray);
        return new String("0x" + string2 + string);
    }

    private static String getMessageNumber() {
        int n2;
        int n3;
        StringBuffer stringBuffer = new StringBuffer("");
        PrintWriter printWriter = logWriter;
        synchronized (printWriter) {
            msgNumber = msgNumber == Integer.MAX_VALUE ? 0 : ++msgNumber;
            n3 = msgNumber;
        }
        String string = Integer.toString(n3);
        int n4 = n2 = string.length();
        while (n4 < 10) {
            stringBuffer.append("0");
            ++n4;
        }
        stringBuffer.append(string);
        stringBuffer.append(" ");
        return stringBuffer.toString();
    }

    public static String getModuleName(int n2) {
        String string = null;
        int n3 = 1;
        int n4 = 0;
        while (n4 < 13) {
            if ((n3 & n2) != 0) {
                string = ModuleName[n4];
                break;
            }
            n3 <<= 1;
            ++n4;
        }
        return string;
    }

    private static String getSystemProperty(String string) {
        return OracleLog.getSystemProperty(string, null);
    }

    private static String getSystemProperty(String string, String string2) {
        if (string != null) {
            final String string3 = string;
            final String string4 = string2;
            final String[] stringArray = new String[]{string2};
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    stringArray[0] = System.getProperty(string3, string4);
                    return null;
                }
            });
            return stringArray[0];
        }
        return string2;
    }

    public static String info() {
        String string = null;
        string = OracleLog.isEnabled() ? "Enabled logging (moduleMask " + OracleLog.getMaskHexStr(moduleMask) + ", categoryMask " + OracleLog.getMaskHexStr(categoryMask) + ")" : "Disabled logging";
        return string;
    }

    private static void initialize() {
        OracleLog.internalCodeChecks();
        OracleLog.setupFromSystemProperties();
    }

    private static void internalCodeChecks() {
        if (ModuleName.length != 13) {
            System.out.println("ERROR: OracleLog.ModuleName[] has " + ModuleName.length + " items (expected " + 13 + ")");
        }
        if (CategoryName.length != 8) {
            System.out.println("ERROR: OracleLog.CategoryName[] has " + ModuleName.length + " items (expected " + 13 + ")");
        }
    }

    public static boolean isDebugZip() {
        boolean bl2 = true;
        bl2 = false;
        return bl2;
    }

    public static boolean isEnabled() {
        return false;
    }

    public static boolean isPrivateLogAvailable() {
        boolean bl2 = false;
        return bl2;
    }

    public static void print(Object object, int n2, int n3, int n4, String string) {
        if (logWriter == null) {
            return;
        }
        boolean bl2 = false;
        if ((n2 & moduleMask) != 0 && (n3 & submodMasks[OracleLog.getBitNumFromVector(n2)]) != 0 && (n4 & categoryMask) != 0) {
            bl2 = true;
        }
        if ((n4 & 4) != 0) {
            bl2 = true;
        }
        if (warningEnabled && (n4 & 8) != 0) {
            bl2 = true;
        }
        if (bl2) {
            StringBuffer stringBuffer = new StringBuffer("");
            if ((printMask & 1) != 0) {
                stringBuffer.append(OracleLog.getMessageNumber());
            }
            if ((printMask & 2) != 0) {
                stringBuffer.append(OracleLog.getCurrTimeStr());
            }
            if ((printMask & 4) != 0) {
                stringBuffer.append(OracleLog.getModuleName(n2));
            }
            if ((printMask & 8) != 0) {
                stringBuffer.append(String.valueOf(OracleLog.getBitNumFromVector(n3)) + " ");
            }
            if ((printMask & 0x10) != 0) {
                stringBuffer.append(OracleLog.getCategoryName(n4));
            }
            if ((printMask & 0x40) != 0) {
                stringBuffer.append(String.valueOf(String.valueOf(Thread.currentThread())) + "_" + Thread.currentThread().hashCode() + "_");
            }
            stringBuffer.append(string);
            if ((printMask & 0x20) != 0) {
                stringBuffer.append(" " + object);
            }
            if (logStream == System.out) {
                logWriter.println();
            }
            logWriter.println(stringBuffer.toString());
            logWriter.flush();
        }
    }

    public static void print(Object object, int n2, int n3, int n4, String string, Exception exception) {
        if (logWriter == null) {
            return;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        exception.printStackTrace(printWriter);
        OracleLog.print(object, n2, n3, n4, String.valueOf(string) + stringWriter.toString());
    }

    public static void print(Object object, int n2, int n3, String string) {
        OracleLog.print(object, n2, 1, n3, string);
    }

    public static boolean registerClassNameAndGetCurrentPrivateTraceSetting(Class clazz) {
        return false;
    }

    public static boolean registerClassNameAndGetCurrentTraceSetting(Class clazz) {
        return false;
    }

    public static void setLogStream(PrintStream printStream) {
        if (!OracleLog.isDebugZip()) {
            if (printStream != null) {
                printStream.println("Oracle Jdbc tracing is not avaliable in a non-debug zip/jar file");
                printStream.flush();
            }
            return;
        }
        if (printStream == null) {
            OracleLog.setLogWriter(null);
        } else {
            OracleLog.setLogWriter(new PrintWriter(printStream));
        }
        logStream = printStream;
    }

    public static void setLogVolume(int n2) {
        OracleLog.print(null, 1, 2, 1, "Set logging volume level to " + n2);
        int n3 = 142;
        switch (n2) {
            case 1: {
                n3 = 142;
                break;
            }
            case 2: {
                n3 = 143;
                break;
            }
            case 3: {
                n3 = 0xFFFFFFF;
                break;
            }
            default: {
                OracleLog.print(null, 1, 2, 4, "Logging volume level " + n2 + " is not in the range of 1 to 3");
                return;
            }
        }
        OracleLog.config(printMask, moduleMask, n3);
    }

    public static void setLogWriter(PrintWriter printWriter) {
        if (!OracleLog.isDebugZip()) {
            if (printWriter != null) {
                printWriter.println("Oracle Jdbc tracing is not avaliable in a non-debug zip/jar file");
                printWriter.flush();
            }
            return;
        }
        if (printWriter == null) {
            OracleLog.setTrace(false);
            OracleLog.print(null, 1, 2, 1, OracleLog.info());
            logWriter = printWriter;
        } else {
            OracleLog.setTrace(true);
            logWriter = printWriter;
            OracleLog.print(null, 1, 2, 1, OracleLog.info());
            if (securityExceptionWhileGettingSystemProperties) {
                OracleLog.print(null, 1, 2, 32, "A security exception occured when attempt to get System properties. This will occur in an applet environment");
            }
        }
    }

    public static void setMaxPrintBytes(int n2) {
        if (n2 > 0) {
            maxPrintBytes = n2;
        }
        OracleLog.print(null, 1, 2, 1, "Set the maximum number of bytes to be printed to " + maxPrintBytes);
    }

    public static void setPrivateTrace(boolean bl2) {
    }

    public static void setSubmodMask(int n2, int n3) {
        int n4 = OracleLog.getBitNumFromVector(n2);
        OracleLog.submodMasks[n4] = n3;
        OracleLog.print(null, 1, 2, 1, "Set logging sub-mask for module " + OracleLog.getMaskHexStr(moduleMask) + "(number " + n4 + ") to " + OracleLog.getMaskHexStr(n3));
    }

    public static void setTrace(boolean bl2) {
    }

    public static void setupFromSystemProperties() {
        boolean bl2 = false;
        securityExceptionWhileGettingSystemProperties = false;
        PrintStream printStream = System.out;
        try {
            String string = null;
            string = OracleLog.getSystemProperty("oracle.jdbc.LogFile", null);
            if (string != null) {
                try {
                    File file = new File(string);
                    printStream = new PrintStream(new FileOutputStream(file));
                    bl2 = true;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace(System.out);
                }
            }
            if ((string = OracleLog.getSystemProperty("oracle.jdbc.Trace", null)) != null && string.compareTo("true") == 0) {
                bl2 = true;
            }
            if ((string = OracleLog.getSystemProperty("oracle.jdbc.PrintMask", null)) != null) {
                printMask = Integer.parseInt(string, 16);
                bl2 = true;
            }
            if ((string = OracleLog.getSystemProperty("oracle.jdbc.PrintFields", null)) != null) {
                if (string.equalsIgnoreCase("default")) {
                    printMask = 20;
                }
                if (string.equalsIgnoreCase("all")) {
                    printMask = 0xFFFFFFF;
                }
                if (string.equalsIgnoreCase("thread")) {
                    printMask = 84;
                }
                if (string.equalsIgnoreCase("none")) {
                    printMask = 0;
                }
                bl2 = true;
            }
            if ((string = OracleLog.getSystemProperty("oracle.jdbc.ModuleMask", null)) != null) {
                moduleMask = Integer.parseInt(string, 16);
                bl2 = true;
            }
            if ((string = OracleLog.getSystemProperty("oracle.jdbc.CategoryMask", null)) != null) {
                categoryMask = Integer.parseInt(string, 16);
                bl2 = true;
            }
            int n2 = 0;
            while (n2 < 32) {
                string = OracleLog.getSystemProperty("oracle.jdbc.SubmodMask" + n2, null);
                if (string != null) {
                    OracleLog.submodMasks[n2] = Integer.parseInt(string, 16);
                    bl2 = true;
                }
                ++n2;
            }
            string = OracleLog.getSystemProperty("oracle.jdbc.MaxPrintBytes", null);
            if (string != null) {
                maxPrintBytes = Integer.parseInt(string, 10);
                bl2 = true;
            }
        }
        catch (SecurityException securityException) {
            securityExceptionWhileGettingSystemProperties = true;
        }
        if (bl2) {
            OracleLog.setLogStream(printStream);
        }
    }

    public static void startLogging() {
        OracleLog.setLogStream(System.out);
    }

    public static void stopLogging() {
        OracleLog.setLogStream(null);
    }

    public static byte[] strToUcs2Bytes(String string) {
        if (string == null) {
            return null;
        }
        return OracleLog.charsToUcs2Bytes(string.toCharArray());
    }

    public static String toHex(byte by) {
        String string = "00" + Integer.toHexString(by & 0xFF);
        return "0x" + string.substring(string.length() - 2);
    }

    public static String toHex(int n2) {
        return OracleLog.toHex(n2, 4);
    }

    public static String toHex(long l2, int n2) {
        String string;
        switch (n2) {
            case 1: {
                string = "00" + Long.toString(l2 & 0xFFL, 16);
                break;
            }
            case 2: {
                string = "0000" + Long.toString(l2 & 0xFFFFL, 16);
                break;
            }
            case 3: {
                string = "000000" + Long.toString(l2 & 0xFFFFFFL, 16);
                break;
            }
            case 4: {
                string = "00000000" + Long.toString(l2 & 0xFFFFFFFFL, 16);
                break;
            }
            case 5: {
                string = "0000000000" + Long.toString(l2 & 0xFFFFFFFFFFL, 16);
                break;
            }
            case 6: {
                string = "000000000000" + Long.toString(l2 & 0xFFFFFFFFFFFFL, 16);
                break;
            }
            case 7: {
                string = "00000000000000" + Long.toString(l2 & 0xFFFFFFFFFFFFFFL, 16);
                break;
            }
            case 8: {
                return String.valueOf(OracleLog.toHex(l2 >> 32, 4)) + OracleLog.toHex(l2, 4).substring(2);
            }
            default: {
                return "more than 8 bytes";
            }
        }
        return "0x" + string.substring(string.length() - 2 * n2);
    }

    public static String toHex(short s2) {
        return OracleLog.toHex(s2, 2);
    }

    public static String toHex(byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        return OracleLog.toHex(byArray, byArray.length);
    }

    public static String toHex(byte[] byArray, int n2) {
        if (byArray == null) {
            return "null";
        }
        if (n2 > byArray.length) {
            return "byte array not long enough";
        }
        String string = "[";
        int n3 = Math.min(64, n2);
        int n4 = 0;
        while (n4 < n3) {
            string = String.valueOf(string) + OracleLog.toHex(byArray[n4]) + " ";
            ++n4;
        }
        if (n3 < n2) {
            string = String.valueOf(string) + "...";
        }
        return String.valueOf(string) + "]";
    }

    public static String toPrintableStr(String string, int n2) {
        if (string == null) {
            return "null";
        }
        if (string.length() > n2) {
            return String.valueOf(string.substring(0, n2 - 1)) + "\n ... the actual length was " + string.length();
        }
        return string;
    }
}

