/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import oracle.jdbc.OracleDatabaseMetaData;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleSql;
import oracle.jdbc.driver.PhysicalConnection;

public class OracleDriver
implements Driver {
    public static final char slash_character = '/';
    public static final char at_sign_character = '@';
    public static final char left_square_bracket_character = '[';
    public static final char right_square_bracket_character = ']';
    public static final String oracle_string = "oracle";
    public static final String protocol_string = "protocol";
    public static final String user_string = "user";
    public static final String password_string = "password";
    public static final String database_string = "database";
    public static final String server_string = "server";
    public static final String access_string = "access";
    public static final String protocolFullName_string = "protocolFullName";
    public static final String logon_as_internal_str = "internal_logon";
    public static final String proxy_client_name = "PROXY_CLIENT_NAME";
    public static final String prefetch_string = "prefetch";
    public static final String row_prefetch_string = "rowPrefetch";
    public static final String default_row_prefetch_string = "defaultRowPrefetch";
    public static final String batch_string = "batch";
    public static final String execute_batch_string = "executeBatch";
    public static final String default_execute_batch_string = "defaultExecuteBatch";
    public static final String process_escapes_string = "processEscapes";
    public static final String dms_parent_name_string = "DMSName";
    public static final String dms_parent_type_string = "DMSType";
    public static final String accumulate_batch_result = "AccumulateBatchResult";
    public static final String j2ee_compliance = "oracle.jdbc.J2EE13Compliant";
    public static final String v8compatible_string = "oracle.jdbc.V8Compatible";
    public static final String permit_timestamp_date_mismatch_string = "oracle.jdbc.internal.permitBindDateDefineTimestampMismatch";
    public static final String StreamChunkSize_string = "oracle.jdbc.StreamChunkSize";
    public static final String SetFloatAndDoubleUseBinary_string = "SetFloatAndDoubleUseBinary";
    public static final String xa_trans_loose = "oracle.jdbc.XATransLoose";
    public static final String tcp_no_delay = "oracle.jdbc.TcpNoDelay";
    public static final String read_timeout = "oracle.jdbc.ReadTimeout";
    public static final String defaultnchar_string = "oracle.jdbc.defaultNChar";
    public static final String defaultncharprop_string = "defaultNChar";
    public static final String useFetchSizeWithLongColumn_prop_string = "useFetchSizeWithLongColumn";
    public static final String useFetchSizeWithLongColumn_string = "oracle.jdbc.useFetchSizeWithLongColumn";
    public static final String remarks_string = "remarks";
    public static final String report_remarks_string = "remarksReporting";
    public static final String synonyms_string = "synonyms";
    public static final String include_synonyms_string = "includeSynonyms";
    public static final String restrict_getTables_string = "restrictGetTables";
    public static final String fixed_string_string = "fixedString";
    public static final String dll_string = "oracle.jdbc.ocinativelibrary";
    public static final String nls_lang_backdoor = "oracle.jdbc.ociNlsLangBackwardCompatible";
    public static final String disable_defineColumnType_string = "disableDefineColumnType";
    public static final String convert_nchar_literals_string = "oracle.jdbc.convertNcharLiterals";
    public static final String dataSizeUnitsPropertyName = "";
    public static final String dataSizeBytes = "";
    public static final String dataSizeChars = "";
    public static final String dms_stmt_metrics_string = "oracle.jdbc.DMSStatementMetrics";
    public static final String dms_stmt_caching_metrics_string = "oracle.jdbc.DMSStatementCachingMetrics";
    public static final String set_new_password_string = "OCINewPassword";
    public static final String retain_v9_bind_behavior_string = "oracle.jdbc.RetainV9LongBindBehavior";
    public static final String no_caching_buffers = "oracle.jdbc.FreeMemoryOnEnterImplicitCache";
    static final int EXTENSION_TYPE_ORACLE_ERROR = -3;
    static final int EXTENSION_TYPE_GEN_ERROR = -2;
    static final int EXTENSION_TYPE_TYPE4_CLIENT = 0;
    static final int EXTENSION_TYPE_TYPE4_SERVER = 1;
    static final int EXTENSION_TYPE_TYPE2_CLIENT = 2;
    static final int EXTENSION_TYPE_TYPE2_SERVER = 3;
    private static final int NUMBER_OF_EXTENSION_TYPES = 4;
    private OracleDriverExtension[] driverExtensions = new OracleDriverExtension[4];
    private static final String DRIVER_PACKAGE_STRING = "driver";
    private static final String[] driverExtensionClassNames = new String[]{"oracle.jdbc.driver.T4CDriverExtension", "oracle.jdbc.driver.T4CDriverExtension", "oracle.jdbc.driver.T2CDriverExtension", "oracle.jdbc.driver.T2SDriverExtension"};
    private static Properties driverAccess;
    protected static Connection defaultConn;
    private static OracleDriver defaultDriver;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:40_PDT_2005";
    static /* synthetic */ Class class$oracle$jdbc$driver$OracleDriver;

    static {
        defaultConn = null;
        defaultDriver = null;
        Timestamp timestamp = Timestamp.valueOf("2000-01-01 00:00:00.0");
        try {
            if (defaultDriver == null) {
                defaultDriver = new OracleDriver();
                DriverManager.registerDriver(defaultDriver);
            }
        }
        catch (RuntimeException runtimeException) {
        }
        catch (SQLException sQLException) {}
        _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    }

    public boolean acceptsURL(String string) {
        if (string.startsWith("jdbc:oracle:")) {
            return this.oracleDriverExtensionTypeFromURL(string) > -2;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Connection connect(String string, Properties properties) throws SQLException {
        String string2;
        String string3;
        Object object;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9;
        String string10;
        String string11;
        int n2;
        String string12;
        String string13;
        Object object2;
        int n3;
        if (string.regionMatches(0, "jdbc:default:connection", 0, 23)) {
            String string14 = "jdbc:oracle:kprb";
            int n4 = string.length();
            string = n4 > 23 ? string14.concat(string.substring(23, string.length())) : string14.concat(":");
            string14 = null;
        }
        if ((n3 = this.oracleDriverExtensionTypeFromURL(string)) == -2) {
            return null;
        }
        if (n3 == -3) {
            DatabaseError.throwSqlException(67);
        }
        OracleDriverExtension oracleDriverExtension = null;
        oracleDriverExtension = this.driverExtensions[n3];
        if (oracleDriverExtension == null) {
            try {
                object2 = this;
                synchronized (object2) {
                    if (oracleDriverExtension == null) {
                        this.driverExtensions[n3] = oracleDriverExtension = (OracleDriverExtension)Class.forName(driverExtensionClassNames[n3]).newInstance();
                    } else {
                        oracleDriverExtension = this.driverExtensions[n3];
                    }
                }
            }
            catch (Exception exception) {
                throw new SQLException(exception.toString());
            }
        }
        if ((object2 = this.parseUrl(string)) == null) {
            return null;
        }
        String string15 = properties.getProperty(user_string);
        String string16 = properties.getProperty(password_string);
        String string17 = properties.getProperty(database_string);
        if (string17 == null) {
            string17 = properties.getProperty(server_string);
        }
        if (string15 == null) {
            string15 = (String)((Hashtable)object2).get(user_string);
        }
        string15 = this.parseLoginOption(string15, properties);
        if (string16 == null) {
            string16 = (String)((Hashtable)object2).get(password_string);
        }
        if (string17 == null) {
            string17 = (String)((Hashtable)object2).get(database_string);
        }
        String string18 = (String)((Hashtable)object2).get(protocol_string);
        ((Hashtable)properties).put(protocol_string, string18);
        if (string18 == null) {
            DatabaseError.throwSqlException(40, "Protocol is not specified in URL");
            return null;
        }
        if (string18.equals("oci8") || string18.equals("oci")) {
            string17 = this.translateConnStr(string17);
        }
        if ((string13 = properties.getProperty(tcp_no_delay)) == null) {
            string13 = OracleDriver.getSystemProperty(tcp_no_delay, null);
        }
        if (string13 != null && string13.equalsIgnoreCase("true")) {
            ((Hashtable)properties).put("TCP.NODELAY", "YES");
        }
        if ((string12 = properties.getProperty(read_timeout)) != null) {
            ((Hashtable)properties).put("oracle.net.READ_TIMEOUT", string12);
        }
        if ((n2 = DriverManager.getLoginTimeout()) != 0 && ((Hashtable)properties).get("oracle.net.CONNECT_TIMEOUT") == null) {
            ((Hashtable)properties).put("oracle.net.CONNECT_TIMEOUT", String.valueOf(n2 * 1000));
        }
        if ((string11 = properties.getProperty(prefetch_string)) == null) {
            string11 = properties.getProperty(row_prefetch_string);
        }
        if (string11 == null) {
            string11 = properties.getProperty(default_row_prefetch_string);
        }
        if (string11 != null && Integer.parseInt(string11) <= 0) {
            string11 = null;
        }
        if ((string10 = properties.getProperty(batch_string)) == null) {
            string10 = properties.getProperty(execute_batch_string);
        }
        if (string10 == null) {
            string10 = properties.getProperty(default_execute_batch_string);
        }
        if (string10 != null && Integer.parseInt(string10) <= 0) {
            string10 = null;
        }
        if ((string9 = properties.getProperty(defaultncharprop_string)) == null) {
            string9 = OracleDriver.getSystemProperty(defaultnchar_string, null);
        }
        if ((string8 = properties.getProperty(useFetchSizeWithLongColumn_prop_string)) == null) {
            string8 = OracleDriver.getSystemProperty(useFetchSizeWithLongColumn_string, null);
        }
        if ((string7 = properties.getProperty(remarks_string)) == null) {
            string7 = properties.getProperty(report_remarks_string);
        }
        if ((string6 = properties.getProperty(synonyms_string)) == null) {
            string6 = properties.getProperty(include_synonyms_string);
        }
        String string19 = properties.getProperty(restrict_getTables_string);
        String string20 = properties.getProperty(fixed_string_string);
        String string21 = properties.getProperty(accumulate_batch_result);
        if (string21 == null) {
            string21 = "true";
        }
        if ((string5 = properties.getProperty(disable_defineColumnType_string)) == null) {
            string5 = "false";
        }
        if ((string4 = properties.getProperty(convert_nchar_literals_string)) == null) {
            string4 = OracleDriver.getSystemProperty(convert_nchar_literals_string, "false");
        }
        Enumeration<Driver> enumeration = DriverManager.getDrivers();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (object instanceof OracleDriver) break;
        }
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (!(object instanceof OracleDriver)) continue;
            DriverManager.deregisterDriver((Driver)object);
        }
        object = (PhysicalConnection)oracleDriverExtension.getConnection(string, string15, string16, string17, properties);
        if (string11 != null) {
            ((PhysicalConnection)object).setDefaultRowPrefetch(Integer.parseInt(string11));
        }
        if (string10 != null) {
            ((PhysicalConnection)object).setDefaultExecuteBatch(Integer.parseInt(string10));
        }
        if (string7 != null) {
            ((PhysicalConnection)object).setRemarksReporting(string7.equalsIgnoreCase("true"));
        }
        if (string6 != null) {
            ((PhysicalConnection)object).setIncludeSynonyms(string6.equalsIgnoreCase("true"));
        }
        if (string19 != null) {
            ((PhysicalConnection)object).setRestrictGetTables(string19.equalsIgnoreCase("true"));
        }
        if (string20 != null) {
            ((PhysicalConnection)object).setDefaultFixedString(string20.equalsIgnoreCase("true"));
        }
        if (string9 != null) {
            ((PhysicalConnection)object).setDefaultNChar(string9.equalsIgnoreCase("true"));
        }
        if (string8 != null) {
            ((PhysicalConnection)object).useFetchSizeWithLongColumn = string8.equalsIgnoreCase("true");
        }
        if (string21 != null) {
            ((PhysicalConnection)object).setAccumulateBatchResult(string21.equalsIgnoreCase("true"));
        }
        if ((string3 = OracleDriver.getSystemProperty(j2ee_compliance, null)) == null) {
            string2 = properties.getProperty(j2ee_compliance);
            if (string2 == null) {
                string2 = "false";
            }
        } else {
            string2 = string3;
        }
        ((PhysicalConnection)object).setJ2EE13Compliant(string2.equalsIgnoreCase("true"));
        ((PhysicalConnection)object).disableDefineColumnType = string5.equalsIgnoreCase("true");
        ((PhysicalConnection)object).convertNcharLiterals = string4.equalsIgnoreCase("true");
        object2 = null;
        ((PhysicalConnection)object).protocolId = n3;
        return object;
    }

    public Connection defaultConnection() throws SQLException {
        if (defaultConn == null || defaultConn.isClosed()) {
            Class clazz = class$oracle$jdbc$driver$OracleDriver != null ? class$oracle$jdbc$driver$OracleDriver : (class$oracle$jdbc$driver$OracleDriver = OracleDriver.class$("oracle.jdbc.driver.OracleDriver"));
            synchronized (clazz) {
                if (defaultConn == null || defaultConn.isClosed()) {
                    defaultConn = DriverManager.getConnection("jdbc:oracle:kprb:");
                }
            }
        }
        return defaultConn;
    }

    public static String getCompileTime() {
        return BUILD_DATE;
    }

    public int getMajorVersion() {
        return OracleDatabaseMetaData.getDriverMajorVersionInfo();
    }

    public int getMinorVersion() {
        return OracleDatabaseMetaData.getDriverMinorVersionInfo();
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    private static String getSystemProperty(String string) {
        return OracleDriver.getSystemProperty(string, null);
    }

    private static String getSystemProperty(String string, String string2) {
        if (string != null) {
            final String string3 = string;
            final String string4 = string2;
            final String[] stringArray = new String[]{string2};
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    stringArray[0] = System.getProperty(string3, string4);
                    return null;
                }
            });
            return stringArray[0];
        }
        return string2;
    }

    public static String getSystemPropertyFastConnectionFailover(String string) {
        return OracleDriver.getSystemProperty("oracle.jdbc.FastConnectionFailover", string);
    }

    public static String getSystemPropertyJserverVersion() {
        return OracleDriver.getSystemProperty("oracle.jserver.version", null);
    }

    protected static String getSystemPropertyPollInterval() {
        return OracleDriver.getSystemProperty("oracle.jdbc.TimeoutPollInterval", "1000");
    }

    protected static String getSystemPropertyUserName() {
        return OracleDriver.getSystemProperty("user.name", null);
    }

    protected static String getSystemPropertyV8Compatible() {
        return OracleDriver.getSystemProperty(v8compatible_string, null);
    }

    public boolean jdbcCompliant() {
        return true;
    }

    private int oracleDriverExtensionTypeFromURL(String string) {
        int n2;
        int n3 = string.indexOf(58) + 1;
        if (n3 == 0) {
            return -2;
        }
        int n4 = string.indexOf(58, n3);
        if (n4 == -1) {
            return -2;
        }
        if (!string.regionMatches(true, n3, oracle_string, 0, n4 - n3)) {
            return -2;
        }
        if ((n2 = string.indexOf(58, ++n4)) == -1) {
            return -3;
        }
        String string2 = string.substring(n4, n2);
        if (string2.equals("thin")) {
            return 0;
        }
        if (string2.equals("oci8") || string2.equals("oci")) {
            return 2;
        }
        return -3;
    }

    private String parseLoginOption(String string, Properties properties) {
        String string2;
        int n2 = 0;
        String string3 = null;
        String string4 = null;
        if (string == null) {
            return null;
        }
        int n3 = string.length();
        if (n3 == 0) {
            return null;
        }
        int n4 = string.indexOf(91);
        if (n4 > 0) {
            n2 = string.indexOf(93);
            string4 = string.substring(n4 + 1, n2);
            if ((string4 = string4.trim()).length() > 0) {
                ((Hashtable)properties).put(proxy_client_name, string4);
            }
            string = String.valueOf(string.substring(0, n4)) + string.substring(n2 + 1, n3);
        }
        if ((n4 = (string2 = string.toLowerCase()).lastIndexOf(" as ")) == -1 || n4 < string2.lastIndexOf("\"")) {
            return string;
        }
        string3 = string.substring(0, n4);
        n4 += 4;
        while (n4 < n3 && string2.charAt(n4) == ' ') {
            ++n4;
        }
        if (n4 == n3) {
            return string;
        }
        String string5 = string2.substring(n4).trim();
        if (string5.length() > 0) {
            ((Hashtable)properties).put(logon_as_internal_str, string5);
        }
        return string3;
    }

    private Hashtable parseUrl(String string) throws SQLException {
        int n2;
        Hashtable<String, String> hashtable = new Hashtable<String, String>(5);
        int n3 = string.indexOf(58, string.indexOf(58) + 1) + 1;
        if (n3 == (n2 = string.length())) {
            return hashtable;
        }
        int n4 = string.indexOf(58, n3);
        if (n4 == -1) {
            return hashtable;
        }
        hashtable.put(protocol_string, string.substring(n3, n4));
        int n5 = n4 + 1;
        int n6 = string.indexOf(47, n5);
        int n7 = string.indexOf(64, n5);
        if (n7 > n5 && n5 > n3 && n6 == -1) {
            return null;
        }
        if (n7 == -1) {
            n7 = n2;
        }
        if (n6 == -1) {
            n6 = n7;
        }
        if (n6 < n7 && n6 != n5 && n7 != n5) {
            hashtable.put(user_string, string.substring(n5, n6));
            hashtable.put(password_string, string.substring(n6 + 1, n7));
        }
        if (n7 < n2) {
            hashtable.put(database_string, string.substring(n7 + 1));
        }
        return hashtable;
    }

    public String processSqlEscapes(String string) throws SQLException {
        OracleSql oracleSql = new OracleSql(null);
        oracleSql.initialize(string);
        return oracleSql.parse(string);
    }

    private String translateConnStr(String string) throws SQLException {
        int n2 = 0;
        int n3 = 0;
        if (string == null) {
            return string;
        }
        n2 = string.indexOf(58);
        if (n2 == -1 || (n3 = string.indexOf(58, n2 + 1)) == -1) {
            return string;
        }
        if (string.indexOf(58, n3 + 1) != -1) {
            DatabaseError.throwSqlException(67, string);
        }
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2 + 1, n3);
        String string4 = string.substring(n3 + 1, string.length());
        String string5 = "(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(HOST=" + string2 + ")(PORT=" + string3 + "))(CONNECT_DATA=(SID=" + string4 + ")))";
        return string5;
    }
}

