/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.PlsqlIndexTableAccessor;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public abstract class OracleCallableStatement
extends OraclePreparedStatement
implements oracle.jdbc.internal.OracleCallableStatement {
    boolean atLeastOneOrdinalParameter = false;
    boolean atLeastOneNamedParameter = false;
    String[] namedParameters = new String[8];
    int parameterCount = 0;
    final String errMsgMixedBind = "Ordinal binding and Named binding cannot be combined!";
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:40_PDT_2005";

    OracleCallableStatement(PhysicalConnection physicalConnection, String string, int n2, int n3) throws SQLException {
        this(physicalConnection, string, n2, n3, 1003, 1007);
    }

    OracleCallableStatement(PhysicalConnection physicalConnection, String string, int n2, int n3, int n4, int n5) throws SQLException {
        super(physicalConnection, string, 1, n3, n4, n5);
        this.statementType = 2;
    }

    public void addBatch() throws SQLException {
        if (this.currentRowBindAccessors != null) {
            DatabaseError.throwSqlException(90, "Stored procedure with out or inout parameters cannot be batched");
        }
        super.addBatch();
    }

    int addNamedPara(String string) throws SQLException {
        String string2 = string.toUpperCase().intern();
        int n2 = 0;
        while (n2 < this.parameterCount) {
            if (string2 == this.namedParameters[n2]) {
                return n2 + 1;
            }
            ++n2;
        }
        if (this.parameterCount >= this.namedParameters.length) {
            String[] stringArray = new String[this.namedParameters.length * 2];
            System.arraycopy(this.namedParameters, 0, stringArray, 0, this.namedParameters.length);
            this.namedParameters = stringArray;
        }
        this.namedParameters[this.parameterCount++] = string2;
        this.atLeastOneNamedParameter = true;
        return this.parameterCount;
    }

    PlsqlIndexTableAccessor allocateIndexTableAccessor(int n2, int n3, int n4, int n5, short s2, boolean bl2) throws SQLException {
        return new PlsqlIndexTableAccessor(this, n2, n3, n4, n5, s2, bl2);
    }

    protected void alwaysOnClose() throws SQLException {
        this.sqlObject.resetNamedParameters();
        this.parameterCount = 0;
        this.atLeastOneOrdinalParameter = false;
        this.atLeastOneNamedParameter = false;
        super.alwaysOnClose();
    }

    public synchronized void clearParameters() throws SQLException {
        super.clearParameters();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean execute() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleCallableStatement oracleCallableStatement = this;
            synchronized (oracleCallableStatement) {
                this.ensureOpen();
                if (this.atLeastOneNamedParameter && this.atLeastOneOrdinalParameter) {
                    DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
                }
                if (!this.sqlObject.setNamedParameters(this.parameterCount, this.namedParameters)) return super.execute();
                this.needToParse = true;
                return super.execute();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int executeUpdate() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleCallableStatement oracleCallableStatement = this;
            synchronized (oracleCallableStatement) {
                this.ensureOpen();
                if (this.atLeastOneNamedParameter && this.atLeastOneOrdinalParameter) {
                    DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
                }
                if (!this.sqlObject.setNamedParameters(this.parameterCount, this.namedParameters)) return super.executeUpdate();
                this.needToParse = true;
                return super.executeUpdate();
            }
        }
    }

    public ARRAY getARRAY(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getARRAY(this.currentRank);
    }

    public Object getAnyDataEmbeddedObject(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getAnyDataEmbeddedObject(this.currentRank);
    }

    public Array getArray(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getARRAY(this.currentRank);
    }

    public Array getArray(String string) throws SQLException {
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        int n2 = 0;
        while (n2 < this.parameterCount) {
            if (string2 == this.namedParameters[n2]) break;
            ++n2;
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getARRAY(this.currentRank);
    }

    public InputStream getAsciiStream(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getAsciiStream(this.currentRank);
    }

    public BFILE getBFILE(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getBFILE(this.currentRank);
    }

    public BLOB getBLOB(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getBLOB(this.currentRank);
    }

    public BigDecimal getBigDecimal(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getBigDecimal(this.currentRank);
    }

    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getBigDecimal(this.currentRank);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        int n2 = 0;
        while (n2 < this.parameterCount) {
            if (string2 == this.namedParameters[n2]) break;
            ++n2;
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getBigDecimal(this.currentRank);
    }

    public InputStream getBinaryStream(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getBinaryStream(this.currentRank);
    }

    public Blob getBlob(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getBLOB(this.currentRank);
    }

    public Blob getBlob(String string) throws SQLException {
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        int n2 = 0;
        while (n2 < this.parameterCount) {
            if (string2 == this.namedParameters[n2]) break;
            ++n2;
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getBLOB(this.currentRank);
    }

    public boolean getBoolean(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getBoolean(this.currentRank);
    }

    public boolean getBoolean(String string) throws SQLException {
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        int n2 = 0;
        while (n2 < this.parameterCount) {
            if (string2 == this.namedParameters[n2]) break;
            ++n2;
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getBoolean(this.currentRank);
    }

    public byte getByte(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getByte(this.currentRank);
    }

    public byte getByte(String string) throws SQLException {
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        int n2 = 0;
        while (n2 < this.parameterCount) {
            if (string2 == this.namedParameters[n2]) break;
            ++n2;
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getByte(this.currentRank);
    }

    public byte[] getBytes(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getBytes(this.currentRank);
    }

    public byte[] getBytes(String string) throws SQLException {
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        int n2 = 0;
        while (n2 < this.parameterCount) {
            if (string2 == this.namedParameters[n2]) break;
            ++n2;
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getBytes(this.currentRank);
    }

    public CHAR getCHAR(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getCHAR(this.currentRank);
    }

    public CLOB getCLOB(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getCLOB(this.currentRank);
    }

    public Reader getCharacterStream(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getCharacterStream(this.currentRank);
    }

    public Clob getClob(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getCLOB(this.currentRank);
    }

    public Clob getClob(String string) throws SQLException {
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        int n2 = 0;
        while (n2 < this.parameterCount) {
            if (string2 == this.namedParameters[n2]) break;
            ++n2;
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getCLOB(this.currentRank);
    }

    public ResultSet getCursor(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getCursor(this.currentRank);
    }

    public Object getCustomDatum(int n2, CustomDatumFactory customDatumFactory) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getCustomDatum(this.currentRank, customDatumFactory);
    }

    public DATE getDATE(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getDATE(this.currentRank);
    }

    public Date getDate(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getDate(this.currentRank);
    }

    public Date getDate(int n2, Calendar calendar) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getDate(this.currentRank, calendar);
    }

    public Date getDate(String string) throws SQLException {
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        int n2 = 0;
        while (n2 < this.parameterCount) {
            if (string2 == this.namedParameters[n2]) break;
            ++n2;
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getDate(this.currentRank);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        int n2 = 0;
        while (n2 < this.parameterCount) {
            if (string2 == this.namedParameters[n2]) break;
            ++n2;
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getDate(this.currentRank, calendar);
    }

    public double getDouble(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getDouble(this.currentRank);
    }

    public double getDouble(String string) throws SQLException {
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        int n2 = 0;
        while (n2 < this.parameterCount) {
            if (string2 == this.namedParameters[n2]) break;
            ++n2;
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getDouble(this.currentRank);
    }

    public float getFloat(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getFloat(this.currentRank);
    }

    public float getFloat(String string) throws SQLException {
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        int n2 = 0;
        while (n2 < this.parameterCount) {
            if (string2 == this.namedParameters[n2]) break;
            ++n2;
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getFloat(this.currentRank);
    }

    public INTERVALDS getINTERVALDS(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getINTERVALDS(this.currentRank);
    }

    public INTERVALYM getINTERVALYM(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getINTERVALYM(this.currentRank);
    }

    public int getInt(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getInt(this.currentRank);
    }

    public int getInt(String string) throws SQLException {
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        int n2 = 0;
        while (n2 < this.parameterCount) {
            if (string2 == this.namedParameters[n2]) break;
            ++n2;
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getInt(this.currentRank);
    }

    public long getLong(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getLong(this.currentRank);
    }

    public long getLong(String string) throws SQLException {
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        int n2 = 0;
        while (n2 < this.parameterCount) {
            if (string2 == this.namedParameters[n2]) break;
            ++n2;
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getLong(this.currentRank);
    }

    public NUMBER getNUMBER(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getNUMBER(this.currentRank);
    }

    public OPAQUE getOPAQUE(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getOPAQUE(this.currentRank);
    }

    public Object getORAData(int n2, ORADataFactory oRADataFactory) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getORAData(this.currentRank, oRADataFactory);
    }

    public Object getObject(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getObject(this.currentRank);
    }

    public Object getObject(int n2, Map map) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getObject(this.currentRank, map);
    }

    public Object getObject(String string) throws SQLException {
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        int n2 = 0;
        while (n2 < this.parameterCount) {
            if (string2 == this.namedParameters[n2]) break;
            ++n2;
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getObject(this.currentRank);
    }

    public Object getObject(String string, Map map) throws SQLException {
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        int n2 = 0;
        while (n2 < this.parameterCount) {
            if (string2 == this.namedParameters[n2]) break;
            ++n2;
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getObject(this.currentRank, map);
    }

    public Datum getOracleObject(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getOracleObject(this.currentRank);
    }

    public synchronized Datum[] getOraclePlsqlIndexTable(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getOraclePlsqlIndexTable(this.currentRank);
    }

    public synchronized Object getPlsqlIndexTable(int n2) throws SQLException {
        Datum[] datumArray = this.getOraclePlsqlIndexTable(n2);
        PlsqlIndexTableAccessor plsqlIndexTableAccessor = (PlsqlIndexTableAccessor)this.outBindAccessors[n2 - 1];
        int n3 = plsqlIndexTableAccessor.elementInternalType;
        Object[] objectArray = null;
        switch (n3) {
            case 9: {
                objectArray = new String[datumArray.length];
                break;
            }
            case 6: {
                objectArray = new BigDecimal[datumArray.length];
                break;
            }
            default: {
                DatabaseError.throwSqlException(1, "Invalid column type");
            }
        }
        int n4 = 0;
        while (n4 < objectArray.length) {
            objectArray[n4] = datumArray[n4] != null && datumArray[n4].getLength() != 0L ? datumArray[n4].toJdbc() : null;
            ++n4;
        }
        return objectArray;
    }

    public synchronized Object getPlsqlIndexTable(int n2, Class clazz) throws SQLException {
        String string;
        Datum[] datumArray = this.getOraclePlsqlIndexTable(n2);
        if (clazz == null || !clazz.isPrimitive()) {
            DatabaseError.throwSqlException(68);
        }
        if ((string = clazz.getName()).equals("byte")) {
            byte[] byArray = new byte[datumArray.length];
            int n3 = 0;
            while (n3 < datumArray.length) {
                byArray[n3] = datumArray[n3] != null ? datumArray[n3].byteValue() : (byte)0;
                ++n3;
            }
            return byArray;
        }
        if (string.equals("char")) {
            char[] cArray = new char[datumArray.length];
            int n4 = 0;
            while (n4 < datumArray.length) {
                cArray[n4] = datumArray[n4] != null && datumArray[n4].getLength() != 0L ? (char)datumArray[n4].intValue() : (char)'\u0000';
                ++n4;
            }
            return cArray;
        }
        if (string.equals("double")) {
            double[] dArray = new double[datumArray.length];
            int n5 = 0;
            while (n5 < datumArray.length) {
                dArray[n5] = datumArray[n5] != null && datumArray[n5].getLength() != 0L ? datumArray[n5].doubleValue() : 0.0;
                ++n5;
            }
            return dArray;
        }
        if (string.equals("float")) {
            float[] fArray = new float[datumArray.length];
            int n6 = 0;
            while (n6 < datumArray.length) {
                fArray[n6] = datumArray[n6] != null && datumArray[n6].getLength() != 0L ? datumArray[n6].floatValue() : 0.0f;
                ++n6;
            }
            return fArray;
        }
        if (string.equals("int")) {
            int[] nArray = new int[datumArray.length];
            int n7 = 0;
            while (n7 < datumArray.length) {
                nArray[n7] = datumArray[n7] != null && datumArray[n7].getLength() != 0L ? datumArray[n7].intValue() : 0;
                ++n7;
            }
            return nArray;
        }
        if (string.equals("long")) {
            long[] lArray = new long[datumArray.length];
            int n8 = 0;
            while (n8 < datumArray.length) {
                lArray[n8] = datumArray[n8] != null && datumArray[n8].getLength() != 0L ? datumArray[n8].longValue() : 0L;
                ++n8;
            }
            return lArray;
        }
        if (string.equals("short")) {
            short[] sArray = new short[datumArray.length];
            int n9 = 0;
            while (n9 < datumArray.length) {
                sArray[n9] = datumArray[n9] != null && datumArray[n9].getLength() != 0L ? (short)datumArray[n9].intValue() : (short)0;
                ++n9;
            }
            return sArray;
        }
        if (string.equals("boolean")) {
            boolean[] blArray = new boolean[datumArray.length];
            int n10 = 0;
            while (n10 < datumArray.length) {
                blArray[n10] = datumArray[n10] != null && datumArray[n10].getLength() != 0L ? datumArray[n10].booleanValue() : false;
                ++n10;
            }
            return blArray;
        }
        DatabaseError.throwSqlException(23);
        return null;
    }

    public RAW getRAW(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getRAW(this.currentRank);
    }

    public REF getREF(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getREF(this.currentRank);
    }

    public ROWID getROWID(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getROWID(this.currentRank);
    }

    public Ref getRef(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getREF(this.currentRank);
    }

    public Ref getRef(String string) throws SQLException {
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        int n2 = 0;
        while (n2 < this.parameterCount) {
            if (string2 == this.namedParameters[n2]) break;
            ++n2;
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getREF(this.currentRank);
    }

    public STRUCT getSTRUCT(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getSTRUCT(this.currentRank);
    }

    public short getShort(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getShort(this.currentRank);
    }

    public short getShort(String string) throws SQLException {
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        int n2 = 0;
        while (n2 < this.parameterCount) {
            if (string2 == this.namedParameters[n2]) break;
            ++n2;
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getShort(this.currentRank);
    }

    public String getString(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getString(this.currentRank);
    }

    public String getString(String string) throws SQLException {
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        int n2 = 0;
        while (n2 < this.parameterCount) {
            if (string2 == this.namedParameters[n2]) break;
            ++n2;
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getString(this.currentRank);
    }

    public TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getTIMESTAMP(this.currentRank);
    }

    public TIMESTAMPLTZ getTIMESTAMPLTZ(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getTIMESTAMPLTZ(this.currentRank);
    }

    public TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getTIMESTAMPTZ(this.currentRank);
    }

    public Time getTime(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getTime(this.currentRank);
    }

    public Time getTime(int n2, Calendar calendar) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getTime(this.currentRank, calendar);
    }

    public Time getTime(String string) throws SQLException {
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        int n2 = 0;
        while (n2 < this.parameterCount) {
            if (string2 == this.namedParameters[n2]) break;
            ++n2;
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getTime(this.currentRank);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        int n2 = 0;
        while (n2 < this.parameterCount) {
            if (string2 == this.namedParameters[n2]) break;
            ++n2;
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getTime(this.currentRank, calendar);
    }

    public Timestamp getTimestamp(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getTimestamp(this.currentRank);
    }

    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getTimestamp(this.currentRank, calendar);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        int n2 = 0;
        while (n2 < this.parameterCount) {
            if (string2 == this.namedParameters[n2]) break;
            ++n2;
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getTimestamp(this.currentRank);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        int n2 = 0;
        while (n2 < this.parameterCount) {
            if (string2 == this.namedParameters[n2]) break;
            ++n2;
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getTimestamp(this.currentRank, calendar);
    }

    public URL getURL(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getURL(this.currentRank);
    }

    public URL getURL(String string) throws SQLException {
        if (!this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        String string2 = string.toUpperCase().intern();
        int n2 = 0;
        while (n2 < this.parameterCount) {
            if (string2 == this.namedParameters[n2]) break;
            ++n2;
        }
        Accessor accessor = null;
        if (++n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(6);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getURL(this.currentRank);
    }

    public InputStream getUnicodeStream(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.getUnicodeStream(this.currentRank);
    }

    public byte[] privateGetBytes(int n2) throws SQLException {
        if (this.atLeastOneNamedParameter) {
            DatabaseError.throwSqlException(90, "Ordinal binding and Named binding cannot be combined!");
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            DatabaseError.throwSqlException(3);
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.privateGetBytes(this.currentRank);
    }

    public synchronized void registerIndexTableOutParameter(int n2, int n3, int n4, int n5) throws SQLException {
        int n6 = n2 - 1;
        if (n6 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        int n7 = this.getInternalType(n4);
        this.resetBatch();
        this.currentRowNeedToPrepareBinds = true;
        if (this.currentRowBindAccessors == null) {
            this.currentRowBindAccessors = new Accessor[this.numberOfBindPositions];
        }
        this.currentRowBindAccessors[n6] = this.allocateIndexTableAccessor(n4, n7, n5, n3, this.currentRowFormOfUse[n6], true);
        this.hasIbtBind = true;
    }

    public void registerOutParameter(int n2, int n3) throws SQLException {
        this.registerOutParameter(n2, n3, 0, -1);
    }

    public void registerOutParameter(int n2, int n3, int n4) throws SQLException {
        this.registerOutParameter(n2, n3, n4, -1);
    }

    public synchronized void registerOutParameter(int n2, int n3, int n4, int n5) throws SQLException {
        this.registerOutParameterInternal(n2, n3, n4, n5, null);
    }

    public void registerOutParameter(int n2, int n3, String string) throws SQLException {
        if (string == null || string.length() == 0) {
            DatabaseError.throwSqlException(60, "empty Object name");
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleCallableStatement oracleCallableStatement = this;
            synchronized (oracleCallableStatement) {
                this.registerOutParameterInternal(n2, n3, 0, 0, string);
            }
        }
    }

    public void registerOutParameter(String string, int n2) throws SQLException {
        this.registerOutParameter(string, n2, 0, -1);
    }

    public void registerOutParameter(String string, int n2, int n3) throws SQLException {
        this.registerOutParameter(string, n2, n3, -1);
    }

    public synchronized void registerOutParameter(String string, int n2, int n3, int n4) throws SQLException {
        int n5 = this.addNamedPara(string);
        this.registerOutParameter(n5, n2, n3, n4);
    }

    public void registerOutParameter(String string, int n2, String string2) throws SQLException {
        int n3 = this.addNamedPara(string);
        this.registerOutParameter(n3, n2, string2);
    }

    public synchronized void registerOutParameterBytes(int n2, int n3, int n4, int n5) throws SQLException {
        this.registerOutParameterInternal(n2, n3, n4, n5, null);
    }

    public synchronized void registerOutParameterChars(int n2, int n3, int n4, int n5) throws SQLException {
        this.registerOutParameterInternal(n2, n3, n4, n5, null);
    }

    void registerOutParameterInternal(int n2, int n3, int n4, int n5, String string) throws SQLException {
        int n6 = n2 - 1;
        if (n6 < 0 || n2 > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if (n3 == 0) {
            DatabaseError.throwSqlException(4);
        }
        int n7 = this.getInternalType(n3);
        this.resetBatch();
        this.currentRowNeedToPrepareBinds = true;
        if (this.currentRowBindAccessors == null) {
            this.currentRowBindAccessors = new Accessor[this.numberOfBindPositions];
        }
        this.currentRowBindAccessors[n6] = this.allocateAccessor(n7, n3, n6 + 1, n5, this.currentRowFormOfUse[n6], string, true);
    }

    void resetBatch() {
        this.batch = 1;
    }

    public synchronized int sendBatch() throws SQLException {
        return this.validRows;
    }

    public void setARRAY(int n2, ARRAY aRRAY) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setARRAYInternal(n2, aRRAY);
    }

    public void setArray(int n2, Array array) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setArrayInternal(n2, array);
    }

    public synchronized void setAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setAsciiStreamInternal(n2, inputStream, n3);
    }

    public void setAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        int n3 = this.addNamedPara(string);
        this.setAsciiStreamInternal(n3, inputStream, n2);
    }

    public synchronized void setBFILE(int n2, BFILE bFILE) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setBFILEInternal(n2, bFILE);
    }

    public synchronized void setBLOB(int n2, BLOB bLOB) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setBLOBInternal(n2, bLOB);
    }

    public synchronized void setBfile(int n2, BFILE bFILE) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setBfileInternal(n2, bFILE);
    }

    public synchronized void setBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setBigDecimalInternal(n2, bigDecimal);
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setBigDecimalInternal(n2, bigDecimal);
    }

    public synchronized void setBinaryDouble(int n2, double d2) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setBinaryDoubleInternal(n2, d2);
    }

    public synchronized void setBinaryDouble(int n2, BINARY_DOUBLE bINARY_DOUBLE) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setBinaryDoubleInternal(n2, bINARY_DOUBLE);
    }

    public void setBinaryDouble(String string, double d2) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setBinaryDoubleInternal(n2, d2);
    }

    public void setBinaryDouble(String string, BINARY_DOUBLE bINARY_DOUBLE) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setBinaryDoubleInternal(n2, bINARY_DOUBLE);
    }

    public synchronized void setBinaryFloat(int n2, float f2) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setBinaryFloatInternal(n2, f2);
    }

    public synchronized void setBinaryFloat(int n2, BINARY_FLOAT bINARY_FLOAT) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setBinaryFloatInternal(n2, bINARY_FLOAT);
    }

    public void setBinaryFloat(String string, float f2) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setBinaryFloatInternal(n2, f2);
    }

    public void setBinaryFloat(String string, BINARY_FLOAT bINARY_FLOAT) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setBinaryFloatInternal(n2, bINARY_FLOAT);
    }

    public synchronized void setBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setBinaryStreamInternal(n2, inputStream, n3);
    }

    public void setBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        int n3 = this.addNamedPara(string);
        this.setBinaryStreamInternal(n3, inputStream, n2);
    }

    public synchronized void setBlob(int n2, Blob blob) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setBlobInternal(n2, blob);
    }

    public synchronized void setBoolean(int n2, boolean bl2) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setBooleanInternal(n2, bl2);
    }

    public void setBoolean(String string, boolean bl2) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setBooleanInternal(n2, bl2);
    }

    public synchronized void setByte(int n2, byte by) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setByteInternal(n2, by);
    }

    public void setByte(String string, byte by) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setByteInternal(n2, by);
    }

    public synchronized void setBytes(int n2, byte[] byArray) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setBytesInternal(n2, byArray);
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setBytesInternal(n2, byArray);
    }

    public void setBytesForBlob(int n2, byte[] byArray) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            this.setNull(n2, 2004);
            return;
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            PhysicalConnection physicalConnection2 = this.connection;
            synchronized (physicalConnection2) {
                this.setBytesForBlobCritical(n2, byArray);
            }
        }
    }

    public void setBytesForBlob(String string, byte[] byArray) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setBytesForBlob(n2, byArray);
    }

    public synchronized void setCHAR(int n2, CHAR cHAR) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setCHARInternal(n2, cHAR);
    }

    public synchronized void setCLOB(int n2, CLOB cLOB) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setCLOBInternal(n2, cLOB);
    }

    public synchronized void setCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setCharacterStreamInternal(n2, reader, n3);
    }

    public void setCharacterStream(String string, Reader reader, int n2) throws SQLException {
        int n3 = this.addNamedPara(string);
        this.setCharacterStreamInternal(n3, reader, n2);
    }

    public synchronized void setClob(int n2, Clob clob) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setClobInternal(n2, clob);
    }

    public synchronized void setCursor(int n2, ResultSet resultSet) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setCursorInternal(n2, resultSet);
    }

    public void setCustomDatum(int n2, CustomDatum customDatum) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setCustomDatumInternal(n2, customDatum);
    }

    public synchronized void setDATE(int n2, DATE dATE) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setDATEInternal(n2, dATE);
    }

    public synchronized void setDate(int n2, Date date) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setDateInternal(n2, date);
    }

    public synchronized void setDate(int n2, Date date, Calendar calendar) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setDateInternal(n2, date, calendar);
    }

    public void setDate(String string, Date date) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setDateInternal(n2, date);
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setDateInternal(n2, date, calendar);
    }

    public synchronized void setDouble(int n2, double d2) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setDoubleInternal(n2, d2);
    }

    public void setDouble(String string, double d2) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setDoubleInternal(n2, d2);
    }

    public synchronized void setExecuteBatch(int n2) throws SQLException {
    }

    public synchronized void setFixedCHAR(int n2, String string) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setFixedCHARInternal(n2, string);
    }

    public synchronized void setFloat(int n2, float f2) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setFloatInternal(n2, f2);
    }

    public void setFloat(String string, float f2) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setFloatInternal(n2, f2);
    }

    public synchronized void setINTERVALDS(int n2, INTERVALDS iNTERVALDS) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setINTERVALDSInternal(n2, iNTERVALDS);
    }

    public synchronized void setINTERVALYM(int n2, INTERVALYM iNTERVALYM) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setINTERVALYMInternal(n2, iNTERVALYM);
    }

    public synchronized void setInt(int n2, int n3) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setIntInternal(n2, n3);
    }

    public void setInt(String string, int n2) throws SQLException {
        int n3 = this.addNamedPara(string);
        this.setIntInternal(n3, n2);
    }

    public synchronized void setInternalBytes(int n2, byte[] byArray, int n3) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setInternalBytesInternal(n2, byArray, n3);
    }

    public synchronized void setLong(int n2, long l2) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setLongInternal(n2, l2);
    }

    public void setLong(String string, long l2) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setLongInternal(n2, l2);
    }

    public synchronized void setNUMBER(int n2, NUMBER nUMBER) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setNUMBERInternal(n2, nUMBER);
    }

    public synchronized void setNull(int n2, int n3) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setNullInternal(n2, n3);
    }

    public synchronized void setNull(int n2, int n3, String string) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setNullInternal(n2, n3, string);
    }

    public void setNull(String string, int n2) throws SQLException {
        int n3 = this.addNamedPara(string);
        this.setNullInternal(n3, n2);
    }

    public void setNull(String string, int n2, String string2) throws SQLException {
        int n3 = this.addNamedPara(string);
        this.setNullInternal(n3, n2, string2);
    }

    public void setOPAQUE(int n2, OPAQUE oPAQUE) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setOPAQUEInternal(n2, oPAQUE);
    }

    public void setORAData(int n2, ORAData oRAData) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setORADataInternal(n2, oRAData);
    }

    public void setObject(int n2, Object object) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setObjectInternal(n2, object);
    }

    public void setObject(int n2, Object object, int n3) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setObjectInternal(n2, object, n3);
    }

    public void setObject(int n2, Object object, int n3, int n4) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setObjectInternal(n2, object, n3, n4);
    }

    public void setObject(String string, Object object) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setObjectInternal(n2, object);
    }

    public void setObject(String string, Object object, int n2) throws SQLException {
        this.setObject(string, object, n2, 0);
    }

    public void setObject(String string, Object object, int n2, int n3) throws SQLException {
        int n4 = this.addNamedPara(string);
        this.setObjectInternal(n4, object, n2, n3);
    }

    public void setOracleObject(int n2, Datum datum) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setOracleObjectInternal(n2, datum);
    }

    public synchronized void setPlsqlIndexTable(int n2, Object object, int n3, int n4, int n5, int n6) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setPlsqlIndexTableInternal(n2, object, n3, n4, n5, n6);
    }

    public synchronized void setRAW(int n2, RAW rAW) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setRAWInternal(n2, rAW);
    }

    public void setREF(int n2, REF rEF) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setREFInternal(n2, rEF);
    }

    public synchronized void setROWID(int n2, ROWID rOWID) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setROWIDInternal(n2, rOWID);
    }

    public void setRef(int n2, Ref ref) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setRefInternal(n2, ref);
    }

    public void setRefType(int n2, REF rEF) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setRefTypeInternal(n2, rEF);
    }

    public void setSTRUCT(int n2, STRUCT sTRUCT) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setSTRUCTInternal(n2, sTRUCT);
    }

    public synchronized void setShort(int n2, short s2) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setShortInternal(n2, s2);
    }

    public void setShort(String string, short s2) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setShortInternal(n2, s2);
    }

    public synchronized void setString(int n2, String string) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setStringInternal(n2, string);
    }

    public void setString(String string, String string2) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setStringInternal(n2, string2);
    }

    public void setStringForClob(int n2, String string) throws SQLException {
        if (string == null || string.length() == 0) {
            this.setNull(n2, 2005);
            return;
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            PhysicalConnection physicalConnection2 = this.connection;
            synchronized (physicalConnection2) {
                this.setStringForClobCritical(n2, string);
            }
        }
    }

    public void setStringForClob(String string, String string2) throws SQLException {
        int n2 = this.addNamedPara(string);
        if (string2 == null || string2.length() == 0) {
            this.setNull(n2, 2005);
            return;
        }
        this.setStringForClob(n2, string2);
    }

    public void setStructDescriptor(int n2, StructDescriptor structDescriptor) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setStructDescriptorInternal(n2, structDescriptor);
    }

    public synchronized void setTIMESTAMP(int n2, TIMESTAMP tIMESTAMP) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setTIMESTAMPInternal(n2, tIMESTAMP);
    }

    public synchronized void setTIMESTAMPLTZ(int n2, TIMESTAMPLTZ tIMESTAMPLTZ) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setTIMESTAMPLTZInternal(n2, tIMESTAMPLTZ);
    }

    public synchronized void setTIMESTAMPTZ(int n2, TIMESTAMPTZ tIMESTAMPTZ) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setTIMESTAMPTZInternal(n2, tIMESTAMPTZ);
    }

    public synchronized void setTime(int n2, Time time) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setTimeInternal(n2, time);
    }

    public synchronized void setTime(int n2, Time time, Calendar calendar) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setTimeInternal(n2, time, calendar);
    }

    public void setTime(String string, Time time) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setTimeInternal(n2, time);
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setTimeInternal(n2, time, calendar);
    }

    public synchronized void setTimestamp(int n2, Timestamp timestamp) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setTimestampInternal(n2, timestamp);
    }

    public synchronized void setTimestamp(int n2, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setTimestampInternal(n2, timestamp, calendar);
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setTimestampInternal(n2, timestamp);
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setTimestampInternal(n2, timestamp, calendar);
    }

    public synchronized void setURL(int n2, URL uRL) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setURLInternal(n2, uRL);
    }

    public void setURL(String string, URL uRL) throws SQLException {
        int n2 = this.addNamedPara(string);
        this.setURLInternal(n2, uRL);
    }

    public synchronized void setUnicodeStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.atLeastOneOrdinalParameter = true;
        this.setUnicodeStreamInternal(n2, inputStream, n3);
    }

    public boolean wasNull() throws SQLException {
        return this.wasNullValue();
    }
}

