/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.sql.DATE;

abstract class DateTimeCommonAccessor
extends Accessor {
    static final int GREGORIAN_CUTOVER_YEAR = 1582;
    static final long GREGORIAN_CUTOVER = -12219292800000L;
    static final int JAN_1_1_JULIAN_DAY = 1721426;
    static final int EPOCH_JULIAN_DAY = 2440588;
    static final int ONE_SECOND = 1000;
    static final int ONE_MINUTE = 60000;
    static final int ONE_HOUR = 3600000;
    static final long ONE_DAY = 86400000L;
    static final int[] NUM_DAYS;
    static final int[] LEAP_NUM_DAYS;
    static final int ORACLE_CENTURY = 0;
    static final int ORACLE_YEAR = 1;
    static final int ORACLE_MONTH = 2;
    static final int ORACLE_DAY = 3;
    static final int ORACLE_HOUR = 4;
    static final int ORACLE_MIN = 5;
    static final int ORACLE_SEC = 6;
    static final int ORACLE_NANO1 = 7;
    static final int ORACLE_NANO2 = 8;
    static final int ORACLE_NANO3 = 9;
    static final int ORACLE_NANO4 = 10;
    static final int ORACLE_TZ1 = 11;
    static final int ORACLE_TZ2 = 12;
    static final int SIZE_DATE = 7;
    static final int MAX_TIMESTAMP_LENGTH = 11;
    static TimeZone epochTimeZone;
    static long epochTimeZoneOffset;

    static {
        int[] nArray = new int[12];
        nArray[1] = 31;
        nArray[2] = 59;
        nArray[3] = 90;
        nArray[4] = 120;
        nArray[5] = 151;
        nArray[6] = 181;
        nArray[7] = 212;
        nArray[8] = 243;
        nArray[9] = 273;
        nArray[10] = 304;
        nArray[11] = 334;
        NUM_DAYS = nArray;
        int[] nArray2 = new int[12];
        nArray2[1] = 31;
        nArray2[2] = 60;
        nArray2[3] = 91;
        nArray2[4] = 121;
        nArray2[5] = 152;
        nArray2[6] = 182;
        nArray2[7] = 213;
        nArray2[8] = 244;
        nArray2[9] = 274;
        nArray2[10] = 305;
        nArray2[11] = 335;
        LEAP_NUM_DAYS = nArray2;
    }

    DateTimeCommonAccessor() {
    }

    static long calculateEpochOffset(TimeZone timeZone) {
        return DateTimeCommonAccessor.zoneOffset(timeZone, 1970, 0, 1, 5, 0);
    }

    static final long computeJulianDay(boolean bl2, int n2, int n3, int n4) {
        boolean bl3 = n2 % 4 == 0;
        int n5 = n2 - 1;
        long l2 = 365L * (long)n5 + DateTimeCommonAccessor.floorDivide(n5, 4L) + 1721423L;
        if (bl2) {
            bl3 = bl3 && (n2 % 100 != 0 || n2 % 400 == 0);
            l2 += DateTimeCommonAccessor.floorDivide(n5, 400L) - DateTimeCommonAccessor.floorDivide(n5, 100L) + 2L;
        }
        return l2 + (long)n4 + (long)(bl3 ? LEAP_NUM_DAYS[n3] : NUM_DAYS[n3]);
    }

    static final long floorDivide(long l2, long l3) {
        return l2 >= 0L ? l2 / l3 : (l2 + 1L) / l3 - 1L;
    }

    DATE getDATE(int n2) throws SQLException {
        DATE dATE = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            int n3 = this.columnIndex + this.byteLength * n2;
            byte[] byArray = new byte[7];
            System.arraycopy(this.rowSpaceByte, n3, byArray, 0, 7);
            dATE = new DATE(byArray);
        }
        return dATE;
    }

    Date getDate(int n2) throws SQLException {
        Date date = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            int n3 = this.columnIndex + this.byteLength * n2;
            TimeZone timeZone = this.statement.getDefaultTimeZone();
            int n4 = ((this.rowSpaceByte[n3] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n3] & 0xFF) - 100;
            if (n4 <= 0) {
                ++n4;
            }
            date = new Date(DateTimeCommonAccessor.getMillis(n4, this.oracleMonth(n3), this.oracleDay(n3), 0, timeZone));
        }
        return date;
    }

    Date getDate(int n2, Calendar calendar) throws SQLException {
        if (calendar == null) {
            return this.getDate(n2);
        }
        Date date = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            int n3 = this.columnIndex + this.byteLength * n2;
            int n4 = ((this.rowSpaceByte[n3] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n3] & 0xFF) - 100;
            calendar.set(1, n4);
            calendar.set(2, this.oracleMonth(n3));
            calendar.set(5, this.oracleDay(n3));
            calendar.set(11, this.oracleHour(n3));
            calendar.set(12, this.oracleMin(n3));
            calendar.set(13, this.oracleSec(n3));
            calendar.set(14, 0);
            date = new Date(calendar.getTime().getTime());
        }
        return date;
    }

    static long getMillis(int n2, int n3, int n4, int n5, TimeZone timeZone) {
        long l2;
        long l3;
        boolean bl2 = n2 >= 1582;
        if (bl2 != (l3 = ((l2 = DateTimeCommonAccessor.computeJulianDay(bl2, n2, n3, n4)) - 2440588L) * 86400000L) >= -12219292800000L) {
            l2 = DateTimeCommonAccessor.computeJulianDay(bl2 ^ true, n2, n3, n4);
            l3 = (l2 - 2440588L) * 86400000L;
        }
        return (l3 += (long)n5) - DateTimeCommonAccessor.zoneOffset(timeZone, n2, n3, n4, DateTimeCommonAccessor.julianDayToDayOfWeek(l2), n5);
    }

    Time getTime(int n2) throws SQLException {
        Time time = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            int n3 = this.columnIndex + this.byteLength * n2;
            TimeZone timeZone = this.statement.getDefaultTimeZone();
            if (timeZone != epochTimeZone) {
                epochTimeZoneOffset = DateTimeCommonAccessor.calculateEpochOffset(timeZone);
                epochTimeZone = timeZone;
            }
            time = new Time((long)this.oracleTime(n3) - epochTimeZoneOffset);
        }
        return time;
    }

    Time getTime(int n2, Calendar calendar) throws SQLException {
        if (calendar == null) {
            return this.getTime(n2);
        }
        Time time = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            int n3 = this.columnIndex + this.byteLength * n2;
            int n4 = ((this.rowSpaceByte[n3] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n3] & 0xFF) - 100;
            calendar.set(1, 1970);
            calendar.set(2, 0);
            calendar.set(5, 1);
            calendar.set(11, this.oracleHour(n3));
            calendar.set(12, this.oracleMin(n3));
            calendar.set(13, this.oracleSec(n3));
            calendar.set(14, 0);
            time = new Time(calendar.getTime().getTime());
        }
        return time;
    }

    Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        if (calendar == null) {
            return this.getTimestamp(n2);
        }
        Timestamp timestamp = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            int n3 = this.columnIndex + this.byteLength * n2;
            int n4 = ((this.rowSpaceByte[n3] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n3] & 0xFF) - 100;
            calendar.set(1, n4);
            calendar.set(2, this.oracleMonth(n3));
            calendar.set(5, this.oracleDay(n3));
            calendar.set(11, this.oracleHour(n3));
            calendar.set(12, this.oracleMin(n3));
            calendar.set(13, this.oracleSec(n3));
            calendar.set(14, 0);
            timestamp = new Timestamp(calendar.getTime().getTime());
            short s2 = this.rowSpaceIndicator[this.lengthIndex + n2];
            if (s2 >= 11) {
                timestamp.setNanos(this.oracleNanos(n3));
            }
        }
        return timestamp;
    }

    static final int julianDayToDayOfWeek(long l2) {
        int n2;
        return n2 + ((n2 = (int)((l2 + 1L) % 7L)) < 0 ? 8 : 1);
    }

    static final long julianDayToMillis(long l2) {
        return (l2 - 2440588L) * 86400000L;
    }

    final int oracleDay(int n2) {
        return this.rowSpaceByte[3 + n2];
    }

    final int oracleHour(int n2) {
        return this.rowSpaceByte[4 + n2] - 1;
    }

    final int oracleMin(int n2) {
        return this.rowSpaceByte[5 + n2] - 1;
    }

    final int oracleMonth(int n2) {
        return this.rowSpaceByte[2 + n2] - 1;
    }

    final int oracleNanos(int n2) {
        int n3 = (this.rowSpaceByte[7 + n2] & 0xFF) << 24;
        n3 |= (this.rowSpaceByte[8 + n2] & 0xFF) << 16;
        n3 |= (this.rowSpaceByte[9 + n2] & 0xFF) << 8;
        return n3 |= this.rowSpaceByte[10 + n2] & 0xFF & 0xFF;
    }

    final int oracleSec(int n2) {
        return this.rowSpaceByte[6 + n2] - 1;
    }

    final int oracleTZ1(int n2) {
        return this.rowSpaceByte[11 + n2];
    }

    final int oracleTZ2(int n2) {
        return this.rowSpaceByte[12 + n2];
    }

    final int oracleTime(int n2) {
        int n3 = this.oracleHour(n2);
        n3 *= 60;
        n3 += this.oracleMin(n2);
        n3 *= 60;
        n3 += this.oracleSec(n2);
        return n3 *= 1000;
    }

    final int oracleYear(int n2) {
        int n3 = ((this.rowSpaceByte[n2] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n2] & 0xFF) - 100;
        return n3 <= 0 ? n3 + 1 : n3;
    }

    static final long zoneOffset(TimeZone timeZone, int n2, int n3, int n4, int n5, int n6) {
        return timeZone.getOffset(n2 < 0 ? 0 : 1, n2, n3, n4, n5, n6);
    }
}

