/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateTimeCommonAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMP;

class DateAccessor
extends DateTimeCommonAccessor {
    static final int maxLength = 7;

    DateAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl2) throws SQLException {
        this.init(oracleStatement, 12, 12, s2, bl2);
        this.initForDataAccess(n3, n2, null);
    }

    DateAccessor(OracleStatement oracleStatement, int n2, boolean bl2, int n3, int n4, int n5, int n6, int n7, short s2) throws SQLException {
        this.init(oracleStatement, 12, 12, s2, false);
        this.initForDescribe(12, n2, bl2, n3, n4, n5, n6, n7, s2, null);
        this.initForDataAccess(0, n2, null);
    }

    Object getObject(int n2) throws SQLException {
        Date date = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            if (this.externalType == 0) {
                date = this.statement.connection.v8Compatible ? this.getTimestamp(n2) : this.getDate(n2);
            } else {
                switch (this.externalType) {
                    case 91: {
                        return this.getDate(n2);
                    }
                    case 92: {
                        return this.getTime(n2);
                    }
                    case 93: {
                        return this.getTimestamp(n2);
                    }
                }
                DatabaseError.throwSqlException(4);
                return null;
            }
        }
        return date;
    }

    Object getObject(int n2, Map map) throws SQLException {
        return this.getObject(n2);
    }

    Datum getOracleObject(int n2) throws SQLException {
        return this.getDATE(n2);
    }

    String getString(int n2) throws SQLException {
        String string = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            int n3 = this.columnIndex + this.byteLength * n2;
            int n4 = ((this.rowSpaceByte[n3] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n3] & 0xFF) - 100;
            string = String.valueOf(n4) + "-" + DateAccessor.toStr(this.rowSpaceByte[2 + n3]) + "-" + DateAccessor.toStr(this.rowSpaceByte[3 + n3]) + " " + DateAccessor.toStr(this.rowSpaceByte[4 + n3] - 1) + ":" + DateAccessor.toStr(this.rowSpaceByte[5 + n3] - 1) + ":" + DateAccessor.toStr(this.rowSpaceByte[6 + n3] - 1) + ".0";
        }
        return string;
    }

    TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        if (!this.statement.connection.v8Compatible || this.externalType != 93) {
            return super.getTIMESTAMP(n2);
        }
        TIMESTAMP tIMESTAMP = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            short s2 = this.rowSpaceIndicator[this.lengthIndex + n2];
            int n3 = this.columnIndex + this.byteLength * n2;
            byte[] byArray = new byte[s2];
            System.arraycopy(this.rowSpaceByte, n3, byArray, 0, s2);
            tIMESTAMP = new TIMESTAMP(byArray);
        }
        return tIMESTAMP;
    }

    Timestamp getTimestamp(int n2) throws SQLException {
        Timestamp timestamp = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            int n3 = this.columnIndex + this.byteLength * n2;
            TimeZone timeZone = this.statement.getDefaultTimeZone();
            int n4 = ((this.rowSpaceByte[n3] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n3] & 0xFF) - 100;
            if (n4 <= 0) {
                ++n4;
            }
            timestamp = new Timestamp(DateTimeCommonAccessor.getMillis(n4, this.oracleMonth(n3), this.oracleDay(n3), this.oracleTime(n3), timeZone));
        }
        return timestamp;
    }

    void initForDataAccess(int n2, int n3, String string) throws SQLException {
        if (n2 != 0) {
            this.externalType = n2;
        }
        this.internalTypeMaxLength = 7;
        if (n3 > 0 && n3 < this.internalTypeMaxLength) {
            this.internalTypeMaxLength = n3;
        }
        this.byteLength = this.internalTypeMaxLength;
    }

    static String toStr(int n2) {
        return n2 < 10 ? "0" + n2 : Integer.toString(n2);
    }
}

