/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;

public class ArrayDataResultSet
extends BaseResultSet {
    Datum[] data;
    Map map;
    private int currentIndex;
    private int lastIndex;
    boolean closed;
    PhysicalConnection connection;
    private Boolean wasNull;
    private static Boolean BOOLEAN_TRUE = new Boolean(true);
    private static Boolean BOOLEAN_FALSE = new Boolean(false);
    private int fetchSize;
    ARRAY array;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:15:38_PDT_2005";

    public ArrayDataResultSet(OracleConnection oracleConnection, ARRAY aRRAY, long l2, int n2, Map map) throws SQLException {
        this.connection = (PhysicalConnection)oracleConnection;
        this.array = aRRAY;
        this.map = map;
        this.currentIndex = (int)l2 - 1;
        int n3 = this.array == null ? 0 : aRRAY.length();
        this.lastIndex = this.currentIndex + (n2 == -1 ? n3 - this.currentIndex : Math.min(n3 - this.currentIndex, n2));
        this.fetchSize = OracleConnection.DEFAULT_ROW_PREFETCH;
    }

    public ArrayDataResultSet(OracleConnection oracleConnection, Datum[] datumArray, long l2, int n2, Map map) throws SQLException {
        this.connection = (PhysicalConnection)oracleConnection;
        this.data = datumArray;
        this.map = map;
        this.currentIndex = (int)l2 - 1;
        int n3 = this.data == null ? 0 : this.data.length;
        this.lastIndex = this.currentIndex + Math.min(n3 - this.currentIndex, n2);
        this.fetchSize = OracleConnection.DEFAULT_ROW_PREFETCH;
    }

    public ArrayDataResultSet(OracleConnection oracleConnection, Datum[] datumArray, Map map) throws SQLException {
        this.connection = (PhysicalConnection)oracleConnection;
        this.data = datumArray;
        this.map = map;
        this.currentIndex = 0;
        this.lastIndex = this.data == null ? 0 : this.data.length;
        this.fetchSize = OracleConnection.DEFAULT_ROW_PREFETCH;
    }

    public synchronized void close() throws SQLException {
        this.closed = true;
    }

    public synchronized int findColumn(String string) throws SQLException {
        if (string.equalsIgnoreCase("index")) {
            return 1;
        }
        if (string.equalsIgnoreCase("value")) {
            return 2;
        }
        DatabaseError.throwSqlException(6, "get_column_index");
        return 0;
    }

    public synchronized ARRAY getARRAY(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof ARRAY) {
                return (ARRAY)datum;
            }
            DatabaseError.throwSqlException(4, "getARRAY");
        }
        return null;
    }

    public synchronized Array getArray(int n2) throws SQLException {
        return this.getARRAY(n2);
    }

    public synchronized InputStream getAsciiStream(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            datum.asciiStreamValue();
        }
        return null;
    }

    public synchronized BFILE getBFILE(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof BFILE) {
                return (BFILE)datum;
            }
            DatabaseError.throwSqlException(4, "getBFILE");
        }
        return null;
    }

    public synchronized BLOB getBLOB(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof BLOB) {
                return (BLOB)datum;
            }
            DatabaseError.throwSqlException(4, "getBLOB");
        }
        return null;
    }

    public synchronized BFILE getBfile(int n2) throws SQLException {
        return this.getBFILE(n2);
    }

    public synchronized BigDecimal getBigDecimal(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.bigDecimalValue();
        }
        return null;
    }

    public synchronized BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.bigDecimalValue();
        }
        return null;
    }

    public synchronized InputStream getBinaryStream(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.binaryStreamValue();
        }
        return null;
    }

    public synchronized Blob getBlob(int n2) throws SQLException {
        return this.getBLOB(n2);
    }

    public synchronized boolean getBoolean(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.booleanValue();
        }
        return false;
    }

    public synchronized byte getByte(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.byteValue();
        }
        return 0;
    }

    public synchronized byte[] getBytes(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof RAW) {
                return ((RAW)datum).shareBytes();
            }
            DatabaseError.throwSqlException(4, "getBytes");
        }
        return null;
    }

    public synchronized CHAR getCHAR(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof CHAR) {
                return (CHAR)datum;
            }
            DatabaseError.throwSqlException(4, "getCHAR");
        }
        return null;
    }

    public synchronized CLOB getCLOB(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof CLOB) {
                return (CLOB)datum;
            }
            DatabaseError.throwSqlException(4, "getCLOB");
        }
        return null;
    }

    public synchronized Reader getCharacterStream(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.characterStreamValue();
        }
        return null;
    }

    public synchronized Clob getClob(int n2) throws SQLException {
        return this.getCLOB(n2);
    }

    public synchronized ResultSet getCursor(int n2) throws SQLException {
        DatabaseError.throwSqlException(4, "getCursor");
        return null;
    }

    public synchronized CustomDatum getCustomDatum(int n2, CustomDatumFactory customDatumFactory) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        return customDatumFactory.create(datum, 0);
    }

    public synchronized DATE getDATE(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof DATE) {
                return (DATE)datum;
            }
            DatabaseError.throwSqlException(4, "getDATE");
        }
        return null;
    }

    public synchronized Date getDate(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.dateValue();
        }
        return null;
    }

    public synchronized Date getDate(int n2, Calendar calendar) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            DATE dATE = null;
            dATE = datum instanceof DATE ? (DATE)datum : new DATE(datum.stringValue());
            if (dATE != null) {
                return dATE.dateValue(calendar);
            }
        }
        return null;
    }

    public synchronized double getDouble(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.doubleValue();
        }
        return 0.0;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public synchronized float getFloat(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.floatValue();
        }
        return 0.0f;
    }

    public synchronized int getInt(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.intValue();
        }
        return 0;
    }

    public synchronized long getLong(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.longValue();
        }
        return 0L;
    }

    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        if (this.closed) {
            DatabaseError.throwSqlException(10, "getMetaData");
        }
        DatabaseError.throwSqlException(23, "getMetaData");
        return null;
    }

    public synchronized NUMBER getNUMBER(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof NUMBER) {
                return (NUMBER)datum;
            }
            DatabaseError.throwSqlException(4, "getNUMBER");
        }
        return null;
    }

    public synchronized OPAQUE getOPAQUE(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof OPAQUE) {
                return (OPAQUE)datum;
            }
            DatabaseError.throwSqlException(4, "getOPAQUE");
        }
        return null;
    }

    public synchronized ORAData getORAData(int n2, ORADataFactory oRADataFactory) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        return oRADataFactory.create(datum, 0);
    }

    public synchronized Object getObject(int n2) throws SQLException {
        return this.getObject(n2, this.map);
    }

    public synchronized Object getObject(int n2, Map map) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof STRUCT) {
                return ((STRUCT)datum).toJdbc(map);
            }
            return datum.toJdbc();
        }
        return null;
    }

    public synchronized Datum getOracleObject(int n2) throws SQLException {
        if (this.currentIndex <= 0) {
            DatabaseError.throwSqlException(14, null);
        }
        if (n2 == 1) {
            this.wasNull = BOOLEAN_FALSE;
            return new NUMBER(this.currentIndex);
        }
        if (n2 == 2) {
            Datum[] datumArray;
            if (this.data != null) {
                this.wasNull = this.data[this.currentIndex - 1] == null ? BOOLEAN_TRUE : BOOLEAN_FALSE;
                return this.data[this.currentIndex - 1];
            }
            if (this.array != null && (datumArray = this.array.getOracleArray(this.currentIndex, 1)) != null && datumArray.length >= 1) {
                this.wasNull = datumArray[0] == null ? BOOLEAN_TRUE : BOOLEAN_FALSE;
                return datumArray[0];
            }
            DatabaseError.throwSqlException(1, "Out of sync");
        }
        DatabaseError.throwSqlException(3, null);
        return null;
    }

    public synchronized RAW getRAW(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof RAW) {
                return (RAW)datum;
            }
            DatabaseError.throwSqlException(4, "getRAW");
        }
        return null;
    }

    public synchronized REF getREF(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof REF) {
                return (REF)datum;
            }
            DatabaseError.throwSqlException(4, "getREF");
        }
        return null;
    }

    public synchronized ROWID getROWID(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof ROWID) {
                return (ROWID)datum;
            }
            DatabaseError.throwSqlException(4, "getROWID");
        }
        return null;
    }

    public synchronized Ref getRef(int n2) throws SQLException {
        return this.getREF(n2);
    }

    public int getRow() throws SQLException {
        return this.currentIndex;
    }

    public synchronized STRUCT getSTRUCT(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof STRUCT) {
                return (STRUCT)datum;
            }
            DatabaseError.throwSqlException(4, "getSTRUCT");
        }
        return null;
    }

    public synchronized short getShort(int n2) throws SQLException {
        long l2 = this.getLong(n2);
        if (l2 > 65537L || l2 < -65538L) {
            DatabaseError.throwSqlException(26, "getShort");
        }
        return (short)l2;
    }

    public synchronized Statement getStatement() throws SQLException {
        return null;
    }

    public synchronized String getString(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.stringValue();
        }
        return null;
    }

    public synchronized Time getTime(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.timeValue();
        }
        return null;
    }

    public synchronized Time getTime(int n2, Calendar calendar) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            DATE dATE = null;
            dATE = datum instanceof DATE ? (DATE)datum : new DATE(datum.stringValue());
            if (dATE != null) {
                return dATE.timeValue(calendar);
            }
        }
        return null;
    }

    public synchronized Timestamp getTimestamp(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.timestampValue();
        }
        return null;
    }

    public synchronized Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            DATE dATE = null;
            dATE = datum instanceof DATE ? (DATE)datum : new DATE(datum.stringValue());
            if (dATE != null) {
                return dATE.timestampValue(calendar);
            }
        }
        return null;
    }

    public synchronized URL getURL(int n2) throws SQLException {
        throw new SQLException("Conversion to java.net.URL not supported.");
    }

    public synchronized InputStream getUnicodeStream(int n2) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            DBConversion dBConversion = this.connection.conversion;
            byte[] byArray = datum.shareBytes();
            if (datum instanceof RAW) {
                return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 3);
            }
            if (datum instanceof CHAR) {
                return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 1);
            }
            DatabaseError.throwSqlException(4, "getUnicodeStream");
        }
        return null;
    }

    public boolean isAfterLast() throws SQLException {
        return this.currentIndex > this.lastIndex;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.currentIndex < 1;
    }

    public boolean isFirst() throws SQLException {
        return this.currentIndex == 1;
    }

    public boolean isLast() throws SQLException {
        return this.currentIndex == this.lastIndex;
    }

    public boolean next() throws SQLException {
        if (this.closed) {
            DatabaseError.throwSqlException(10, "next");
        }
        ++this.currentIndex;
        return this.currentIndex <= this.lastIndex;
    }

    public void setFetchSize(int n2) throws SQLException {
        if (n2 < 0) {
            DatabaseError.throwSqlException(68);
        } else {
            this.fetchSize = n2 == 0 ? OracleConnection.DEFAULT_ROW_PREFETCH : n2;
        }
    }

    public synchronized boolean wasNull() throws SQLException {
        if (this.wasNull == null) {
            DatabaseError.throwSqlException(24, null);
        }
        return this.wasNull;
    }
}

