/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.ParameterUtils;
import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

final class Util {
    static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final Logger utilLogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.Util");
    private static final int leapDaysBeforeSQLBaseDate = Util.leapDaysBeforeYear(1900);
    static final char LEFT_BRACKET = '[';
    static final char RIGHT_BRACKET = ']';
    static final char[] DOUBLE_RIGHT_BRACKET = new char[]{']', ']'};
    private static final int MAX_SINGLE_BYTE_LENGTH = 255;
    private static final int MAX_DOUBLE_BYTE_LENGTH = 65535;

    Util() {
    }

    static short readShort(byte[] byArray, int n2) {
        return (short)(byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8);
    }

    static int readUnsignedShort(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8;
    }

    static void writeShort(short s2, byte[] byArray, int n2) {
        byArray[n2 + 0] = (byte)(s2 >> 0 & 0xFF);
        byArray[n2 + 1] = (byte)(s2 >> 8 & 0xFF);
    }

    static void writeShortBigEndian(short s2, byte[] byArray, int n2) {
        byArray[n2 + 0] = (byte)(s2 >> 8 & 0xFF);
        byArray[n2 + 1] = (byte)(s2 >> 0 & 0xFF);
    }

    static int readInt(byte[] byArray, int n2) {
        int n3 = byArray[n2 + 0] & 0xFF;
        int n4 = (byArray[n2 + 1] & 0xFF) << 8;
        int n5 = (byArray[n2 + 2] & 0xFF) << 16;
        int n6 = (byArray[n2 + 3] & 0xFF) << 24;
        return n6 | n5 | n4 | n3;
    }

    static void writeInt(int n2, byte[] byArray, int n3) {
        byArray[n3 + 0] = (byte)(n2 >> 0 & 0xFF);
        byArray[n3 + 1] = (byte)(n2 >> 8 & 0xFF);
        byArray[n3 + 2] = (byte)(n2 >> 16 & 0xFF);
        byArray[n3 + 3] = (byte)(n2 >> 24 & 0xFF);
    }

    static void writeIntBigEndian(int n2, byte[] byArray, int n3) {
        byArray[n3 + 0] = (byte)(n2 >> 24 & 0xFF);
        byArray[n3 + 1] = (byte)(n2 >> 16 & 0xFF);
        byArray[n3 + 2] = (byte)(n2 >> 8 & 0xFF);
        byArray[n3 + 3] = (byte)(n2 >> 0 & 0xFF);
    }

    static long readLong(byte[] byArray, int n2) {
        long l2 = 0L;
        for (int i2 = 7; i2 > 0; --i2) {
            l2 += (long)(byArray[n2 + i2] & 0xFF);
            l2 <<= 8;
        }
        return l2 + (long)(byArray[n2] & 0xFF);
    }

    static int majorVersion() {
        return 1;
    }

    static String minorVersion() {
        String string = "2";
        return string;
    }

    static String getProgramName_65() {
        return "SQLServer";
    }

    static String nameAndVersion(boolean bl2) {
        String string = "Microsoft SQL Server 2005 JDBC Driver";
        if (!bl2) {
            return string;
        }
        return string + "(" + Util.majorVersion() + "." + Util.minorVersion() + ")";
    }

    static String javaSqlTypeToString(int n2) {
        switch (n2) {
            case -7: {
                return "BIT";
            }
            case -6: {
                return "TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 6: {
                return "FLOAT";
            }
            case 7: {
                return "REAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 2: {
                return "NUMERIC";
            }
            case 3: {
                return "DECIMAL";
            }
            case 1: {
                return "CHAR";
            }
            case 12: {
                return "VARCHAR";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -2: {
                return "BINARY";
            }
            case -3: {
                return "VARBINARY";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case 0: {
                return "NULL";
            }
            case 1111: {
                return "OTHER";
            }
        }
        return "UNKNOWN" + n2;
    }

    private static int leapDaysBeforeYear(int n2) {
        return (n2 - 1) / 4 - (n2 - 1) / 100 + (n2 - 1) / 400;
    }

    static void writeTimestamp(Calendar calendar, TDSWriter tDSWriter) throws SQLServerException {
        int n2 = calendar.get(1);
        int n3 = calendar.get(6) - 1 + (n2 - 1900) * 365 + Util.leapDaysBeforeYear(n2) - leapDaysBeforeSQLBaseDate;
        int n4 = calendar.get(14) + 1000 * calendar.get(13) + 60000 * calendar.get(12) + 3600000 * calendar.get(11);
        if (86399999 == n4) {
            ++n3;
            n4 = 0;
        }
        tDSWriter.writeInt(n3);
        tDSWriter.writeInt((3 * n4 + 5) / 10);
    }

    static String normalizePropertyNames(String string) {
        int n2;
        if (null == string) {
            return string;
        }
        for (n2 = 0; n2 < SQLServerDriver.driverPropertiesSynonyms.length; ++n2) {
            if (!SQLServerDriver.driverPropertiesSynonyms[n2][0].equalsIgnoreCase(string)) continue;
            return SQLServerDriver.driverPropertiesSynonyms[n2][1];
        }
        for (n2 = 0; n2 < SQLServerDriver.driverProperties.length; ++n2) {
            if (!SQLServerDriver.driverProperties[n2].equalsIgnoreCase(string)) continue;
            return SQLServerDriver.driverProperties[n2];
        }
        if (utilLogger.isLoggable(Level.FINE)) {
            utilLogger.fine("Unknown property" + string);
        }
        return null;
    }

    static Properties parseUrl(String string) throws SQLServerException {
        Properties properties = new Properties();
        String string2 = string;
        String string3 = "jdbc:sqlserver://";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        if (!string2.startsWith(string3)) {
            return null;
        }
        string2 = string2.substring(string3.length());
        int n2 = 0;
        int n3 = 0;
        block18: for (n2 = 0; n2 < string2.length(); ++n2) {
            char c2 = string2.charAt(n2);
            switch (n3) {
                case 0: {
                    if (c2 == ';') {
                        n3 = 7;
                        continue block18;
                    }
                    string4 = string4 + c2;
                    n3 = 1;
                    continue block18;
                }
                case 1: {
                    if (c2 == ';' || c2 == ':' || c2 == '\\') {
                        if ((string4 = string4.trim()).length() > 0) {
                            properties.put("serverName", string4);
                            if (utilLogger.isLoggable(Level.FINE)) {
                                utilLogger.fine("Property : serverName Value:" + string4);
                            }
                        }
                        string4 = "";
                        if (c2 == ';') {
                            n3 = 7;
                            continue block18;
                        }
                        if (c2 == ':') {
                            n3 = 2;
                            continue block18;
                        }
                        n3 = 3;
                        continue block18;
                    }
                    string4 = string4 + c2;
                    continue block18;
                }
                case 2: {
                    if (c2 == ';') {
                        string4 = string4.trim();
                        if (utilLogger.isLoggable(Level.FINE)) {
                            utilLogger.fine("Property : portNumber Value:" + string4);
                        }
                        properties.put("portNumber", string4);
                        string4 = "";
                        n3 = 7;
                        continue block18;
                    }
                    string4 = string4 + c2;
                    continue block18;
                }
                case 3: {
                    if (c2 == ';' || c2 == ':') {
                        string4 = string4.trim();
                        if (utilLogger.isLoggable(Level.FINE)) {
                            utilLogger.fine("Property : instanceName Value:" + string6);
                        }
                        properties.put("instanceName", string4.toLowerCase(Locale.US));
                        string4 = "";
                        if (c2 == ';') {
                            n3 = 7;
                            continue block18;
                        }
                        n3 = 2;
                        continue block18;
                    }
                    string4 = string4 + c2;
                    continue block18;
                }
                case 7: {
                    if (c2 == '=') {
                        if ((string5 = string5.trim()).length() <= 0) {
                            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_errorConnectionString"), null, true);
                        }
                        n3 = 6;
                        continue block18;
                    }
                    if (c2 == ';') {
                        if ((string5 = string5.trim()).length() <= 0) continue block18;
                        SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_errorConnectionString"), null, true);
                        continue block18;
                    }
                    string5 = string5 + c2;
                    continue block18;
                }
                case 6: {
                    if (c2 == ';') {
                        string6 = string6.trim();
                        if (null != (string5 = Util.normalizePropertyNames(string5))) {
                            if (utilLogger.isLoggable(Level.FINE) && !string5.equals("user") && !string5.equals("password")) {
                                utilLogger.fine("Property:" + string5 + "Value:" + string6);
                            }
                            properties.put(string5, string6);
                        }
                        string5 = "";
                        string6 = "";
                        n3 = 7;
                        continue block18;
                    }
                    if (c2 == '{') {
                        n3 = 4;
                        if ((string6 = string6.trim()).length() <= 0) continue block18;
                        SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_errorConnectionString"), null, true);
                        continue block18;
                    }
                    string6 = string6 + c2;
                    continue block18;
                }
                case 4: {
                    if (c2 == '}') {
                        if (null != (string5 = Util.normalizePropertyNames(string5))) {
                            if (utilLogger.isLoggable(Level.FINE) && !string5.equals("user") && !string5.equals("password")) {
                                utilLogger.fine("Property:" + string5 + "Value:" + string6);
                            }
                            properties.put(string5, string6);
                        }
                        string5 = "";
                        string6 = "";
                        n3 = 5;
                        continue block18;
                    }
                    string6 = string6 + c2;
                    continue block18;
                }
                case 5: {
                    if (c2 == ';') {
                        n3 = 7;
                        continue block18;
                    }
                    if (c2 == ' ') continue block18;
                    SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_errorConnectionString"), null, true);
                }
            }
        }
        switch (n3) {
            case 1: {
                string4 = string4.trim();
                if (string4.length() <= 0) break;
                if (utilLogger.isLoggable(Level.FINE)) {
                    utilLogger.fine("Property : serverName Value:" + string4);
                }
                properties.put("serverName", string4);
                break;
            }
            case 2: {
                string4 = string4.trim();
                if (utilLogger.isLoggable(Level.FINE)) {
                    utilLogger.fine("Property : portNumber Value:" + string4);
                }
                properties.put("portNumber", string4);
            }
            case 3: {
                string4 = string4.trim();
                if (utilLogger.isLoggable(Level.FINE)) {
                    utilLogger.fine("Property : instanceName Value:" + string4);
                }
                properties.put("instanceName", string4);
                break;
            }
            case 6: {
                string6 = string6.trim();
                string5 = Util.normalizePropertyNames(string5);
                if (null == string5) break;
                if (utilLogger.isLoggable(Level.FINE) && !string5.equals("user") && !string5.equals("password")) {
                    utilLogger.fine("Property:" + string5 + "Value:" + string6);
                }
                properties.put(string5, string6);
                break;
            }
            case 0: 
            case 5: {
                break;
            }
            case 7: {
                string5 = string5.trim();
                if (string5.length() <= 0) break;
                SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_errorConnectionString"), null, true);
                break;
            }
            default: {
                SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_errorConnectionString"), null, true);
            }
        }
        return properties;
    }

    static byte[] GUIDToBytes(String string) throws SQLServerException {
        int n2 = string.length();
        byte[] byArray = new byte[16];
        int n3 = 0;
        int n4 = 0;
        if (n2 != 36) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_stringNotInHex"), null, false);
        }
        while (n3 + 1 < n2 && 16 != n4) {
            char c2;
            if ((c2 = string.charAt(n3++)) == '-') {
                if (9 == n3 || 14 == n3 || 19 == n3 || 24 == n3) continue;
                SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_stringNotInHex"), null, false);
            }
            byte by = ParameterUtils.CharToHex(c2);
            by = (byte)(by << 4);
            c2 = string.charAt(n3++);
            byte by2 = ParameterUtils.CharToHex(c2);
            int n5 = n4;
            if (n4 == 0) {
                n5 = 3;
            }
            if (n4 == 1) {
                n5 = 2;
            }
            if (n4 == 2) {
                n5 = 1;
            }
            if (n4 == 3) {
                n5 = 0;
            }
            if (n4 == 4) {
                n5 = 5;
            }
            if (n4 == 5) {
                n5 = 4;
            }
            if (n4 == 6) {
                n5 = 7;
            }
            if (n4 == 7) {
                n5 = 6;
            }
            byArray[n5] = (byte)(by + by2);
            ++n4;
        }
        return byArray;
    }

    static SQLServerException notSupportedBySQLServer(String string) throws SQLServerException {
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_notSupportedBySQL"));
        Object[] objectArray = new Object[]{new String(string)};
        SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), "0A000", false);
        return null;
    }

    static boolean isBigInt(int n2, int n3) {
        return n2 == 38 && n3 == 8;
    }

    static void println(String string) {
        System.out.println(string);
    }

    static void print(String string) {
        System.out.print(string);
    }

    static String escapeSQLId(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 2);
        stringBuffer.append('[');
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (']' == c2) {
                stringBuffer.append(DOUBLE_RIGHT_BRACKET);
                continue;
            }
            stringBuffer.append(c2);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    static void checkSingleByteLength(int n2) throws SQLServerException {
        if (n2 < 0 || n2 > 255) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidDataLength"));
            Object[] objectArray = new Object[]{new Integer(n2)};
            throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, true);
        }
    }

    static void checkDoubleByteLength(int n2) throws SQLServerException {
        if (n2 < 0 || n2 > 65535) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidDataLength"));
            Object[] objectArray = new Object[]{new Integer(n2)};
            throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, true);
        }
    }

    static String readUnicodeString(byte[] byArray, int n2, int n3) throws SQLServerException {
        try {
            return new String(byArray, n2, n3, "UTF-16LE");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_stringReadError"));
            Object[] objectArray = new Object[]{new Integer(n2)};
            throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, true);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_stringReadError"));
            Object[] objectArray = new Object[]{new Integer(n2)};
            throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, true);
        }
    }

    static int writeUnicodeString(byte[] byArray, int n2, String string) throws SQLServerException {
        try {
            byte[] byArray2 = string.getBytes("UTF-16LE");
            System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
            return byArray2.length;
        }
        catch (IOException iOException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_stringWriteError"));
            Object[] objectArray = new Object[]{new Integer(n2)};
            throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, true);
        }
    }

    static String byteToHexDisplayString(byte[] byArray) {
        if (null == byArray) {
            return "(null)";
        }
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2 + 2);
        stringBuffer.append("0x");
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = byArray[i2] & 0xFF;
            stringBuffer.append(hexChars[(n2 & 0xF0) >> 4]);
            stringBuffer.append(hexChars[n2 & 0xF]);
        }
        return stringBuffer.toString();
    }

    static String bytesToHexString(byte[] byArray, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2 * 2);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = byArray[i2] & 0xFF;
            stringBuffer.append(hexChars[(n3 & 0xF0) >> 4]);
            stringBuffer.append(hexChars[n3 & 0xF]);
        }
        return stringBuffer.toString();
    }

    static String lookupHostName() throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getLocalHost();
        if (null != inetAddress) {
            String string = inetAddress.getHostName();
            if (null != string && string.length() > 0) {
                return string;
            }
            string = inetAddress.getHostAddress();
            if (null != string && string.length() > 0) {
                return string;
            }
        }
        return "WSID Not Available";
    }
}

