/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DDC;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.InputStreamSetterArgs;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.TDSChannel;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;

final class TDSWriter {
    private static Logger logger;
    private final boolean isLoggable = logger.isLoggable(Level.FINEST);
    private final TDSChannel tdsChannel;
    private final SQLServerConnection con;
    private boolean dataIsLoggable = true;
    private byte tdsMessageType;
    private static final byte TDS_MESSAGE_STATUS_NORMAL = 0;
    private static final byte TDS_MESSAGE_STATUS_EOM = 1;
    private static final byte TDS_MESSAGE_STATUS_ATTENTION = 2;
    private static final byte TDS_MESSAGE_STATUS_RESET_CONN = 8;
    private boolean atEOM = false;
    private volatile boolean attentionRaised = false;
    private boolean attentionSent = false;
    private String attentionReason = null;
    private int currentPacketSize = 0;
    private static final int TDS_PACKET_HEADER_SIZE = 8;
    private static final byte[] placeholderHeader;
    private byte[] valueBytes = new byte[256];
    private int packetNum = 0;
    private ByteBuffer stagingBuffer;
    private ByteBuffer socketBuffer;
    private ByteBuffer logBuffer;
    static final /* synthetic */ boolean $assertionsDisabled;

    final String toLogString() {
        return "TDSWriter@" + Integer.toHexString(this.hashCode()) + " (" + this.con.toLogString() + ")";
    }

    void setDataLoggable(boolean bl2) {
        this.dataIsLoggable = bl2;
    }

    final boolean attentionSent() {
        return this.attentionSent;
    }

    TDSWriter(TDSChannel tDSChannel, SQLServerConnection sQLServerConnection) {
        this.tdsChannel = tDSChannel;
        this.con = sQLServerConnection;
    }

    void preparePacket() throws SQLServerException {
        if (this.atEOM) {
            return;
        }
        if (this.tdsChannel.isLoggingPackets()) {
            Arrays.fill(this.logBuffer.array(), (byte)-2);
            this.logBuffer.clear();
        }
        this.writeBytes(placeholderHeader);
    }

    void writeMessageHeader() throws SQLServerException {
        if (this.con.isYukonOrLater() && (1 == this.tdsMessageType || 14 == this.tdsMessageType || 3 == this.tdsMessageType)) {
            this.writeInt(22);
            this.writeInt(18);
            this.writeShort((short)2);
            this.writeBytes(this.con.getTransactionDescriptor());
            this.writeInt(1);
        }
    }

    TDSWriter startMessage(byte by) throws SQLServerException {
        this.tdsMessageType = by;
        this.atEOM = false;
        if (6 != by) {
            this.attentionRaised = false;
            this.attentionSent = false;
            this.attentionReason = null;
        }
        this.packetNum = 0;
        this.dataIsLoggable = true;
        int n2 = this.con.getTDSPacketSize();
        if (this.currentPacketSize != n2) {
            this.socketBuffer = ByteBuffer.allocate(n2).order(ByteOrder.LITTLE_ENDIAN);
            this.stagingBuffer = ByteBuffer.allocate(n2).order(ByteOrder.LITTLE_ENDIAN);
            this.logBuffer = ByteBuffer.allocate(n2).order(ByteOrder.LITTLE_ENDIAN);
            this.tdsChannel.setSendBufferSize(n2);
            this.currentPacketSize = n2;
        }
        this.socketBuffer.position(this.socketBuffer.limit());
        this.stagingBuffer.clear();
        this.preparePacket();
        this.writeMessageHeader();
        return this;
    }

    final void endMessage() throws SQLServerException {
        this.writePacket(1);
    }

    final void raiseAttention(String string) {
        this.attentionReason = string;
        this.attentionRaised = true;
    }

    void writeByte(byte by) throws SQLServerException {
        if (this.stagingBuffer.remaining() >= 1) {
            this.stagingBuffer.put(by);
            if (this.tdsChannel.isLoggingPackets()) {
                if (this.dataIsLoggable) {
                    this.logBuffer.put(by);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + 1);
                }
            }
        } else {
            this.valueBytes[0] = by;
            this.writeWrappedBytes(this.valueBytes, 1);
        }
    }

    void writeTinyInt(short s2) throws SQLServerException {
        if (this.stagingBuffer.remaining() >= 1) {
            this.stagingBuffer.put((byte)(s2 & 0xFF));
            if (this.tdsChannel.isLoggingPackets()) {
                if (this.dataIsLoggable) {
                    this.logBuffer.put((byte)(s2 & 0xFF));
                } else {
                    this.logBuffer.position(this.logBuffer.position() + 1);
                }
            }
        } else {
            this.valueBytes[0] = (byte)(s2 & 0xFF);
            this.writeWrappedBytes(this.valueBytes, 1);
        }
    }

    void writeChar(char c2) throws SQLServerException {
        if (this.stagingBuffer.remaining() >= 2) {
            this.stagingBuffer.putChar(c2);
            if (this.tdsChannel.isLoggingPackets()) {
                if (this.dataIsLoggable) {
                    this.logBuffer.putChar(c2);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + 2);
                }
            }
        } else {
            Util.writeShort((short)c2, this.valueBytes, 0);
            this.writeWrappedBytes(this.valueBytes, 2);
        }
    }

    void writeShort(short s2) throws SQLServerException {
        if (this.stagingBuffer.remaining() >= 2) {
            this.stagingBuffer.putShort(s2);
            if (this.tdsChannel.isLoggingPackets()) {
                if (this.dataIsLoggable) {
                    this.logBuffer.putShort(s2);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + 2);
                }
            }
        } else {
            Util.writeShort(s2, this.valueBytes, 0);
            this.writeWrappedBytes(this.valueBytes, 2);
        }
    }

    void writeInt(int n2) throws SQLServerException {
        if (this.stagingBuffer.remaining() >= 4) {
            this.stagingBuffer.putInt(n2);
            if (this.tdsChannel.isLoggingPackets()) {
                if (this.dataIsLoggable) {
                    this.logBuffer.putInt(n2);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + 4);
                }
            }
        } else {
            Util.writeInt(n2, this.valueBytes, 0);
            this.writeWrappedBytes(this.valueBytes, 4);
        }
    }

    void writeLong(long l2) throws SQLServerException {
        if (this.stagingBuffer.remaining() >= 8) {
            this.stagingBuffer.putLong(l2);
            if (this.tdsChannel.isLoggingPackets()) {
                if (this.dataIsLoggable) {
                    this.logBuffer.putLong(l2);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + 8);
                }
            }
        } else {
            this.valueBytes[0] = (byte)(l2 >> 0 & 0xFFL);
            this.valueBytes[1] = (byte)(l2 >> 8 & 0xFFL);
            this.valueBytes[2] = (byte)(l2 >> 16 & 0xFFL);
            this.valueBytes[3] = (byte)(l2 >> 24 & 0xFFL);
            this.valueBytes[4] = (byte)(l2 >> 32 & 0xFFL);
            this.valueBytes[5] = (byte)(l2 >> 40 & 0xFFL);
            this.valueBytes[6] = (byte)(l2 >> 48 & 0xFFL);
            this.valueBytes[7] = (byte)(l2 >> 56 & 0xFFL);
            this.writeWrappedBytes(this.valueBytes, 8);
        }
    }

    void writeBytes(byte[] byArray) throws SQLServerException {
        this.writeBytes(byArray, byArray.length);
    }

    void writeBytes(byte[] byArray, int n2) throws SQLServerException {
        int n3;
        int n4 = 0;
        while ((n3 = n2 - n4) > 0) {
            if (0 == this.stagingBuffer.remaining()) {
                this.writePacket(0);
            }
            if (n3 > this.stagingBuffer.remaining()) {
                n3 = this.stagingBuffer.remaining();
            }
            this.stagingBuffer.put(byArray, n4, n3);
            if (this.tdsChannel.isLoggingPackets()) {
                if (this.dataIsLoggable) {
                    this.logBuffer.put(byArray, n4, n3);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + n3);
                }
            }
            n4 += n3;
        }
    }

    void writeChars(char[] cArray, int n2) throws SQLServerException {
        byte[] byArray = new byte[8000];
        int n3 = 0;
        do {
            int n4 = 0;
            while (n3 < n2 && n4 < byArray.length) {
                byArray[n4++] = (byte)(cArray[n3] >> 0 & 0xFF);
                byArray[n4++] = (byte)(cArray[n3] >> 8 & 0xFF);
                ++n3;
            }
            this.writeBytes(byArray, n4);
        } while (n3 < n2);
    }

    void writeWrappedBytes(byte[] byArray, int n2) throws SQLServerException {
        int n3 = this.stagingBuffer.remaining();
        if (n3 > 0) {
            this.stagingBuffer.put(byArray, 0, n3);
            if (this.tdsChannel.isLoggingPackets()) {
                if (this.dataIsLoggable) {
                    this.logBuffer.put(byArray, 0, n3);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + n3);
                }
            }
        }
        this.writePacket(0);
        this.stagingBuffer.put(byArray, n3, n2 - n3);
        if (this.tdsChannel.isLoggingPackets()) {
            if (this.dataIsLoggable) {
                this.logBuffer.put(byArray, n3, n2 - n3);
            } else {
                this.logBuffer.position(this.logBuffer.position() + n3);
            }
        }
    }

    void writeString(String string) throws SQLServerException {
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            int n4 = 2 * (n3 - n2);
            if (n4 > this.valueBytes.length) {
                n4 = this.valueBytes.length;
            }
            int n5 = 0;
            while (n5 < n4) {
                char c2 = string.charAt(n2++);
                this.valueBytes[n5++] = (byte)(c2 >> 0 & 0xFF);
                this.valueBytes[n5++] = (byte)(c2 >> 8 & 0xFF);
            }
            this.writeBytes(this.valueBytes, n5);
        }
    }

    void writeStream(InputStream inputStream, long l2, boolean bl2) throws SQLServerException {
        int n2;
        long l3 = 0L;
        byte[] byArray = new byte[8000];
        int n3 = 0;
        do {
            for (n2 = 0; -1 != n3 && n2 < byArray.length; n2 += n3) {
                try {
                    n3 = inputStream.read(byArray, n2, byArray.length - n2);
                }
                catch (IOException iOException) {
                    this.error(iOException.getMessage());
                }
                if (-1 == n3) break;
                if (n3 >= 0 && n3 <= byArray.length - n2) continue;
                this.error(SQLServerException.getErrString("R_unexpectedIOExceptionProcessingInputStream"));
            }
            if (bl2) {
                this.writeInt(n2);
            }
            this.writeBytes(byArray, n2);
            l3 += (long)n2;
        } while (-1 != n3 || n2 > 0);
        if (-1L != l2 && l3 != l2) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_mismatchedStreamLength"));
            Object[] objectArray = new Object[]{new Long(l2), new Long(l3)};
            this.error(messageFormat.format(objectArray));
        }
    }

    void writeReader(Reader reader, long l2, boolean bl2) throws SQLServerException {
        int n2;
        if (!$assertionsDisabled && l2 < -1L) {
            throw new AssertionError();
        }
        long l3 = 0L;
        char[] cArray = new char[4000];
        int n3 = 0;
        do {
            for (n2 = 0; -1 != n3 && n2 < cArray.length; n2 += n3) {
                try {
                    n3 = reader.read(cArray, n2, cArray.length - n2);
                }
                catch (IOException iOException) {
                    this.error(iOException.getMessage());
                }
                if (-1 == n3) break;
                if (n3 >= 0 && n3 <= cArray.length - n2) continue;
                this.error(SQLServerException.getErrString("R_unexpectedIOExceptionProcessingReader"));
            }
            if (bl2) {
                this.writeInt(2 * n2);
            }
            this.writeChars(cArray, n2);
            l3 += (long)n2;
        } while (-1 != n3 || n2 > 0);
        if (-1L != l2 && l3 != l2) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_mismatchedStreamLength"));
            Object[] objectArray = new Object[]{new Long(l2), new Long(l3)};
            this.error(messageFormat.format(objectArray));
        }
    }

    private final void error(String string) throws SQLServerException {
        this.raiseAttention(string);
        this.endMessage();
    }

    private final void writePacket(int n2) throws SQLServerException {
        if (this.atEOM) {
            if (this.isLoggable) {
                logger.finest(this.toLogString() + ": Dropping packet...");
            }
            return;
        }
        if (6 != this.tdsMessageType && this.attentionRaised) {
            if (0 != this.packetNum) {
                ++this.tdsChannel.numMsgsSent;
                this.sendAttention();
            }
            this.throwAttentionReason();
        }
        this.writePacketHeader(n2);
        this.flush();
        if (this.atEOM) {
            this.flush();
            ++this.tdsChannel.numMsgsSent;
        }
    }

    final void sendAttention() throws SQLServerException {
        if (this.isLoggable) {
            logger.finest(this.toLogString() + ": sending attention signal to server");
        }
        this.startMessage((byte)6).endMessage();
        this.attentionSent = true;
        if (this.isLoggable) {
            logger.finest(this.toLogString() + ": sent attention signal to server");
        }
    }

    private final void throwAttentionReason() throws SQLServerException {
        if (this.isLoggable) {
            logger.finest(this.toLogString() + ": throwing interrupt exception, reason=" + this.attentionReason);
        }
        SQLServerException sQLServerException = new SQLServerException(null, this.attentionReason, null, 0, false);
        sQLServerException.setDriverErrorCode(1);
        throw sQLServerException;
    }

    private final void writePacketHeader(int n2) {
        int n3 = this.stagingBuffer.position();
        ++this.packetNum;
        this.stagingBuffer.put(0, this.tdsMessageType);
        this.stagingBuffer.put(1, (byte)n2);
        this.stagingBuffer.put(2, (byte)(n3 >> 8 & 0xFF));
        this.stagingBuffer.put(3, (byte)(n3 >> 0 & 0xFF));
        this.stagingBuffer.putShort(4, (short)0);
        this.stagingBuffer.put(6, (byte)(this.packetNum % 256));
        this.stagingBuffer.put(7, (byte)0);
        if (this.tdsChannel.isLoggingPackets()) {
            this.logBuffer.put(0, this.tdsMessageType);
            this.logBuffer.put(1, (byte)n2);
            this.logBuffer.put(2, (byte)(n3 >> 8 & 0xFF));
            this.logBuffer.put(3, (byte)(n3 >> 0 & 0xFF));
            this.logBuffer.putShort(4, (short)0);
            this.logBuffer.put(6, (byte)(this.packetNum % 256));
            this.logBuffer.put(7, (byte)0);
        }
        if (1 == (1 & n2)) {
            this.atEOM = true;
        }
    }

    void flush() throws SQLServerException {
        this.tdsChannel.write(this.socketBuffer.array(), this.socketBuffer.position(), this.socketBuffer.remaining());
        this.socketBuffer.position(this.socketBuffer.limit());
        if (this.stagingBuffer.position() >= 8) {
            ByteBuffer byteBuffer = this.stagingBuffer;
            this.stagingBuffer = this.socketBuffer;
            this.socketBuffer = byteBuffer;
            this.socketBuffer.flip();
            this.stagingBuffer.clear();
            if (this.tdsChannel.isLoggingPackets()) {
                this.tdsChannel.logPacket(this.logBuffer.array(), 0, this.socketBuffer.limit(), this.toLogString() + " sending packet (" + this.socketBuffer.limit() + " bytes)");
            }
            this.preparePacket();
            this.tdsChannel.write(this.socketBuffer.array(), this.socketBuffer.position(), this.socketBuffer.remaining());
            this.socketBuffer.position(this.socketBuffer.limit());
        }
    }

    private void writeRPCNameValType(String string, boolean bl2, int n2) throws SQLServerException {
        int n3 = 0;
        if (null != string) {
            n3 = string.length() + 1;
        }
        this.writeByte((byte)n3);
        if (n3 > 0) {
            this.writeChar('@');
            this.writeString(string);
        }
        this.writeByte((byte)(bl2 ? 1 : 0));
        this.writeByte((byte)n2);
    }

    void writeRPCBit(String string, Boolean bl2, boolean bl3) throws SQLServerException {
        this.writeRPCNameValType(string, bl3, 104);
        this.writeByte((byte)1);
        if (null == bl2) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)1);
            this.writeByte((byte)(bl2 != false ? 1 : 0));
        }
    }

    void writeRPCByte(String string, Byte by, boolean bl2) throws SQLServerException {
        this.writeRPCNameValType(string, bl2, 38);
        this.writeByte((byte)1);
        if (null == by) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)1);
            this.writeTinyInt(by.byteValue());
        }
    }

    void writeRPCShort(String string, Short s2, boolean bl2) throws SQLServerException {
        this.writeRPCNameValType(string, bl2, 38);
        this.writeByte((byte)2);
        if (null == s2) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)2);
            this.writeShort(s2);
        }
    }

    void writeRPCInt(String string, Integer n2, boolean bl2) throws SQLServerException {
        this.writeRPCNameValType(string, bl2, 38);
        this.writeByte((byte)4);
        if (null == n2) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)4);
            this.writeInt(n2);
        }
    }

    void writeRPCLong(String string, Long l2, boolean bl2) throws SQLServerException {
        this.writeRPCNameValType(string, bl2, 38);
        this.writeByte((byte)8);
        if (null == l2) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)8);
            this.writeLong(l2);
        }
    }

    void writeRPCReal(String string, Float f2, boolean bl2) throws SQLServerException {
        this.writeRPCNameValType(string, bl2, 109);
        if (null == f2) {
            this.writeByte((byte)4);
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)4);
            this.writeByte((byte)4);
            this.writeInt(Float.floatToRawIntBits(f2.floatValue()));
        }
    }

    void writeRPCDouble(String string, Double d2, boolean bl2) throws SQLServerException {
        this.writeRPCNameValType(string, bl2, 109);
        int n2 = 8;
        this.writeByte((byte)n2);
        if (null == d2) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)n2);
            long l2 = Double.doubleToLongBits(d2);
            long l3 = 255L;
            int n3 = 0;
            for (int i2 = 0; i2 < 8; ++i2) {
                this.writeByte((byte)((l2 & l3) >> n3));
                n3 += 8;
                l3 <<= 8;
            }
        }
    }

    void writeRPCBigDecimal(String string, BigDecimal bigDecimal, int n2, boolean bl2) throws SQLServerException {
        this.writeRPCNameValType(string, bl2, 106);
        this.writeByte((byte)17);
        this.writeByte((byte)38);
        byte[] byArray = DDC.convertBigDecimalToBytes(bigDecimal, n2);
        this.writeBytes(byArray, byArray.length);
    }

    void writeVMaxHeader(long l2, boolean bl2, boolean bl3) throws SQLServerException {
        this.writeShort((short)-1);
        if (bl3) {
            this.con.getDatabaseCollation().writeCollation(this);
        }
        if (bl2) {
            this.writeLong(-1L);
        } else if (-1L == l2) {
            this.writeLong(-2L);
        } else {
            this.writeLong(l2);
        }
    }

    void writeRPCString(String string) throws SQLServerException {
        this.writeRPCString(null, string, false, 12);
    }

    void writeRPCString(String string, String string2, boolean bl2, int n2) throws SQLServerException {
        boolean bl3;
        boolean bl4 = string2 == null;
        int n3 = bl4 ? 0 : 2 * string2.length();
        boolean bl5 = n3 <= 8000;
        boolean bl6 = bl3 = this.con.isYukonOrLater() && (!bl5 || bl2);
        if (bl3) {
            this.writeRPCNameValType(string, bl2, 231);
            this.writeVMaxHeader(n3, bl4, true);
            if (!bl4) {
                if (n3 > 0) {
                    this.writeInt(n3);
                    this.writeString(string2);
                }
                this.writeInt(0);
            }
        } else {
            if (bl5) {
                this.writeRPCNameValType(string, bl2, 231);
                this.writeShort((short)8000);
            } else {
                this.writeRPCNameValType(string, bl2, 99);
                this.writeInt(Integer.MAX_VALUE);
            }
            this.con.getDatabaseCollation().writeCollation(this);
            if (bl4) {
                this.writeShort((short)-1);
            } else {
                if (bl5) {
                    this.writeShort((short)n3);
                } else {
                    this.writeInt(n3);
                }
                if (0 != n3) {
                    this.writeString(string2);
                }
            }
        }
    }

    void writeRPCByteArray(String string, byte[] byArray, boolean bl2, int n2) throws SQLServerException {
        boolean bl3;
        boolean bl4 = byArray == null;
        int n3 = bl4 ? 0 : byArray.length;
        boolean bl5 = n3 <= 8000;
        boolean bl6 = bl3 = this.con.isYukonOrLater() && (!bl5 || bl2);
        if (bl3) {
            this.writeRPCNameValType(string, bl2, DataTypes.isBinaryJDBCType(n2) ? 165 : 167);
            this.writeVMaxHeader(n3, bl4, !DataTypes.isBinaryJDBCType(n2));
            if (!bl4) {
                if (n3 > 0) {
                    this.writeInt(n3);
                    this.writeBytes(byArray);
                }
                this.writeInt(0);
            }
        } else {
            if (bl5) {
                this.writeRPCNameValType(string, bl2, DataTypes.isBinaryJDBCType(n2) ? 165 : 167);
                this.writeShort((short)8000);
            } else {
                this.writeRPCNameValType(string, bl2, DataTypes.isBinaryJDBCType(n2) ? 34 : 35);
                this.writeInt(Integer.MAX_VALUE);
            }
            if (!DataTypes.isBinaryJDBCType(n2)) {
                this.con.getDatabaseCollation().writeCollation(this);
            }
            if (bl4) {
                this.writeShort((short)-1);
            } else {
                if (bl5) {
                    this.writeShort((short)n3);
                } else {
                    this.writeInt(n3);
                }
                if (0 != n3) {
                    this.writeBytes(byArray);
                }
            }
        }
    }

    void writeRPCTimestamp(String string, Calendar calendar, boolean bl2) throws SQLServerException {
        this.writeRPCNameValType(string, bl2, 111);
        this.writeByte((byte)8);
        if (null == calendar) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)8);
            Util.writeTimestamp(calendar, this);
        }
    }

    void writeRPCInputStream(String string, InputStream inputStream, InputStreamSetterArgs inputStreamSetterArgs, boolean bl2) throws SQLServerException {
        boolean bl3;
        boolean bl4 = inputStream == null;
        boolean bl5 = bl3 = 1 == inputStreamSetterArgs.streamType;
        if (this.con.isYukonOrLater() && !bl4 && (-1L == inputStreamSetterArgs.length || inputStreamSetterArgs.length > 8000L)) {
            this.writeRPCNameValType(string, bl2, bl3 ? 165 : 167);
            this.writeVMaxHeader(inputStreamSetterArgs.length, false, !bl3);
            this.writeStream(inputStream, inputStreamSetterArgs.length, true);
        } else {
            boolean bl6;
            boolean bl7 = bl6 = bl4 || inputStreamSetterArgs.length <= 8000L;
            this.writeRPCNameValType(string, bl2, bl3 ? (bl6 ? 165 : 34) : (bl6 ? 167 : 35));
            if (bl6) {
                this.writeShort((short)8000);
            } else {
                this.writeInt(Integer.MAX_VALUE);
            }
            if (!bl3) {
                this.con.getDatabaseCollation().writeCollation(this);
            }
            if (bl4) {
                this.writeShort((short)-1);
            } else {
                if (bl6) {
                    this.writeShort((short)inputStreamSetterArgs.length);
                } else {
                    this.writeInt((int)inputStreamSetterArgs.length);
                }
                this.writeStream(inputStream, inputStreamSetterArgs.length, false);
            }
        }
    }

    void writeRPCReader(String string, Reader reader, long l2, boolean bl2, int n2) throws SQLServerException {
        boolean bl3;
        boolean bl4 = bl3 = reader == null;
        if (this.con.isYukonOrLater() && !bl3 && (-1L == l2 || l2 > 4000L)) {
            this.writeRPCNameValType(string, bl2, 231);
            this.writeVMaxHeader(-1L == l2 ? -1L : 2L * l2, false, true);
            this.writeReader(reader, l2, true);
        } else {
            boolean bl5 = bl3 || l2 <= 4000L;
            this.writeRPCNameValType(string, bl2, bl5 ? 231 : 99);
            if (bl5) {
                this.writeShort((short)8000);
            } else {
                this.writeInt(Integer.MAX_VALUE);
            }
            this.con.getDatabaseCollation().writeCollation(this);
            if (bl3) {
                this.writeShort((short)-1);
            } else {
                if (bl5) {
                    this.writeShort((short)(2L * l2));
                } else {
                    this.writeInt((int)(2L * l2));
                }
                this.writeReader(reader, l2, false);
            }
        }
    }

    static {
        $assertionsDisabled = !TDSWriter.class.desiredAssertionStatus();
        logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.TDSWriter");
        placeholderHeader = new byte[8];
    }
}

