/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DDC;
import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.SQLServerBlob;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.ServerDTVImpl;
import com.microsoft.sqlserver.jdbc.SimpleInputStream;
import com.microsoft.sqlserver.jdbc.TDSChannel;
import com.microsoft.sqlserver.jdbc.TDSPacket;
import com.microsoft.sqlserver.jdbc.TDSReaderMark;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

final class TDSReader {
    private static Logger logger;
    private final boolean isLoggable = logger.isLoggable(Level.FINEST);
    private final TDSChannel tdsChannel;
    private final SQLServerConnection con;
    private TDSPacket currentPacket;
    private TDSPacket lastPacket = this.currentPacket = new TDSPacket(0);
    private int payloadOffset = 0;
    private int packetNum = 0;
    private boolean isStreaming = true;
    private final byte[] valueBytes = new byte[256];
    static final String guidTemplate = "NNNNNNNN-NNNN-NNNN-NNNN-NNNNNNNNNNNN";
    static final /* synthetic */ boolean $assertionsDisabled;

    final String toLogString() {
        return "TDSReader@" + Integer.toHexString(this.hashCode()) + " (" + this.con.toLogString() + ")";
    }

    final SQLServerConnection getConnection() {
        return this.con;
    }

    TDSReader(TDSChannel tDSChannel, SQLServerConnection sQLServerConnection) {
        this.tdsChannel = tDSChannel;
        this.con = sQLServerConnection;
        tDSChannel.setRecvBufferSize(sQLServerConnection.getTDSPacketSize());
    }

    final void throwInvalidTDS() throws SQLServerException {
        logger.severe(this.toLogString() + " got unexpected value in TDS response at offset:" + this.payloadOffset);
        SQLServerException.makeFromDriverError(this.con, null, SQLServerException.getErrString("R_invalidTDS"), "08006", true);
    }

    final boolean responseEOM() {
        return this.lastPacket.isEOM();
    }

    final synchronized void readResponse() throws SQLServerException {
        if (!$assertionsDisabled && this.tdsChannel.numMsgsRcvd > this.tdsChannel.numMsgsSent) {
            throw new AssertionError();
        }
        if (!this.responseEOM()) {
            if (this.isLoggable) {
                logger.finest(this.toLogString() + ": Buffering all remaining response bytes...");
            }
            while (this.readPacket()) {
            }
        }
        if (!$assertionsDisabled && this.tdsChannel.numMsgsRcvd > this.tdsChannel.numMsgsSent) {
            throw new AssertionError();
        }
    }

    private final synchronized boolean nextPacket() throws SQLServerException {
        if (!$assertionsDisabled && null == this.currentPacket) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.payloadOffset != this.currentPacket.payloadLength) {
            throw new AssertionError();
        }
        if (null == this.currentPacket.next) {
            if (!$assertionsDisabled && this.currentPacket != this.lastPacket) {
                throw new AssertionError();
            }
            if (this.currentPacket.isEOM()) {
                return false;
            }
            this.readPacket();
        }
        if (!$assertionsDisabled && null == this.currentPacket.next) {
            throw new AssertionError();
        }
        TDSPacket tDSPacket = this.currentPacket.next;
        if (this.isStreaming) {
            this.currentPacket.next = null;
        }
        this.currentPacket = tDSPacket;
        this.payloadOffset = 0;
        return true;
    }

    final boolean readPacket() throws SQLServerException {
        int n2;
        int n3;
        int n4;
        if (!$assertionsDisabled && this.tdsChannel.numMsgsRcvd >= this.tdsChannel.numMsgsSent) {
            throw new AssertionError();
        }
        TDSPacket tDSPacket = new TDSPacket(this.con.getTDSPacketSize());
        for (n3 = 0; n3 < 8; n3 += n4) {
            n4 = this.tdsChannel.read(tDSPacket.header, n3, 8 - n3);
            if (n4 >= 0) continue;
            SQLServerException.makeFromDriverError(this.con, null, 0 == this.packetNum && 0 == n3 ? SQLServerException.getErrString("R_noServerResponse") : SQLServerException.getErrString("R_truncatedServerResponse"), "08006", true);
        }
        if (tDSPacket.header[0] != 4) {
            this.throwInvalidTDS();
        }
        if (tDSPacket.isEOM()) {
            ++this.tdsChannel.numMsgsRcvd;
        }
        if ((n3 = tDSPacket.header[3] & 0xFF | (tDSPacket.header[2] & 0xFF) << 8) < 8 || n3 > this.con.getTDSPacketSize()) {
            this.throwInvalidTDS();
        }
        tDSPacket.payloadLength = n3 - 8;
        n4 = tDSPacket.header[5] & 0xFF | (tDSPacket.header[4] & 0xFF) << 8;
        byte[] byArray = null;
        if (this.tdsChannel.isLoggingPackets()) {
            byArray = new byte[n3];
            System.arraycopy(tDSPacket.header, 0, byArray, 0, 8);
        }
        for (int i2 = 0; i2 < tDSPacket.payloadLength; i2 += n2) {
            n2 = this.tdsChannel.read(tDSPacket.payload, i2, tDSPacket.payloadLength - i2);
            if (n2 >= 0) continue;
            SQLServerException.makeFromDriverError(this.con, null, SQLServerException.getErrString("R_truncatedServerResponse"), "08006", true);
        }
        ++this.packetNum;
        this.lastPacket.next = tDSPacket;
        this.lastPacket = tDSPacket;
        if (this.tdsChannel.isLoggingPackets()) {
            System.arraycopy(tDSPacket.payload, 0, byArray, 8, tDSPacket.payloadLength);
            this.tdsChannel.logPacket(byArray, 0, n3, this.toLogString() + " received Packet:" + this.packetNum + " from SPID:" + n4 + " (" + tDSPacket.payloadLength + " bytes)");
        }
        return !tDSPacket.isEOM();
    }

    final TDSReaderMark mark() {
        TDSReaderMark tDSReaderMark = new TDSReaderMark(this.currentPacket, this.payloadOffset);
        this.isStreaming = false;
        if (this.isLoggable) {
            logger.finest(this.toLogString() + ": Buffering starting at mark MarkID:" + tDSReaderMark);
        }
        return tDSReaderMark;
    }

    final void reset(TDSReaderMark tDSReaderMark) {
        if (this.isLoggable) {
            logger.finest(this.toLogString() + ": Resetting to MarkID:" + tDSReaderMark);
        }
        this.currentPacket = tDSReaderMark.packet;
        this.payloadOffset = tDSReaderMark.payloadOffset;
    }

    final void stream() {
        this.isStreaming = true;
    }

    final int available() {
        int n2 = this.currentPacket.payloadLength - this.payloadOffset;
        TDSPacket tDSPacket = this.currentPacket.next;
        while (null != tDSPacket) {
            n2 += tDSPacket.payloadLength;
            tDSPacket = tDSPacket.next;
        }
        return n2;
    }

    final int peekTokenType() throws SQLServerException {
        if (this.payloadOffset == this.currentPacket.payloadLength && !this.nextPacket()) {
            return -1;
        }
        if (!$assertionsDisabled && this.payloadOffset >= this.currentPacket.payloadLength) {
            throw new AssertionError();
        }
        return this.currentPacket.payload[this.payloadOffset] & 0xFF;
    }

    final int readUnsignedByte() throws SQLServerException {
        if (this.payloadOffset == this.currentPacket.payloadLength && !this.nextPacket() && !$assertionsDisabled) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.payloadOffset >= this.currentPacket.payloadLength) {
            throw new AssertionError();
        }
        return this.currentPacket.payload[this.payloadOffset++] & 0xFF;
    }

    final short readShort() throws SQLServerException {
        if (this.payloadOffset + 2 <= this.currentPacket.payloadLength) {
            short s2 = Util.readShort(this.currentPacket.payload, this.payloadOffset);
            this.payloadOffset += 2;
            return s2;
        }
        return Util.readShort(this.readWrappedBytes(2), 0);
    }

    final int readUnsignedShort() throws SQLServerException {
        if (this.payloadOffset + 2 <= this.currentPacket.payloadLength) {
            int n2 = Util.readUnsignedShort(this.currentPacket.payload, this.payloadOffset);
            this.payloadOffset += 2;
            return n2;
        }
        return Util.readUnsignedShort(this.readWrappedBytes(2), 0);
    }

    final String readUnicodeString(int n2) throws SQLServerException {
        int n3 = 2 * n2;
        byte[] byArray = new byte[n3];
        this.readBytes(byArray, 0, n3);
        return Util.readUnicodeString(byArray, 0, n3);
    }

    final char readChar() throws SQLServerException {
        return (char)this.readShort();
    }

    final int readInt() throws SQLServerException {
        if (this.payloadOffset + 4 <= this.currentPacket.payloadLength) {
            int n2 = Util.readInt(this.currentPacket.payload, this.payloadOffset);
            this.payloadOffset += 4;
            return n2;
        }
        return Util.readInt(this.readWrappedBytes(4), 0);
    }

    final long readUnsignedInt() throws SQLServerException {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    final long readLong() throws SQLServerException {
        if (this.payloadOffset + 8 <= this.currentPacket.payloadLength) {
            long l2 = Util.readLong(this.currentPacket.payload, this.payloadOffset);
            this.payloadOffset += 8;
            return l2;
        }
        return Util.readLong(this.readWrappedBytes(8), 0);
    }

    final void readBytes(byte[] byArray, int n2, int n3) throws SQLServerException {
        int n4 = 0;
        while (n4 < n3) {
            if (this.payloadOffset == this.currentPacket.payloadLength && !this.nextPacket() && !$assertionsDisabled) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.payloadOffset >= this.currentPacket.payloadLength) {
                throw new AssertionError();
            }
            int n5 = n3 - n4;
            if (n5 > this.currentPacket.payloadLength - this.payloadOffset) {
                n5 = this.currentPacket.payloadLength - this.payloadOffset;
            }
            System.arraycopy(this.currentPacket.payload, this.payloadOffset, byArray, n2 + n4, n5);
            n4 += n5;
            this.payloadOffset += n5;
        }
    }

    final byte[] readWrappedBytes(int n2) throws SQLServerException {
        this.readBytes(this.valueBytes, 0, n2);
        return this.valueBytes;
    }

    final Object readUnicodeString(int n2, int n3, InputStreamGetterArgs inputStreamGetterArgs, ServerDTVImpl serverDTVImpl) throws SQLServerException {
        SimpleInputStream simpleInputStream = new SimpleInputStream(this, n2, inputStreamGetterArgs, serverDTVImpl);
        if (2 == inputStreamGetterArgs.streamType && inputStreamGetterArgs.isAdaptive) {
            return simpleInputStream;
        }
        byte[] byArray = simpleInputStream.getBytes();
        return DDC.convertStringToObject(Util.readUnicodeString(byArray, 0, n2), "UTF-16LE", n3, inputStreamGetterArgs.streamType);
    }

    final Object readDecimal(int n2, TypeInfo typeInfo, int n3, int n4) throws SQLServerException {
        byte[] byArray = new byte[n2];
        this.readBytes(byArray, 0, n2);
        int n5 = 0 == byArray[0] ? -1 : 1;
        byte[] byArray2 = new byte[n2 - 1];
        for (int i2 = 1; i2 <= byArray2.length; ++i2) {
            byArray2[byArray2.length - i2] = byArray[i2];
        }
        BigDecimal bigDecimal = new BigDecimal(new BigInteger(n5, byArray2), typeInfo.getScale());
        return DDC.convertBigDecimalToObject(bigDecimal, n3, n4);
    }

    final Object readMoney(int n2, int n3, int n4) throws SQLServerException {
        BigInteger bigInteger;
        switch (n2) {
            case 8: {
                int n5 = this.readInt();
                int n6 = this.readInt();
                if (-2 == n3) {
                    byte[] byArray = new byte[8];
                    Util.writeIntBigEndian(n5, byArray, 0);
                    Util.writeIntBigEndian(n6, byArray, 4);
                    return byArray;
                }
                bigInteger = BigInteger.valueOf((long)n5 << 32 | (long)n6 & 0xFFFFFFFFL);
                break;
            }
            case 4: {
                if (-2 == n3) {
                    byte[] byArray = new byte[4];
                    Util.writeIntBigEndian(this.readInt(), byArray, 0);
                    return byArray;
                }
                bigInteger = BigInteger.valueOf(this.readInt());
                break;
            }
            default: {
                this.throwInvalidTDS();
                return null;
            }
        }
        return DDC.convertBigDecimalToObject(new BigDecimal(bigInteger, 4), n3, n4);
    }

    final Object readReal(int n2, int n3, int n4) throws SQLServerException {
        if (4 != n2) {
            this.throwInvalidTDS();
        }
        return DDC.convertFloatToObject(Float.intBitsToFloat(this.readInt()), n3, n4);
    }

    final Object readFloat(int n2, int n3, int n4) throws SQLServerException {
        if (8 != n2) {
            this.throwInvalidTDS();
        }
        return DDC.convertDoubleToObject(Double.longBitsToDouble(this.readLong()), n3, n4);
    }

    final Object readDateTime(int n2, Calendar calendar, int n3, int n4) throws SQLServerException {
        int n5;
        int n6;
        switch (n2) {
            case 8: {
                n6 = this.readInt();
                int n7 = this.readInt();
                if (-2 == n3) {
                    byte[] byArray = new byte[8];
                    Util.writeIntBigEndian(n6, byArray, 0);
                    Util.writeIntBigEndian(n7, byArray, 4);
                    return byArray;
                }
                n5 = (n7 * 10 + 1) / 3;
                break;
            }
            case 4: {
                n6 = this.readUnsignedShort();
                int n8 = this.readUnsignedShort();
                if (-2 == n3) {
                    byte[] byArray = new byte[4];
                    Util.writeShortBigEndian((short)n6, byArray, 0);
                    Util.writeShortBigEndian((short)n8, byArray, 2);
                    return byArray;
                }
                n5 = n8 * 60 * 1000;
                break;
            }
            default: {
                this.throwInvalidTDS();
                return null;
            }
        }
        Calendar calendar2 = calendar;
        if (null == calendar2) {
            calendar2 = Calendar.getInstance(Locale.US);
        }
        calendar2.setLenient(true);
        calendar2.clear();
        if (91 == n3) {
            calendar2.set(1, 1900);
            calendar2.set(6, 1 + n6);
            return new Date(calendar2.getTimeInMillis());
        }
        if (92 == n3) {
            calendar2.set(14, n5);
            return new Time(calendar2.getTimeInMillis());
        }
        calendar2.set(1, 1900);
        calendar2.set(6, 1 + n6);
        calendar2.set(14, n5);
        Timestamp timestamp = new Timestamp(calendar2.getTimeInMillis());
        if (93 == n3) {
            return timestamp;
        }
        if (2 == n4) {
            return new StringReader(timestamp.toString());
        }
        return timestamp.toString();
    }

    final Object readBinary(int n2, int n3, InputStreamGetterArgs inputStreamGetterArgs, ServerDTVImpl serverDTVImpl) throws SQLServerException {
        SimpleInputStream simpleInputStream = new SimpleInputStream(this, n2, inputStreamGetterArgs, serverDTVImpl);
        if (1 == inputStreamGetterArgs.streamType || 3 == inputStreamGetterArgs.streamType) {
            return simpleInputStream;
        }
        byte[] byArray = simpleInputStream.getBytes();
        switch (n3) {
            case 2004: {
                return new SQLServerBlob(null, byArray);
            }
            case -1: 
            case 1: 
            case 12: {
                return DDC.convertStringToObject(Util.bytesToHexString(byArray, n2), "UTF-16LE", n3, inputStreamGetterArgs.streamType);
            }
        }
        return byArray;
    }

    final Object readGUID(int n2, int n3, int n4) throws SQLServerException {
        if (16 != n2) {
            this.throwInvalidTDS();
        }
        byte[] byArray = new byte[16];
        this.readBytes(byArray, 0, 16);
        switch (n3) {
            case -1: 
            case 1: 
            case 12: {
                int n5;
                StringBuffer stringBuffer = new StringBuffer(guidTemplate.length());
                for (n5 = 0; n5 < 4; ++n5) {
                    stringBuffer.append(Util.hexChars[(byArray[3 - n5] & 0xF0) >> 4]);
                    stringBuffer.append(Util.hexChars[byArray[3 - n5] & 0xF]);
                }
                stringBuffer.append('-');
                for (n5 = 0; n5 < 2; ++n5) {
                    stringBuffer.append(Util.hexChars[(byArray[5 - n5] & 0xF0) >> 4]);
                    stringBuffer.append(Util.hexChars[byArray[5 - n5] & 0xF]);
                }
                stringBuffer.append('-');
                for (n5 = 0; n5 < 2; ++n5) {
                    stringBuffer.append(Util.hexChars[(byArray[7 - n5] & 0xF0) >> 4]);
                    stringBuffer.append(Util.hexChars[byArray[7 - n5] & 0xF]);
                }
                stringBuffer.append('-');
                for (n5 = 0; n5 < 2; ++n5) {
                    stringBuffer.append(Util.hexChars[(byArray[8 + n5] & 0xF0) >> 4]);
                    stringBuffer.append(Util.hexChars[byArray[8 + n5] & 0xF]);
                }
                stringBuffer.append('-');
                for (n5 = 0; n5 < 6; ++n5) {
                    stringBuffer.append(Util.hexChars[(byArray[10 + n5] & 0xF0) >> 4]);
                    stringBuffer.append(Util.hexChars[byArray[10 + n5] & 0xF]);
                }
                return DDC.convertStringToObject(stringBuffer.toString(), "UTF-16LE", n3, n4);
            }
        }
        if (1 == n4 || 3 == n4) {
            return new ByteArrayInputStream(byArray);
        }
        return byArray;
    }

    final void skip(int n2) throws SQLServerException {
        while (n2 > 0) {
            if (this.currentPacket.payloadLength == this.payloadOffset && !this.nextPacket() && !$assertionsDisabled) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.payloadOffset >= this.currentPacket.payloadLength) {
                throw new AssertionError();
            }
            int n3 = n2;
            if (n3 > this.currentPacket.payloadLength - this.payloadOffset) {
                n3 = this.currentPacket.payloadLength - this.payloadOffset;
            }
            n2 -= n3;
            this.payloadOffset += n3;
        }
    }

    static {
        $assertionsDisabled = !TDSReader.class.desiredAssertionStatus();
        logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.TDSReader");
    }
}

