/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.TDS;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSTokenHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

final class TDSParser {
    private static Logger logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.TDS.TOKEN");

    TDSParser() {
    }

    static void parse(TDSReader tDSReader, String string) throws SQLServerException {
        TDSParser.parse(tDSReader, new TDSTokenHandler(string));
    }

    static void parse(TDSReader tDSReader, TDSTokenHandler tDSTokenHandler) throws SQLServerException {
        boolean bl2 = logger.isLoggable(Level.FINEST);
        boolean bl3 = true;
        block16: while (bl3) {
            int n2 = tDSReader.peekTokenType();
            if (bl2) {
                logger.finest(tDSReader.toLogString() + ": " + tDSTokenHandler.logContext + ": Processing " + (-1 == n2 ? "EOF" : TDS.getTokenName(n2)));
            }
            switch (n2) {
                case 237: {
                    bl3 = tDSTokenHandler.onSSPI(tDSReader);
                    continue block16;
                }
                case 173: {
                    bl3 = tDSTokenHandler.onLoginAck(tDSReader);
                    continue block16;
                }
                case 227: {
                    bl3 = tDSTokenHandler.onEnvChange(tDSReader);
                    continue block16;
                }
                case 121: {
                    bl3 = tDSTokenHandler.onRetStatus(tDSReader);
                    continue block16;
                }
                case 172: {
                    bl3 = tDSTokenHandler.onRetValue(tDSReader);
                    continue block16;
                }
                case 253: 
                case 254: 
                case 255: {
                    bl3 = tDSTokenHandler.onDone(tDSReader);
                    continue block16;
                }
                case 170: {
                    bl3 = tDSTokenHandler.onError(tDSReader);
                    continue block16;
                }
                case 171: {
                    bl3 = tDSTokenHandler.onInfo(tDSReader);
                    continue block16;
                }
                case 169: {
                    bl3 = tDSTokenHandler.onOrder(tDSReader);
                    continue block16;
                }
                case 129: {
                    bl3 = tDSTokenHandler.onColMetaData(tDSReader);
                    continue block16;
                }
                case 209: {
                    bl3 = tDSTokenHandler.onRow(tDSReader);
                    continue block16;
                }
                case 165: {
                    bl3 = tDSTokenHandler.onColInfo(tDSReader);
                    continue block16;
                }
                case 164: {
                    bl3 = tDSTokenHandler.onTabName(tDSReader);
                    continue block16;
                }
                case -1: {
                    tDSTokenHandler.onEOF(tDSReader);
                    bl3 = false;
                    continue block16;
                }
            }
            TDSParser.throwUnexpectedTokenException(tDSReader, tDSTokenHandler.logContext);
        }
    }

    static void throwUnexpectedTokenException(TDSReader tDSReader, String string) throws SQLServerException {
        logger.severe(tDSReader.toLogString() + ": " + string + ": Encountered unexpected " + TDS.getTokenName(tDSReader.peekTokenType()));
        tDSReader.throwInvalidTDS();
    }

    static void ignoreLengthPrefixedToken(TDSReader tDSReader) throws SQLServerException {
        tDSReader.readUnsignedByte();
        int n2 = tDSReader.readUnsignedShort();
        byte[] byArray = new byte[n2];
        tDSReader.readBytes(byArray, 0, n2);
    }
}

