/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.BaseInputStream;
import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.ServerDTVImpl;
import com.microsoft.sqlserver.jdbc.TDSReader;
import java.io.IOException;
import java.util.logging.Level;

final class SimpleInputStream
extends BaseInputStream {
    private final int payloadLength;
    private final byte[] bSingleByte = new byte[1];
    static final /* synthetic */ boolean $assertionsDisabled;

    SimpleInputStream(TDSReader tDSReader, int n2, InputStreamGetterArgs inputStreamGetterArgs, ServerDTVImpl serverDTVImpl) throws SQLServerException {
        super(tDSReader, inputStreamGetterArgs.isAdaptive, inputStreamGetterArgs.isStreaming, serverDTVImpl);
        this.setLoggingInfo(inputStreamGetterArgs.logContext);
        this.payloadLength = n2;
    }

    public void close() throws IOException {
        if (null == this.tdsReader) {
            return;
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(this.toLogString() + "Enter Closing SimpleInputStream.");
        }
        this.skip(this.payloadLength - this.streamPos);
        this.closeHelper();
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(this.toLogString() + "Exit Closing SimpleInputStream.");
        }
    }

    private final boolean isEOS() throws IOException {
        if (!$assertionsDisabled && this.streamPos > this.payloadLength) {
            throw new AssertionError();
        }
        return this.streamPos == this.payloadLength;
    }

    public long skip(long l2) throws IOException {
        this.checkClosed();
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(this.toLogString() + " Skipping :" + l2);
        }
        if (l2 < 0L) {
            return 0L;
        }
        if (this.isEOS()) {
            return 0L;
        }
        int n2 = (long)this.streamPos + l2 > (long)this.payloadLength ? this.payloadLength - this.streamPos : (int)l2;
        try {
            this.tdsReader.skip(n2);
        }
        catch (SQLServerException sQLServerException) {
            throw new IOException(sQLServerException.getMessage());
        }
        this.streamPos += n2;
        if (this.isReadLimitSet && this.streamPos - this.markedStreamPos > this.readLimit) {
            this.clearCurrentMark();
        }
        return n2;
    }

    public int available() throws IOException {
        this.checkClosed();
        if (!$assertionsDisabled && this.streamPos > this.payloadLength) {
            throw new AssertionError();
        }
        int n2 = this.payloadLength - this.streamPos;
        if (this.tdsReader.available() < n2) {
            n2 = this.tdsReader.available();
        }
        return n2;
    }

    public int read() throws IOException {
        this.checkClosed();
        if (this.isEOS()) {
            return -1;
        }
        int n2 = this.read(this.bSingleByte, 0, 1);
        return 0 == n2 ? -1 : this.bSingleByte[0] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        this.checkClosed();
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        this.checkClosed();
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(this.toLogString() + " Read at offset:" + n2 + " BytesToRead:" + n3);
        }
        if (n2 < 0 || n3 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.isEOS()) {
            return -1;
        }
        if (n3 < 0) {
            return 0;
        }
        int n4 = 0;
        n4 = this.streamPos + n3 > this.payloadLength ? this.payloadLength - this.streamPos : n3;
        try {
            this.tdsReader.readBytes(byArray, n2, n4);
        }
        catch (SQLServerException sQLServerException) {
            throw new IOException(sQLServerException.getMessage());
        }
        this.streamPos += n4;
        if (this.isReadLimitSet && this.streamPos - this.markedStreamPos > this.readLimit) {
            this.clearCurrentMark();
        }
        return n4;
    }

    public void mark(int n2) {
        if (null != this.tdsReader && n2 > 0) {
            this.currentMark = this.tdsReader.mark();
            this.markedStreamPos = this.streamPos;
            this.setReadLimit(n2);
        }
    }

    public void reset() throws IOException {
        this.resetHelper();
        this.streamPos = this.markedStreamPos;
    }

    final byte[] getBytes() throws SQLServerException {
        if (!$assertionsDisabled && 0 != this.streamPos) {
            throw new AssertionError();
        }
        byte[] byArray = new byte[this.payloadLength];
        try {
            this.read(byArray);
            this.close();
        }
        catch (IOException iOException) {
            SQLServerException.makeFromDriverError(null, null, iOException.getMessage(), null, true);
        }
        return byArray;
    }

    static {
        $assertionsDisabled = !SimpleInputStream.class.desiredAssertionStatus();
    }
}

