/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.TDSReaderMark;
import java.util.logging.Level;

final class ScrollWindow {
    private TDSReaderMark[] rowMark;
    private boolean[] updatedRow;
    private boolean[] deletedRow;
    private int size = 0;
    private int maxRows = 0;
    private int currentRow;
    static final /* synthetic */ boolean $assertionsDisabled;

    final int getMaxRows() {
        return this.maxRows;
    }

    final int getRow() {
        return this.currentRow;
    }

    ScrollWindow(int n2) {
        this.setSize(n2);
        this.reset();
    }

    private final void setSize(int n2) {
        if (!$assertionsDisabled && this.size == n2) {
            throw new AssertionError();
        }
        this.size = n2;
        this.maxRows = n2;
        this.rowMark = new TDSReaderMark[n2];
        this.updatedRow = new boolean[n2];
        this.deletedRow = new boolean[n2];
    }

    final void clear() {
        for (int i2 = 0; i2 < this.rowMark.length; ++i2) {
            this.rowMark[i2] = null;
            this.updatedRow[i2] = false;
            this.deletedRow[i2] = false;
        }
        if (!$assertionsDisabled && this.size <= 0) {
            throw new AssertionError();
        }
        this.maxRows = this.size;
        this.reset();
    }

    final void reset() {
        this.currentRow = 0;
    }

    final void resize(int n2) {
        if (!$assertionsDisabled && n2 <= 0) {
            throw new AssertionError();
        }
        if (n2 != this.size) {
            this.setSize(n2);
        }
    }

    final String logCursorState() {
        return " currentRow:" + this.currentRow + " maxRows:" + this.maxRows;
    }

    final boolean next(SQLServerResultSet sQLServerResultSet) throws SQLServerException {
        if (SQLServerResultSet.logger.isLoggable(Level.FINER)) {
            SQLServerResultSet.logger.fine(sQLServerResultSet.toLogString() + this.logCursorState());
        }
        if (!($assertionsDisabled || 0 <= this.currentRow && this.currentRow <= this.maxRows + 1)) {
            throw new AssertionError();
        }
        if (this.maxRows + 1 == this.currentRow) {
            return false;
        }
        if (this.currentRow >= 1) {
            this.updatedRow[this.currentRow - 1] = sQLServerResultSet.getUpdatedCurrentRow();
            this.deletedRow[this.currentRow - 1] = sQLServerResultSet.getDeletedCurrentRow();
        }
        ++this.currentRow;
        if (this.maxRows + 1 == this.currentRow) {
            sQLServerResultSet.fetchBufferNext();
            return false;
        }
        if (null != this.rowMark[this.currentRow - 1]) {
            sQLServerResultSet.fetchBufferReset(this.rowMark[this.currentRow - 1]);
            sQLServerResultSet.setUpdatedCurrentRow(this.updatedRow[this.currentRow - 1]);
            sQLServerResultSet.setDeletedCurrentRow(this.deletedRow[this.currentRow - 1]);
            return true;
        }
        if (sQLServerResultSet.fetchBufferNext()) {
            this.rowMark[this.currentRow - 1] = sQLServerResultSet.fetchBufferMark();
            return true;
        }
        this.maxRows = this.currentRow - 1;
        return false;
    }

    final void previous(SQLServerResultSet sQLServerResultSet) throws SQLServerException {
        if (SQLServerResultSet.logger.isLoggable(Level.FINER)) {
            SQLServerResultSet.logger.fine(sQLServerResultSet.toLogString() + this.logCursorState());
        }
        if (!($assertionsDisabled || 0 <= this.currentRow && this.currentRow <= this.maxRows + 1)) {
            throw new AssertionError();
        }
        if (0 == this.currentRow) {
            return;
        }
        if (this.currentRow <= this.maxRows) {
            if (!$assertionsDisabled && this.currentRow < 1) {
                throw new AssertionError();
            }
            this.updatedRow[this.currentRow - 1] = sQLServerResultSet.getUpdatedCurrentRow();
            this.deletedRow[this.currentRow - 1] = sQLServerResultSet.getDeletedCurrentRow();
        }
        --this.currentRow;
        if (0 == this.currentRow) {
            return;
        }
        if (!$assertionsDisabled && null == this.rowMark[this.currentRow - 1]) {
            throw new AssertionError();
        }
        sQLServerResultSet.fetchBufferReset(this.rowMark[this.currentRow - 1]);
        sQLServerResultSet.setUpdatedCurrentRow(this.updatedRow[this.currentRow - 1]);
        sQLServerResultSet.setDeletedCurrentRow(this.deletedRow[this.currentRow - 1]);
    }

    static {
        $assertionsDisabled = !ScrollWindow.class.desiredAssertionStatus();
    }
}

