/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.CharacterStreamSetterArgs;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.InputStreamSetterArgs;
import com.microsoft.sqlserver.jdbc.JDBCCallSyntaxTranslator;
import com.microsoft.sqlserver.jdbc.Parameter;
import com.microsoft.sqlserver.jdbc.ParameterUtils;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerParameterMetaData;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import com.microsoft.sqlserver.jdbc.TDSCommand;
import com.microsoft.sqlserver.jdbc.TDSParser;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import com.microsoft.sqlserver.jdbc.UninterruptableTDSCommand;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.logging.Level;

public class SQLServerPreparedStatement
extends SQLServerStatement
implements PreparedStatement {
    private static final int BATCH_STATEMENT_DELIMITER_TDS_71 = 128;
    private static final int BATCH_STATEMENT_DELIMITER_TDS_72 = 255;
    final int nBatchStatementDelimiter;
    private String sqlCommand;
    private String preparedTypeDefinitions;
    private String preparedSQL;
    final boolean bReturnValueSyntax;
    ArrayList batchParamValues;
    static final /* synthetic */ boolean $assertionsDisabled;

    final String getPreparedSQL() {
        return this.preparedSQL;
    }

    SQLServerPreparedStatement(SQLServerConnection sQLServerConnection, String string, int n2, int n3) throws SQLServerException {
        super(sQLServerConnection, n2, n3);
        this.nBatchStatementDelimiter = this.connection.isYukonOrLater() ? 255 : 128;
        this.sendStringParametersAsUnicode = sQLServerConnection.sendStringParametersAsUnicode();
        this.sqlCommand = string;
        this.prepStmtHandle = 0;
        JDBCCallSyntaxTranslator jDBCCallSyntaxTranslator = new JDBCCallSyntaxTranslator();
        string = jDBCCallSyntaxTranslator.translate(string);
        this.procedureName = jDBCCallSyntaxTranslator.getProcedureName();
        this.bReturnValueSyntax = jDBCCallSyntaxTranslator.hasReturnValueSyntax();
        this.userSQL = string;
        this.initParams(this.userSQL);
    }

    private void closePreparedHandle() throws SQLServerException {
        if (this.connection.isClosed()) {
            return;
        }
        final class PreparedHandleClose
        extends UninterruptableTDSCommand {
            PreparedHandleClose() {
                super("closePreparedHandle");
            }

            final boolean doExecute() throws SQLServerException {
                TDSWriter tDSWriter = this.startRequest((byte)3);
                tDSWriter.writeShort((short)-1);
                tDSWriter.writeShort(SQLServerPreparedStatement.this.isServerSideCursor ? (short)6 : 15);
                tDSWriter.writeByte((byte)0);
                tDSWriter.writeByte((byte)0);
                tDSWriter.writeRPCInt(null, new Integer(SQLServerPreparedStatement.this.prepStmtHandle), false);
                SQLServerPreparedStatement.this.prepStmtHandle = 0;
                TDSParser.parse(this.startResponse(), this.getLogContext());
                return true;
            }
        }
        this.executeCommand(new PreparedHandleClose());
    }

    public void close() throws SQLServerException {
        block4: {
            super.close();
            this.batchParamValues = null;
            if (0 != this.prepStmtHandle) {
                if (this.getStatementLogger().isLoggable(Level.FINE)) {
                    this.getStatementLogger().fine(this.toLogString() + ": Closing PreparedHandle:" + this.prepStmtHandle);
                }
                try {
                    this.closePreparedHandle();
                }
                catch (SQLServerException sQLServerException) {
                    if (!this.getStatementLogger().isLoggable(Level.WARNING)) break block4;
                    this.getStatementLogger().log(Level.WARNING, this.toLogString() + ": Error (ignored) closing PreparedHandle:" + this.prepStmtHandle, sQLServerException);
                }
            }
        }
    }

    final void initParams(String string) {
        int n2 = 0;
        int n3 = -1;
        while (true) {
            ++n3;
            if ((n3 = ParameterUtils.scanSQLForChar('?', string, n3)) >= string.length()) break;
            ++n2;
        }
        this.inOutParam = new Parameter[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.inOutParam[i2] = new Parameter();
        }
    }

    public final void clearParameters() throws SQLServerException {
        this.checkClosed();
        if (this.inOutParam == null) {
            return;
        }
        for (int i2 = 0; i2 < this.inOutParam.length; ++i2) {
            this.inOutParam[i2].clearInputValue();
        }
    }

    private final boolean buildPreparedStrings(Parameter[] parameterArray) throws SQLServerException {
        String string = this.buildParamTypeDefinitions(parameterArray);
        if (null != this.preparedTypeDefinitions && string.equals(this.preparedTypeDefinitions)) {
            return false;
        }
        this.preparedTypeDefinitions = string;
        this.preparedSQL = this.connection.replaceParameterMarkers(this.userSQL, parameterArray, this.bReturnValueSyntax);
        if (this.bRequestedGeneratedKeys) {
            this.preparedSQL = this.preparedSQL + " select SCOPE_IDENTITY() AS GENERATED_KEYS";
        }
        return true;
    }

    private String buildParamTypeDefinitions(Parameter[] parameterArray) throws SQLServerException {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = parameterArray.length;
        char[] cArray = new char[10];
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(',');
            }
            int n3 = SQLServerConnection.makeParamName(i2, cArray, 0);
            for (int i3 = 0; i3 < n3; ++i3) {
                stringBuffer.append(cArray[i3]);
            }
            stringBuffer.append(' ');
            String string = parameterArray[i2].getTypeDefinition(this.connection, this.tdsReader);
            if (null == string) {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_valueNotSetForParameter"));
                Object[] objectArray = new Object[]{new Integer(i2 + 1)};
                SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), null, false);
            }
            stringBuffer.append(string);
            if (!parameterArray[i2].isOutput()) continue;
            stringBuffer.append(" OUTPUT");
        }
        return stringBuffer.toString();
    }

    public ResultSet executeQuery() throws SQLServerException {
        this.checkClosed();
        this.executeStatement(new PrepStmtExecCmd(this, 1));
        return this.resultSet;
    }

    public int executeUpdate() throws SQLServerException {
        this.checkClosed();
        this.executeStatement(new PrepStmtExecCmd(this, 2));
        return this.updateCount;
    }

    public boolean execute() throws SQLServerException {
        this.checkClosed();
        this.executeStatement(new PrepStmtExecCmd(this, 3));
        return null != this.resultSet;
    }

    final void doExecutePreparedStatement(PrepStmtExecCmd prepStmtExecCmd) throws SQLServerException {
        this.resetForReexecute();
        if (2 != this.executeMethod) {
            this.connection.setMaxRows(this.maxRows);
            this.connection.setMaxFieldSize(this.maxFieldSize);
        }
        if (2 == this.executeMethod) {
            this.isServerSideCursor = false;
        }
        TDSWriter tDSWriter = prepStmtExecCmd.startRequest((byte)3);
        this.doPrepExec(tDSWriter, this.inOutParam);
        this.tdsReader = prepStmtExecCmd.startResponse(this.getIsResponseBufferingAdaptive());
        this.moreResults = true;
        this.getNextResult();
        if (1 == this.executeMethod && null == this.resultSet) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_noResultset"), null, true);
        } else if (2 == this.executeMethod && null != this.resultSet) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_resultsetGeneratedForUpdate"), null, false);
        }
    }

    void sendParamsByRPC(TDSWriter tDSWriter, Parameter[] parameterArray) throws SQLServerException {
        for (int i2 = 0; i2 < this.inOutParam.length; ++i2) {
            parameterArray[i2].sendByRPC(tDSWriter, this.connection, i2);
        }
    }

    private final void buildServerCursorPrepExecParams(TDSWriter tDSWriter) throws SQLServerException {
        if (this.getStatementLogger().isLoggable(Level.FINE)) {
            this.getStatementLogger().fine(this.toLogString() + ": calling sp_cursorprepexec: PreparedHandle:" + this.prepStmtHandle + ", SQL:" + this.preparedSQL);
        }
        this.prepexecOutParamCount = 3;
        this.prepexecOutParamIndexAdjustment = 7;
        tDSWriter.writeShort((short)-1);
        tDSWriter.writeShort((short)5);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeRPCInt(null, new Integer(this.prepStmtHandle), true);
        this.prepStmtHandle = 0;
        tDSWriter.writeRPCInt(null, new Integer(0), true);
        tDSWriter.writeRPCString(this.preparedTypeDefinitions.length() > 0 ? this.preparedTypeDefinitions : null);
        tDSWriter.writeRPCString(this.preparedSQL);
        tDSWriter.writeRPCInt(null, new Integer(this.getResultSetScrollOpt() & ~(0 == this.preparedTypeDefinitions.length() ? 4096 : 0)), false);
        tDSWriter.writeRPCInt(null, new Integer(this.getResultSetCCOpt()), false);
        tDSWriter.writeRPCInt(null, new Integer(0), true);
    }

    private final void buildPrepExecParams(TDSWriter tDSWriter) throws SQLServerException {
        if (this.getStatementLogger().isLoggable(Level.FINE)) {
            this.getStatementLogger().fine(this.toLogString() + ": calling sp_prepexec: PreparedHandle:" + this.prepStmtHandle + ", SQL:" + this.preparedSQL);
        }
        this.prepexecOutParamCount = 1;
        this.prepexecOutParamIndexAdjustment = 3;
        tDSWriter.writeShort((short)-1);
        tDSWriter.writeShort((short)13);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeRPCInt(null, new Integer(this.prepStmtHandle), true);
        this.prepStmtHandle = 0;
        tDSWriter.writeRPCString(this.preparedTypeDefinitions.length() > 0 ? this.preparedTypeDefinitions : null);
        tDSWriter.writeRPCString(this.preparedSQL);
    }

    private final void buildServerCursorExecParams(TDSWriter tDSWriter) throws SQLServerException {
        if (this.getStatementLogger().isLoggable(Level.FINE)) {
            this.getStatementLogger().fine(this.toLogString() + ": calling sp_cursorexecute: PreparedHandle:" + this.prepStmtHandle + ", SQL:" + this.preparedSQL);
        }
        this.prepexecOutParamCount = 2;
        this.prepexecOutParamIndexAdjustment = 5;
        tDSWriter.writeShort((short)-1);
        tDSWriter.writeShort((short)4);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeRPCInt(null, new Integer(this.prepStmtHandle), false);
        tDSWriter.writeRPCInt(null, new Integer(0), true);
        tDSWriter.writeRPCInt(null, new Integer(this.getResultSetScrollOpt() & 0xFFFFEFFF), false);
        tDSWriter.writeRPCInt(null, new Integer(this.getResultSetCCOpt()), false);
        tDSWriter.writeRPCInt(null, new Integer(0), true);
    }

    private final void buildExecParams(TDSWriter tDSWriter) throws SQLServerException {
        if (this.getStatementLogger().isLoggable(Level.FINE)) {
            this.getStatementLogger().fine(this.toLogString() + ": calling sp_execute: PreparedHandle:" + this.prepStmtHandle + ", SQL:" + this.preparedSQL);
        }
        this.prepexecOutParamCount = 0;
        this.prepexecOutParamIndexAdjustment = 1;
        tDSWriter.writeShort((short)-1);
        tDSWriter.writeShort((short)12);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeRPCInt(null, new Integer(this.prepStmtHandle), false);
    }

    private final boolean doPrepExec(TDSWriter tDSWriter, Parameter[] parameterArray) throws SQLServerException {
        boolean bl2;
        boolean bl3 = bl2 = this.buildPreparedStrings(parameterArray) || 0 == this.prepStmtHandle;
        if (bl2) {
            if (this.isServerSideCursor && (3 == this.executeMethod || 1 == this.executeMethod)) {
                this.buildServerCursorPrepExecParams(tDSWriter);
            } else {
                this.buildPrepExecParams(tDSWriter);
            }
        } else if (this.isServerSideCursor && (3 == this.executeMethod || 1 == this.executeMethod)) {
            this.buildServerCursorExecParams(tDSWriter);
        } else {
            this.buildExecParams(tDSWriter);
        }
        this.sendParamsByRPC(tDSWriter, parameterArray);
        return bl2;
    }

    public final ResultSetMetaData getMetaData() throws SQLServerException {
        boolean bl2 = false;
        try {
            if (this.resultSet != null) {
                this.resultSet.checkClosed();
            }
        }
        catch (SQLServerException sQLServerException) {
            bl2 = true;
        }
        if (this.resultSet == null || bl2) {
            ResultSetMetaData resultSetMetaData = null;
            SQLServerResultSet sQLServerResultSet = (SQLServerResultSet)this.buildExecuteMetaData();
            if (null != sQLServerResultSet) {
                resultSetMetaData = sQLServerResultSet.getMetaData();
            }
            return resultSetMetaData;
        }
        if (this.resultSet != null) {
            return this.resultSet.getMetaData();
        }
        return null;
    }

    private ResultSet buildExecuteMetaData() throws SQLServerException {
        SQLServerResultSet sQLServerResultSet;
        block3: {
            String string = this.sqlCommand;
            if (string.indexOf(123) >= 0) {
                string = new JDBCCallSyntaxTranslator().translate(string);
            }
            sQLServerResultSet = null;
            try {
                string = SQLServerPreparedStatement.replaceMarkerWithNull(string);
                SQLServerStatement sQLServerStatement = (SQLServerStatement)this.connection.createStatement();
                sQLServerResultSet = sQLServerStatement.executeQueryInternal("set fmtonly on " + string + "\nset fmtonly off");
            }
            catch (SQLServerException sQLServerException) {
                if (sQLServerException.getMessage().equals(SQLServerException.getErrString("R_noResultset"))) break block3;
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_processingError"));
                Object[] objectArray = new Object[]{new String(sQLServerException.getMessage())};
                SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), null, true);
            }
        }
        return sQLServerResultSet;
    }

    final Parameter setterGetParam(int n2) throws SQLServerException {
        this.checkClosed();
        if (n2 < 1 || n2 > this.inOutParam.length) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_indexOutOfRange"));
            Object[] objectArray = new Object[]{new Integer(n2)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), "07009", false);
        }
        return this.inOutParam[n2 - 1];
    }

    public final void setAsciiStream(int n2, InputStream inputStream, int n3) throws SQLServerException {
        this.setterGetParam(n2).setValue(-1, inputStream, new InputStreamSetterArgs(3, n3), this.connection);
    }

    private final Parameter getParam(int n2) throws SQLServerException {
        if (--n2 < 0 || n2 >= this.inOutParam.length) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_indexOutOfRange"));
            Object[] objectArray = new Object[]{new Integer(n2 + 1)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), "07009", false);
        }
        return this.inOutParam[n2];
    }

    public final void setBigDecimal(int n2, BigDecimal bigDecimal) throws SQLServerException {
        this.setterGetParam(n2).setValue(3, bigDecimal, this.connection);
    }

    public final void setBinaryStream(int n2, InputStream inputStream, int n3) throws SQLServerException {
        this.setterGetParam(n2).setValue(-4, inputStream, new InputStreamSetterArgs(1, n3), this.connection);
    }

    public final void setBoolean(int n2, boolean bl2) throws SQLServerException {
        this.setterGetParam(n2).setValue(-7, new Boolean(bl2), this.connection);
    }

    public final void setByte(int n2, byte by) throws SQLServerException {
        this.setterGetParam(n2).setValue(5, new Byte(by), this.connection);
    }

    public final void setBytes(int n2, byte[] byArray) throws SQLServerException {
        this.setterGetParam(n2).setValue(-2, byArray, this.connection);
    }

    public final void setDouble(int n2, double d2) throws SQLServerException {
        this.setterGetParam(n2).setValue(8, new Double(d2), this.connection);
    }

    public final void setFloat(int n2, float f2) throws SQLServerException {
        this.setterGetParam(n2).setValue(7, new Float(f2), this.connection);
    }

    public final void setInt(int n2, int n3) throws SQLServerException {
        this.setterGetParam(n2).setValue(4, new Integer(n3), this.connection);
    }

    public final void setLong(int n2, long l2) throws SQLServerException {
        this.setterGetParam(n2).setValue(-5, new Long(l2), this.connection);
    }

    public final void setNull(int n2, int n3) throws SQLServerException {
        this.setObject(n2, null, n3, null);
    }

    public final void setObject(int n2, Object object) throws SQLServerException {
        this.setObject(n2, object, 999, null);
    }

    public final void setObject(int n2, Object object, int n3) throws SQLServerException {
        this.setObject(n2, object, n3, null);
    }

    public final void setObject(int n2, Object object, int n3, int n4) throws SQLServerException {
        this.setObject(n2, object, n3, new Integer(n4));
    }

    private final void setObject(int n2, Object object, int n3, Integer n4) throws SQLServerException {
        Parameter parameter = this.setterGetParam(n2);
        int n5 = DataTypes.getObjectJDBCType(object, n3);
        if (999 == n3) {
            n3 = n5;
        }
        if (null == object) {
            if (999 == n5) {
                n3 = parameter.getJdbcType();
                if (999 != n3) {
                    n5 = n3;
                } else {
                    n3 = 1;
                    n5 = 1;
                }
            } else if (DataTypes.isUnsupportedJDBCType(n3)) {
                n3 = -2;
            }
        }
        if (!DataTypes.canConvertFromJDBCTypeToJDBCType(n5, n3)) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unsupportedConversionFromTo"));
            Object[] objectArray = new Object[]{Util.javaSqlTypeToString(n5), Util.javaSqlTypeToString(n3)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), null, true);
        }
        if (Reader.class.isInstance(object)) {
            parameter.setValue(n3, object, new CharacterStreamSetterArgs(-1), this.connection);
        } else if (InputStream.class.isInstance(object)) {
            parameter.setValue(n3, object, new InputStreamSetterArgs(DataTypes.isBinaryJDBCType(n3) ? 1 : 3, -1L), this.connection);
        } else {
            parameter.setValue(n3, object, n4, this.connection);
        }
    }

    public final void setShort(int n2, short s2) throws SQLServerException {
        this.setterGetParam(n2).setValue(5, new Short(s2), this.connection);
    }

    public final void setString(int n2, String string) throws SQLServerException {
        this.setterGetParam(n2).setValue(1, string, this.connection);
    }

    private final void setTimeParam(int n2, Time time, Calendar calendar) throws SQLServerException {
        this.setterGetParam(n2).setValue(92, time, calendar, this.connection);
    }

    public final void setTime(int n2, Time time) throws SQLServerException {
        this.checkClosed();
        this.setTimeParam(n2, time, null);
    }

    private final void setTimestampParam(int n2, Timestamp timestamp, Calendar calendar) throws SQLServerException {
        this.setterGetParam(n2).setValue(93, timestamp, calendar, this.connection);
    }

    public final void setTimestamp(int n2, Timestamp timestamp) throws SQLServerException {
        this.setTimestampParam(n2, timestamp, null);
    }

    private final void setDateParam(int n2, Date date, Calendar calendar) throws SQLServerException {
        this.setterGetParam(n2).setValue(91, date, calendar, this.connection);
    }

    public final void setDate(int n2, Date date) throws SQLServerException {
        this.setDateParam(n2, date, null);
    }

    public final void setUnicodeStream(int n2, InputStream inputStream, int n3) throws SQLServerException {
        this.NotImplemented();
    }

    public final void addBatch() throws SQLServerException {
        this.checkClosed();
        if (this.batchParamValues == null) {
            this.batchParamValues = new ArrayList();
        }
        int n2 = this.inOutParam.length;
        Parameter[] parameterArray = new Parameter[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            parameterArray[i2] = this.inOutParam[i2].cloneForBatch();
        }
        this.batchParamValues.add(parameterArray);
    }

    public final void clearBatch() throws SQLServerException {
        this.checkClosed();
        this.batchParamValues = null;
    }

    public int[] executeBatch() throws SQLServerException, BatchUpdateException {
        this.checkClosed();
        this.resetForReexecute();
        if (this.batchParamValues == null) {
            return new int[0];
        }
        PrepStmtBatchExecCmd prepStmtBatchExecCmd = new PrepStmtBatchExecCmd(this);
        try {
            this.executeStatement(prepStmtBatchExecCmd);
        }
        catch (SQLServerException sQLServerException) {
            prepStmtBatchExecCmd.batchException = sQLServerException;
        }
        this.batchParamValues = null;
        if (null != prepStmtBatchExecCmd.batchException) {
            throw new BatchUpdateException(prepStmtBatchExecCmd.batchException.toString(), prepStmtBatchExecCmd.batchException.getSQLState(), prepStmtBatchExecCmd.batchException.getErrorCode(), prepStmtBatchExecCmd.updateCounts);
        }
        return prepStmtBatchExecCmd.updateCounts;
    }

    final void doExecutePreparedStatementBatch(PrepStmtBatchExecCmd prepStmtBatchExecCmd) throws SQLServerException {
        int n2;
        this.executeMethod = 4;
        prepStmtBatchExecCmd.batchException = null;
        int n3 = this.batchParamValues.size();
        prepStmtBatchExecCmd.updateCounts = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            prepStmtBatchExecCmd.updateCounts[n2] = -3;
        }
        n2 = 0;
        int n4 = 0;
        if (this.isSelect(this.userSQL)) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_selectNotPermittedinBatch"), null, true);
        }
        Parameter[] parameterArray = new Parameter[this.inOutParam.length];
        TDSWriter tDSWriter = null;
        while (n4 < n3) {
            Parameter[] parameterArray2 = (Parameter[])this.batchParamValues.get(n2);
            if (!$assertionsDisabled && parameterArray2.length != parameterArray.length) {
                throw new AssertionError();
            }
            for (int i2 = 0; i2 < parameterArray2.length; ++i2) {
                parameterArray[i2] = parameterArray2[i2];
            }
            if (n4 < n2) {
                tDSWriter.writeByte((byte)this.nBatchStatementDelimiter);
            } else {
                tDSWriter = prepStmtBatchExecCmd.startRequest((byte)3);
            }
            if (!this.doPrepExec(tDSWriter, parameterArray) && ++n2 != n3) continue;
            this.tdsReader = prepStmtBatchExecCmd.startResponse(this.getIsResponseBufferingAdaptive());
            this.moreResults = true;
            while (n4 < n2) {
                block10: {
                    try {
                        this.getNextResult();
                    }
                    catch (SQLServerException sQLServerException) {
                        this.updateCount = -3;
                        if (null != prepStmtBatchExecCmd.batchException) break block10;
                        prepStmtBatchExecCmd.batchException = sQLServerException;
                    }
                }
                prepStmtBatchExecCmd.updateCounts[n4++] = -1 == this.updateCount ? -2 : this.updateCount;
            }
        }
    }

    public final void setCharacterStream(int n2, Reader reader, int n3) throws SQLServerException {
        this.setterGetParam(n2).setValue(-1, reader, new CharacterStreamSetterArgs(n3), this.connection);
    }

    public final void setRef(int n2, Ref ref) throws SQLServerException {
        this.NotImplemented();
    }

    public final void setBlob(int n2, Blob blob) throws SQLServerException {
        this.setterGetParam(n2).setValue(2004, blob, this.connection);
    }

    public final void setClob(int n2, Clob clob) throws SQLServerException {
        this.setterGetParam(n2).setValue(2005, clob, this.connection);
    }

    public final void setArray(int n2, Array array) throws SQLServerException {
        this.NotImplemented();
    }

    public final void setDate(int n2, Date date, Calendar calendar) throws SQLServerException {
        this.checkClosed();
        this.setDateParam(n2, date, calendar);
    }

    public final void setTime(int n2, Time time, Calendar calendar) throws SQLServerException {
        this.checkClosed();
        this.setTimeParam(n2, time, calendar);
    }

    public final void setTimestamp(int n2, Timestamp timestamp, Calendar calendar) throws SQLServerException {
        this.checkClosed();
        this.setTimestampParam(n2, timestamp, calendar);
    }

    public final void setNull(int n2, int n3, String string) throws SQLServerException {
        this.checkClosed();
        this.setNull(n2, n3);
    }

    public final ParameterMetaData getParameterMetaData() throws SQLServerException {
        this.checkClosed();
        return new SQLServerParameterMetaData(this, this.userSQL);
    }

    public final void setURL(int n2, URL uRL) throws SQLServerException {
        this.NotImplemented();
    }

    public final int executeUpdate(String string) throws SQLServerException {
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_cannotTakeArgumentsPreparedOrCallable"));
        Object[] objectArray = new Object[]{new String("executeUpdate()")};
        throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
    }

    public final boolean execute(String string) throws SQLServerException {
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_cannotTakeArgumentsPreparedOrCallable"));
        Object[] objectArray = new Object[]{new String("execute()")};
        throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
    }

    public final ResultSet executeQuery(String string) throws SQLServerException {
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_cannotTakeArgumentsPreparedOrCallable"));
        Object[] objectArray = new Object[]{new String("executeQuery()")};
        throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
    }

    public void addBatch(String string) throws SQLServerException {
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_cannotTakeArgumentsPreparedOrCallable"));
        Object[] objectArray = new Object[]{new String("addBatch()")};
        throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
    }

    static {
        $assertionsDisabled = !SQLServerPreparedStatement.class.desiredAssertionStatus();
    }

    private final class PrepStmtBatchExecCmd
    extends TDSCommand {
        private final SQLServerPreparedStatement stmt;
        SQLServerException batchException;
        int[] updateCounts;

        PrepStmtBatchExecCmd(SQLServerPreparedStatement sQLServerPreparedStatement2) {
            super(sQLServerPreparedStatement2.toLogString() + " executeBatch", SQLServerPreparedStatement.this.queryTimeout);
            this.stmt = sQLServerPreparedStatement2;
        }

        final boolean doExecute() throws SQLServerException {
            this.stmt.doExecutePreparedStatementBatch(this);
            return true;
        }

        final void onAttention(TDSReader tDSReader) throws SQLServerException {
            SQLServerPreparedStatement.this.processAttention(tDSReader);
            super.onAttention(tDSReader);
        }
    }

    private final class PrepStmtExecCmd
    extends TDSCommand {
        private final SQLServerPreparedStatement stmt;

        PrepStmtExecCmd(SQLServerPreparedStatement sQLServerPreparedStatement2, int n2) {
            super(sQLServerPreparedStatement2.toLogString() + " executeXXX", SQLServerPreparedStatement.this.queryTimeout);
            this.stmt = sQLServerPreparedStatement2;
            sQLServerPreparedStatement2.executeMethod = n2;
        }

        final boolean doExecute() throws SQLServerException {
            this.stmt.doExecutePreparedStatement(this);
            return false;
        }

        final void onAttention(TDSReader tDSReader) throws SQLServerException {
            SQLServerPreparedStatement.this.processAttention(tDSReader);
            super.onAttention(tDSReader);
        }
    }
}

