/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerResource;
import com.microsoft.sqlserver.jdbc.StreamError;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ListResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SQLServerException
extends SQLException
implements Serializable {
    static final String EXCEPTION_XOPEN_CONNECTION_CANT_ESTABLISH = "08001";
    static final String EXCEPTION_XOPEN_CONNECTION_FAILURE = "08006";
    static final int LOGON_FAILED = 18456;
    static final int PASSWORD_EXPIRED = 18488;
    private final StreamError streamError;
    static Logger exLogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.SQLServerException");
    static final int DRIVER_ERROR_NONE = 0;
    static final int DRIVER_ERROR_COMMAND_INTERRUPTED = 1;
    static final int DRIVER_ERROR_FROM_DATABASE = 2;
    private int driverErrorCode = 0;

    final StreamError getDatabaseError() {
        return this.streamError;
    }

    final int getDriverErrorCode() {
        return this.driverErrorCode;
    }

    final void setDriverErrorCode(int n2) {
        this.driverErrorCode = n2;
    }

    private void logException(Object object, String string, boolean bl2) {
        String string2 = "";
        if (object != null) {
            string2 = object.toString();
        }
        if (exLogger.isLoggable(Level.FINE)) {
            exLogger.fine("*** SQLException:" + string2 + " " + this.toString() + " " + string);
        }
        if (bl2 && exLogger.isLoggable(Level.FINE)) {
            StringBuffer stringBuffer = new StringBuffer(100);
            StackTraceElement[] stackTraceElementArray = this.getStackTrace();
            for (int i2 = 0; i2 < stackTraceElementArray.length; ++i2) {
                stringBuffer.append(stackTraceElementArray[i2].toString());
            }
            exLogger.fine(stringBuffer.toString());
        }
    }

    static String getErrString(String string) {
        ListResourceBundle listResourceBundle = (ListResourceBundle)SQLServerResource.getBundle("com.microsoft.sqlserver.jdbc.SQLServerResource");
        return listResourceBundle.getString(string);
    }

    public SQLServerException(Object object, String string, String string2, int n2, boolean bl2) {
        super(string, string2, n2);
        this.streamError = null;
        this.logException(object, string, bl2);
    }

    public SQLServerException(Object object, String string, String string2, StreamError streamError, boolean bl2) {
        super(string, string2, streamError.getErrorNumber());
        this.streamError = streamError;
        string = "Msg " + streamError.getErrorNumber() + ", Level " + streamError.getErrorSeverity() + ", State " + streamError.getErrorState() + ", " + string;
        this.logException(object, string, bl2);
    }

    public static void makeFromDriverError(SQLServerConnection sQLServerConnection, Object object, String string, String string2, boolean bl2) throws SQLServerException {
        String string3 = "";
        if (string2 != null) {
            string3 = string2;
        }
        if (sQLServerConnection == null || !sQLServerConnection.xopenStates) {
            string3 = SQLServerException.mapFromXopen(string2);
        }
        SQLServerException sQLServerException = new SQLServerException(object, string, string3, 0, bl2);
        if (null != string2 && string2.equals(EXCEPTION_XOPEN_CONNECTION_FAILURE) && null != sQLServerConnection) {
            sQLServerConnection.notifyPooledConnection(sQLServerException);
            sQLServerConnection.close();
        }
        throw sQLServerException;
    }

    public static void makeFromDatabaseError(SQLServerConnection sQLServerConnection, Object object, String string, StreamError streamError, boolean bl2) throws SQLServerException {
        String string2 = SQLServerException.generateStateCode(sQLServerConnection, streamError.getErrorNumber(), streamError.getErrorState());
        SQLServerException sQLServerException = new SQLServerException(object, string, string2, streamError, bl2);
        sQLServerException.setDriverErrorCode(2);
        if (streamError.getErrorSeverity() >= 20 && null != sQLServerConnection) {
            sQLServerConnection.notifyPooledConnection(sQLServerException);
            sQLServerConnection.close();
        }
        throw sQLServerException;
    }

    public static String mapFromXopen(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("07009")) {
            return "S1093";
        }
        if (string.equals(EXCEPTION_XOPEN_CONNECTION_CANT_ESTABLISH)) {
            return "08S01";
        }
        if (string.equals(EXCEPTION_XOPEN_CONNECTION_FAILURE)) {
            return "08S01";
        }
        return "";
    }

    public static String generateStateCode(SQLServerConnection sQLServerConnection, int n2, int n3) {
        boolean bl2;
        boolean bl3 = bl2 = sQLServerConnection != null && sQLServerConnection.xopenStates;
        if (bl2) {
            switch (n2) {
                case 4060: {
                    return EXCEPTION_XOPEN_CONNECTION_CANT_ESTABLISH;
                }
                case 18456: {
                    return EXCEPTION_XOPEN_CONNECTION_CANT_ESTABLISH;
                }
                case 2714: {
                    return "42S01";
                }
                case 208: {
                    return "42S02";
                }
                case 207: {
                    return "42S22";
                }
            }
            return "42000";
        }
        switch (n2) {
            case 8152: {
                return "22001";
            }
            case 515: 
            case 547: {
                return "23000";
            }
            case 2714: {
                return "S0001";
            }
            case 208: {
                return "S0002";
            }
            case 1205: {
                return "40001";
            }
            case 2627: {
                return "23000";
            }
        }
        return "S000" + n3;
    }

    int getSQLSeverity() {
        if (null != this.streamError) {
            return this.streamError.getErrorSeverity();
        }
        return 0;
    }
}

