/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.AuthenticationJNI;
import com.microsoft.sqlserver.jdbc.FailoverInfo;
import com.microsoft.sqlserver.jdbc.FailoverMapSingleton;
import com.microsoft.sqlserver.jdbc.FailoverServerPortPlaceHolder;
import com.microsoft.sqlserver.jdbc.Parameter;
import com.microsoft.sqlserver.jdbc.ParameterUtils;
import com.microsoft.sqlserver.jdbc.SQLCollation;
import com.microsoft.sqlserver.jdbc.SQLServerCallableStatement;
import com.microsoft.sqlserver.jdbc.SQLServerConnectionSecurityManager;
import com.microsoft.sqlserver.jdbc.SQLServerDatabaseMetaData;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerPooledConnection;
import com.microsoft.sqlserver.jdbc.SQLServerPreparedStatement;
import com.microsoft.sqlserver.jdbc.SQLServerSavepoint;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import com.microsoft.sqlserver.jdbc.StreamLoginAck;
import com.microsoft.sqlserver.jdbc.StreamSSPI;
import com.microsoft.sqlserver.jdbc.TDSChannel;
import com.microsoft.sqlserver.jdbc.TDSCommand;
import com.microsoft.sqlserver.jdbc.TDSParser;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSReaderMark;
import com.microsoft.sqlserver.jdbc.TDSTokenHandler;
import com.microsoft.sqlserver.jdbc.TDSVersion;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import com.microsoft.sqlserver.jdbc.UninterruptableTDSCommand;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.IOException;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.XAConnection;

public class SQLServerConnection
implements Connection,
Serializable {
    public static final int TRANSACTION_SNAPSHOT = 4096;
    private static final float TIMEOUTSTEP = 0.08f;
    private boolean sendStringParametersAsUnicode = true;
    private boolean lastUpdateCount;
    private int nLockTimeout;
    private String selectMethod;
    private String responseBuffering;
    Properties activeConnectionProperties;
    private String applicationName;
    private String instanceName;
    private boolean integratedSecurity = false;
    String sConnectURL;
    String sqlServerVersion;
    boolean xopenStates;
    private boolean databaseAutoCommitMode = true;
    private boolean inXATransaction = false;
    private byte[] transactionDescriptor = new byte[8];
    boolean bIsOpen;
    private int connectionID = SQLServerConnection.nextConnectionID();
    static final int maxDecimalPrecision = 38;
    private int maxFieldSize = 0;
    private int maxRows = 0;
    private SQLCollation databaseCollation;
    private static int baseConnectionID = 0;
    private String sCatalog = "master";
    private int transactionIsolationLevel = 2;
    private SQLServerPooledConnection pooledConnectionParent;
    private DatabaseMetaData databaseMetaData;
    private int nNextSavePointId = 10000;
    private SQLServerConnectionSecurityManager securityManager;
    private Logger connectionlogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.SQLServerConnection");
    int udpMillisecondsTimeout = 10000;
    private String failoverPartnerServerProvided = null;
    private int nHoldability = 1;
    static final int DEFAULT_TDS_PACKET_SIZE = 8000;
    private int tdsPacketSize = 4096;
    private int requestedPacketSize = 8000;
    private TDSChannel tdsChannel;
    private TDSCommand currentCommand = null;
    private TDSVersion tdsVersion;
    static final int MAX_SQL_LOGIN_NAME_WCHARS = 128;
    Vector sqlWarnings;
    private static final int ENVCHANGE_DATABASE = 1;
    private static final int ENVCHANGE_LANGUAGE = 2;
    private static final int ENVCHANGE_CHARSET = 3;
    private static final int ENVCHANGE_PACKETSIZE = 4;
    private static final int ENVCHANGE_SORTLOCALEID = 5;
    private static final int ENVCHANGE_SORTFLAGS = 6;
    private static final int ENVCHANGE_SQLCOLLATION = 7;
    private static final int ENVCHANGE_XACT_BEGIN = 8;
    private static final int ENVCHANGE_XACT_COMMIT = 9;
    private static final int ENVCHANGE_XACT_ROLLBACK = 10;
    private static final int ENVCHANGE_DTC_ENLIST = 11;
    private static final int ENVCHANGE_DTC_DEFECT = 12;
    private static final int ENVCHANGE_CHANGE_MIRROR = 13;
    private static final int ENVCHANGE_UNUSED_14 = 14;
    private static final int ENVCHANGE_DTC_PROMOTE = 15;
    private static final int ENVCHANGE_DTC_MGR_ADDR = 16;
    private static final int ENVCHANGE_XACT_ENDED = 17;
    private static final int ENVCHANGE_RESET_COMPLETE = 18;
    private static final int ENVCHANGE_USER_INFO = 19;
    static final char[] OUT = new char[]{' ', 'O', 'U', 'T'};

    boolean sendStringParametersAsUnicode() {
        return this.sendStringParametersAsUnicode;
    }

    final boolean useLastUpdateCount() {
        return this.lastUpdateCount;
    }

    final String getSelectMethod() {
        return this.selectMethod;
    }

    final String getResponseBuffering() {
        return this.responseBuffering;
    }

    final void setMaxFieldSize(int n2) throws SQLServerException {
        if (this.maxFieldSize != n2) {
            this.connectionCommand("SET TEXTSIZE " + (0 == n2 ? Integer.MAX_VALUE : n2), "setMaxFieldSize");
            this.maxFieldSize = n2;
        }
    }

    final void setMaxRows(int n2) throws SQLServerException {
        if (this.maxRows != n2) {
            this.connectionCommand("SET ROWCOUNT " + n2, "setMaxRows");
            this.maxRows = n2;
        }
    }

    final SQLCollation getDatabaseCollation() {
        return this.databaseCollation;
    }

    final int getTDSPacketSize() {
        return this.tdsPacketSize;
    }

    final boolean isYukonOrLater() {
        return this.tdsVersion.isYukonOrLater();
    }

    SQLServerConnection() {
    }

    void setFailoverPartnerServerProvided(String string) {
        this.failoverPartnerServerProvided = string;
    }

    private static synchronized int nextConnectionID() {
        return ++baseConnectionID;
    }

    Logger getConnectionLogger() {
        return this.connectionlogger;
    }

    final int getRawLoggingID() {
        return this.connectionID;
    }

    String toLogString() {
        String string = " ConnectionID:" + this.connectionID + " TransactionID:" + Util.byteToHexDisplayString(this.transactionDescriptor);
        return string;
    }

    void NotImplemented() throws SQLServerException {
        SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_notSupported"), null, false);
    }

    void checkClosed() throws SQLServerException {
        if (!this.bIsOpen) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_connectionIsClosed"), null, false);
        }
    }

    private boolean booleanPropertyOn(String string, String string2) throws SQLServerException {
        if (null == string2) {
            return false;
        }
        String string3 = string2.toLowerCase(Locale.US);
        if (string3.equals("true")) {
            return true;
        }
        if (string3.equals("false")) {
            return false;
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidBooleanValue"));
        Object[] objectArray = new Object[]{new String(string)};
        SQLServerException.makeFromDriverError(this, this, messageFormat.format(objectArray), null, false);
        return false;
    }

    private static String AppendNameValue(String string, String string2, String string3) {
        string = string + string2;
        string = string + " : ";
        string = string3 != null ? string + string3 : string + "no value set";
        string = string + "  ";
        return string;
    }

    void ValidateMaxSQLLoginName(String string, String string2) throws SQLServerException {
        if (string2 != null && string2.length() > 128) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_propertyMaximumExceedsChars"));
            Object[] objectArray = new Object[]{string, new Integer(128)};
            SQLServerException.makeFromDriverError(this, this, messageFormat.format(objectArray), null, false);
        }
    }

    Connection connect(Properties properties, SQLServerPooledConnection sQLServerPooledConnection) throws SQLServerException {
        Object[] objectArray;
        Object object;
        Object[] objectArray2;
        Object object2;
        MessageFormat messageFormat;
        Object object3;
        String string = "";
        boolean bl2 = this.connectionlogger.isLoggable(Level.FINE);
        this.activeConnectionProperties = (Properties)properties.clone();
        this.pooledConnectionParent = sQLServerPooledConnection;
        String string2 = null;
        String string3 = null;
        string2 = "user";
        string3 = this.activeConnectionProperties.getProperty(string2);
        if (string3 == null) {
            string3 = "";
            this.activeConnectionProperties.setProperty(string2, string3);
        }
        this.ValidateMaxSQLLoginName(string2, string3);
        string2 = "password";
        string3 = this.activeConnectionProperties.getProperty(string2);
        if (string3 == null) {
            string3 = "";
            this.activeConnectionProperties.setProperty(string2, string3);
        }
        this.ValidateMaxSQLLoginName(string2, string3);
        string2 = "databaseName";
        string3 = this.activeConnectionProperties.getProperty(string2);
        this.ValidateMaxSQLLoginName(string2, string3);
        string2 = "loginTimeout";
        String string4 = string3 = this.activeConnectionProperties.getProperty(string2);
        if (null != string4 && string4.length() > 0) {
            Object[] objectArray3;
            try {
                int n2 = Integer.parseInt(string4);
                if (n2 >= 0 && n2 <= 65535) {
                    if (n2 > 10) {
                        this.udpMillisecondsTimeout = n2 * 1000;
                    }
                } else {
                    object3 = new MessageFormat(SQLServerException.getErrString("R_invalidTimeOut"));
                    objectArray3 = new Object[]{string4};
                    SQLServerException.makeFromDriverError(this, this, ((Format)object3).format(objectArray3), null, false);
                }
            }
            catch (NumberFormatException numberFormatException) {
                object3 = new MessageFormat(SQLServerException.getErrString("R_invalidTimeOut"));
                objectArray3 = new Object[]{string4};
                SQLServerException.makeFromDriverError(this, this, ((Format)object3).format(objectArray3), null, false);
            }
        }
        if ((string3 = this.activeConnectionProperties.getProperty(string2 = "serverName")) == null) {
            string3 = "localhost";
        }
        String string5 = "portNumber";
        object3 = this.activeConnectionProperties.getProperty(string5);
        int n3 = string3.indexOf(92);
        String string6 = null;
        String string7 = null;
        if (n3 >= 0) {
            string7 = string3.substring(n3 + 1, string3.length());
            this.ValidateMaxSQLLoginName("instanceName", string7);
            string3 = string3.substring(0, n3);
            if (object3 == null || ((String)object3).equals("0")) {
                string6 = this.getInstancePort(string3, string7);
            }
        }
        this.activeConnectionProperties.setProperty(string2, string3);
        String string8 = this.activeConnectionProperties.getProperty("instanceName");
        if (null != string8) {
            string7 = string8;
        }
        if (string7 != null) {
            this.ValidateMaxSQLLoginName("instanceName", string7);
            if (object3 == null || ((String)object3).equals("0")) {
                string6 = this.getInstancePort(string3, string7);
            }
            this.activeConnectionProperties.setProperty("instanceName", string7);
        }
        if (object3 == null || ((String)object3).equals("0")) {
            object3 = string6 == null ? "1433" : string6;
        }
        this.activeConnectionProperties.setProperty(string5, (String)object3);
        string2 = "applicationName";
        string3 = this.activeConnectionProperties.getProperty(string2);
        this.ValidateMaxSQLLoginName(string2, string3);
        string2 = "lastUpdateCount";
        string3 = this.activeConnectionProperties.getProperty(string2);
        if (string3 == null) {
            string3 = "true";
            this.activeConnectionProperties.setProperty(string2, string3);
        }
        if ((string3 = this.activeConnectionProperties.getProperty(string2 = "selectMethod")) == null) {
            string3 = "direct";
        }
        if (string3.equals("cursor") || string3.equals("direct")) {
            this.activeConnectionProperties.setProperty(string2, string3);
        } else {
            messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidselectMethod"));
            object2 = new Object[]{new String(string3)};
            SQLServerException.makeFromDriverError(this, this, messageFormat.format(object2), null, false);
        }
        string2 = "responseBuffering";
        string3 = this.activeConnectionProperties.getProperty(string2);
        if (string3 == null) {
            string3 = "full";
        }
        if (string3.equals("full") || string3.equals("adaptive")) {
            this.activeConnectionProperties.setProperty(string2, string3);
        } else {
            messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidresponseBuffering"));
            object2 = new Object[]{new String(string3)};
            SQLServerException.makeFromDriverError(this, this, messageFormat.format(object2), null, false);
        }
        string2 = "disableStatementPooling";
        string3 = this.activeConnectionProperties.getProperty(string2);
        if (string3 != null && !this.booleanPropertyOn(string2, string3)) {
            messageFormat = new MessageFormat(SQLServerException.getErrString("R_invaliddisableStatementPooling"));
            object2 = new Object[]{new String(string3)};
            SQLServerException.makeFromDriverError(this, this, messageFormat.format(object2), null, false);
        }
        if ((string3 = this.activeConnectionProperties.getProperty(string2 = "integratedSecurity")) != null) {
            this.integratedSecurity = this.booleanPropertyOn(string2, string3);
        }
        string2 = "workstationID";
        string3 = this.activeConnectionProperties.getProperty(string2);
        this.ValidateMaxSQLLoginName(string2, string3);
        int n4 = 0;
        try {
            n4 = new Integer(this.activeConnectionProperties.getProperty("portNumber"));
            if (n4 < 0 || n4 > 65535) {
                object2 = new MessageFormat(SQLServerException.getErrString("R_invalidPortNumber"));
                objectArray2 = new Object[]{new Integer(n4)};
                SQLServerException.makeFromDriverError(this, this, ((Format)object2).format(objectArray2), null, false);
            }
        }
        catch (NumberFormatException numberFormatException) {
            objectArray2 = new MessageFormat(SQLServerException.getErrString("R_invalidPortNumber"));
            object = new Object[]{this.activeConnectionProperties.getProperty("portNumber")};
            SQLServerException.makeFromDriverError(this, this, objectArray2.format(object), null, false);
        }
        string3 = this.activeConnectionProperties.getProperty("packetSize");
        if (null != string3 && string3.length() > 0) {
            try {
                this.requestedPacketSize = Integer.parseInt(string3);
                if (-1 == this.requestedPacketSize) {
                    this.requestedPacketSize = 0;
                } else if (0 == this.requestedPacketSize) {
                    this.requestedPacketSize = Short.MAX_VALUE;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.requestedPacketSize = -1;
            }
            if (0 != this.requestedPacketSize && (this.requestedPacketSize < 512 || this.requestedPacketSize > Short.MAX_VALUE)) {
                object2 = new MessageFormat(SQLServerException.getErrString("R_invalidPacketSize"));
                objectArray2 = new Object[]{string3};
                SQLServerException.makeFromDriverError(this, this, ((Format)object2).format(objectArray2), null, false);
            }
        }
        if (bl2) {
            this.connectionlogger.fine(this.toLogString() + " Calling securityManager.checkConnect(" + this.activeConnectionProperties.getProperty("serverName") + "," + n4 + ")");
        }
        this.securityManager = new SQLServerConnectionSecurityManager(this.activeConnectionProperties.getProperty("serverName"), n4);
        this.securityManager.checkConnect();
        if (bl2) {
            this.connectionlogger.fine(this.toLogString() + " securityManager.checkConnect succeeded.");
        }
        if (this.integratedSecurity) {
            if (bl2) {
                this.connectionlogger.fine(this.toLogString() + " securityManager.checkLink.");
            }
            this.securityManager.checkLink();
            if (bl2) {
                this.connectionlogger.fine(this.toLogString() + " securityManager.checkLink succeedded.");
            }
        }
        this.sendStringParametersAsUnicode = null == this.activeConnectionProperties.getProperty("sendStringParametersAsUnicode") ? true : this.booleanPropertyOn("sendStringParametersAsUnicode", this.activeConnectionProperties.getProperty("sendStringParametersAsUnicode"));
        this.lastUpdateCount = this.booleanPropertyOn("lastUpdateCount", this.activeConnectionProperties.getProperty("lastUpdateCount"));
        this.xopenStates = this.booleanPropertyOn("xopenStates", this.activeConnectionProperties.getProperty("xopenStates"));
        this.selectMethod = null;
        if (this.activeConnectionProperties.getProperty("selectMethod") != null && this.activeConnectionProperties.getProperty("selectMethod").length() > 0) {
            this.selectMethod = this.activeConnectionProperties.getProperty("selectMethod");
        }
        this.responseBuffering = null;
        if (this.activeConnectionProperties.getProperty("responseBuffering") != null && this.activeConnectionProperties.getProperty("responseBuffering").length() > 0) {
            this.responseBuffering = this.activeConnectionProperties.getProperty("responseBuffering");
        }
        this.applicationName = Util.nameAndVersion(false);
        if (this.activeConnectionProperties.getProperty("applicationName") != null) {
            this.applicationName = this.activeConnectionProperties.getProperty("applicationName");
            this.ValidateMaxSQLLoginName("applicationName", this.applicationName);
        }
        int n5 = 0;
        if (this.activeConnectionProperties.getProperty("loginTimeout") != null && this.activeConnectionProperties.getProperty("loginTimeout").length() > 0) {
            try {
                int n6 = new Integer(this.activeConnectionProperties.getProperty("loginTimeout"));
                if (n6 >= 0 && n6 <= 65535) {
                    n5 = n6;
                } else {
                    object = new MessageFormat(SQLServerException.getErrString("R_invalidTimeOut"));
                    objectArray = new Object[]{this.activeConnectionProperties.getProperty("loginTimeout")};
                    SQLServerException.makeFromDriverError(this, this, ((Format)object).format(objectArray), null, false);
                }
            }
            catch (NumberFormatException numberFormatException) {
                object = new MessageFormat(SQLServerException.getErrString("R_invalidTimeOut"));
                objectArray = new Object[]{this.activeConnectionProperties.getProperty("loginTimeout")};
                SQLServerException.makeFromDriverError(this, this, ((Format)object).format(objectArray), null, false);
            }
        }
        this.nLockTimeout = -1;
        if (this.activeConnectionProperties.getProperty("lockTimeout") != null && this.activeConnectionProperties.getProperty("lockTimeout").length() > 0) {
            try {
                int n7 = new Integer(this.activeConnectionProperties.getProperty("lockTimeout"));
                if (n7 >= -1) {
                    this.nLockTimeout = n7;
                } else {
                    object = new MessageFormat(SQLServerException.getErrString("R_invalidLockTimeOut"));
                    objectArray = new Object[]{this.activeConnectionProperties.getProperty("lockTimeout")};
                    SQLServerException.makeFromDriverError(this, this, ((Format)object).format(objectArray), null, false);
                }
            }
            catch (NumberFormatException numberFormatException) {
                object = new MessageFormat(SQLServerException.getErrString("R_invalidLockTimeOut"));
                objectArray = new Object[]{this.activeConnectionProperties.getProperty("lockTimeout")};
                SQLServerException.makeFromDriverError(this, this, ((Format)object).format(objectArray), null, false);
            }
        }
        FailoverInfo failoverInfo = null;
        if (null != this.activeConnectionProperties.getProperty("databaseName")) {
            failoverInfo = FailoverMapSingleton.getFailoverInfo(this, this.activeConnectionProperties.getProperty("serverName"), this.activeConnectionProperties.getProperty("instanceName"), this.activeConnectionProperties.getProperty("databaseName"));
        } else if (null != this.activeConnectionProperties.getProperty("failoverPartner")) {
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_failoverPartnerWithoutDB"), null, true);
        }
        object = null;
        if (null == failoverInfo) {
            object = this.activeConnectionProperties.getProperty("failoverPartner");
        }
        long l2 = System.currentTimeMillis();
        if (null == object && null == failoverInfo) {
            this.loginWithoutFailover(this.activeConnectionProperties.getProperty("serverName"), this.activeConnectionProperties.getProperty("instanceName"), n4, n5, l2);
        } else {
            this.loginWithFailover(this.activeConnectionProperties.getProperty("serverName"), (String)object, failoverInfo, n4, n5, l2);
        }
        this.bIsOpen = true;
        if (bl2) {
            this.connectionlogger.fine(this.toLogString() + " End of connect");
        }
        return this;
    }

    private void loginWithFailover(String string, String string2, FailoverInfo failoverInfo, int n2, int n3, long l2) throws SQLServerException {
        String string3;
        String string4;
        long l3;
        long l4;
        long l5;
        FailoverInfo failoverInfo2;
        int n4 = 100;
        boolean bl2 = false;
        int n5 = n2;
        boolean bl3 = this.connectionlogger.isLoggable(Level.FINE);
        FailoverServerPortPlaceHolder failoverServerPortPlaceHolder = null;
        boolean bl4 = false;
        if (null != failoverInfo) {
            failoverInfo2 = failoverInfo;
            failoverServerPortPlaceHolder = failoverInfo2.failoverPermissionCheck(this, this.integratedSecurity);
            bl4 = true;
            bl2 = failoverServerPortPlaceHolder.getUseFailoverPartner();
        } else {
            failoverInfo2 = new FailoverInfo(string2, this, false);
        }
        if (0 == n3) {
            l5 = 0L;
            l4 = 0L;
            l3 = 0L;
        } else {
            long l6 = n3 * 1000;
            l5 = l2 + l6;
            l4 = (long)(0.08f * (float)l6);
            l3 = l2 + l4;
            if (bl3) {
                this.connectionlogger.fine(this.toLogString() + " Start time: " + l2 + " Time out time: " + l5 + " Timeout Unit Interval: " + l4);
            }
        }
        int n6 = 0;
        while (true) {
            if (bl2) {
                if (!bl4) {
                    failoverServerPortPlaceHolder = failoverInfo2.failoverPermissionCheck(this, this.integratedSecurity);
                    bl4 = true;
                }
                string4 = failoverServerPortPlaceHolder.getFailoverPartner();
                n5 = failoverServerPortPlaceHolder.getFailoverPortNumber();
            } else {
                string4 = string;
                n5 = n2;
            }
            if (bl3) {
                string3 = bl2 ? failoverServerPortPlaceHolder.getFailoverInstance() : this.instanceName;
                this.connectionlogger.fine(this.toLogString() + " This attempt server name: " + string4 + " port: " + n5 + " InstanceName: " + string3);
                this.connectionlogger.fine(this.toLogString() + " This attempt endtime: " + l3);
                this.connectionlogger.fine(this.toLogString() + " This attempt No: " + n6);
            }
            try {
                this.connectHelper(string4, n5, SQLServerConnection.TimerRemaining(l3), n3);
            }
            catch (SQLServerException sQLServerException) {
                long l7;
                if (18456 == sQLServerException.getErrorCode() || 18488 == sQLServerException.getErrorCode() || 0 != n3 && SQLServerConnection.timerHasExpired(l5)) {
                    throw sQLServerException;
                }
                if (1 == n6 % 2 && 0 != n3 && (l7 = (long)SQLServerConnection.TimerRemaining(l5)) <= (long)n4) {
                    throw sQLServerException;
                }
                if (1 == n6 % 2) {
                    if (bl3) {
                        this.connectionlogger.fine(this.toLogString() + " sleeping milisec: " + n4);
                    }
                    try {
                        Thread.sleep(n4);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    n4 = n4 < 500 ? n4 * 2 : 1000;
                }
                if (0 != n3 && (l3 = System.currentTimeMillis() + l4 * (long)(++n6 / 2 + 1)) > l5) {
                    l3 = l5;
                }
                bl2 = !bl2;
                continue;
            }
            break;
        }
        if (bl2 && null == this.failoverPartnerServerProvided) {
            string3 = string4;
            if (null != failoverServerPortPlaceHolder.getFailoverInstance()) {
                string3 = string3 + "\\";
                string3 = string3 + failoverServerPortPlaceHolder.getFailoverInstance();
            }
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidPartnerConfiguration"));
            Object[] objectArray = new Object[]{new String(this.activeConnectionProperties.getProperty("databaseName")), string3};
            SQLServerException.makeFromDriverError(this, this, messageFormat.format(objectArray), null, false);
        }
        if (null != this.failoverPartnerServerProvided) {
            if (null != failoverInfo) {
                failoverInfo.failoverAdd(this, bl2, this.failoverPartnerServerProvided);
            } else {
                if (bl3) {
                    this.connectionlogger.fine(this.toLogString() + " adding new failover info server: " + this.activeConnectionProperties.getProperty("serverName") + " instance: " + this.activeConnectionProperties.getProperty("instanceName") + " database: " + this.activeConnectionProperties.getProperty("databaseName") + " server provided failover: " + this.failoverPartnerServerProvided);
                }
                failoverInfo2.failoverAdd(this, bl2, this.failoverPartnerServerProvided);
                FailoverMapSingleton.putFailoverInfo(this, string, this.activeConnectionProperties.getProperty("instanceName"), this.activeConnectionProperties.getProperty("databaseName"), failoverInfo2, bl2, this.failoverPartnerServerProvided);
            }
        }
    }

    private void loginWithoutFailover(String string, String string2, int n2, int n3, long l2) throws SQLServerException {
        long l3;
        long l4;
        long l5;
        int n4 = 100;
        String string3 = string;
        int n5 = n2;
        boolean bl2 = this.connectionlogger.isLoggable(Level.FINE);
        if (0 == n3) {
            l5 = 0L;
            l4 = 0L;
            l3 = 0L;
        } else {
            long l6 = n3 * 1000;
            l5 = l2 + l6;
            l4 = (long)(0.08f * (float)l6);
            l3 = l2 + l4;
            if (bl2) {
                this.connectionlogger.fine(this.toLogString() + " Start time: " + l2 + " Time out time: " + l5 + " Timeout Unit Interval: " + l4);
            }
        }
        int n6 = 0;
        while (true) {
            if (bl2) {
                this.connectionlogger.fine(this.toLogString() + " This attempt server name: " + string3 + " port: " + n5 + " InstanceName: " + string2);
                this.connectionlogger.fine(this.toLogString() + " This attempt endtime: " + l3);
                this.connectionlogger.fine(this.toLogString() + " This attempt No: " + n6);
            }
            try {
                this.connectHelper(string3, n5, SQLServerConnection.TimerRemaining(l3), n3);
            }
            catch (SQLServerException sQLServerException) {
                long l7;
                if (18456 == sQLServerException.getErrorCode() || 18488 == sQLServerException.getErrorCode() || SQLServerConnection.timerHasExpired(l5)) {
                    throw sQLServerException;
                }
                if (1 == n6 % 2 && 0 != n3 && (l7 = (long)SQLServerConnection.TimerRemaining(l5)) <= (long)n4) {
                    throw sQLServerException;
                }
                if (1 == n6 % 2) {
                    if (bl2) {
                        this.connectionlogger.fine(this.toLogString() + " sleeping milisec: " + n4);
                    }
                    try {
                        Thread.sleep(n4);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    n4 = n4 < 500 ? n4 * 2 : 1000;
                }
                if (0 == n3 || (l3 = System.currentTimeMillis() + l4 * (long)(++n6 / 2 + 1)) <= l5) continue;
                l3 = l5;
                continue;
            }
            break;
        }
        if (null != this.failoverPartnerServerProvided) {
            FailoverInfo failoverInfo = new FailoverInfo(this.failoverPartnerServerProvided, this, false);
            if (bl2) {
                this.connectionlogger.fine(this.toLogString() + " adding new failover info server: " + this.activeConnectionProperties.getProperty("serverName") + " instance: " + this.activeConnectionProperties.getProperty("instanceName") + " database: " + this.activeConnectionProperties.getProperty("databaseName") + " server provided failover: " + this.failoverPartnerServerProvided);
            }
            FailoverMapSingleton.putFailoverInfo(this, this.activeConnectionProperties.getProperty("serverName"), this.activeConnectionProperties.getProperty("instanceName"), this.activeConnectionProperties.getProperty("databaseName"), failoverInfo, false, this.failoverPartnerServerProvided);
        }
    }

    static boolean timerHasExpired(long l2) {
        boolean bl2 = System.currentTimeMillis() > l2;
        return bl2;
    }

    static int TimerRemaining(long l2) {
        long l3 = System.currentTimeMillis();
        long l4 = l2 - l3;
        if (l4 > Integer.MAX_VALUE) {
            l4 = Integer.MAX_VALUE;
        }
        if (l4 <= 0L) {
            l4 = 1L;
        }
        return (int)l4;
    }

    private void connectHelper(String string, int n2, int n3, int n4) throws SQLServerException {
        boolean bl2 = this.connectionlogger.isLoggable(Level.FINE);
        IOException iOException = null;
        try {
            if (bl2) {
                this.connectionlogger.fine(this.toLogString() + " Connecting with server: " + string + " port: " + n2 + " Timeout slice: " + n3 + " Timeout Full: " + n4);
            }
            this.tdsChannel = new TDSChannel(this);
            if (0 == n4) {
                this.tdsChannel.open(string, n2, 0);
            } else {
                this.tdsChannel.open(string, n2, n3);
            }
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        if (iOException != null) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_tcpipConnectionFailed"));
            Object[] objectArray = new Object[]{""};
            String string2 = iOException.toString();
            string2 = string2.replaceAll(this.activeConnectionProperties.getProperty("serverName"), "");
            String string3 = messageFormat.format(objectArray);
            string3 = string3 + " " + string2;
            SQLServerException.makeFromDriverError(this, this, string3, "08001", false);
        }
        this.Prelogin(false);
        this.executeCommand(new LogonCommand());
    }

    void Prelogin(boolean bl2) throws SQLServerException {
        int n2;
        bl2 = false;
        byte[] byArray = new byte[]{18, 1, 0, 26, 0, 0, 0, 0, 0, 0, 11, 0, 6, 1, 0, 17, 0, 1, -1, 0, 0, 0, 0, 0, 0, bl2 ? (byte)1 : 2};
        byte[] byArray2 = new byte[4096];
        this.tdsChannel.write(byArray, 0, byArray.length);
        this.tdsChannel.flush();
        int n3 = 0;
        int n4 = 0;
        do {
            n2 = 0;
            n2 = this.tdsChannel.read(byArray2, n3, byArray2.length - n3);
            if (-1 == n2) {
                SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_incompleteResponseIsSQL2000"), "08006", true);
            }
            if ((n3 += n2) < 8 || false != n4 || n2 >= (n4 = byArray2[2] << 8 | byArray2[3]) && 4 == byArray2[0] && 1 == byArray2[1]) continue;
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_incompleteResponseIsSQL2000"), "08006", true);
        } while (n3 < n4);
        n2 = 0;
        boolean bl3 = false;
        int n5 = 3;
        int n6 = 8;
        while (true) {
            byte by;
            if (n6 + 1 >= n4) {
                SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_inCompleteTDSPrelogin"), "08006", true);
            }
            if (-1 == (by = byArray2[n6++])) break;
            if (n6 + 5 >= n4) {
                SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_inCompleteTDSPrelogin"), "08006", true);
            }
            int n7 = byArray2[n6++] << 8;
            int n8 = n6++;
            int n9 = byArray2[n6++] << 8;
            if ((n7 += byArray2[n8] + 8) > n4 || n7 + (n9 += byArray2[n6++]) > n4) {
                SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_inCompleteTDSPrelogin"), "08006", true);
            }
            switch (by) {
                case 0: {
                    if (n2 != 0) {
                        SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_unexpectedServerVersion"), "08006", true);
                    }
                    if (6 != n9) {
                        SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_malformedServerVersion"), "08006", true);
                    }
                    if (9 <= byArray2[n7]) {
                        this.tdsVersion = new TDSVersion(114);
                    } else if (8 == byArray2[n7]) {
                        this.tdsVersion = new TDSVersion(113);
                    } else {
                        SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_unsupportedServerVersion"), "08006", true);
                    }
                    n2 = 1;
                    break;
                }
                case 1: {
                    if (bl3) {
                        SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_unexpectedEncryptionOption"), "08006", true);
                    }
                    if (1 != n9) {
                        SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_malformedEncryptionOption"), "08006", true);
                    }
                    n5 = byArray2[n7];
                    bl3 = true;
                }
            }
        }
        if (n2 == 0 || !bl3) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_inCompleteTDSPrelogin"), "08006", true);
        }
        if (2 != n5) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_requiresSSL"), "08006", true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean executeCommand(TDSCommand tDSCommand) throws SQLServerException {
        if (null != this.currentCommand) {
            this.currentCommand.detach();
        }
        boolean bl2 = false;
        TDSCommand tDSCommand2 = this.currentCommand;
        this.currentCommand = tDSCommand;
        try {
            bl2 = tDSCommand.execute(this.tdsChannel.getWriter(), this.tdsChannel.getReader());
        }
        finally {
            if (bl2) {
                this.currentCommand = tDSCommand2;
            }
        }
        return bl2;
    }

    private final void connectionCommand(String string, String string2) throws SQLServerException {
        final class ConnectionCommand
        extends UninterruptableTDSCommand {
            final String sql;

            ConnectionCommand(String string, String string2) {
                super(string2);
                this.sql = string;
            }

            final boolean doExecute() throws SQLServerException {
                this.startRequest((byte)1).writeString(this.sql);
                TDSParser.parse(this.startResponse(), this.getLogContext());
                return true;
            }
        }
        this.executeCommand(new ConnectionCommand(string, string2));
    }

    String sqlStatementToInitialize() {
        String string = "";
        if (this.nLockTimeout > -1) {
            string = string + " set lock_timeout " + this.nLockTimeout;
        }
        return string;
    }

    void setCatalogName(String string) {
        if (string != null && string.length() > 0) {
            this.sCatalog = string;
        }
    }

    String sqlStatementToSetTransactionIsolationLevel() throws SQLServerException {
        String string = "set transaction isolation level ";
        switch (this.transactionIsolationLevel) {
            case 1: {
                string = string + " read uncommitted ";
                break;
            }
            case 2: {
                string = string + " read committed ";
                break;
            }
            case 4: {
                string = string + " repeatable read ";
                break;
            }
            case 8: {
                string = string + " serializable ";
                break;
            }
            case 4096: {
                string = string + " snapshot ";
                break;
            }
            default: {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidTransactionLevel"));
                Object[] objectArray = new Object[]{new Integer(this.transactionIsolationLevel)};
                SQLServerException.makeFromDriverError(this, this, messageFormat.format(objectArray), null, false);
            }
        }
        return string;
    }

    static String sqlStatementToSetCommit(boolean bl2) {
        return true == bl2 ? "set implicit_transactions off " : "set implicit_transactions on ";
    }

    String sqlStatementForSettings() throws SQLServerException {
        String string = "";
        string = string + this.sqlStatementToInitialize() + " " + this.sqlStatementToSetTransactionIsolationLevel() + " " + SQLServerConnection.sqlStatementToSetCommit(this.databaseAutoCommitMode);
        return string;
    }

    String getUrl() {
        return this.sConnectURL;
    }

    public Statement createStatement() throws SQLServerException {
        return this.createStatement(1003, 1007);
    }

    public PreparedStatement prepareStatement(String string) throws SQLServerException {
        return this.prepareStatement(string, 1003, 1007);
    }

    public CallableStatement prepareCall(String string) throws SQLServerException {
        return this.prepareCall(string, 1003, 1007);
    }

    public String nativeSQL(String string) throws SQLServerException {
        this.checkClosed();
        return string;
    }

    public void setAutoCommit(boolean bl2) throws SQLServerException {
        String string = "";
        this.checkClosed();
        if (bl2 == this.databaseAutoCommitMode) {
            return;
        }
        if (bl2) {
            string = "IF @@TRANCOUNT > 0 COMMIT TRAN ";
        }
        if (this.connectionlogger.isLoggable(Level.FINE)) {
            this.connectionlogger.fine(this.toLogString() + " Autocommitmode current :" + this.databaseAutoCommitMode + " new: " + bl2);
        }
        this.connectionCommand(string + SQLServerConnection.sqlStatementToSetCommit(bl2), "setAutoCommit");
        this.databaseAutoCommitMode = bl2;
    }

    public boolean getAutoCommit() throws SQLServerException {
        this.checkClosed();
        return !this.inXATransaction && this.databaseAutoCommitMode;
    }

    final byte[] getTransactionDescriptor() {
        return this.transactionDescriptor;
    }

    public void commit() throws SQLServerException {
        this.checkClosed();
        if (this.databaseAutoCommitMode) {
            return;
        }
        this.connectionCommand("IF @@TRANCOUNT > 0 COMMIT TRAN", "Connection.commit");
    }

    public void rollback() throws SQLServerException {
        this.checkClosed();
        if (this.databaseAutoCommitMode) {
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_cantInvokeRollback"), null, true);
        }
        this.connectionCommand("IF @@TRANCOUNT > 0 ROLLBACK TRAN", "Connection.rollback");
    }

    public void close() throws SQLServerException {
        if (!this.bIsOpen || null != this.pooledConnectionParent) {
            return;
        }
        if (this.connectionlogger.isLoggable(Level.FINE)) {
            this.connectionlogger.fine(this.toLogString() + " closing.");
        }
        this.bIsOpen = false;
        this.tdsChannel.close();
        this.tdsChannel = null;
    }

    final void poolCloseEventNotify() throws SQLServerException {
        if (this.bIsOpen && null != this.pooledConnectionParent) {
            if (!this.databaseAutoCommitMode && !(this.pooledConnectionParent instanceof XAConnection)) {
                this.connectionCommand("IF @@TRANCOUNT > 0 ROLLBACK TRAN", "close connection");
            }
            this.notifyPooledConnection(null);
            if (this.connectionlogger.isLoggable(Level.FINE)) {
                this.connectionlogger.fine(this.toLogString() + " Connection closed and returned to connection pool");
            }
        }
    }

    public boolean isClosed() throws SQLServerException {
        return !this.bIsOpen;
    }

    public DatabaseMetaData getMetaData() throws SQLServerException {
        this.checkClosed();
        if (this.databaseMetaData == null) {
            this.databaseMetaData = new SQLServerDatabaseMetaData(this);
        }
        return this.databaseMetaData;
    }

    public void setReadOnly(boolean bl2) throws SQLServerException {
        this.checkClosed();
    }

    public boolean isReadOnly() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public void setCatalog(String string) throws SQLServerException {
        this.checkClosed();
        if (string != null) {
            this.connectionCommand("use " + Util.escapeSQLId(string), "setCatalog");
            this.sCatalog = string;
        }
    }

    public String getCatalog() throws SQLServerException {
        this.checkClosed();
        return this.sCatalog;
    }

    public void setTransactionIsolation(int n2) throws SQLServerException {
        this.checkClosed();
        if (n2 == 0) {
            return;
        }
        this.transactionIsolationLevel = n2;
        String string = this.sqlStatementToSetTransactionIsolationLevel();
        this.connectionCommand(string, "setTransactionIsolation");
    }

    public int getTransactionIsolation() throws SQLServerException {
        this.checkClosed();
        return this.transactionIsolationLevel;
    }

    public SQLWarning getWarnings() throws SQLServerException {
        this.checkClosed();
        if (this.sqlWarnings == null) {
            return null;
        }
        return (SQLWarning)this.sqlWarnings.elementAt(0);
    }

    public void clearWarnings() throws SQLServerException {
        this.checkClosed();
        this.sqlWarnings = null;
    }

    public Statement createStatement(int n2, int n3) throws SQLServerException {
        this.checkClosed();
        return new SQLServerStatement(this, n2, n3);
    }

    public PreparedStatement prepareStatement(String string, int n2, int n3) throws SQLServerException {
        this.checkClosed();
        return new SQLServerPreparedStatement(this, string, n2, n3);
    }

    public CallableStatement prepareCall(String string, int n2, int n3) throws SQLServerException {
        this.checkClosed();
        return new SQLServerCallableStatement(this, string, n2, n3);
    }

    public void setTypeMap(Map map) throws SQLServerException {
        this.checkClosed();
        if (map != null && map instanceof HashMap && map.isEmpty()) {
            return;
        }
        this.NotImplemented();
    }

    public Map getTypeMap() throws SQLServerException {
        this.checkClosed();
        return new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void logon(LogonCommand logonCommand) throws SQLServerException {
        block5: {
            AuthenticationJNI authenticationJNI;
            block6: {
                authenticationJNI = null;
                if (this.integratedSecurity) {
                    authenticationJNI = new AuthenticationJNI();
                }
                try {
                    this.sendLogon(logonCommand, authenticationJNI);
                    this.connectionCommand(this.sqlStatementForSettings(), "Change Settings");
                    Object var4_3 = null;
                    if (!this.integratedSecurity) break block5;
                    if (null == authenticationJNI) break block6;
                    authenticationJNI.ReleaseClientContext();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (this.integratedSecurity) {
                        if (null != authenticationJNI) {
                            authenticationJNI.ReleaseClientContext();
                        }
                        authenticationJNI = null;
                    }
                    throw throwable;
                }
            }
            authenticationJNI = null;
            {
            }
        }
    }

    private void SSPIData(byte[] byArray, byte[] byArray2, int[] nArray, boolean[] blArray, AuthenticationJNI authenticationJNI) throws SQLServerException {
        int n2 = null == byArray ? authenticationJNI.GenerateClientContext(null, 0, byArray2, nArray, blArray) : authenticationJNI.GenerateClientContext(byArray, byArray.length, byArray2, nArray, blArray);
        if (n2 != 0) {
            this.connectionlogger.warning(this.toLogString() + " Authentication failed code" + n2);
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_notConfiguredForIntegrated"), "08001", false);
        }
    }

    final void processEnvChange(TDSReader tDSReader) throws SQLServerException {
        tDSReader.readUnsignedByte();
        int n2 = tDSReader.readUnsignedShort();
        TDSReaderMark tDSReaderMark = tDSReader.mark();
        int n3 = tDSReader.readUnsignedByte();
        switch (n3) {
            case 4: {
                try {
                    this.tdsPacketSize = Integer.parseInt(tDSReader.readUnicodeString(tDSReader.readUnsignedByte()));
                }
                catch (NumberFormatException numberFormatException) {
                    tDSReader.throwInvalidTDS();
                }
                this.connectionlogger.fine(this.toLogString() + " Network packet size is " + this.tdsPacketSize + " bytes");
                break;
            }
            case 7: {
                if (5 != tDSReader.readUnsignedByte()) {
                    tDSReader.throwInvalidTDS();
                }
                this.databaseCollation = new SQLCollation(tDSReader);
                break;
            }
            case 8: 
            case 11: {
                if (!this.isYukonOrLater()) break;
                byte[] byArray = this.getTransactionDescriptor();
                if (byArray.length != tDSReader.readUnsignedByte()) {
                    tDSReader.throwInvalidTDS();
                }
                tDSReader.readBytes(byArray, 0, byArray.length);
                if (!this.connectionlogger.isLoggable(Level.FINE)) break;
                String string = 8 == n3 ? " started" : " enlisted";
                this.connectionlogger.fine(this.toLogString() + string);
                break;
            }
            case 10: {
                if (this.inXATransaction) {
                    if (!this.connectionlogger.isLoggable(Level.FINE)) break;
                    String string = " rolled back. (DTC)";
                    this.connectionlogger.fine(this.toLogString() + string);
                    break;
                }
            }
            case 9: 
            case 12: {
                if (this.connectionlogger.isLoggable(Level.FINE)) {
                    String string = 9 == n3 ? " committed" : (12 == n3 ? " defected" : " rolled back");
                    this.connectionlogger.fine(this.toLogString() + string);
                }
                if (!this.isYukonOrLater()) break;
                Arrays.fill(this.getTransactionDescriptor(), (byte)0);
                break;
            }
            case 1: {
                this.setCatalogName(tDSReader.readUnicodeString(tDSReader.readUnsignedByte()));
                break;
            }
            case 13: {
                this.setFailoverPartnerServerProvided(tDSReader.readUnicodeString(tDSReader.readUnsignedByte()));
                break;
            }
        }
        tDSReader.reset(tDSReaderMark);
        tDSReader.readBytes(new byte[n2], 0, n2);
    }

    private final void executeDTCCommand(int n2, byte[] byArray, String string) throws SQLServerException {
        final class DTCCommand
        extends UninterruptableTDSCommand {
            private final int requestType;
            private final byte[] payload;

            DTCCommand(int n2, byte[] byArray, String string) {
                super(string);
                this.requestType = n2;
                this.payload = byArray;
            }

            final boolean doExecute() throws SQLServerException {
                TDSWriter tDSWriter = this.startRequest((byte)14);
                tDSWriter.writeShort((short)this.requestType);
                if (null == this.payload) {
                    tDSWriter.writeShort((short)0);
                } else {
                    tDSWriter.writeShort((short)this.payload.length);
                    tDSWriter.writeBytes(this.payload);
                }
                TDSParser.parse(this.startResponse(), this.getLogContext());
                return true;
            }
        }
        this.executeCommand(new DTCCommand(n2, byArray, string));
    }

    final void JTAUnenlistConnection() throws SQLServerException {
        this.executeDTCCommand(1, null, "MS_DTC unenlist connection");
        this.inXATransaction = false;
    }

    final void JTAEnlistConnection(byte[] byArray) throws SQLServerException {
        if (byArray.length > Short.MAX_VALUE) {
            throw new SQLServerException(null, "Invalid transaction cookie length.", null, 0, true);
        }
        this.executeDTCCommand(1, byArray, "MS_DTC enlist connection");
        this.connectionCommand(this.sqlStatementToSetTransactionIsolationLevel(), "JTAEnlistConnection");
        this.inXATransaction = true;
    }

    private byte[] toUCS16(String string) throws SQLServerException {
        if (string == null) {
            return new byte[0];
        }
        int n2 = string.length();
        byte[] byArray = new byte[n2 * 2];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            byte by = (byte)(c2 & 0xFF);
            byArray[n3++] = by;
            byArray[n3++] = (byte)(c2 >> 8 & 0xFF);
        }
        return byArray;
    }

    private byte[] encryptPassword(String string) {
        if (string == null) {
            string = "";
        }
        int n2 = string.length();
        byte[] byArray = new byte[n2 * 2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byte by;
            byte by2;
            int n3 = string.charAt(i2) ^ 0x5A5A;
            n3 = (n3 & 0xF) << 4 | (n3 & 0xF0) >> 4 | (n3 & 0xF00) << 4 | (n3 & 0xF000) >> 4;
            byArray[i2 * 2 + 1] = by2 = (byte)((n3 & 0xFF00) >> 8);
            byArray[i2 * 2 + 0] = by = (byte)(n3 & 0xFF);
        }
        return byArray;
    }

    private void sendLogon(LogonCommand logonCommand, AuthenticationJNI authenticationJNI) throws SQLServerException {
        TDSReader tDSReader;
        int n2;
        int n3;
        String string = this.activeConnectionProperties.getProperty("workstationID");
        String string2 = this.activeConnectionProperties.getProperty("user");
        String string3 = this.activeConnectionProperties.getProperty("password");
        String string4 = this.activeConnectionProperties.getProperty("applicationName");
        String string5 = this.activeConnectionProperties.getProperty("databaseName");
        if (string == null || string.length() == 0) {
            try {
                string = Util.lookupHostName();
            }
            catch (UnknownHostException unknownHostException) {
                string = "WSID Not Available";
            }
        }
        byte[] byArray = new byte[]{};
        int[] nArray = new int[]{0};
        boolean[] blArray = new boolean[]{false};
        if (this.integratedSecurity) {
            if (authenticationJNI.IsEnabled()) {
                nArray[0] = authenticationJNI.GetMaxSSPIBlobSize();
                byArray = new byte[nArray[0]];
                authenticationJNI.InitDNSNameAndPort(this.activeConnectionProperties.getProperty("serverName"), this.activeConnectionProperties.getProperty("portNumber"));
                this.SSPIData(null, byArray, nArray, blArray, authenticationJNI);
                string2 = null;
                string3 = null;
            } else {
                SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_notConfiguredForIntegrated"), "08001", false);
            }
        }
        byte[] byArray2 = this.toUCS16(string);
        byte[] byArray3 = this.toUCS16(string2);
        byte[] byArray4 = this.encryptPassword(string3);
        int n4 = byArray4 != null ? byArray4.length : 0;
        byte[] byArray5 = this.toUCS16(string4);
        byte[] byArray6 = this.toUCS16(string);
        byte[] byArray7 = this.toUCS16(string5);
        byte[] byArray8 = new byte[6];
        int n5 = 0;
        int n6 = 0;
        if (this.isYukonOrLater()) {
            n3 = 1913192450;
            n2 = 94;
        } else {
            n3 = 0x71000000;
            n2 = 86;
        }
        n5 = n4 + byArray2.length + byArray3.length + byArray5.length + byArray6.length + byArray7.length + n2 + nArray[0];
        TDSWriter tDSWriter = logonCommand.startRequest((byte)16);
        tDSWriter.writeInt(n5);
        tDSWriter.writeInt(n3);
        tDSWriter.writeInt(this.requestedPacketSize);
        tDSWriter.writeInt(0);
        tDSWriter.writeInt(0);
        tDSWriter.writeInt(0);
        tDSWriter.writeByte((byte)-32);
        if (!this.integratedSecurity) {
            tDSWriter.writeByte((byte)3);
        } else {
            tDSWriter.writeByte((byte)-125);
        }
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeInt(0);
        tDSWriter.writeInt(0);
        tDSWriter.writeShort((short)n2);
        tDSWriter.writeShort((short)(string == null ? 0 : string.length()));
        n6 += byArray2.length;
        if (!this.integratedSecurity) {
            tDSWriter.writeShort((short)(n2 + n6));
            tDSWriter.writeShort((short)(string2 == null ? 0 : string2.length()));
            tDSWriter.writeShort((short)(n2 + (n6 += byArray3.length)));
            tDSWriter.writeShort((short)(string3 == null ? 0 : string3.length()));
            n6 += n4;
        } else {
            tDSWriter.writeShort((short)0);
            tDSWriter.writeShort((short)0);
            tDSWriter.writeShort((short)0);
            tDSWriter.writeShort((short)0);
        }
        tDSWriter.writeShort((short)(n2 + n6));
        tDSWriter.writeShort((short)(string4 == null ? 0 : string4.length()));
        tDSWriter.writeShort((short)(n2 + (n6 += byArray5.length)));
        tDSWriter.writeShort((short)(string == null ? 0 : string.length()));
        n6 += byArray6.length;
        tDSWriter.writeShort((short)0);
        tDSWriter.writeShort((short)0);
        tDSWriter.writeShort((short)0);
        tDSWriter.writeShort((short)0);
        tDSWriter.writeShort((short)0);
        tDSWriter.writeShort((short)0);
        tDSWriter.writeShort((short)(n2 + n6));
        tDSWriter.writeShort((short)(string5 == null ? 0 : string5.length()));
        n6 += byArray7.length;
        tDSWriter.writeBytes(byArray8);
        if (!this.integratedSecurity) {
            tDSWriter.writeShort((short)0);
            tDSWriter.writeShort((short)0);
        } else {
            tDSWriter.writeShort((short)(n2 + n6));
            if (65535 <= nArray[0]) {
                tDSWriter.writeShort((short)-1);
            } else {
                tDSWriter.writeShort((short)nArray[0]);
            }
        }
        tDSWriter.writeShort((short)0);
        tDSWriter.writeShort((short)0);
        if (n3 >= 0x72000000) {
            tDSWriter.writeShort((short)0);
            tDSWriter.writeShort((short)0);
            if (65535 <= nArray[0]) {
                tDSWriter.writeInt(nArray[0]);
            } else {
                tDSWriter.writeInt(0);
            }
        }
        tDSWriter.writeBytes(byArray2);
        tDSWriter.setDataLoggable(false);
        if (!this.integratedSecurity) {
            tDSWriter.writeBytes(byArray3);
            tDSWriter.writeBytes(byArray4);
        }
        tDSWriter.setDataLoggable(true);
        tDSWriter.writeBytes(byArray5);
        tDSWriter.writeBytes(byArray6);
        tDSWriter.writeBytes(byArray7);
        tDSWriter.setDataLoggable(false);
        if (this.integratedSecurity) {
            tDSWriter.writeBytes(byArray, nArray[0]);
        }
        tDSWriter.setDataLoggable(true);
        final class LogonProcessor
        extends TDSTokenHandler {
            private final AuthenticationJNI intAuth;
            private final byte[] secBlobOut;
            private final int[] outBlobSize;
            StreamLoginAck loginAckToken;

            LogonProcessor(AuthenticationJNI authenticationJNI) {
                super("logon");
                this.intAuth = authenticationJNI;
                this.secBlobOut = new byte[authenticationJNI.GetMaxSSPIBlobSize()];
                this.outBlobSize = new int[1];
                this.loginAckToken = null;
            }

            boolean onSSPI(TDSReader tDSReader) throws SQLServerException {
                StreamSSPI streamSSPI = new StreamSSPI();
                streamSSPI.setFromTDS(tDSReader);
                boolean[] blArray = new boolean[]{false};
                LogonProcessor logonProcessor = this;
                this.outBlobSize[0] = logonProcessor.intAuth.GetMaxSSPIBlobSize();
                SQLServerConnection.this.SSPIData(streamSSPI.sspiBlob, this.secBlobOut, this.outBlobSize, blArray, this.intAuth);
                return true;
            }

            boolean onLoginAck(TDSReader tDSReader) throws SQLServerException {
                this.loginAckToken = new StreamLoginAck();
                this.loginAckToken.setFromTDS(tDSReader);
                SQLServerConnection.this.sqlServerVersion = this.loginAckToken.sSQLServerVersion;
                return true;
            }

            final boolean complete(LogonCommand logonCommand, TDSReader tDSReader) throws SQLServerException {
                if (null != this.loginAckToken) {
                    return true;
                }
                if (0 != this.outBlobSize[0]) {
                    logonCommand.startRequest((byte)17).writeBytes(this.secBlobOut, this.outBlobSize[0]);
                    return false;
                }
                --((SQLServerConnection)SQLServerConnection.this).tdsChannel.numMsgsRcvd;
                tDSReader.readPacket();
                TDSParser.parse(tDSReader, this);
                return true;
            }
        }
        LogonProcessor logonProcessor = new LogonProcessor(authenticationJNI);
        do {
            tDSReader = logonCommand.startResponse();
            TDSParser.parse(tDSReader, logonProcessor);
        } while (!logonProcessor.complete(logonCommand, tDSReader));
    }

    private void checkHoldability(int n2) throws SQLServerException {
        if (n2 != 1) {
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_sqlServerHoldability"), null, false);
        }
    }

    public Statement createStatement(int n2, int n3, int n4) throws SQLServerException {
        this.checkClosed();
        this.checkHoldability(n4);
        return this.createStatement(n2, n3);
    }

    public PreparedStatement prepareStatement(String string, int n2, int n3, int n4) throws SQLServerException {
        this.checkClosed();
        this.checkHoldability(n4);
        return this.prepareStatement(string, n2, n3);
    }

    public CallableStatement prepareCall(String string, int n2, int n3, int n4) throws SQLServerException {
        this.checkClosed();
        this.checkHoldability(n4);
        return this.prepareCall(string, n2, n3);
    }

    public PreparedStatement prepareStatement(String string, int n2) throws SQLServerException {
        this.checkClosed();
        SQLServerPreparedStatement sQLServerPreparedStatement = (SQLServerPreparedStatement)this.prepareStatement(string);
        sQLServerPreparedStatement.bRequestedGeneratedKeys = n2 == 1;
        return sQLServerPreparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLServerException {
        this.checkClosed();
        if (nArray == null || nArray.length != 1) {
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_invalidColumnArrayLength"), null, false);
        }
        SQLServerPreparedStatement sQLServerPreparedStatement = (SQLServerPreparedStatement)this.prepareStatement(string);
        sQLServerPreparedStatement.bRequestedGeneratedKeys = true;
        return sQLServerPreparedStatement;
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLServerException {
        this.checkClosed();
        if (stringArray == null || stringArray.length != 1) {
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_invalidColumnArrayLength"), null, false);
        }
        SQLServerPreparedStatement sQLServerPreparedStatement = (SQLServerPreparedStatement)this.prepareStatement(string);
        sQLServerPreparedStatement.bRequestedGeneratedKeys = true;
        return sQLServerPreparedStatement;
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLServerException {
        throw Util.notSupportedBySQLServer("releaseSavepoint");
    }

    private final Savepoint setNamedSavepoint(String string) throws SQLServerException {
        if (this.databaseAutoCommitMode) {
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_cantSetSavepoint"), null, false);
        }
        SQLServerSavepoint sQLServerSavepoint = new SQLServerSavepoint(this, string);
        this.connectionCommand("IF @@TRANCOUNT = 0 BEGIN BEGIN TRAN IF @@TRANCOUNT = 2 COMMIT TRAN END SAVE TRAN " + Util.escapeSQLId(sQLServerSavepoint.getLabel()), "setSavepoint");
        return sQLServerSavepoint;
    }

    public Savepoint setSavepoint(String string) throws SQLServerException {
        this.checkClosed();
        return this.setNamedSavepoint(string);
    }

    public Savepoint setSavepoint() throws SQLServerException {
        this.checkClosed();
        return this.setNamedSavepoint(null);
    }

    public void rollback(Savepoint savepoint) throws SQLServerException {
        this.checkClosed();
        if (this.databaseAutoCommitMode) {
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_cantInvokeRollback"), null, false);
        }
        this.connectionCommand("IF @@TRANCOUNT > 0 ROLLBACK TRAN " + Util.escapeSQLId(((SQLServerSavepoint)savepoint).getLabel()), "rollbackSavepoint");
    }

    public int getHoldability() throws SQLServerException {
        return this.nHoldability;
    }

    public void setHoldability(int n2) throws SQLServerException {
        this.checkClosed();
        if (n2 == this.nHoldability) {
            return;
        }
        String string = "SET CURSOR_CLOSE_ON_COMMIT ";
        string = n2 == 1 ? string + "OFF" : string + "ON";
        this.connectionCommand(string, "setHoldability");
        this.nHoldability = n2;
    }

    String replaceParameterMarkers(String string, Parameter[] parameterArray, boolean bl2) throws SQLServerException {
        char[] cArray = new char[string.length() + parameterArray.length * (6 + OUT.length)];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (true) {
            int n6 = ParameterUtils.scanSQLForChar('?', string, n3);
            string.getChars(n3, n6, cArray, n2);
            n2 += n6 - n3;
            if (string.length() == n6) break;
            n2 += SQLServerConnection.makeParamName(n4++, cArray, n2);
            n3 = n6 + 1;
            if (!parameterArray[n5++].isOutput() || bl2 && n5 <= 1) continue;
            System.arraycopy(OUT, 0, cArray, n2, OUT.length);
            n2 += OUT.length;
        }
        while (n2 < cArray.length) {
            cArray[n2++] = 32;
        }
        return new String(cArray);
    }

    static int makeParamName(int n2, char[] cArray, int n3) {
        cArray[n3 + 0] = 64;
        cArray[n3 + 1] = 80;
        if (n2 < 10) {
            cArray[n3 + 2] = (char)(48 + n2);
            return 3;
        }
        if (n2 < 100) {
            int n4 = 2;
            while (true) {
                if (n2 < n4 * 10) {
                    cArray[n3 + 2] = (char)(48 + (n4 - 1));
                    cArray[n3 + 3] = (char)(48 + (n2 - (n4 - 1) * 10));
                    return 4;
                }
                ++n4;
            }
        }
        String string = "" + n2;
        string.getChars(0, string.length(), cArray, n3 + 2);
        return 2 + string.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyPooledConnection(SQLServerException sQLServerException) {
        SQLServerConnection sQLServerConnection = this;
        synchronized (sQLServerConnection) {
            if (null != this.pooledConnectionParent) {
                this.pooledConnectionParent.notifyEvent(sQLServerException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void DetachFromPool() {
        SQLServerConnection sQLServerConnection = this;
        synchronized (sQLServerConnection) {
            this.pooledConnectionParent = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getInstancePort(String string, String string2) throws SQLServerException {
        Object[] objectArray;
        Object object;
        Object object2;
        Object object3;
        DatagramSocket datagramSocket = null;
        byte[] byArray = new byte[4096];
        int n2 = 1434;
        int n3 = this.udpMillisecondsTimeout;
        int n4 = 0;
        try {
            object3 = (" " + string2).getBytes();
            object3[0] = 4;
            while (true) {
                datagramSocket = new DatagramSocket();
                object2 = new DatagramPacket((byte[])object3, ((byte[])object3).length, InetAddress.getByName(string), n2);
                datagramSocket.send((DatagramPacket)object2);
                datagramSocket.setSoTimeout(1000);
                object2 = new DatagramPacket(byArray, byArray.length);
                try {
                    datagramSocket.receive((DatagramPacket)object2);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    if (0 == n4 % 30 && this.connectionlogger.isLoggable(Level.FINE)) {
                        this.connectionlogger.fine(this.toLogString() + " Unexpected UDP timeout at " + (n4 + 1) + " seconds resolving instance port.  Target -> udp:" + InetAddress.getByName(string) + ":1434.");
                    }
                    ++n4;
                    n3 -= 1000;
                    if (null == datagramSocket) continue;
                    datagramSocket.close();
                    datagramSocket = null;
                    if (n3 > 0) continue;
                    throw socketTimeoutException;
                }
                break;
            }
            byArray = ((DatagramPacket)object2).getData();
        }
        catch (IOException iOException) {
            object2 = new MessageFormat(SQLServerException.getErrString("R_failedConnection"));
            object = iOException.toString();
            object = ((String)object).replaceAll(this.activeConnectionProperties.getProperty("serverName"), "");
            object = ((String)object).replaceAll(string2, "");
            objectArray = new Object[]{"", object};
            SQLServerException.makeFromDriverError(this, this, ((Format)object2).format(objectArray), "08001", false);
        }
        finally {
            if (null != datagramSocket) {
                datagramSocket.close();
            }
        }
        object3 = new String(byArray, 3, byArray.length - 3);
        int n5 = ((String)object3).indexOf("tcp;");
        if (-1 != n5) {
            int n6 = n5 + 4;
            int n7 = ((String)object3).indexOf(59, n6);
            String string3 = ((String)object3).substring(n6, n7);
            return string3;
        }
        object = new MessageFormat(SQLServerException.getErrString("R_notConfiguredToListentcpip"));
        objectArray = new Object[]{string2};
        SQLServerException.makeFromDriverError(this, this, ((Format)object).format(objectArray), "08001", false);
        return null;
    }

    int getNextSavepointId() {
        ++this.nNextSavePointId;
        return this.nNextSavePointId;
    }

    SQLServerConnectionSecurityManager getSecurityManager() {
        return this.securityManager;
    }

    private final class LogonCommand
    extends UninterruptableTDSCommand {
        LogonCommand() {
            super("logon");
        }

        final boolean doExecute() throws SQLServerException {
            SQLServerConnection.this.logon(this);
            return true;
        }
    }
}

