/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerClob;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.io.IOException;
import java.io.Reader;

final class SQLServerClobCharacterReader
extends Reader {
    private SQLServerClob parentClob = null;
    private long streamPos;
    private long markPos;
    private char[] cSingleChar = new char[1];

    SQLServerClobCharacterReader(SQLServerClob sQLServerClob) {
        this.parentClob = sQLServerClob;
        this.streamPos = 0L;
        this.markPos = 0L;
    }

    private long getClobCharLength() throws IOException {
        try {
            return this.parentClob.length();
        }
        catch (SQLServerException sQLServerException) {
            throw new IOException(sQLServerException.getMessage());
        }
    }

    private void checkClosed() throws IOException {
        if (null == this.parentClob) {
            throw new IOException(SQLServerException.getErrString("R_streamIsClosed"));
        }
    }

    private boolean isEOS() throws IOException {
        return this.streamPos >= this.getClobCharLength();
    }

    public long skip(long l2) throws IOException {
        this.checkClosed();
        if (l2 < 0L) {
            return 0L;
        }
        if (this.isEOS()) {
            return 0L;
        }
        long l3 = this.getClobCharLength();
        if (0L == l3) {
            return 0L;
        }
        if (this.streamPos >= l3) {
            return 0L;
        }
        if (this.streamPos + l2 > l3) {
            long l4 = l3 - this.streamPos;
            this.streamPos = l3;
            return l4;
        }
        this.streamPos += l2;
        return l2;
    }

    public int read() throws IOException {
        this.checkClosed();
        if (this.isEOS()) {
            return -1;
        }
        int n2 = this.read(this.cSingleChar, 0, 1);
        return 0 == n2 ? -1 : this.cSingleChar[0];
    }

    public int read(char[] cArray) throws IOException {
        this.checkClosed();
        if (null == cArray) {
            return 0;
        }
        return this.read(cArray, 0, cArray.length);
    }

    public int read(char[] cArray, int n2, int n3) throws IOException {
        this.checkClosed();
        if (null == cArray) {
            return 0;
        }
        if (this.isEOS()) {
            return -1;
        }
        int n4 = this.parentClob.read((int)this.streamPos, cArray, n2, n3);
        this.streamPos += (long)n4;
        return n4;
    }

    public boolean ready() {
        return true;
    }

    public void mark(int n2) {
        this.markPos = this.streamPos;
    }

    public boolean markSupported() {
        return true;
    }

    public void close() throws IOException {
        this.checkClosed();
        this.parentClob = null;
    }

    public void reset() throws IOException {
        this.checkClosed();
        this.streamPos = this.markPos;
    }
}

